/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.util;

import com.jetbrains.rd.util.CommonsLoggingLoggerFactory;
import com.jetbrains.rd.util.ILoggerFactory;
import com.jetbrains.rd.util.LogLevel;
import com.jetbrains.rd.util.Logger;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rd/util/CommonsLoggingLoggerFactory;", "Lcom/jetbrains/rd/util/ILoggerFactory;", "()V", "getLogger", "Lcom/jetbrains/rd/util/Logger;", "category", "", "rd-core"})
public final class CommonsLoggingLoggerFactory
implements ILoggerFactory {
    @NotNull
    public static final CommonsLoggingLoggerFactory INSTANCE = new CommonsLoggingLoggerFactory();

    private CommonsLoggingLoggerFactory() {
    }

    @Override
    @NotNull
    public Logger getLogger(@NotNull String category) {
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        return new Logger(category){
            private final Log internalLogger;
            {
                this.internalLogger = LogFactory.getLog((String)$category);
            }

            public void log(@NotNull LogLevel level, @Nullable Object message, @Nullable Throwable throwable) {
                Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
                switch (getLogger.WhenMappings.$EnumSwitchMapping$0[level.ordinal()]) {
                    case 1: {
                        this.internalLogger.trace(message, throwable);
                        break;
                    }
                    case 2: {
                        this.internalLogger.debug(message, throwable);
                        break;
                    }
                    case 3: {
                        this.internalLogger.info(message, throwable);
                        break;
                    }
                    case 4: {
                        this.internalLogger.warn(message, throwable);
                        break;
                    }
                    case 5: {
                        this.internalLogger.error(message, throwable);
                        break;
                    }
                    case 6: {
                        this.internalLogger.fatal(message, throwable);
                    }
                }
            }

            public boolean isEnabled(@NotNull LogLevel level) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
                switch (getLogger.WhenMappings.$EnumSwitchMapping$0[level.ordinal()]) {
                    case 1: {
                        bl = this.internalLogger.isTraceEnabled();
                        break;
                    }
                    case 2: {
                        bl = this.internalLogger.isDebugEnabled();
                        break;
                    }
                    case 3: {
                        bl = this.internalLogger.isInfoEnabled();
                        break;
                    }
                    case 4: {
                        bl = this.internalLogger.isWarnEnabled();
                        break;
                    }
                    case 5: {
                        bl = this.internalLogger.isErrorEnabled();
                        break;
                    }
                    case 6: {
                        bl = this.internalLogger.isFatalEnabled();
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return bl;
            }
        };
    }
}

