/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.rdtext.impl;

import com.jetbrains.rd.framework.IRdDynamic;
import com.jetbrains.rd.framework.base.IRdBindable;
import com.jetbrains.rd.framework.base.IRdBindableKt;
import com.jetbrains.rd.framework.base.RdBindableBase;
import com.jetbrains.rd.framework.base.RdDelegateBase;
import com.jetbrains.rd.framework.base.RdReactiveBase;
import com.jetbrains.rd.framework.impl.RdProperty;
import com.jetbrains.rd.rdtext.ITextBufferWithTypingSession;
import com.jetbrains.rd.rdtext.ITypingSession;
import com.jetbrains.rd.rdtext.impl.RdTextBuffer;
import com.jetbrains.rd.rdtext.impl.TextBufferTypingSession;
import com.jetbrains.rd.rdtext.impl.intrinsics.RdAssertion;
import com.jetbrains.rd.rdtext.impl.intrinsics.RdChangeOrigin;
import com.jetbrains.rd.rdtext.impl.intrinsics.RdTextBufferChange;
import com.jetbrains.rd.rdtext.impl.intrinsics.RdTextBufferState;
import com.jetbrains.rd.rdtext.intrinsics.RdTextChange;
import com.jetbrains.rd.rdtext.intrinsics.RdTextChangeKind;
import com.jetbrains.rd.rdtext.intrinsics.RdTextChangeKt;
import com.jetbrains.rd.rdtext.intrinsics.TextBufferVersion;
import com.jetbrains.rd.util.LogLevel;
import com.jetbrains.rd.util.Logger;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rd.util.reactive.IProperty;
import com.jetbrains.rd.util.reactive.IScheduler;
import com.jetbrains.rd.util.reactive.ISignal;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.OptProperty;
import com.jetbrains.rd.util.reactive.PropertyCombinatorsKt;
import com.jetbrains.rd.util.reactive.Signal;
import com.jetbrains.rd.util.reactive.SourceExKt;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J$\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020$0(H\u0016J\u0010\u0010)\u001a\u00020$2\u0006\u0010*\u001a\u00020+H\u0016J \u0010,\u001a\u00020$2\u0006\u0010-\u001a\u00020&2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020+H\u0016J\b\u00101\u001a\u000202H\u0016J\b\u00103\u001a\u00020$H\u0016J\u0010\u00104\u001a\u00020$2\u0006\u00105\u001a\u00020\fH\u0016J\b\u00106\u001a\u00020$H\u0002J\r\u00107\u001a\u00020$H\u0010\u00a2\u0006\u0002\b8J\u0010\u00109\u001a\u00020$2\u0006\u0010:\u001a\u00020\u0015H\u0014J\u0010\u0010;\u001a\u00020$2\u0006\u0010<\u001a\u00020+H\u0016J\u0010\u0010=\u001a\u00020$2\u0006\u00105\u001a\u00020\u0015H\u0014J\u000e\u0010>\u001a\b\u0012\u0004\u0012\u00020\f0?H\u0016J\b\u0010@\u001a\u00020+H\u0016J1\u0010A\u001a\u00020$2\u0006\u0010B\u001a\u00020\n2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020\n0D2\f\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00150DH\u0000\u00a2\u0006\u0002\bFR\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\f0\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001cR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0018R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\f0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lcom/jetbrains/rd/rdtext/impl/RdTextBuffer;", "Lcom/jetbrains/rd/framework/base/RdDelegateBase;", "Lcom/jetbrains/rd/rdtext/impl/intrinsics/RdTextBufferState;", "Lcom/jetbrains/rd/rdtext/ITextBufferWithTypingSession;", "delegate", "isMaster", "", "(Lcom/jetbrains/rd/rdtext/impl/intrinsics/RdTextBufferState;Z)V", "_discardedBufferVersion", "Lcom/jetbrains/rd/util/reactive/ISignal;", "Lcom/jetbrains/rd/rdtext/intrinsics/TextBufferVersion;", "_historyChanged", "Lcom/jetbrains/rd/rdtext/intrinsics/RdTextChange;", "activeTypingSession", "Lcom/jetbrains/rd/rdtext/impl/TextBufferTypingSession;", "<set-?>", "bufferVersion", "getBufferVersion", "()Lcom/jetbrains/rd/rdtext/intrinsics/TextBufferVersion;", "changesToConfirmOrRollback", "", "Lcom/jetbrains/rd/rdtext/impl/intrinsics/RdTextBufferChange;", "changing", "getChanging", "()Z", "discardedBufferVersion", "Lcom/jetbrains/rd/util/reactive/ISource;", "getDiscardedBufferVersion", "()Lcom/jetbrains/rd/util/reactive/ISource;", "historyChanged", "getHistoryChanged", "localOrigin", "Lcom/jetbrains/rd/rdtext/impl/intrinsics/RdChangeOrigin;", "textChanged", "Lcom/jetbrains/rd/util/reactive/IOptProperty;", "advise", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "handler", "Lkotlin/Function1;", "assertState", "allText", "", "bind", "lf", "parent", "Lcom/jetbrains/rd/framework/IRdDynamic;", "name", "deepClone", "Lcom/jetbrains/rd/framework/base/IRdBindable;", "finishTypingSession", "fire", "value", "incrementBufferVersion", "promoteLocalVersion", "promoteLocalVersion$rd_text", "receiveChange", "textBufferChange", "reset", "text", "sendChange", "startTypingSession", "Lcom/jetbrains/rd/rdtext/ITypingSession;", "toString", "updateHistory", "initialVersion", "versionsToDiscard", "", "changesToApply", "updateHistory$rd_text", "rd-text"})
public class RdTextBuffer
extends RdDelegateBase<RdTextBufferState>
implements ITextBufferWithTypingSession {
    private final boolean isMaster;
    @NotNull
    private final List<RdTextBufferChange> changesToConfirmOrRollback;
    @NotNull
    private final IOptProperty<RdTextChange> textChanged;
    @NotNull
    private final ISignal<RdTextChange> _historyChanged;
    @NotNull
    private final ISignal<TextBufferVersion> _discardedBufferVersion;
    @Nullable
    private TextBufferTypingSession activeTypingSession;
    @NotNull
    private TextBufferVersion bufferVersion;
    @NotNull
    private final RdChangeOrigin localOrigin;

    public RdTextBuffer(@NotNull RdTextBufferState delegate2, boolean isMaster) {
        Intrinsics.checkNotNullParameter((Object)delegate2, (String)"delegate");
        super((RdBindableBase)delegate2);
        this.isMaster = isMaster;
        this.changesToConfirmOrRollback = new ArrayList();
        this.textChanged = new OptProperty();
        this._historyChanged = new Signal();
        this._discardedBufferVersion = new Signal();
        this.bufferVersion = TextBufferVersion.Companion.getINIT_VERSION();
        this.localOrigin = this.isMaster ? RdChangeOrigin.Master : RdChangeOrigin.Slave;
        IProperty<RdTextBufferChange> iProperty = ((RdTextBufferState)this.getDelegatedBy()).getChanges();
        Intrinsics.checkNotNull(iProperty, (String)"null cannot be cast to non-null type com.jetbrains.rd.framework.impl.RdProperty<*>");
        ((RdProperty)iProperty).slave();
    }

    public /* synthetic */ RdTextBuffer(RdTextBufferState rdTextBufferState, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(rdTextBufferState, bl);
    }

    @Override
    public final boolean isMaster() {
        return this.isMaster;
    }

    @Override
    @NotNull
    public ISource<RdTextChange> getHistoryChanged() {
        return this._historyChanged;
    }

    @Override
    @NotNull
    public ISource<TextBufferVersion> getDiscardedBufferVersion() {
        return this._discardedBufferVersion;
    }

    @Override
    @NotNull
    public final TextBufferVersion getBufferVersion() {
        return this.bufferVersion;
    }

    @Override
    public boolean getChanging() {
        return ((RdTextBufferState)this.getDelegatedBy()).getChanges().getChanging();
    }

    @Override
    public void bind(@NotNull Lifetime lf, @NotNull IRdDynamic parent, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)lf, (String)"lf");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super.bind(lf, parent, name);
        SourceExKt.adviseNotNull((ISource)((RdTextBufferState)this.getDelegatedBy()).getChanges(), lf, (Function1)new Function1<RdTextBufferChange, Unit>(this){
            final /* synthetic */ RdTextBuffer this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull RdTextBufferChange it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (it.getOrigin() == RdTextBuffer.access$getLocalOrigin$p(this.this$0)) {
                    return;
                }
                this.this$0.receiveChange(it);
            }
        });
        PropertyCombinatorsKt.compose((IOptPropertyView)((RdTextBufferState)this.getDelegatedBy()).getAssertedSlaveText(), (IOptPropertyView)((RdTextBufferState)this.getDelegatedBy()).getAssertedMasterText(), (Function2)bind.2.INSTANCE).advise(lf, bind.3.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    protected void receiveChange(@NotNull RdTextBufferChange textBufferChange) {
        Intrinsics.checkNotNullParameter((Object)textBufferChange, (String)"textBufferChange");
        TextBufferVersion newVersion = textBufferChange.getVersion();
        RdChangeOrigin remoteOrigin = textBufferChange.getOrigin();
        RdTextChange change2 = textBufferChange.getChange();
        if (!(remoteOrigin != this.localOrigin)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        TextBufferTypingSession activeSession = this.activeTypingSession;
        if (activeSession != null && activeSession.tryPushRemoteChange(textBufferChange)) {
            return;
        }
        if (change2.getKind() == RdTextChangeKind.Reset) {
            this.changesToConfirmOrRollback.clear();
        } else {
            if (change2.getKind() == RdTextChangeKind.PromoteVersion) {
                if (!(!this.isMaster)) {
                    boolean $i$a$-require-RdTextBuffer$receiveChange$22 = false;
                    String $i$a$-require-RdTextBuffer$receiveChange$22 = "!IsMaster";
                    throw new IllegalArgumentException($i$a$-require-RdTextBuffer$receiveChange$22.toString());
                }
                this.changesToConfirmOrRollback.clear();
                this.bufferVersion = newVersion;
                this._historyChanged.fire(change2);
                return;
            }
            if (this.isMaster) {
                if (newVersion.getMaster() != this.bufferVersion.getMaster()) {
                    void $this$log$iv$iv;
                    Logger $this$warn$iv = RdReactiveBase.Companion.getLogReceived();
                    boolean $i$f$warn = false;
                    Logger logger = $this$warn$iv;
                    LogLevel level$iv$iv = LogLevel.Warn;
                    boolean $i$f$log = false;
                    if ($this$log$iv$iv.isEnabled(level$iv$iv)) {
                        LogLevel logLevel = level$iv$iv;
                        void var12_18 = $this$log$iv$iv;
                        boolean bl = false;
                        String string = "Rejecting the change '" + change2 + '\'';
                        var12_18.log(logLevel, string, null);
                    }
                    return;
                }
            } else if (newVersion.getSlave() != this.bufferVersion.getSlave()) {
                RdTextBufferChange ch;
                Iterator iterator2 = CollectionsKt.reversed((Iterable)this.changesToConfirmOrRollback).iterator();
                while (iterator2.hasNext() && (ch = (RdTextBufferChange)iterator2.next()).getVersion().getSlave() > newVersion.getSlave()) {
                    RdTextChange reversedChange = RdTextChangeKt.reverse(ch.getChange());
                    this._historyChanged.fire(reversedChange);
                    this.textChanged.set(reversedChange);
                }
                this.changesToConfirmOrRollback.clear();
            } else {
                this.changesToConfirmOrRollback.clear();
            }
        }
        this.bufferVersion = newVersion;
        this._historyChanged.fire(change2);
        if (activeSession == null || !activeSession.isCommitting()) {
            this.textChanged.set(change2);
        }
    }

    private final void incrementBufferVersion() {
        this.bufferVersion = this.isMaster ? this.bufferVersion.incrementMaster() : this.bufferVersion.incrementSlave();
    }

    @Override
    public void fire(@NotNull RdTextChange value2) {
        TextBufferTypingSession activeSession;
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        if (!(((RdTextBufferState)this.getDelegatedBy()).isBound() || Intrinsics.areEqual((Object)this.bufferVersion, (Object)TextBufferVersion.Companion.getINIT_VERSION()))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (((RdTextBufferState)this.getDelegatedBy()).isBound()) {
            IScheduler.DefaultImpls.assertThread$default(this.getProtocol().getScheduler(), null, 1, null);
        }
        if ((activeSession = this.activeTypingSession) != null && activeSession.isCommitting()) {
            return;
        }
        this.incrementBufferVersion();
        RdTextBufferChange bufferChange = new RdTextBufferChange(this.bufferVersion, this.localOrigin, value2);
        if (value2.getKind() == RdTextChangeKind.Reset) {
            this.changesToConfirmOrRollback.clear();
        } else if (!this.isMaster) {
            this.changesToConfirmOrRollback.add(bufferChange);
        }
        TextBufferTypingSession textBufferTypingSession = activeSession;
        if (textBufferTypingSession != null) {
            textBufferTypingSession.tryPushLocalChange(bufferChange);
        }
        this._historyChanged.fire(value2);
        this.sendChange(bufferChange);
    }

    protected void sendChange(@NotNull RdTextBufferChange value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        ((RdTextBufferState)this.getDelegatedBy()).getChanges().set(value2);
    }

    @Override
    public void reset(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.fire(new RdTextChange(RdTextChangeKind.Reset, 0, "", text, text.length()));
    }

    @Override
    public void advise(@NotNull Lifetime lifetime, @NotNull Function1<? super RdTextChange, Unit> handler) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        if (!((RdTextBufferState)this.getDelegatedBy()).isBound()) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        IScheduler.DefaultImpls.assertThread$default(this.getProtocol().getScheduler(), null, 1, null);
        this.textChanged.advise(lifetime, handler);
    }

    @Override
    public void assertState(@NotNull String allText) {
        Intrinsics.checkNotNullParameter((Object)allText, (String)"allText");
        if (this.activeTypingSession != null) {
            return;
        }
        RdAssertion assertion = new RdAssertion(this.bufferVersion.getMaster(), this.bufferVersion.getSlave(), allText);
        IOptProperty<RdAssertion> assertedTextProp = this.isMaster ? ((RdTextBufferState)this.getDelegatedBy()).getAssertedMasterText() : ((RdTextBufferState)this.getDelegatedBy()).getAssertedSlaveText();
        assertedTextProp.set(assertion);
    }

    @NotNull
    public String toString() {
        return "Text Buffer: (" + this.getRdid() + ')';
    }

    @Override
    @NotNull
    public ITypingSession<RdTextChange> startTypingSession() {
        TextBufferTypingSession session;
        if (!(this.activeTypingSession == null)) {
            boolean bl = false;
            String string = "activeTypingSession == null";
            throw new IllegalArgumentException(string.toString());
        }
        this.activeTypingSession = session = new TextBufferTypingSession(this);
        return session;
    }

    @Override
    public void finishTypingSession() {
        if (!(this.activeTypingSession != null)) {
            boolean bl = false;
            String string = "activeTypingSession != null";
            throw new IllegalArgumentException(string.toString());
        }
        this.activeTypingSession = null;
    }

    public void promoteLocalVersion$rd_text() {
        if (!this.isMaster) {
            boolean bl = false;
            String string = "isMaster";
            throw new IllegalArgumentException(string.toString());
        }
        this.fire(new RdTextChange(RdTextChangeKind.PromoteVersion, 0, "", "", -1));
    }

    public final void updateHistory$rd_text(@NotNull TextBufferVersion initialVersion, @NotNull List<TextBufferVersion> versionsToDiscard, @NotNull List<RdTextBufferChange> changesToApply) {
        Intrinsics.checkNotNullParameter((Object)initialVersion, (String)"initialVersion");
        Intrinsics.checkNotNullParameter(versionsToDiscard, (String)"versionsToDiscard");
        Intrinsics.checkNotNullParameter(changesToApply, (String)"changesToApply");
        for (TextBufferVersion version : versionsToDiscard) {
            this._discardedBufferVersion.fire(version);
        }
        this.bufferVersion = initialVersion;
        for (RdTextBufferChange change2 : changesToApply) {
            this.receiveChange(change2);
        }
    }

    @Override
    @NotNull
    public IRdBindable deepClone() {
        return new RdTextBuffer((RdTextBufferState)IRdBindableKt.deepClonePolymorphic(this.getDelegatedBy()), this.isMaster);
    }

    public static final /* synthetic */ RdChangeOrigin access$getLocalOrigin$p(RdTextBuffer $this) {
        return $this.localOrigin;
    }
}

