/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.util;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ContentRootData;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProviderImpl;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.Stack;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Stream;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.gradle.GradleScript;
import org.gradle.util.GradleVersion;
import org.gradle.wrapper.WrapperConfiguration;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.GradleManager;
import org.jetbrains.plugins.gradle.execution.build.CachedModuleDataFinder;
import org.jetbrains.plugins.gradle.model.data.GradleProjectBuildScriptData;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleLog;

public final class GradleUtil {
    private static final String LAST_USED_GRADLE_HOME_KEY = "last.used.gradle.home";

    private GradleUtil() {
    }

    @NotNull
    public static FileChooserDescriptor getGradleProjectFileChooserDescriptor() {
        return new FileChooserDescriptor(true, true, false, false, false, false).withFileFilter(file -> file.isCaseSensitive() ? StringUtil.endsWith((CharSequence)file.getName(), (CharSequence)".gradle") || StringUtil.endsWith((CharSequence)file.getName(), (CharSequence)".gradle.kts") : StringUtil.endsWithIgnoreCase((String)file.getName(), (String)".gradle") || StringUtil.endsWithIgnoreCase((String)file.getName(), (String)".gradle.kts"));
    }

    @NotNull
    public static FileChooserDescriptor getGradleHomeFileChooserDescriptor() {
        return FileChooserDescriptorFactory.createSingleFileOrFolderDescriptor();
    }

    public static boolean isGradleDefaultWrapperFilesExist(@Nullable String gradleProjectPath) {
        return GradleUtil.getWrapperConfiguration(gradleProjectPath) != null;
    }

    @Nullable
    public static WrapperConfiguration getWrapperConfiguration(@Nullable String gradleProjectPath) {
        WrapperConfiguration wrapperConfiguration2;
        block14: {
            Path wrapperPropertiesFile = GradleUtil.findDefaultWrapperPropertiesFile(gradleProjectPath);
            if (wrapperPropertiesFile == null) {
                return null;
            }
            WrapperConfiguration wrapperConfiguration3 = new WrapperConfiguration();
            BufferedReader wrapperPropertiesReader = Files.newBufferedReader(wrapperPropertiesFile);
            try {
                String zipStoreBase;
                String zipStorePath;
                String distPathBase;
                Properties props = new Properties();
                props.load(wrapperPropertiesReader);
                String distributionUrl = props.getProperty("distributionUrl");
                if (StringUtil.isEmpty((String)distributionUrl)) {
                    throw new ExternalSystemException("Wrapper 'distributionUrl' property does not exist!");
                }
                wrapperConfiguration3.setDistribution(GradleUtil.prepareDistributionUri(distributionUrl, wrapperPropertiesFile));
                String distributionPath = props.getProperty("distributionPath");
                if (!StringUtil.isEmpty((String)distributionPath)) {
                    wrapperConfiguration3.setDistributionPath(distributionPath);
                }
                if (!StringUtil.isEmpty((String)(distPathBase = props.getProperty("distributionBase")))) {
                    wrapperConfiguration3.setDistributionBase(distPathBase);
                }
                if (!StringUtil.isEmpty((String)(zipStorePath = props.getProperty("zipStorePath")))) {
                    wrapperConfiguration3.setZipPath(zipStorePath);
                }
                if (!StringUtil.isEmpty((String)(zipStoreBase = props.getProperty("zipStoreBase")))) {
                    wrapperConfiguration3.setZipBase(zipStoreBase);
                }
                wrapperConfiguration2 = wrapperConfiguration3;
                if (wrapperPropertiesReader == null) break block14;
            }
            catch (Throwable throwable) {
                try {
                    if (wrapperPropertiesReader != null) {
                        try {
                            ((Reader)wrapperPropertiesReader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    GradleLog.LOG.warn(String.format("I/O exception on reading gradle wrapper properties file at '%s'", wrapperPropertiesFile.toAbsolutePath()), (Throwable)e);
                    return null;
                }
            }
            ((Reader)wrapperPropertiesReader).close();
        }
        return wrapperConfiguration2;
    }

    private static URI prepareDistributionUri(String distributionUrl, Path propertiesFile) throws URISyntaxException {
        URI source = new URI(distributionUrl);
        return source.getScheme() != null ? source : propertiesFile.resolveSibling(source.getSchemeSpecificPart()).toUri();
    }

    @NotNull
    public static String getConfigPath(@NotNull GradleProject subProject, @NotNull String rootProjectPath) {
        try {
            File file;
            GradleScript script = subProject.getBuildScript();
            if (script != null && (file = script.getSourceFile()) != null) {
                if (!file.isDirectory()) {
                    file = file.getParentFile();
                }
                return ExternalSystemApiUtil.toCanonicalPath((String)file.getPath());
            }
        }
        catch (Exception script) {
            // empty catch block
        }
        File rootProjectParent = new File(rootProjectPath);
        StringBuilder buffer = new StringBuilder(FileUtil.toCanonicalPath((String)rootProjectParent.getAbsolutePath()));
        Stack stack = new Stack();
        for (GradleProject p = subProject; p != null; p = p.getParent()) {
            stack.push((Object)p.getName());
        }
        stack.pop();
        while (!stack.isEmpty()) {
            buffer.append('/').append((String)stack.pop());
        }
        return buffer.toString();
    }

    @NotNull
    public static String getLastUsedGradleHome() {
        return PropertiesComponent.getInstance().getValue(LAST_USED_GRADLE_HOME_KEY, "");
    }

    public static void storeLastUsedGradleHome(@Nullable String gradleHomePath) {
        PropertiesComponent.getInstance().setValue(LAST_USED_GRADLE_HOME_KEY, gradleHomePath, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static Path findDefaultWrapperPropertiesFile(@Nullable String gradleProjectPath) {
        Path gradleDir;
        if (gradleProjectPath == null) {
            return null;
        }
        Path file = Path.of(gradleProjectPath, new String[0]);
        Path path2 = gradleDir = Files.isRegularFile(file, new LinkOption[0]) ? file.resolveSibling("gradle") : file.resolve("gradle");
        if (!Files.isDirectory(gradleDir, new LinkOption[0])) {
            return null;
        }
        Path wrapperDir = gradleDir.resolve("wrapper");
        if (!Files.isDirectory(wrapperDir, new LinkOption[0])) {
            return null;
        }
        try (Stream<Path> pathsStream = Files.list(wrapperDir);){
            List<Path> candidates = pathsStream.filter(path -> FileUtilRt.extensionEquals((String)path.getFileName().toString(), (String)"properties") && Files.isRegularFile(path, new LinkOption[0])).toList();
            if (candidates.isEmpty()) {
                GradleLog.LOG.warn("No *.properties file is found at the gradle wrapper directory " + wrapperDir);
                Path path3 = null;
                return path3;
            }
            if (candidates.size() != 1) {
                GradleLog.LOG.warn(String.format("%d *.properties files instead of one have been found at the wrapper directory (%s): %s", candidates.size(), wrapperDir, StringUtil.join(candidates, (String)", ")));
                Path path4 = null;
                return path4;
            }
            Path path5 = candidates.get(0);
            return path5;
        }
        catch (IOException e) {
            GradleLog.LOG.warn("Couldn't list gradle wrapper directory " + wrapperDir, (Throwable)e);
            return null;
        }
    }

    @NotNull
    public static String determineRootProject(@NotNull String subProjectPath) {
        Path subProject;
        try {
            for (Path candidate = subProject = Paths.get(subProjectPath, new String[0]); candidate != null && candidate != candidate.getParent(); candidate = candidate.getParent()) {
                if (!GradleUtil.containsGradleSettingsFile(candidate)) continue;
                return candidate.toString();
            }
        }
        catch (IOException e) {
            GradleLog.LOG.warn("Failed to determine root Gradle project directory for [" + subProjectPath + "]", (Throwable)e);
        }
        return Files.isDirectory(subProject, new LinkOption[0]) ? subProjectPath : subProject.getParent().toString();
    }

    private static boolean containsGradleSettingsFile(Path directory) throws IOException {
        if (!Files.isDirectory(directory, new LinkOption[0])) {
            return false;
        }
        try (Stream<Path> stream = Files.walk(directory, 1, new FileVisitOption[0]);){
            boolean bl = stream.map(Path::getFileName).filter(Objects::nonNull).map(Path::toString).anyMatch(name2 -> name2.startsWith("settings.gradle"));
            return bl;
        }
    }

    @ApiStatus.Experimental
    @Nullable
    public static DataNode<ModuleData> findGradleModuleData(@NotNull Module module) {
        String projectPath = ExternalSystemApiUtil.getExternalProjectPath((Module)module);
        if (projectPath == null) {
            return null;
        }
        Project project = module.getProject();
        return GradleUtil.findGradleModuleData(project, projectPath);
    }

    @ApiStatus.Experimental
    @Nullable
    public static DataNode<ModuleData> findGradleModuleData(@NotNull Project project, @NotNull String projectPath) {
        return ExternalSystemApiUtil.findModuleNode((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID, (String)projectPath);
    }

    @Nullable
    public static Module findGradleModule(@NotNull Project project, @NotNull String projectPath) {
        DataNode moduleNode = ExternalSystemApiUtil.findModuleNode((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID, (String)projectPath);
        if (moduleNode == null) {
            return null;
        }
        return GradleUtil.findGradleModule(project, (ModuleData)moduleNode.getData());
    }

    @Nullable
    public static Module findGradleModule(@NotNull Project project, @NotNull ProjectData projectData) {
        return GradleUtil.findGradleModule(project, projectData.getLinkedExternalProjectPath());
    }

    @Nullable
    public static Module findGradleModule(@NotNull Project project, @NotNull ModuleData moduleData) {
        IdeModelsProviderImpl modelsProvider = new IdeModelsProviderImpl(project);
        return modelsProvider.findIdeModule(moduleData);
    }

    @NotNull
    public static GradleVersion getGradleVersion(Project project, PsiFile file) {
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile != null) {
            String filePath = virtualFile.getPath();
            return GradleUtil.getGradleVersion(project, filePath);
        }
        return GradleVersion.current();
    }

    @NotNull
    public static GradleVersion getGradleVersion(Project project, String filePath) {
        GradleSettings settings2;
        GradleProjectSettings projectSettings;
        GradleManager gradleManager;
        String externalProjectPath2;
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)GradleConstants.SYSTEM_ID);
        if (manager instanceof GradleManager && (externalProjectPath2 = (gradleManager = (GradleManager)manager).getAffectedExternalProjectPath(filePath, project)) != null && (projectSettings = (GradleProjectSettings)(settings2 = GradleSettings.getInstance(project)).getLinkedProjectSettings(externalProjectPath2)) != null) {
            return projectSettings.resolveGradleVersion();
        }
        return GradleVersion.current();
    }

    public static boolean isSupportedImplementationScope(@NotNull GradleVersion gradleVersion2) {
        return gradleVersion2.getBaseVersion().compareTo(GradleVersion.version((String)"3.4")) >= 0;
    }

    @Nullable
    public static VirtualFile getGradleBuildScriptSource(@NotNull Module module) {
        DataNode<? extends ModuleData> moduleData = CachedModuleDataFinder.getInstance(module.getProject()).findModuleData(module);
        if (moduleData == null) {
            return null;
        }
        DataNode dataNode = ExternalSystemApiUtil.find(moduleData, GradleProjectBuildScriptData.KEY);
        if (dataNode == null) {
            return null;
        }
        File data = ((GradleProjectBuildScriptData)dataNode.getData()).getBuildScriptSource();
        if (data == null) {
            return null;
        }
        return VfsUtil.findFileByIoFile((File)data, (boolean)true);
    }

    public static void excludeOutDir(@NotNull DataNode<ModuleData> ideModule, File ideaOutDir) {
        ContentRootData excludedContentRootData;
        DataNode contentRootDataDataNode = ExternalSystemApiUtil.find(ideModule, (Key)ProjectKeys.CONTENT_ROOT);
        if (contentRootDataDataNode == null || !GradleUtil.isContentRootAncestor((ContentRootData)contentRootDataDataNode.getData(), ideaOutDir)) {
            excludedContentRootData = new ContentRootData(GradleConstants.SYSTEM_ID, ideaOutDir.getPath());
            ideModule.createChild(ProjectKeys.CONTENT_ROOT, (Object)excludedContentRootData);
        } else {
            excludedContentRootData = (ContentRootData)contentRootDataDataNode.getData();
        }
        excludedContentRootData.storePath(ExternalSystemSourceType.EXCLUDED, ideaOutDir.getPath());
    }

    public static void unexcludeOutDir(@NotNull DataNode<ModuleData> ideModule, File ideaOutDir) {
        DataNode contentRootDataDataNode = ExternalSystemApiUtil.find(ideModule, (Key)ProjectKeys.CONTENT_ROOT);
        if (contentRootDataDataNode != null && GradleUtil.isContentRootAncestor((ContentRootData)contentRootDataDataNode.getData(), ideaOutDir)) {
            ContentRootData excludedContentRootData = (ContentRootData)contentRootDataDataNode.getData();
            excludedContentRootData.getPaths(ExternalSystemSourceType.EXCLUDED).removeIf(sourceRoot -> sourceRoot.getPath().equals(ideaOutDir.getPath()));
        }
    }

    private static boolean isContentRootAncestor(@NotNull ContentRootData data, @NotNull File ideaOutDir) {
        String canonicalIdeOutPath = FileUtil.toCanonicalPath((String)ideaOutDir.getPath());
        String canonicalRootPath = data.getRootPath();
        return FileUtil.isAncestor((String)canonicalRootPath, (String)canonicalIdeOutPath, (boolean)false);
    }
}

