/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.util;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsDataStorage;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.PathPrefixTreeMap;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.text.StringKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.data.BuildParticipant;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleTaskData;
import org.jetbrains.plugins.gradle.util.GradleTasksUtilKt;
import org.jetbrains.plugins.gradle.util.ModuleTaskData;
import org.jetbrains.plugins.gradle.util.ProjectTaskData;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a.\u0010\u0005\u001a \u0012\u0004\u0012\u00020\u0007\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\b0\u00062\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a(\u0010\u000b\u001a\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\f0\b0\u00062\u0006\u0010\u0003\u001a\u00020\u0004H\u0007\u001a(\u0010\r\u001a\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\f0\b0\u00062\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0016\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\tH\u0002\u00a8\u0006\u0012"}, d2={"findGradleTasks", "", "Lorg/jetbrains/plugins/gradle/util/ProjectTaskData;", "project", "Lcom/intellij/openapi/project/Project;", "getGradleTaskNodesMap", "", "", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "Lcom/intellij/openapi/externalSystem/model/task/TaskData;", "getGradleTasks", "Lorg/jetbrains/plugins/gradle/util/GradleTaskData;", "getGradleTasksMap", "getModuleTasks", "Lorg/jetbrains/plugins/gradle/util/ModuleTaskData;", "moduleNode", "Lcom/intellij/openapi/externalSystem/model/project/ModuleData;", "intellij.gradle.common"})
public final class GradleTasksUtilKt {
    @ApiStatus.Internal
    @NotNull
    public static final Map<String, MultiMap<String, GradleTaskData>> getGradleTasks(@NotNull Project project) {
        return (Map)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> GradleTasksUtilKt.getGradleTasks$lambda$0(project));
    }

    /*
     * WARNING - void declaration
     */
    private static final Map<String, MultiMap<String, GradleTaskData>> getGradleTasksMap(Project project) {
        void $this$mapValuesTo$iv$iv;
        Map<String, MultiMap<String, DataNode<TaskData>>> $this$mapValues$iv = GradleTasksUtilKt.getGradleTaskNodesMap(project);
        boolean $i$f$mapValues = false;
        Map<String, MultiMap<String, DataNode<TaskData>>> map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            MultiMap moduleTasks2 = (MultiMap)entry2.getValue();
            MultiMap transformed = MultiMap.create();
            for (Map.Entry entry3 : moduleTasks2.entrySet()) {
                Collection<GradleTaskData> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                String gradleModulePath = (String)entry3.getKey();
                Collection moduleTaskNodes = (Collection)entry3.getValue();
                Iterable iterable = moduleTaskNodes;
                String string2 = gradleModulePath;
                MultiMap multiMap = transformed;
                boolean $i$f$map = false;
                void var25_25 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    DataNode dataNode = (DataNode)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl3 = false;
                    collection.add(new GradleTaskData((DataNode<TaskData>)it, gradleModulePath));
                }
                collection = (List)destination$iv$iv2;
                multiMap.putValues((Object)string2, (Collection)collection);
            }
            MultiMap multiMap = transformed;
            map3.put(k, multiMap);
        }
        return destination$iv$iv;
    }

    private static final Map<String, MultiMap<String, DataNode<TaskData>>> getGradleTaskNodesMap(Project project) {
        LinkedHashMap<Object, MultiMap> tasks2 = new LinkedHashMap<Object, MultiMap>();
        for (ProjectTaskData projectTaskData : GradleTasksUtilKt.findGradleTasks(project)) {
            MultiMap projectTasks = MultiMap.createOrderedSet();
            PathPrefixTreeMap modulePaths = new PathPrefixTreeMap(":", false);
            for (ModuleTaskData moduleTaskData : projectTaskData.getModulesTaskData()) {
                modulePaths.set(moduleTaskData.getGradlePath(), (Object)moduleTaskData.getExternalModulePath());
                projectTasks.putValues((Object)moduleTaskData.getGradlePath(), (Collection)moduleTaskData.getTasks());
            }
            for (Map.Entry entry : ((Map)modulePaths).entrySet()) {
                String gradlePath2 = (String)entry.getKey();
                String externalModulePath = (String)entry.getValue();
                MultiMap moduleTasks2 = tasks2.computeIfAbsent(externalModulePath, arg_0 -> GradleTasksUtilKt.getGradleTaskNodesMap$lambda$3(getGradleTaskNodesMap.moduleTasks.1.INSTANCE, arg_0));
                Set childrenModulesPaths = modulePaths.getAllDescendantKeys(gradlePath2);
                for (String childModulePath : childrenModulesPaths) {
                    moduleTasks2.putValues((Object)childModulePath, projectTasks.get((Object)childModulePath));
                }
            }
        }
        return tasks2;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<ProjectTaskData> findGradleTasks(Project project) {
        Iterable moduleNode;
        ProjectDataManager projectDataManager = ProjectDataManager.getInstance();
        MultiMap projects2 = MultiMap.createOrderedSet();
        for (GradleProjectSettings settings2 : GradleSettings.getInstance(project).getLinkedProjectsSettings()) {
            Iterator $this$flatMapTo$iv$iv;
            ExternalProjectInfo projectInfo = projectDataManager.getExternalProjectData(project, GradleConstants.SYSTEM_ID, settings2.getExternalProjectPath());
            Object object = settings2.getCompositeBuild();
            if (object == null || (object = ((GradleProjectSettings.CompositeBuild)object).getCompositeParticipants()) == null) {
                object = CollectionsKt.emptyList();
            }
            Object compositeParticipants = object;
            Iterable $this$flatMap$iv = (Iterable)compositeParticipants;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            Iterator iterator = $this$flatMapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void $this$mapTo$iv$iv;
                Object element$iv$iv = iterator.next();
                BuildParticipant it = (BuildParticipant)element$iv$iv;
                boolean bl = false;
                Iterable $this$map$iv = it.getProjects();
                boolean $i$f$map = false;
                Iterable iterable2 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void module;
                    String string2 = (String)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    collection.add(TuplesKt.to((Object)module, (Object)it.getRootPath()));
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Map compositeProjects = MapsKt.toMap((Iterable)((List)destination$iv$iv));
            ExternalProjectInfo externalProjectInfo = projectInfo;
            if (externalProjectInfo == null || (externalProjectInfo = externalProjectInfo.getExternalProjectStructure()) == null) continue;
            ExternalProjectInfo projectNode = externalProjectInfo;
            Collection moduleNodes = ExternalSystemApiUtil.getChildren((DataNode)projectNode, (Key)ProjectKeys.MODULE);
            $this$flatMapTo$iv$iv = moduleNodes.iterator();
            while ($this$flatMapTo$iv$iv.hasNext()) {
                moduleNode = (DataNode)$this$flatMapTo$iv$iv.next();
                String externalModulePath = ((ModuleData)moduleNode.getData()).getLinkedExternalProjectPath();
                String string3 = (String)compositeProjects.get(externalModulePath);
                if (string3 == null) {
                    string3 = settings2.getExternalProjectPath();
                }
                String projectPath = string3;
                projects2.putValue((Object)projectPath, (Object)moduleNode);
            }
        }
        ArrayList<ProjectTaskData> projectTasksData = new ArrayList<ProjectTaskData>();
        for (Map.Entry entry : projects2.entrySet()) {
            void $this$mapTo$iv$iv;
            String externalProjectPath2 = (String)entry.getKey();
            Collection modulesNodes = (Collection)entry.getValue();
            Iterable $this$map$iv = modulesNodes;
            boolean $i$f$map = false;
            moduleNode = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                DataNode bl = (DataNode)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(GradleTasksUtilKt.getModuleTasks((DataNode<ModuleData>)p0));
            }
            List modulesTaskData = (List)destination$iv$iv;
            Object object = (ModuleTaskData)CollectionsKt.firstOrNull((List)modulesTaskData);
            String taskProjectPath = object != null && (object = ((ModuleTaskData)object).getTasks()) != null && (object = (DataNode)CollectionsKt.firstOrNull((List)object)) != null && (object = (TaskData)object.getData()) != null ? object.getLinkedExternalProjectPath() : null;
            String string4 = taskProjectPath;
            if (string4 == null) {
                string4 = externalProjectPath2;
            }
            projectTasksData.add(new ProjectTaskData(string4, modulesTaskData));
        }
        return projectTasksData;
    }

    /*
     * WARNING - void declaration
     */
    private static final ModuleTaskData getModuleTasks(DataNode<ModuleData> moduleNode) {
        String string2;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        ModuleData moduleData = (ModuleData)moduleNode.getData();
        String externalModulePath = moduleData.getLinkedExternalProjectPath();
        String gradlePath2 = StringsKt.removeSuffix((String)GradleProjectResolverUtil.getGradlePath(moduleData), (CharSequence)":");
        Iterable iterable = ExternalSystemApiUtil.getChildren(moduleNode, (Key)ProjectKeys.TASK);
        boolean $i$f$filter = false;
        void var7_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DataNode it = (DataNode)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)((TaskData)it.getData()).getName()).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List tasks2 = (List)destination$iv$iv;
        Object object = (DataNode)CollectionsKt.firstOrNull((List)tasks2);
        String taskPathPrefix = StringKt.nullize$default(object != null && (object = (TaskData)object.getData()) != null && (object = object.getName()) != null ? StringsKt.substringBeforeLast((String)object, (char)':', (String)"") : null, (boolean)false, (int)1, null);
        DataNode dataNode = (DataNode)CollectionsKt.firstOrNull((List)tasks2);
        String linkedExternalProjectPath = dataNode != null && (dataNode = (TaskData)dataNode.getData()) != null ? dataNode.getLinkedExternalProjectPath() : null;
        String string3 = linkedExternalProjectPath;
        if (string3 == null) {
            string3 = externalModulePath;
        }
        if ((string2 = taskPathPrefix) == null) {
            string2 = gradlePath2;
        }
        return new ModuleTaskData(string3, string2, tasks2);
    }

    private static final CachedValueProvider.Result getGradleTasks$lambda$0(Project $project) {
        Object[] objectArray = new Object[]{ExternalProjectsDataStorage.getInstance((Project)$project)};
        return CachedValueProvider.Result.create(GradleTasksUtilKt.getGradleTasksMap($project), (Object[])objectArray);
    }

    private static final MultiMap getGradleTaskNodesMap$lambda$3(Function1 $tmp0, Object p0) {
        return (MultiMap)$tmp0.invoke(p0);
    }
}

