/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.util;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleModuleDataKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J!\u0010\u001b\u001a\u0004\u0018\u0001H\u001c\"\u0004\b\u0000\u0010\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001c0\u001e\u00a2\u0006\u0002\u0010\u001fJ \u0010 \u001a\b\u0012\u0004\u0012\u0002H\u001c0!\"\u0004\b\u0000\u0010\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001c0\u001eJ\u0018\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u00072\b\b\u0002\u0010$\u001a\u00020\u0014R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0016\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\f\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\tR\u0011\u0010\u000e\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\tR\u0016\u0010\u0010\u001a\u00070\u0007\u00a2\u0006\u0002\b\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\tR\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0019\u001a\u00070\u0007\u00a2\u0006\u0002\b\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\t\u00a8\u0006%"}, d2={"Lorg/jetbrains/plugins/gradle/util/GradleModuleData;", "", "dataNode", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "Lcom/intellij/openapi/externalSystem/model/project/ModuleData;", "(Lcom/intellij/openapi/externalSystem/model/DataNode;)V", "compositeBuildGradlePath", "", "getCompositeBuildGradlePath", "()Ljava/lang/String;", "directoryToRunTask", "getDirectoryToRunTask", "fullGradlePath", "getFullGradlePath", "gradlePath", "getGradlePath", "gradleProjectDir", "Lorg/jetbrains/annotations/NotNull;", "getGradleProjectDir", "isBuildSrcModule", "", "()Z", "moduleData", "getModuleData", "()Lcom/intellij/openapi/externalSystem/model/project/ModuleData;", "moduleName", "getModuleName", "find", "T", "key", "Lcom/intellij/openapi/externalSystem/model/Key;", "(Lcom/intellij/openapi/externalSystem/model/Key;)Ljava/lang/Object;", "findAll", "", "getTaskPath", "simpleTaskName", "prependCompositeBuildPath", "intellij.gradle.common"})
@ApiStatus.Experimental
public final class GradleModuleData {
    @NotNull
    private final DataNode<? extends ModuleData> dataNode;
    @NotNull
    private final ModuleData moduleData;
    @NotNull
    private final String moduleName;
    @NotNull
    private final String gradleProjectDir;

    public GradleModuleData(@NotNull DataNode<? extends ModuleData> dataNode) {
        this.dataNode = dataNode;
        this.moduleData = (ModuleData)this.dataNode.getData();
        ProjectSystemId systemId = this.moduleData.getOwner();
        if (!Intrinsics.areEqual((Object)systemId, (Object)GradleConstants.SYSTEM_ID)) {
            boolean bl = false;
            String string2 = "Gradle module expected but '" + systemId + "' module has been got.";
            throw new IllegalArgumentException(string2.toString());
        }
        this.moduleName = this.moduleData.getModuleName();
        this.gradleProjectDir = this.moduleData.getLinkedExternalProjectPath();
    }

    @NotNull
    public final ModuleData getModuleData() {
        return this.moduleData;
    }

    @NotNull
    public final String getModuleName() {
        return this.moduleName;
    }

    @NotNull
    public final String getGradleProjectDir() {
        return this.gradleProjectDir;
    }

    @NotNull
    public final String getDirectoryToRunTask() {
        return GradleModuleDataKt.getDirectoryToRunTask(this.moduleData);
    }

    @NotNull
    public final String getGradlePath() {
        return GradleModuleDataKt.getGradlePath(this.moduleData);
    }

    @NotNull
    public final String getCompositeBuildGradlePath() {
        return GradleModuleDataKt.getCompositeBuildGradlePath(this.moduleData);
    }

    @NotNull
    public final String getFullGradlePath() {
        return this.getCompositeBuildGradlePath() + this.getGradlePath();
    }

    public final boolean isBuildSrcModule() {
        return GradleModuleDataKt.isBuildSrcModule(this.moduleData);
    }

    @NotNull
    public final String getTaskPath(@NotNull String simpleTaskName, boolean prependCompositeBuildPath) {
        String path = prependCompositeBuildPath ? this.getFullGradlePath() : this.getGradlePath();
        char[] cArray = new char[]{':'};
        return StringsKt.trimEnd((String)path, (char[])cArray) + ":" + simpleTaskName;
    }

    public static /* synthetic */ String getTaskPath$default(GradleModuleData gradleModuleData, String string2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return gradleModuleData.getTaskPath(string2, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T> Collection<T> findAll(@NotNull Key<T> key) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = ExternalSystemApiUtil.findAll(this.dataNode, key);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            DataNode it = (DataNode)element$iv$iv;
            boolean bl2 = false;
            if (it.getData() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final <T> T find(@NotNull Key<T> key) {
        DataNode dataNode = ExternalSystemApiUtil.find(this.dataNode, key);
        return (T)(dataNode != null ? dataNode.getData() : null);
    }
}

