/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.util;

import com.intellij.ide.impl.ProjectViewSelectInTarget;
import com.intellij.ide.util.EditorHelper;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.lang.JavaVersion;
import java.io.File;
import java.nio.file.Path;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.properties.GradleProperties;
import org.jetbrains.plugins.gradle.properties.GradlePropertiesFile;
import org.jetbrains.plugins.gradle.properties.models.Property;
import org.jetbrains.plugins.gradle.service.project.GradleNotification;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleJvmSupportMatrices;
import org.jetbrains.plugins.gradle.util.JavaHomeValidationStatus;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0001H\u0002\u001a\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0001\u001a&\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\"\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0001\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0018\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0018\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001\u001a\u001e\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u0018"}, d2={"createLinkToFile", "", "project", "Lcom/intellij/openapi/project/Project;", "path", "isSupported", "", "gradleVersion", "Lorg/gradle/util/GradleVersion;", "javaVersionString", "notifyInvalidGradleJavaHomeInfo", "", "javaHomeProperty", "Lorg/jetbrains/plugins/gradle/properties/models/Property;", "reason", "Lorg/jetbrains/plugins/gradle/util/JavaHomeValidationStatus;", "notifyInvalidGradleJvmInfo", "notificationHint", "notifyInvalidJavaHomeInfo", "validateGradleJavaHome", "javaHome", "validateJavaHome", "externalProjectPath", "Ljava/nio/file/Path;", "intellij.gradle.common"})
@ApiStatus.Internal
@JvmName(name="GradleJvmValidationUtil")
public final class GradleJvmValidationUtil {
    public static final void validateJavaHome(@NotNull Project project, @NotNull Path externalProjectPath2, @NotNull GradleVersion gradleVersion2) {
        GradleProperties gradleProperties = GradlePropertiesFile.INSTANCE.getProperties(project, externalProjectPath2);
        Property<String> javaHomeProperty = gradleProperties.getJavaHomeProperty();
        if (javaHomeProperty != null) {
            String javaHome = javaHomeProperty.getValue();
            JavaHomeValidationStatus validationStatus = GradleJvmValidationUtil.validateGradleJavaHome(gradleVersion2, javaHome);
            if (Intrinsics.areEqual((Object)validationStatus, (Object)JavaHomeValidationStatus.Invalid.INSTANCE)) {
                GradleJvmValidationUtil.notifyInvalidGradleJavaHomeInfo(project, javaHomeProperty, validationStatus);
            } else if (validationStatus instanceof JavaHomeValidationStatus.Unsupported) {
                GradleJvmValidationUtil.notifyInvalidGradleJavaHomeInfo(project, javaHomeProperty, validationStatus);
            }
        } else {
            String javaHome = ExternalSystemJdkUtil.getJavaHome();
            JavaHomeValidationStatus validationStatus = GradleJvmValidationUtil.validateGradleJavaHome(gradleVersion2, javaHome);
            if (Intrinsics.areEqual((Object)validationStatus, (Object)JavaHomeValidationStatus.Invalid.INSTANCE)) {
                GradleJvmValidationUtil.notifyInvalidJavaHomeInfo(project, validationStatus);
            } else if (validationStatus instanceof JavaHomeValidationStatus.Unsupported) {
                GradleJvmValidationUtil.notifyInvalidJavaHomeInfo(project, validationStatus);
            }
        }
    }

    @NotNull
    public static final JavaHomeValidationStatus validateGradleJavaHome(@NotNull GradleVersion gradleVersion2, @Nullable String javaHome) {
        if (javaHome == null) {
            return JavaHomeValidationStatus.Undefined.INSTANCE;
        }
        if (!ExternalSystemJdkUtil.isValidJdk((String)javaHome)) {
            return JavaHomeValidationStatus.Invalid.INSTANCE;
        }
        SdkType javaSdkType = ExternalSystemJdkUtil.getJavaSdkType();
        String string2 = javaSdkType.getVersionString(javaHome);
        if (string2 == null) {
            return JavaHomeValidationStatus.Invalid.INSTANCE;
        }
        String versionString = string2;
        JavaVersion javaVersion = JavaVersion.tryParse((String)versionString);
        if (javaVersion == null) {
            return JavaHomeValidationStatus.Invalid.INSTANCE;
        }
        JavaVersion javaVersion2 = javaVersion;
        if (!GradleJvmValidationUtil.isSupported(gradleVersion2, versionString)) {
            return new JavaHomeValidationStatus.Unsupported(javaVersion2, gradleVersion2);
        }
        return new JavaHomeValidationStatus.Success(javaHome);
    }

    public static final boolean isSupported(@NotNull GradleVersion gradleVersion2, @NotNull String javaVersionString) {
        JavaVersion javaVersion = JavaVersion.tryParse((String)javaVersionString);
        if (javaVersion == null) {
            return false;
        }
        JavaVersion javaVersion2 = javaVersion;
        return GradleJvmSupportMatrices.isSupported(gradleVersion2, javaVersion2);
    }

    private static final void notifyInvalidGradleJavaHomeInfo(Project project, Property<String> javaHomeProperty, JavaHomeValidationStatus reason) {
        String propertyLocation = GradleJvmValidationUtil.createLinkToFile(project, javaHomeProperty.getLocation());
        Object[] objectArray = new Object[]{propertyLocation};
        String notificationContent = GradleBundle.message("gradle.notifications.java.home.property.content", objectArray);
        GradleJvmValidationUtil.notifyInvalidGradleJvmInfo(project, notificationContent, reason);
    }

    private static final void notifyInvalidJavaHomeInfo(Project project, JavaHomeValidationStatus reason) {
        String notificationContent = GradleBundle.message("gradle.notifications.java.home.variable.content", new Object[0]);
        GradleJvmValidationUtil.notifyInvalidGradleJvmInfo(project, notificationContent, reason);
    }

    private static final String createLinkToFile(Project project, String path) {
        String string2;
        VirtualFile projectDirectory = ProjectUtil.guessProjectDir((Project)project);
        Object object = projectDirectory;
        if (object != null && (object = object.getPath()) != null) {
            Object it = object;
            boolean bl = false;
            string2 = FileUtil.toSystemDependentName((String)it);
        } else {
            string2 = null;
        }
        String projectPath = string2;
        String filePath = FileUtil.toSystemDependentName((String)path);
        String presentablePath = projectPath == null ? FileUtil.getLocationRelativeToUserHome((String)filePath) : (FileUtil.isAncestor((String)projectPath, (String)filePath, (boolean)true) ? FileUtil.getRelativePath((String)projectPath, (String)filePath, (char)File.separatorChar) : FileUtil.getLocationRelativeToUserHome((String)filePath));
        return "<a href='" + path + "'>" + presentablePath + "</a>";
    }

    private static final void notifyInvalidGradleJvmInfo(Project project, @NlsContexts.HintText String notificationHint, JavaHomeValidationStatus reason) {
        String notificationTitle = GradleBundle.message("gradle.notifications.java.home.invalid.title", new Object[0]);
        Object notificationContent = notificationHint;
        if (reason instanceof JavaHomeValidationStatus.Unsupported) {
            String javaVersion = ((JavaHomeValidationStatus.Unsupported)reason).getJavaVersion().toString();
            String gradleVersion2 = ((JavaHomeValidationStatus.Unsupported)reason).getGradleVersion().getVersion();
            Object[] objectArray = new Object[]{javaVersion, gradleVersion2};
            String additionalFailureHint = GradleBundle.message("gradle.notifications.java.home.unsupported.content", objectArray);
            notificationContent = additionalFailureHint + " " + (String)notificationContent;
        }
        NotificationListener.Adapter hyperLinkProcessor2 = new NotificationListener.Adapter(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
            }

            protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(e.getDescription());
                if (virtualFile == null) {
                    return;
                }
                VirtualFile file = virtualFile;
                ProjectViewSelectInTarget.select((Project)this.$project, (Object)file, (String)"ProjectPane", null, (VirtualFile)file, (boolean)true);
                PsiFile psiFile = PsiManager.getInstance((Project)this.$project).findFile(file);
                if (psiFile == null) {
                    return;
                }
                PsiFile psiFile2 = psiFile;
                EditorHelper.openInEditor((PsiElement)((PsiElement)psiFile2));
            }
        };
        GradleNotification.NOTIFICATION_GROUP.createNotification(notificationTitle, (String)notificationContent, NotificationType.INFORMATION).setDisplayId("gradle.jvm.invalid").setListener((NotificationListener)hyperLinkProcessor2).notify(project);
    }
}

