/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListenerAdapter;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemProcessingManager;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemResolveProjectTask;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemProgressNotificationManager;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataImportListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IntellijInternalApi;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.plugins.gradle.util.GradleImportingUtil;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0007\u001a\"\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u0002\u001a*\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u0002\u001a*\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u000b\u001a\u00020\t2\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u0002\u001a\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0007\u001a\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\b\u001a\u00020\tH\u0007\u001a\"\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\r\u001a\u00020\u00022\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002\u001a\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0007\u001a\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0006H\u0002\u001a\u001e\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u00192\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\u001a"}, d2={"getExecutionTaskFinishPromise", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/openapi/project/Project;", "getExternalSystemTaskFinishPromise", "isRelevantTask", "Lkotlin/Function1;", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "getExternalSystemTaskFinishPromiseImpl", "disposable", "getProjectDataLoadPromise", "project", "expectedProjectPath", "", "expectedProjects", "", "Ljava/nio/file/Path;", "getResolveTaskFinishPromise", "isResolveTask", "id", "whenResolveTaskStarted", "", "action", "Lkotlin/Function0;", "intellij.gradle.common"})
@JvmName(name="GradleImportingUtil")
public final class GradleImportingUtil {
    private static final boolean isResolveTask(ExternalSystemTaskId id) {
        ExternalSystemTask task2;
        if (id.getType() == ExternalSystemTaskType.RESOLVE_PROJECT && (task2 = ((ExternalSystemProcessingManager)ApplicationManager.getApplication().getService(ExternalSystemProcessingManager.class)).findTask(id)) instanceof ExternalSystemResolveProjectTask) {
            return !((ExternalSystemResolveProjectTask)task2).isPreviewMode();
        }
        return false;
    }

    @IntellijInternalApi
    public static final void whenResolveTaskStarted(@NotNull Function0<Unit> action2, @NotNull Disposable parentDisposable) {
        ExternalSystemProgressNotificationManager.getInstance().addNotificationListener((ExternalSystemTaskNotificationListener)new ExternalSystemTaskNotificationListenerAdapter(action2){
            final /* synthetic */ Function0<Unit> $action;
            {
                this.$action = $action;
            }

            public void onStart(@NotNull ExternalSystemTaskId id, @Nullable String workingDir) {
                if (GradleImportingUtil.access$isResolveTask(id)) {
                    this.$action.invoke();
                }
            }
        }, parentDisposable);
    }

    @IntellijInternalApi
    @NotNull
    public static final Promise<Project> getProjectDataLoadPromise(@NotNull Disposable parentDisposable) {
        return GradleImportingUtil.getResolveTaskFinishPromise(parentDisposable).thenAsync(arg_0 -> GradleImportingUtil.getProjectDataLoadPromise$lambda$0(getProjectDataLoadPromise.1.INSTANCE, arg_0));
    }

    @TestOnly
    @NotNull
    public static final Promise<Project> getProjectDataLoadPromise() {
        return GradleImportingUtil.getExternalSystemTaskFinishPromise((Function1<? super ExternalSystemTaskId, Boolean>)((Function1)getProjectDataLoadPromise.2.INSTANCE)).thenAsync(arg_0 -> GradleImportingUtil.getProjectDataLoadPromise$lambda$1(getProjectDataLoadPromise.3.INSTANCE, arg_0));
    }

    @TestOnly
    @NotNull
    public static final Promise<Project> getProjectDataLoadPromise(@NotNull List<? extends Path> expectedProjects) {
        if (!(!((Collection)expectedProjects).isEmpty())) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        return GradleImportingUtil.getExternalSystemTaskFinishPromise((Function1<? super ExternalSystemTaskId, Boolean>)((Function1)getProjectDataLoadPromise.4.INSTANCE)).thenAsync(arg_0 -> GradleImportingUtil.getProjectDataLoadPromise$lambda$2((Function1)new Function1<Project, Promise<Project>>(expectedProjects){
            final /* synthetic */ List<Path> $expectedProjects;
            {
                this.$expectedProjects = $expectedProjects;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final Promise<Project> invoke(Project project) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = this.$expectedProjects;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Path path = (Path)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    String linkedProjectPath = FileUtil.toCanonicalPath((String)((Object)it.toAbsolutePath()).toString());
                    collection.add(GradleImportingUtil.access$getProjectDataLoadPromise(project, linkedProjectPath));
                }
                return Promises.all((Collection)((List)destination$iv$iv), (Object)project, (boolean)false);
            }
        }, arg_0));
    }

    @TestOnly
    @NotNull
    public static final Promise<Project> getExecutionTaskFinishPromise() {
        return GradleImportingUtil.getExternalSystemTaskFinishPromise((Function1<? super ExternalSystemTaskId, Boolean>)((Function1)getExecutionTaskFinishPromise.1.INSTANCE));
    }

    private static final Promise<Project> getResolveTaskFinishPromise(Disposable parentDisposable) {
        return GradleImportingUtil.getExternalSystemTaskFinishPromise(parentDisposable, (Function1<? super ExternalSystemTaskId, Boolean>)((Function1)getResolveTaskFinishPromise.1.INSTANCE));
    }

    private static final Promise<Project> getExternalSystemTaskFinishPromise(Disposable parentDisposable, Function1<? super ExternalSystemTaskId, Boolean> isRelevantTask) {
        Disposable disposable = Disposer.newDisposable((Disposable)parentDisposable, (String)"");
        return GradleImportingUtil.getExternalSystemTaskFinishPromiseImpl(disposable, isRelevantTask);
    }

    private static final Promise<Project> getExternalSystemTaskFinishPromise(Function1<? super ExternalSystemTaskId, Boolean> isRelevantTask) {
        Disposable disposable = Disposer.newDisposable((String)"");
        return GradleImportingUtil.getExternalSystemTaskFinishPromiseImpl(disposable, isRelevantTask);
    }

    private static final Promise<Project> getExternalSystemTaskFinishPromiseImpl(Disposable disposable, Function1<? super ExternalSystemTaskId, Boolean> isRelevantTask) {
        AsyncPromise promise = new AsyncPromise();
        ExternalSystemProgressNotificationManager.getInstance().addNotificationListener((ExternalSystemTaskNotificationListener)new ExternalSystemTaskNotificationListenerAdapter(isRelevantTask, disposable, (AsyncPromise<Project>)promise){
            final /* synthetic */ Function1<ExternalSystemTaskId, Boolean> $isRelevantTask;
            final /* synthetic */ Disposable $disposable;
            final /* synthetic */ AsyncPromise<Project> $promise;
            {
                this.$isRelevantTask = $isRelevantTask;
                this.$disposable = $disposable;
                this.$promise = $promise;
            }

            public void onSuccess(@NotNull ExternalSystemTaskId id) {
                if (((Boolean)this.$isRelevantTask.invoke((Object)id)).booleanValue()) {
                    Disposer.dispose((Disposable)this.$disposable);
                    Project project = id.findProject();
                    Intrinsics.checkNotNull((Object)project);
                    this.$promise.setResult((Object)project);
                }
            }

            public void onFailure(@NotNull ExternalSystemTaskId id, @NotNull Exception e) {
                if (((Boolean)this.$isRelevantTask.invoke((Object)id)).booleanValue()) {
                    Disposer.dispose((Disposable)this.$disposable);
                    this.$promise.setError((Throwable)e);
                }
            }

            public void onCancel(@NotNull ExternalSystemTaskId id) {
                if (((Boolean)this.$isRelevantTask.invoke((Object)id)).booleanValue()) {
                    Disposer.dispose((Disposable)this.$disposable);
                    this.$promise.cancel();
                }
            }
        }, disposable);
        return (Promise)promise;
    }

    private static final Promise<Project> getProjectDataLoadPromise(Project project, String expectedProjectPath) {
        AsyncPromise promise = new AsyncPromise();
        Disposable parentDisposable = Disposer.newDisposable();
        MessageBusConnection connection = project.getMessageBus().connect(parentDisposable);
        connection.subscribe(ProjectDataImportListener.TOPIC, (Object)new ProjectDataImportListener(expectedProjectPath, parentDisposable, (AsyncPromise<Project>)promise, project){
            final /* synthetic */ String $expectedProjectPath;
            final /* synthetic */ Disposable $parentDisposable;
            final /* synthetic */ AsyncPromise<Project> $promise;
            final /* synthetic */ Project $project;
            {
                this.$expectedProjectPath = $expectedProjectPath;
                this.$parentDisposable = $parentDisposable;
                this.$promise = $promise;
                this.$project = $project;
            }

            public void onFinalTasksFinished(@Nullable String projectPath) {
                if (this.$expectedProjectPath == null || Intrinsics.areEqual((Object)this.$expectedProjectPath, (Object)projectPath)) {
                    Disposer.dispose((Disposable)this.$parentDisposable);
                    this.$promise.setResult((Object)this.$project);
                }
            }

            public void onImportFailed(@Nullable String projectPath) {
                if (this.$expectedProjectPath == null || Intrinsics.areEqual((Object)this.$expectedProjectPath, (Object)projectPath)) {
                    Disposer.dispose((Disposable)this.$parentDisposable);
                    this.$promise.setError("Import failed for " + projectPath);
                }
            }
        });
        return (Promise)promise;
    }

    static /* synthetic */ Promise getProjectDataLoadPromise$default(Project project, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return GradleImportingUtil.getProjectDataLoadPromise(project, string2);
    }

    private static final Promise getProjectDataLoadPromise$lambda$0(Function1 $tmp0, Object p0) {
        return (Promise)$tmp0.invoke(p0);
    }

    private static final Promise getProjectDataLoadPromise$lambda$1(Function1 $tmp0, Object p0) {
        return (Promise)$tmp0.invoke(p0);
    }

    private static final Promise getProjectDataLoadPromise$lambda$2(Function1 $tmp0, Object p0) {
        return (Promise)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ boolean access$isResolveTask(ExternalSystemTaskId id) {
        return GradleImportingUtil.isResolveTask(id);
    }

    public static final /* synthetic */ Promise access$getProjectDataLoadPromise(Project project, String expectedProjectPath) {
        return GradleImportingUtil.getProjectDataLoadPromise(project, expectedProjectPath);
    }
}

