/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.statistics;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.externalSystem.model.ConfigurationDataImpl;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.statistics.ExternalSystemUsagesCollector;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Version;
import java.lang.invoke.LambdaMetafactory;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.text.StringsKt;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.settings.TestRunner;
import org.jetbrains.plugins.gradle.statistics.GradleSettingsCollector;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/gradle/statistics/GradleSettingsCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "()V", "anonymizeGradleVersion", "", "version", "Lorg/gradle/util/GradleVersion;", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "intellij.gradle.common"})
public final class GradleSettingsCollector
extends ProjectUsagesCollector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final EventLogGroup GROUP = new EventLogGroup("build.gradle.state", 4, null, 4, null);
    @NotNull
    private static final EventId1<Boolean> HAS_GRADLE_PROJECT = GROUP.registerEvent("hasGradleProject", (EventField)EventFields.Enabled);
    @NotNull
    private static final EventId1<Boolean> OFFLINE_WORK = GROUP.registerEvent("offlineWork", (EventField)EventFields.Enabled);
    @NotNull
    private static final EventId1<Boolean> HAS_CUSTOM_SERVICE_DIRECTORY_PATH = GROUP.registerEvent("hasCustomServiceDirectoryPath", (EventField)EventFields.Enabled);
    @NotNull
    private static final EventId1<Boolean> HAS_CUSTOM_GRADLE_VM_OPTIONS = GROUP.registerEvent("hasCustomGradleVmOptions", (EventField)EventFields.Enabled);
    @NotNull
    private static final EventId1<Boolean> SHOW_SELECTIVE_IMPORT_DIALOG_ON_INITIAL_IMPORT = GROUP.registerEvent("showSelectiveImportDialogOnInitialImport", (EventField)EventFields.Enabled);
    @NotNull
    private static final EventId1<Boolean> STORE_PROJECT_FILES_EXTERNALLY = GROUP.registerEvent("storeProjectFilesExternally", (EventField)EventFields.Enabled);
    @NotNull
    private static final EventId1<Boolean> IS_USE_QUALIFIED_MODULE_NAMES = GROUP.registerEvent("isUseQualifiedModuleNames", (EventField)EventFields.Enabled);
    @NotNull
    private static final EventId1<Boolean> CREATE_MODULE_PER_SOURCE_SET = GROUP.registerEvent("createModulePerSourceSet", (EventField)EventFields.Enabled);
    @NotNull
    private static final EventId1<Boolean> IS_COMPOSITE_BUILDS = GROUP.registerEvent("isCompositeBuilds", (EventField)EventFields.Enabled);
    @NotNull
    private static final EventId1<Boolean> DISABLE_WRAPPER_SOURCE_DISTRIBUTION_NOTIFICATION = GROUP.registerEvent("disableWrapperSourceDistributionNotification", (EventField)EventFields.Enabled);
    @NotNull
    private static final EventId1<Boolean> DELEGATE_BUILD_RUN = GROUP.registerEvent("delegateBuildRun", (EventField)EventFields.Enabled);
    @NotNull
    private static final EventId1<Boolean> IDEA_SPECIFIC_CONFIGURATION_USED = GROUP.registerEvent("ideaSpecificConfigurationUsed", (EventField)EventFields.Enabled);
    @NotNull
    private static final EventId1<DistributionType> DISTRIBUTION_TYPE = GROUP.registerEvent("distributionType", (EventField)EventFields.Enum((String)"value", DistributionType.class, (Function1)Companion.DISTRIBUTION_TYPE.1.INSTANCE));
    @NotNull
    private static final StringEventField VERSION_FIELD = EventFields.StringValidatedByRegexp((String)"value", (String)"version");
    @NotNull
    private static final EventId1<String> GRADLE_VERSION = GROUP.registerEvent("gradleVersion", (EventField)VERSION_FIELD);
    @NotNull
    private static final EventId1<TestRunner> PREFERRED_TEST_RUNNER = GROUP.registerEvent("preferredTestRunner", (EventField)EventFields.Enum((String)"value", TestRunner.class, (Function1)Companion.PREFERRED_TEST_RUNNER.1.INSTANCE));
    @NotNull
    private static final EventId1<ExternalSystemUsagesCollector.JreType> GRADLE_JVM_TYPE = GROUP.registerEvent("gradleJvmType", (EventField)ExternalSystemUsagesCollector.Companion.getJRE_TYPE_FIELD());
    @NotNull
    private static final EventId1<String> GRADLE_JVM_VERSION = GROUP.registerEvent("gradleJvmVersion", (EventField)VERSION_FIELD);

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    protected Set<MetricEvent> getMetrics(@NotNull Project project) {
        gradleSettings = GradleSettings.getInstance(project);
        projectsSettings = gradleSettings.getLinkedProjectsSettings();
        if (projectsSettings.isEmpty()) {
            return SetsKt.emptySet();
        }
        usages = new LinkedHashSet<E>();
        usages.add(GradleSettingsCollector.HAS_GRADLE_PROJECT.metric((Object)true));
        usages.add(GradleSettingsCollector.OFFLINE_WORK.metric((Object)gradleSettings.isOfflineWork()));
        var5_5 = gradleSettings.getServiceDirectoryPath();
        usages.add(GradleSettingsCollector.HAS_CUSTOM_SERVICE_DIRECTORY_PATH.metric((Object)((var5_5 == null || StringsKt.isBlank((CharSequence)var5_5) != false) == false)));
        var5_5 = gradleSettings.getGradleVmOptions();
        usages.add(GradleSettingsCollector.HAS_CUSTOM_GRADLE_VM_OPTIONS.metric((Object)((var5_5 == null || StringsKt.isBlank((CharSequence)var5_5) != false) == false)));
        usages.add(GradleSettingsCollector.SHOW_SELECTIVE_IMPORT_DIALOG_ON_INITIAL_IMPORT.metric((Object)gradleSettings.showSelectiveImportDialogOnInitialImport()));
        usages.add(GradleSettingsCollector.STORE_PROJECT_FILES_EXTERNALLY.metric((Object)gradleSettings.getStoreProjectFilesExternally()));
        for (GradleProjectSettings setting : gradleSettings.getLinkedProjectsSettings()) {
            projectPath = setting.getExternalProjectPath();
            usages.add(GradleSettingsCollector.IS_USE_QUALIFIED_MODULE_NAMES.metric((Object)setting.isUseQualifiedModuleNames()));
            usages.add(GradleSettingsCollector.CREATE_MODULE_PER_SOURCE_SET.metric((Object)setting.isResolveModulePerSourceSet()));
            distributionType = setting.getDistributionType();
            if (distributionType != null) {
                usages.add(GradleSettingsCollector.DISTRIBUTION_TYPE.metric((Object)distributionType));
            }
            usages.add(GradleSettingsCollector.IS_COMPOSITE_BUILDS.metric((Object)(setting.getCompositeBuild() != null)));
            usages.add(GradleSettingsCollector.DISABLE_WRAPPER_SOURCE_DISTRIBUTION_NOTIFICATION.metric((Object)setting.isDisableWrapperSourceDistributionNotification()));
            usages.add(GradleSettingsCollector.GRADLE_JVM_TYPE.metric((Object)ExternalSystemUsagesCollector.Companion.getJreType(setting.getGradleJvm())));
            usages.add(GradleSettingsCollector.GRADLE_JVM_VERSION.metric((Object)ExternalSystemUsagesCollector.Companion.getJreVersion(project, setting.getGradleJvm())));
            gradleVersion = setting.resolveGradleVersion();
            if (gradleVersion.isSnapshot()) {
                usages.add(GradleSettingsCollector.GRADLE_VERSION.metric((Object)(this.anonymizeGradleVersion(gradleVersion.getBaseVersion()) + ".SNAPSHOT")));
            } else {
                usages.add(GradleSettingsCollector.GRADLE_VERSION.metric((Object)this.anonymizeGradleVersion(gradleVersion)));
            }
            usages.add(GradleSettingsCollector.DELEGATE_BUILD_RUN.metric((Object)GradleProjectSettings.isDelegatedBuildEnabled(project, projectPath)));
            usages.add(GradleSettingsCollector.PREFERRED_TEST_RUNNER.metric((Object)GradleProjectSettings.getTestRunner(project, projectPath)));
            var11_11 = ProjectDataManager.getInstance().getExternalProjectData(project, GradleConstants.SYSTEM_ID, projectPath);
            if (var11_11 == null || (var12_12 = var11_11.getExternalProjectStructure()) == null) ** GOTO lbl-1000
            dataNode = var12_12;
            $i$a$-let-GradleSettingsCollector$getMetrics$hasNonEmptyIntellijConfig$1 = false;
            var13_13 = ExternalSystemApiUtil.findFirstRecursively((DataNode)dataNode, (Predicate<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, getMetrics$lambda$1$lambda$0(kotlin.jvm.functions.Function1 java.lang.Object ), (Ljava/lang/Object;)Z)((Function1)getMetrics.hasNonEmptyIntellijConfig.1.1.INSTANCE));
            if (var13_13 == null) ** GOTO lbl-1000
            it = var13_13;
            $i$a$-let-GradleSettingsCollector$getMetrics$hasNonEmptyIntellijConfig$2 = false;
            var18_20 = it.getData();
            var14_14 = var18_20 instanceof ConfigurationDataImpl ? (ConfigurationDataImpl)var18_20 : null;
            if (var14_14 != null) {
                it = var14_14;
                $i$a$-let-GradleSettingsCollector$getMetrics$hasNonEmptyIntellijConfig$3 = false;
                v0 = it.getJsonString().length() > 2;
            } else lbl-1000:
            // 3 sources

            {
                v0 = false;
            }
            hasNonEmptyIntellijConfig = v0;
            usages.add(GradleSettingsCollector.IDEA_SPECIFIC_CONFIGURATION_USED.metric((Object)hasNonEmptyIntellijConfig));
        }
        return usages;
    }

    private final String anonymizeGradleVersion(GradleVersion version) {
        Object object = Version.parseVersion((String)version.getVersion());
        if (object == null || (object = object.toCompactString()) == null) {
            object = "unknown";
        }
        return object;
    }

    private static final boolean getMetrics$lambda$1$lambda$0(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/plugins/gradle/statistics/GradleSettingsCollector$Companion;", "", "()V", "CREATE_MODULE_PER_SOURCE_SET", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "", "DELEGATE_BUILD_RUN", "DISABLE_WRAPPER_SOURCE_DISTRIBUTION_NOTIFICATION", "DISTRIBUTION_TYPE", "Lorg/jetbrains/plugins/gradle/settings/DistributionType;", "GRADLE_JVM_TYPE", "Lcom/intellij/openapi/externalSystem/statistics/ExternalSystemUsagesCollector$JreType;", "GRADLE_JVM_VERSION", "", "GRADLE_VERSION", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "HAS_CUSTOM_GRADLE_VM_OPTIONS", "HAS_CUSTOM_SERVICE_DIRECTORY_PATH", "HAS_GRADLE_PROJECT", "IDEA_SPECIFIC_CONFIGURATION_USED", "IS_COMPOSITE_BUILDS", "IS_USE_QUALIFIED_MODULE_NAMES", "OFFLINE_WORK", "PREFERRED_TEST_RUNNER", "Lorg/jetbrains/plugins/gradle/settings/TestRunner;", "SHOW_SELECTIVE_IMPORT_DIALOG_ON_INITIAL_IMPORT", "STORE_PROJECT_FILES_EXTERNALLY", "VERSION_FIELD", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "intellij.gradle.common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

