/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.startup;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.ExternalSystemConfigurableAware;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkProvider;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkUtil;
import com.intellij.openapi.externalSystem.service.settings.AbstractExternalSystemConfigurable;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListenerEx;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ui.configuration.SdkListPresenter;
import com.intellij.openapi.util.Computable;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.GradleManager;
import org.jetbrains.plugins.gradle.service.project.GradleNotification;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.startup.GradleProjectSettingsUpdater;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleJvmResolutionUtil;
import org.jetbrains.plugins.gradle.util.GradleJvmValidationUtil;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u0012\u0010\u0011\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0010H\u0002J*\u0010\u0014\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00102\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0002J:\u0010\u0016\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u001a\u0010\u0017\u001a\u0016\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0016J\u0018\u0010\u001c\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u0010H\u0002J\u0018\u0010\u001e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/plugins/gradle/startup/GradleProjectSettingsUpdater;", "Lcom/intellij/openapi/externalSystem/settings/ExternalSystemSettingsListenerEx;", "()V", "findRegisteredSdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "sdk", "fixupInternalJdk", "", "project", "Lcom/intellij/openapi/project/Project;", "projectSettings", "Lorg/jetbrains/plugins/gradle/settings/GradleProjectSettings;", "fixupUnknownSdk", "isInternalSdk", "", "jdkReference", "", "isSdkName", "isUnknownSdk", "sdkName", "notifyGradleJvmChangeInfo", "gradleJvm", "onProjectsLoaded", "manager", "Lcom/intellij/openapi/externalSystem/ExternalSystemManager;", "settings", "", "Lcom/intellij/openapi/externalSystem/settings/ExternalProjectSettings;", "showGradleProjectSettings", "externalProjectPath", "updateGradleJvm", "intellij.gradle.common"})
final class GradleProjectSettingsUpdater
implements ExternalSystemSettingsListenerEx {
    public void onProjectsLoaded(@NotNull Project project, @NotNull ExternalSystemManager<?, ?, ?, ?, ?> manager, @NotNull Collection<? extends ExternalProjectSettings> settings2) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        if (!(manager instanceof GradleManager)) {
            return;
        }
        for (ExternalProjectSettings externalProjectSettings : settings2) {
            if (!(externalProjectSettings instanceof GradleProjectSettings)) continue;
            this.updateGradleJvm(project, (GradleProjectSettings)externalProjectSettings);
        }
    }

    private final void updateGradleJvm(Project project, GradleProjectSettings projectSettings) {
        String string2 = projectSettings.getGradleJvm();
        if (string2 == null) {
            return;
        }
        String gradleJvm = string2;
        if (this.isInternalSdk(gradleJvm)) {
            this.fixupInternalJdk(project, projectSettings);
        } else if (this.isSdkName(gradleJvm) && this.isUnknownSdk(gradleJvm)) {
            this.fixupUnknownSdk(project, projectSettings);
        }
    }

    private final void fixupInternalJdk(Project project, GradleProjectSettings projectSettings) {
        ExternalSystemJdkProvider jdkProvider = ExternalSystemJdkProvider.getInstance();
        Sdk internalSdk = jdkProvider.getInternalJdk();
        projectSettings.setGradleJvm(internalSdk.getName());
        this.fixupUnknownSdk(project, projectSettings);
    }

    private final void fixupUnknownSdk(Project project, GradleProjectSettings projectSettings) {
        String string2 = projectSettings.getGradleJvm();
        if (string2 == null) {
            return;
        }
        String gradleJvm = string2;
        GradleVersion gradleVersion2 = projectSettings.resolveGradleVersion();
        projectSettings.setGradleJvm(null);
        GradleJvmResolutionUtil.getGradleJvmLookupProvider(project, projectSettings).newLookupBuilder().withSdkName(gradleJvm).withVersionFilter((Function1)new Function1<String, Boolean>(gradleVersion2){
            final /* synthetic */ GradleVersion $gradleVersion;
            {
                this.$gradleVersion = $gradleVersion;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull String it) {
                return GradleJvmValidationUtil.isSupported(this.$gradleVersion, it);
            }
        }).withSdkType(ExternalSystemJdkUtil.getJavaSdkType()).withSdkHomeFilter((Function1)fixupUnknownSdk.2.INSTANCE).onSdkNameResolved((Function1)new Function1<Sdk, Unit>(this, projectSettings){
            final /* synthetic */ GradleProjectSettingsUpdater this$0;
            final /* synthetic */ GradleProjectSettings $projectSettings;
            {
                this.this$0 = $receiver;
                this.$projectSettings = $projectSettings;
                super(1);
            }

            public final void invoke(@Nullable Sdk sdk) {
                Sdk fakeSdk;
                Sdk sdk2 = sdk;
                if (sdk2 != null) {
                    Sdk sdk3 = sdk2;
                    GradleProjectSettingsUpdater gradleProjectSettingsUpdater = this.this$0;
                    Sdk p0 = sdk3;
                    boolean bl = false;
                    v1 = GradleProjectSettingsUpdater.access$findRegisteredSdk(gradleProjectSettingsUpdater, p0);
                } else {
                    v1 = fakeSdk = null;
                }
                if (fakeSdk != null && this.$projectSettings.getGradleJvm() == null) {
                    this.$projectSettings.setGradleJvm(fakeSdk.getName());
                }
            }
        }).onSdkResolved((Function1)new Function1<Sdk, Unit>(projectSettings, gradleJvm, this, project){
            final /* synthetic */ GradleProjectSettings $projectSettings;
            final /* synthetic */ String $gradleJvm;
            final /* synthetic */ GradleProjectSettingsUpdater this$0;
            final /* synthetic */ Project $project;
            {
                this.$projectSettings = $projectSettings;
                this.$gradleJvm = $gradleJvm;
                this.this$0 = $receiver;
                this.$project = $project;
                super(1);
            }

            public final void invoke(@Nullable Sdk sdk) {
                if (this.$projectSettings.getGradleJvm() == null) {
                    Object object = sdk;
                    if (object == null || (object = object.getName()) == null) {
                        object = this.$gradleJvm;
                    }
                    this.$projectSettings.setGradleJvm((String)object);
                }
                GradleProjectSettingsUpdater.access$notifyGradleJvmChangeInfo(this.this$0, this.$project, this.$projectSettings, this.$gradleJvm, sdk);
            }
        }).executeLookup();
    }

    private final void notifyGradleJvmChangeInfo(Project project, GradleProjectSettings projectSettings, String gradleJvm, Sdk sdk) {
        if (sdk == null) {
            return;
        }
        String string2 = sdk.getVersionString();
        if (string2 == null) {
            return;
        }
        String versionString = string2;
        String string3 = sdk.getHomePath();
        if (string3 == null) {
            return;
        }
        String homePath = string3;
        String string4 = projectSettings.getExternalProjectPath();
        if (string4 == null) {
            return;
        }
        String externalProjectPath2 = string4;
        String presentablePath = SdkListPresenter.presentDetectedSdkPath((String)homePath);
        String notificationTitle = GradleBundle.message("gradle.notifications.java.home.change.title", new Object[0]);
        Object[] objectArray = new Object[]{gradleJvm, versionString, presentablePath};
        String notificationContent = GradleBundle.message("gradle.notifications.java.home.change.content", objectArray);
        Notification notification = GradleNotification.NOTIFICATION_GROUP.createNotification(notificationTitle, notificationContent, NotificationType.INFORMATION);
        notification.setDisplayId("gradle.jvm.configured");
        notification.addAction((AnAction)NotificationAction.createSimple((String)GradleBundle.message("gradle.open.gradle.settings", new Object[0]), () -> GradleProjectSettingsUpdater.notifyGradleJvmChangeInfo$lambda$0(this, project, externalProjectPath2)));
        notification.notify(project);
    }

    private final void showGradleProjectSettings(Project project, String externalProjectPath2) {
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)GradleConstants.SYSTEM_ID);
        Intrinsics.checkNotNull((Object)manager, (String)"null cannot be cast to non-null type com.intellij.openapi.externalSystem.ExternalSystemConfigurableAware");
        Configurable configurable = ((ExternalSystemConfigurableAware)manager).getConfigurable(project);
        if (configurable instanceof AbstractExternalSystemConfigurable) {
            ShowSettingsUtil settingsUtil = ShowSettingsUtil.getInstance();
            settingsUtil.editConfigurable(project, configurable, () -> GradleProjectSettingsUpdater.showGradleProjectSettings$lambda$1(configurable, externalProjectPath2));
        }
    }

    private final boolean isUnknownSdk(String sdkName) {
        ProjectJdkTable projectJdkTable = ProjectJdkTable.getInstance();
        Sdk sdk = projectJdkTable.findJdk(sdkName);
        return sdk == null;
    }

    private final boolean isSdkName(String jdkReference) {
        return jdkReference != null && !StringsKt.startsWith$default((CharSequence)jdkReference, (char)'#', (boolean)false, (int)2, null);
    }

    private final boolean isInternalSdk(String jdkReference) {
        return Intrinsics.areEqual((Object)jdkReference, (Object)"#JAVA_INTERNAL");
    }

    private final Sdk findRegisteredSdk(Sdk sdk) {
        boolean $i$f$runReadAction = false;
        return (Sdk)ApplicationManager.getApplication().runReadAction(new Computable(sdk){
            final /* synthetic */ Sdk $sdk$inlined;
            {
                this.$sdk$inlined = sdk;
            }

            public final T compute() {
                boolean bl = false;
                ProjectJdkTable projectJdkTable = ProjectJdkTable.getInstance();
                return (T)projectJdkTable.findJdk(this.$sdk$inlined.getName(), this.$sdk$inlined.getSdkType().getName());
            }
        });
    }

    private static final void notifyGradleJvmChangeInfo$lambda$0(GradleProjectSettingsUpdater this$0, Project $project, String $externalProjectPath) {
        this$0.showGradleProjectSettings($project, $externalProjectPath);
    }

    private static final void showGradleProjectSettings$lambda$1(Configurable $configurable, String $externalProjectPath) {
        ((AbstractExternalSystemConfigurable)$configurable).selectProject($externalProjectPath);
    }

    public static final /* synthetic */ Sdk access$findRegisteredSdk(GradleProjectSettingsUpdater $this, Sdk sdk) {
        return $this.findRegisteredSdk(sdk);
    }

    public static final /* synthetic */ void access$notifyGradleJvmChangeInfo(GradleProjectSettingsUpdater $this, Project project, GradleProjectSettings projectSettings, String gradleJvm, Sdk sdk) {
        $this.notifyGradleJvmChangeInfo(project, projectSettings, gradleJvm, sdk);
    }
}

