/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.settings;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListener;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.config.GradleSettingsListenerAdapter;
import org.jetbrains.plugins.gradle.model.ExternalTask;
import org.jetbrains.plugins.gradle.model.GradleExtensions;
import org.jetbrains.plugins.gradle.model.GradleProperty;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.service.project.data.GradleExtensionsDataService;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleExtensionsSettings {
    private static final Logger LOG = Logger.getInstance(GradleExtensionsSettings.class);
    private final Settings myState = new Settings();

    public GradleExtensionsSettings(Project project) {
        ExternalSystemApiUtil.subscribe((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID, (ExternalSystemSettingsListener)new GradleSettingsListenerAdapter(){

            public void onProjectsUnlinked(@NotNull Set<String> linkedProjectPaths) {
                GradleExtensionsSettings.this.myState.remove(linkedProjectPaths);
            }
        });
    }

    @NotNull
    public static Settings getInstance(@NotNull Project project) {
        return ((GradleExtensionsSettings)project.getService(GradleExtensionsSettings.class)).myState;
    }

    public static void load(Project project) {
        Collection projectsData = ProjectDataManager.getInstance().getExternalProjectsData(project, GradleConstants.SYSTEM_ID);
        for (ExternalProjectInfo projectInfo : projectsData) {
            DataNode projectDataNode = projectInfo.getExternalProjectStructure();
            if (projectDataNode == null) continue;
            String projectPath = projectInfo.getExternalProjectPath();
            try {
                SmartList nodes = new SmartList();
                for (DataNode moduleNode : ExternalSystemApiUtil.findAll((DataNode)projectDataNode, (Key)ProjectKeys.MODULE)) {
                    ContainerUtil.addIfNotNull((Collection)nodes, (Object)ExternalSystemApiUtil.find((DataNode)moduleNode, GradleExtensionsDataService.KEY));
                }
                GradleExtensionsSettings.getInstance(project).add(projectPath, (Collection<? extends DataNode<GradleExtensions>>)nodes);
            }
            catch (ClassCastException e) {
                LOG.debug((Throwable)e);
                ExternalProjectsManager.getInstance((Project)project).getExternalProjectsWatcher().markDirty(projectPath);
            }
        }
    }

    @Nullable
    public static GradleProject getRootProject(@NotNull PsiElement element) {
        PsiFile containingFile = element.getContainingFile().getOriginalFile();
        Project project = containingFile.getProject();
        return GradleExtensionsSettings.getInstance(project).getRootGradleProject(GradleExtensionsSettings.getRootProjectPath(element));
    }

    @Nullable
    public static String getRootProjectPath(@NotNull PsiElement element) {
        PsiFile containingFile = element.getContainingFile().getOriginalFile();
        Module module = ModuleUtilCore.findModuleForFile((PsiFile)containingFile);
        return ExternalSystemApiUtil.getExternalRootProjectPath((Module)module);
    }

    public static class Settings {
        public Map<String, GradleProject> projects = new HashMap<String, GradleProject>();

        public void add(@NotNull String rootPath, @NotNull Collection<? extends DataNode<GradleExtensions>> extensionsData) {
            HashMap<String, GradleExtensions> extensionMap = new HashMap<String, GradleExtensions>();
            for (DataNode<GradleExtensions> dataNode : extensionsData) {
                DataNode parent = dataNode.getParent();
                if (parent == null || !(parent.getData() instanceof ModuleData)) continue;
                String gradlePath2 = GradleProjectResolverUtil.getGradlePath((ModuleData)parent.getData());
                extensionMap.put(gradlePath2, (GradleExtensions)dataNode.getData());
            }
            this.add(rootPath, extensionMap);
        }

        public void add(@NotNull String rootPath, @NotNull Map<String, GradleExtensions> extensions) {
            GradleProject gradleProject = new GradleProject();
            for (Map.Entry<String, GradleExtensions> entry : extensions.entrySet()) {
                GradleExtensionsData extensionsData = new GradleExtensionsData();
                GradleExtensions gradleExtensions = entry.getValue();
                extensionsData.parent = gradleExtensions.getParentProjectPath();
                for (org.jetbrains.plugins.gradle.model.GradleExtension extension : gradleExtensions.getExtensions()) {
                    GradleExtension gradleExtension = new GradleExtension();
                    gradleExtension.name = extension.getName();
                    gradleExtension.rootTypeFqn = extension.getTypeFqn();
                    extensionsData.extensions.put(extension.getName(), gradleExtension);
                }
                for (org.jetbrains.plugins.gradle.model.GradleConvention convention : gradleExtensions.getConventions()) {
                    GradleConvention gradleConvention = new GradleConvention();
                    gradleConvention.name = convention.getName();
                    gradleConvention.typeFqn = convention.getTypeFqn();
                    extensionsData.conventions.add(gradleConvention);
                }
                for (GradleProperty property2 : gradleExtensions.getGradleProperties()) {
                    GradleProp gradleProp = new GradleProp();
                    gradleProp.name = property2.getName();
                    gradleProp.typeFqn = property2.getTypeFqn();
                    extensionsData.properties.put(gradleProp.name, gradleProp);
                }
                for (ExternalTask task2 : gradleExtensions.getTasks()) {
                    GradleTask gradleTask = new GradleTask();
                    gradleTask.name = task2.getName();
                    String type = task2.getType();
                    if (type != null) {
                        gradleTask.typeFqn = type;
                    }
                    StringBuilder description = new StringBuilder();
                    if (task2.getDescription() != null) {
                        description.append(task2.getDescription());
                        if (task2.getGroup() != null) {
                            description.append("<p>");
                        }
                    }
                    if (task2.getGroup() != null) {
                        description.append("<i>Task group: ").append(task2.getGroup()).append("<i>");
                    }
                    gradleTask.description = description.toString();
                    extensionsData.tasksMap.put(gradleTask.name, gradleTask);
                }
                for (org.jetbrains.plugins.gradle.model.GradleConfiguration configuration : gradleExtensions.getConfigurations()) {
                    GradleConfiguration gradleConfiguration = new GradleConfiguration();
                    gradleConfiguration.name = configuration.getName();
                    gradleConfiguration.description = configuration.getDescription();
                    gradleConfiguration.visible = configuration.isVisible();
                    gradleConfiguration.scriptClasspath = configuration.isScriptClasspathConfiguration();
                    gradleConfiguration.declarationAlternatives = configuration.getDeclarationAlternatives();
                    if (gradleConfiguration.scriptClasspath) {
                        extensionsData.buildScriptConfigurations.put(configuration.getName(), gradleConfiguration);
                        continue;
                    }
                    extensionsData.configurations.put(configuration.getName(), gradleConfiguration);
                }
                gradleProject.extensions.put(entry.getKey(), extensionsData);
                extensionsData.myGradleProject = gradleProject;
            }
            HashMap<String, GradleProject> projects2 = new HashMap<String, GradleProject>(this.projects);
            projects2.put(rootPath, gradleProject);
            this.projects = projects2;
        }

        public void remove(Set<String> rootPaths) {
            HashMap<String, GradleProject> projects2 = new HashMap<String, GradleProject>(this.projects);
            for (String path : rootPaths) {
                projects2.remove(path);
            }
            this.projects = projects2;
        }

        @Nullable
        public GradleExtensionsData getExtensionsFor(@Nullable Module module) {
            if (module == null) {
                return null;
            }
            return this.getExtensionsFor(ExternalSystemApiUtil.getExternalRootProjectPath((Module)module), GradleProjectResolverUtil.getGradlePath(module));
        }

        @Nullable
        public GradleExtensionsData getExtensionsFor(@Nullable String rootProjectPath, @Nullable String gradlePath2) {
            GradleProject gradleProject = this.getRootGradleProject(rootProjectPath);
            if (gradleProject == null) {
                return null;
            }
            return gradleProject.extensions.get(gradlePath2);
        }

        @Contract(value="null -> null")
        @Nullable
        public GradleProject getRootGradleProject(@Nullable String rootProjectPath) {
            if (rootProjectPath == null) {
                return null;
            }
            return this.projects.get(rootProjectPath);
        }
    }

    public static class GradleProject {
        public Map<String, GradleExtensionsData> extensions = new HashMap<String, GradleExtensionsData>();
    }

    public static class GradleConfiguration {
        public String name;
        public boolean visible = true;
        public boolean scriptClasspath;
        public String description;
        public List<String> declarationAlternatives;
    }

    public static class GradleTask
    implements TypeAware {
        public String name;
        public String typeFqn = "org.gradle.api.DefaultTask";
        @Nullable
        public String description;

        @Override
        public String getTypeFqn() {
            return this.typeFqn;
        }
    }

    public static class GradleProp
    implements TypeAware {
        public String name;
        public String typeFqn = "java.lang.String";
        @Nullable
        public String value;

        @Override
        public String getTypeFqn() {
            return this.typeFqn;
        }
    }

    public static class GradleConvention
    implements TypeAware {
        public String name;
        public String typeFqn = "Object";

        @Override
        public String getTypeFqn() {
            return this.typeFqn;
        }
    }

    public static class GradleExtension
    implements TypeAware {
        public String name;
        public String rootTypeFqn = "Object";

        @Override
        public String getTypeFqn() {
            return this.rootTypeFqn;
        }
    }

    public static interface TypeAware {
        public String getTypeFqn();
    }

    public static class GradleExtensionsData {
        private GradleProject myGradleProject;
        public String parent;
        @NotNull
        public final Map<String, GradleExtension> extensions = new HashMap<String, GradleExtension>();
        @NotNull
        public final List<GradleConvention> conventions = new SmartList();
        @NotNull
        public final Map<String, GradleProp> properties = new HashMap<String, GradleProp>();
        @NotNull
        public final Map<String, GradleTask> tasksMap = new LinkedHashMap<String, GradleTask>();
        @NotNull
        public final Map<String, GradleConfiguration> configurations = new HashMap<String, GradleConfiguration>();
        @NotNull
        public final Map<String, GradleConfiguration> buildScriptConfigurations = new HashMap<String, GradleConfiguration>();

        @Nullable
        public GradleExtensionsData getParent() {
            if (this.myGradleProject == null) {
                return null;
            }
            return this.myGradleProject.extensions.get(this.parent);
        }

        @Nullable
        public GradleProp findProperty(@Nullable String name2) {
            return GradleExtensionsData.findProperty(this, name2);
        }

        @NotNull
        public Collection<GradleProp> findAllProperties() {
            return GradleExtensionsData.findAllProperties(this, new HashMap<String, GradleProp>());
        }

        @NotNull
        private static Collection<GradleProp> findAllProperties(@NotNull GradleExtensionsData extensionsData, @NotNull Map<String, GradleProp> result) {
            for (GradleProp property2 : extensionsData.properties.values()) {
                result.putIfAbsent(property2.name, property2);
            }
            if (extensionsData.getParent() != null) {
                GradleExtensionsData.findAllProperties(extensionsData.getParent(), result);
            }
            return result.values();
        }

        @Nullable
        private static GradleProp findProperty(@NotNull GradleExtensionsData extensionsData, String propName) {
            GradleExtensionsData parentData;
            GradleProp prop = extensionsData.properties.get(propName);
            if (prop != null) {
                return prop;
            }
            if (extensionsData.parent != null && extensionsData.myGradleProject != null && (parentData = extensionsData.myGradleProject.extensions.get(extensionsData.parent)) != null) {
                return GradleExtensionsData.findProperty(parentData, propName);
            }
            return null;
        }
    }
}

