/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.settings;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.externalSystem.util.PaintAwarePanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.target.GradleRuntimeTargetUI;
import org.jetbrains.plugins.gradle.execution.target.GradleTargetUtil;
import org.jetbrains.plugins.gradle.execution.target.TargetPathFieldWithBrowseButton;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.gradle.service.execution.BuildLayoutParameters;
import org.jetbrains.plugins.gradle.service.settings.GradleSystemSettingsControlBuilder;
import org.jetbrains.plugins.gradle.service.settings.IdeaGradleProjectSettingsControlBuilder;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleBundle;

public class IdeaGradleSystemSettingsControlBuilder
implements GradleSystemSettingsControlBuilder {
    @NotNull
    private final GradleSettings myInitialSettings;
    @Nullable
    private JBLabel myServiceDirectoryLabel;
    private JBLabel myServiceDirectoryHint;
    @Nullable
    private TargetPathFieldWithBrowseButton myServiceDirectoryPathField;
    @Nullable
    private JBTextField myGradleVmOptionsField;
    List<Component> myGradleVmOptionsComponents = new ArrayList<Component>();
    private boolean dropVmOptions;
    @Nullable
    private JBCheckBox myGenerateImlFilesCheckBox;
    private JBLabel myGenerateImlFilesHint;
    private boolean dropStoreExternallyCheckBox;
    private static final Pattern VM_OPTIONS_REGEX = Pattern.compile("^(\\s*\"?org\\.gradle\\.jvmargs\"?\\s*[=:]).*?(?<!\\\\)($)", 40);

    public IdeaGradleSystemSettingsControlBuilder(@NotNull GradleSettings initialSettings) {
        this.myInitialSettings = initialSettings;
    }

    @Override
    public void fillUi(@NotNull PaintAwarePanel canvas, int indentLevel) {
        this.addServiceDirectoryControl(canvas, indentLevel);
        this.addVMOptionsControl(canvas, indentLevel);
        if (!this.dropStoreExternallyCheckBox) {
            this.myGenerateImlFilesCheckBox = new JBCheckBox(GradleBundle.message("gradle.settings.text.generate.iml.files", new Object[0]));
            canvas.add((Component)this.myGenerateImlFilesCheckBox, (Object)ExternalSystemUiUtil.getFillLineConstraints((int)indentLevel));
            this.myGenerateImlFilesHint = new JBLabel(XmlStringUtil.wrapInHtml((CharSequence)GradleBundle.message("gradle.settings.text.generate.iml.files.hint", IdeaGradleProjectSettingsControlBuilder.getIDEName())), UIUtil.ComponentStyle.SMALL);
            this.myGenerateImlFilesHint.setForeground(UIUtil.getLabelFontColor((UIUtil.FontColor)UIUtil.FontColor.BRIGHTER));
            GridBag constraints = ExternalSystemUiUtil.getFillLineConstraints((int)indentLevel);
            constraints.insets.left += UIUtil.getCheckBoxTextHorizontalOffset((JCheckBox)this.myGenerateImlFilesCheckBox);
            constraints.insets.top = 0;
            canvas.add((Component)this.myGenerateImlFilesHint, (Object)constraints);
        }
    }

    @Override
    public void showUi(boolean show) {
        ExternalSystemUiUtil.showUi((Object)this, (boolean)show);
    }

    @Override
    public void reset() {
        if (this.myServiceDirectoryPathField != null) {
            BuildLayoutParameters buildLayoutParameters = GradleInstallationManager.defaultBuildLayoutParameters(this.myInitialSettings.getProject());
            String gradleUserHomeDir = GradleTargetUtil.maybeGetTargetValue(buildLayoutParameters.getGradleUserHome());
            ((JBTextField)this.myServiceDirectoryPathField.getTextField()).getEmptyText().setText(gradleUserHomeDir);
            this.myServiceDirectoryPathField.setLocalPath(this.myInitialSettings.getServiceDirectoryPath());
        }
        if (this.myGradleVmOptionsField != null) {
            String vmOptions = IdeaGradleSystemSettingsControlBuilder.trimIfPossible(this.myInitialSettings.getGradleVmOptions());
            this.myGradleVmOptionsField.setText(vmOptions);
            this.myGradleVmOptionsComponents.forEach(it -> {
                boolean showSetting = vmOptions != null || Registry.is((String)"gradle.settings.showDeprecatedSettings", (boolean)false);
                it.setVisible(showSetting);
            });
        }
        if (this.myGenerateImlFilesCheckBox != null) {
            this.myGenerateImlFilesCheckBox.setSelected(!this.myInitialSettings.getStoreProjectFilesExternally());
        }
    }

    @Override
    public boolean isModified() {
        if (this.myServiceDirectoryPathField != null && !Objects.equals(ExternalSystemApiUtil.normalizePath((String)this.myServiceDirectoryPathField.getLocalPath()), ExternalSystemApiUtil.normalizePath((String)this.myInitialSettings.getServiceDirectoryPath()))) {
            return true;
        }
        if (this.myGradleVmOptionsField != null && !Objects.equals(IdeaGradleSystemSettingsControlBuilder.trimIfPossible(this.myGradleVmOptionsField.getText()), IdeaGradleSystemSettingsControlBuilder.trimIfPossible(this.myInitialSettings.getGradleVmOptions()))) {
            return true;
        }
        return this.myGenerateImlFilesCheckBox != null && this.myGenerateImlFilesCheckBox.isSelected() == this.myInitialSettings.getStoreProjectFilesExternally();
    }

    @Override
    public void apply(@NotNull GradleSettings settings2) {
        if (this.myServiceDirectoryPathField != null) {
            String serviceDirectoryPath = IdeaGradleSystemSettingsControlBuilder.trimIfPossible(this.myServiceDirectoryPathField.getLocalPath());
            settings2.setServiceDirectoryPath(ExternalSystemApiUtil.normalizePath((String)serviceDirectoryPath));
        }
        if (this.myGradleVmOptionsField != null) {
            settings2.setGradleVmOptions(IdeaGradleSystemSettingsControlBuilder.trimIfPossible(this.myGradleVmOptionsField.getText()));
        }
        if (this.myGenerateImlFilesCheckBox != null) {
            settings2.setStoreProjectFilesExternally(!this.myGenerateImlFilesCheckBox.isSelected());
        }
    }

    @Override
    public boolean validate(@NotNull GradleSettings settings2) {
        return true;
    }

    @Override
    public void disposeUIResources() {
        ExternalSystemUiUtil.disposeUi((Object)this);
    }

    @Override
    @NotNull
    public GradleSettings getInitialSettings() {
        return this.myInitialSettings;
    }

    public IdeaGradleSystemSettingsControlBuilder dropStoreExternallyCheckBox() {
        this.dropStoreExternallyCheckBox = true;
        return this;
    }

    public IdeaGradleSystemSettingsControlBuilder dropVmOptions() {
        this.dropVmOptions = true;
        return this;
    }

    private void addServiceDirectoryControl(PaintAwarePanel canvas, int indentLevel) {
        this.myServiceDirectoryLabel = new JBLabel(GradleBundle.message("gradle.settings.text.user.home", new Object[0]));
        this.myServiceDirectoryHint = new JBLabel(XmlStringUtil.wrapInHtml((CharSequence)GradleBundle.message("gradle.settings.text.user.home.hint", new Object[0])), UIUtil.ComponentStyle.SMALL);
        this.myServiceDirectoryHint.setForeground(UIUtil.getLabelFontColor((UIUtil.FontColor)UIUtil.FontColor.BRIGHTER));
        this.myServiceDirectoryPathField = GradleRuntimeTargetUI.targetPathFieldWithBrowseButton(this.myInitialSettings.getProject(), GradleBundle.message("gradle.settings.text.user.home.dialog.title", new Object[0]));
        canvas.add((Component)this.myServiceDirectoryLabel, (Object)ExternalSystemUiUtil.getLabelConstraints((int)indentLevel));
        canvas.add((Component)((Object)this.myServiceDirectoryPathField), (Object)ExternalSystemUiUtil.getFillLineConstraints((int)indentLevel));
        canvas.add(Box.createGlue(), (Object)ExternalSystemUiUtil.getLabelConstraints((int)indentLevel));
        GridBag constraints = ExternalSystemUiUtil.getFillLineConstraints((int)indentLevel);
        constraints.insets.top = 0;
        canvas.add((Component)this.myServiceDirectoryHint, (Object)constraints);
        this.myServiceDirectoryLabel.setLabelFor((Component)((Object)this.myServiceDirectoryPathField));
    }

    private void addVMOptionsControl(@NotNull PaintAwarePanel canvas, int indentLevel) {
        if (!this.dropVmOptions) {
            JBLabel label = new JBLabel(GradleBundle.message("gradle.settings.text.vm.options", new Object[0]));
            canvas.add((Component)label, (Object)ExternalSystemUiUtil.getLabelConstraints((int)indentLevel));
            this.myGradleVmOptionsComponents.add((Component)label);
            this.myGradleVmOptionsField = new JBTextField();
            canvas.add((Component)this.myGradleVmOptionsField, (Object)ExternalSystemUiUtil.getFillLineConstraints((int)indentLevel));
            this.myGradleVmOptionsComponents.add((Component)this.myGradleVmOptionsField);
            label.setLabelFor((Component)this.myGradleVmOptionsField);
            Component glue = Box.createGlue();
            canvas.add(glue, (Object)ExternalSystemUiUtil.getLabelConstraints((int)indentLevel));
            this.myGradleVmOptionsComponents.add(glue);
            final HyperlinkLabel fixLabel = new HyperlinkLabel();
            fixLabel.setFontSize(UIUtil.FontSize.SMALL);
            fixLabel.setForeground(UIUtil.getLabelFontColor((UIUtil.FontColor)UIUtil.FontColor.BRIGHTER));
            fixLabel.setIcon(AllIcons.General.BalloonWarning12);
            label.setVerticalTextPosition(1);
            GridBag constraints = ExternalSystemUiUtil.getFillLineConstraints((int)indentLevel);
            constraints.insets.top = 0;
            canvas.add((Component)fixLabel, (Object)constraints);
            this.myGradleVmOptionsComponents.add((Component)fixLabel);
            this.myGradleVmOptionsField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(@NotNull DocumentEvent e) {
                    boolean showMigration = e.getDocument().getLength() > 0;
                    fixLabel.setHyperlinkText(GradleBundle.message("gradle.settings.text.vm.options.link.tooltip", new Object[0]) + " ", showMigration ? GradleBundle.message("gradle.settings.text.vm.options.link.text", new Object[0]) : "  ", "");
                }
            });
            this.myGradleVmOptionsField.setText(" ");
            fixLabel.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

                protected void hyperlinkActivated(@NotNull HyperlinkEvent e) {
                    String jvmArgs = IdeaGradleSystemSettingsControlBuilder.this.myGradleVmOptionsField.getText().trim();
                    if (jvmArgs.isEmpty()) {
                        return;
                    }
                    if (IdeaGradleSystemSettingsControlBuilder.this.moveVMOptionsToGradleProperties(jvmArgs, IdeaGradleSystemSettingsControlBuilder.this.myInitialSettings)) {
                        IdeaGradleSystemSettingsControlBuilder.this.myGradleVmOptionsField.setText(null);
                        IdeaGradleSystemSettingsControlBuilder.this.myGradleVmOptionsField.getEmptyText().setText(GradleBundle.message("gradle.settings.text.vm.options.empty.text", new Object[0]));
                    }
                }
            });
        }
    }

    @Nullable
    private static String trimIfPossible(@Nullable String s) {
        return StringUtil.nullize((String)StringUtil.trim((String)s));
    }

    private boolean moveVMOptionsToGradleProperties(@NotNull String vmOptions, @NotNull GradleSettings settings2) {
        int result;
        String fieldText;
        File gradleUserHomeDir = null;
        if (this.myServiceDirectoryPathField != null && (fieldText = IdeaGradleSystemSettingsControlBuilder.trimIfPossible(this.myServiceDirectoryPathField.getText())) != null) {
            gradleUserHomeDir = new File(fieldText);
        }
        if (gradleUserHomeDir == null) {
            BuildLayoutParameters buildLayoutParameters = GradleInstallationManager.defaultBuildLayoutParameters(settings2.getProject());
            String gradleUserHome2 = GradleTargetUtil.maybeGetLocalValue(buildLayoutParameters.getGradleUserHome());
            if (gradleUserHome2 == null) {
                Messages.showErrorDialog((Project)settings2.getProject(), (String)GradleBundle.message("gradle.settings.text.vm.options.migration.error.text", GradleBundle.message("gradle.settings.text.user.home.not.found.error.text", new Object[0])), (String)GradleBundle.message("gradle.settings.text.vm.options.migration.error.title", new Object[0]));
                return false;
            }
            gradleUserHomeDir = new File(gradleUserHome2);
        }
        if ((result = Messages.showYesNoDialog((Project)settings2.getProject(), (String)GradleBundle.message("gradle.settings.text.vm.options.confirm.text", new File(gradleUserHomeDir, "gradle.properties")), (String)GradleBundle.message("gradle.title.gradle.settings", new Object[0]), (Icon)Messages.getQuestionIcon())) != 0) {
            return false;
        }
        try {
            String updated;
            if (!gradleUserHomeDir.exists() && !FileUtil.createDirectory((File)gradleUserHomeDir)) {
                throw new IOException("Cannot create " + gradleUserHomeDir);
            }
            File props = new File(gradleUserHomeDir, "gradle.properties");
            if (props.isDirectory()) {
                throw new IOException(props.getPath() + " is a directory");
            }
            String original = props.exists() ? FileUtil.loadFile((File)props) : "";
            if (!original.equals(updated = IdeaGradleSystemSettingsControlBuilder.updateVMOptions(original, vmOptions))) {
                FileUtil.writeToFile((File)props, (String)updated);
            }
        }
        catch (IOException e) {
            Messages.showErrorDialog((Project)settings2.getProject(), (String)GradleBundle.message("gradle.settings.text.vm.options.migration.error.text", e.getMessage()), (String)GradleBundle.message("gradle.settings.text.vm.options.migration.error.title", new Object[0]));
            return false;
        }
        return true;
    }

    @NotNull
    public static String updateVMOptions(@NotNull String originalText, @NotNull String vmOptions) {
        Matcher matcher = VM_OPTIONS_REGEX.matcher(originalText);
        StringBuilder result = new StringBuilder(originalText.length() + vmOptions.length());
        String escapedValue = StringUtil.escapeProperty((String)vmOptions, (boolean)false);
        if (matcher.find()) {
            matcher.appendReplacement(result, "$1" + Matcher.quoteReplacement(escapedValue) + "$2");
            matcher.appendTail(result);
        } else {
            result.append(originalText);
            if (!originalText.isEmpty() && !originalText.endsWith("\n")) {
                result.append("\n");
            }
            result.append("org.gradle.jvmargs=").append(escapedValue).append("\n");
        }
        return result.toString();
    }
}

