/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project.open;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.UiUtils;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.PathKt;
import com.intellij.util.text.StringKt;
import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.gradle.service.project.open.GradleOpenProjectProvider;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleEnvironment;
import org.jetbrains.plugins.gradle.util.GradleJvmResolutionUtil;
import org.jetbrains.plugins.gradle.util.GradleUtil;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0001H\u0007\u001a\u000e\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t\u001a\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u0005H\u0007\u001a\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a-\u0010\u0010\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0011\u001a\u00020\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0013\u001a\u00020\u0001H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0014\u001a\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u001c\u0010\u0018\u001a\u00020\u000f*\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0007\u001a\f\u0010\u0019\u001a\u00020\u000f*\u00020\u001aH\u0007\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001b"}, d2={"canLinkAndRefreshGradleProject", "", "projectFilePath", "", "project", "Lcom/intellij/openapi/project/Project;", "showValidationDialog", "canOpenGradleProject", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "createLinkSettings", "Lorg/jetbrains/plugins/gradle/settings/GradleProjectSettings;", "projectDirectory", "Ljava/nio/file/Path;", "linkAndRefreshGradleProject", "", "openGradleProject", "projectFile", "projectToClose", "forceOpenInNewFrame", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/project/Project;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "suggestGradleHome", "validateGradleProject", "Lcom/intellij/openapi/ui/ValidationInfo;", "setupGradleProjectSettings", "setupGradleSettings", "Lorg/jetbrains/plugins/gradle/settings/GradleSettings;", "intellij.gradle.common"})
@JvmName(name="GradleProjectImportUtil")
public final class GradleProjectImportUtil {
    public static final boolean canOpenGradleProject(@NotNull VirtualFile file) {
        return new GradleOpenProjectProvider().canOpenProject(file);
    }

    @Nullable
    public static final Object openGradleProject(@NotNull VirtualFile projectFile, @Nullable Project projectToClose, boolean forceOpenInNewFrame, @NotNull Continuation<? super Project> $completion) {
        return new GradleOpenProjectProvider().openProject(projectFile, projectToClose, forceOpenInNewFrame, $completion);
    }

    @ApiStatus.Experimental
    @JvmOverloads
    public static final boolean canLinkAndRefreshGradleProject(@NotNull String projectFilePath, @NotNull Project project, boolean showValidationDialog) {
        ValidationInfo validationInfo = GradleProjectImportUtil.validateGradleProject(projectFilePath, project);
        if (validationInfo == null) {
            return true;
        }
        ValidationInfo validationInfo2 = validationInfo;
        if (showValidationDialog) {
            String title = ExternalSystemBundle.message((String)"error.project.import.error.title", (Object[])new Object[0]);
            if (validationInfo2.warning) {
                Messages.showWarningDialog((Project)project, (String)validationInfo2.message, (String)title);
            } else {
                Messages.showErrorDialog((Project)project, (String)validationInfo2.message, (String)title);
            }
        }
        return false;
    }

    public static /* synthetic */ boolean canLinkAndRefreshGradleProject$default(String string2, Project project, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return GradleProjectImportUtil.canLinkAndRefreshGradleProject(string2, project, bl);
    }

    public static final void linkAndRefreshGradleProject(@NotNull String projectFilePath, @NotNull Project project) {
        new GradleOpenProjectProvider().linkToExistingProject(projectFilePath, project);
    }

    @ApiStatus.Internal
    @NotNull
    public static final GradleProjectSettings createLinkSettings(@NotNull Path projectDirectory, @NotNull Project project) {
        GradleSettings gradleSettings = GradleSettings.getInstance(project);
        GradleProjectImportUtil.setupGradleSettings(gradleSettings);
        GradleProjectSettings gradleProjectSettings = new GradleProjectSettings();
        GradleProjectImportUtil.setupGradleProjectSettings(gradleProjectSettings, project, projectDirectory);
        GradleVersion gradleVersion2 = gradleProjectSettings.resolveGradleVersion();
        GradleJvmResolutionUtil.setupGradleJvm(project, gradleProjectSettings, gradleVersion2);
        return gradleProjectSettings;
    }

    @ApiStatus.Internal
    public static final void setupGradleSettings(@NotNull GradleSettings $this$setupGradleSettings) {
        String string2 = GradleEnvironment.Headless.GRADLE_VM_OPTIONS;
        if (string2 == null) {
            string2 = $this$setupGradleSettings.getGradleVmOptions();
        }
        $this$setupGradleSettings.setGradleVmOptions(string2);
        String string3 = GradleEnvironment.Headless.GRADLE_OFFLINE;
        $this$setupGradleSettings.setOfflineWork(string3 != null ? Boolean.parseBoolean(string3) : $this$setupGradleSettings.isOfflineWork());
        String string4 = GradleEnvironment.Headless.GRADLE_SERVICE_DIRECTORY;
        if (string4 == null) {
            string4 = $this$setupGradleSettings.getServiceDirectoryPath();
        }
        $this$setupGradleSettings.setServiceDirectoryPath(string4);
        $this$setupGradleSettings.setStoreProjectFilesExternally(true);
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    public static final void setupGradleProjectSettings(@NotNull GradleProjectSettings $this$setupGradleProjectSettings, @NotNull Project project, @NotNull Path projectDirectory) {
        Object object;
        GradleProjectSettings gradleProjectSettings;
        block5: {
            block4: {
                void p0;
                $this$setupGradleProjectSettings.setExternalProjectPath(PathKt.getSystemIndependentPath((Path)projectDirectory));
                $this$setupGradleProjectSettings.setUseQualifiedModuleNames(true);
                gradleProjectSettings = $this$setupGradleProjectSettings;
                object = GradleEnvironment.Headless.GRADLE_DISTRIBUTION_TYPE;
                if (object == null) break block4;
                String string2 = object;
                GradleProjectSettings gradleProjectSettings2 = gradleProjectSettings;
                boolean bl = false;
                DistributionType distributionType = DistributionType.valueOf((String)p0);
                gradleProjectSettings = gradleProjectSettings2;
                object = distributionType;
                if (distributionType != null) break block5;
            }
            object = DistributionType.DEFAULT_WRAPPED;
        }
        gradleProjectSettings.setDistributionType((DistributionType)((Object)object));
        String string3 = GradleEnvironment.Headless.GRADLE_HOME;
        if (string3 == null) {
            string3 = GradleProjectImportUtil.suggestGradleHome(project);
        }
        $this$setupGradleProjectSettings.setGradleHome(string3);
    }

    private static final String suggestGradleHome(Project project) {
        GradleInstallationManager installationManager = (GradleInstallationManager)ApplicationManager.getApplication().getService(GradleInstallationManager.class);
        String lastUsedGradleHome = StringKt.nullize$default((String)GradleUtil.getLastUsedGradleHome(), (boolean)false, (int)1, null);
        if (lastUsedGradleHome != null) {
            return lastUsedGradleHome;
        }
        File file = installationManager.getAutodetectedGradleHome(project);
        if (file == null) {
            return null;
        }
        File gradleHome2 = file;
        return FileUtil.toCanonicalPath((String)gradleHome2.getPath());
    }

    private static final ValidationInfo validateGradleProject(String projectFilePath, Project project) {
        AbstractExternalSystemSettings systemSettings = ExternalSystemApiUtil.getSettings((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID);
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        VirtualFile projectFile = localFileSystem.refreshAndFindFileByPath(projectFilePath);
        if (projectFile == null) {
            String shortPath = UiUtils.getPresentablePath((String)projectFilePath);
            Object[] objectArray = new Object[]{"Gradle", shortPath};
            return new ValidationInfo(ExternalSystemBundle.message((String)"error.project.does.not.exist", (Object[])objectArray));
        }
        VirtualFile projectDirectory = projectFile.isDirectory() ? projectFile : projectFile.getParent();
        ExternalProjectSettings projectSettings = systemSettings.getLinkedProjectSettings(projectDirectory.getPath());
        if (projectSettings != null) {
            return new ValidationInfo(ExternalSystemBundle.message((String)"error.project.already.registered", (Object[])new Object[0]));
        }
        return null;
    }

    @ApiStatus.Experimental
    @JvmOverloads
    public static final boolean canLinkAndRefreshGradleProject(@NotNull String projectFilePath, @NotNull Project project) {
        return GradleProjectImportUtil.canLinkAndRefreshGradleProject$default(projectFilePath, project, false, 4, null);
    }
}

