/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project.open;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.importing.AbstractOpenProjectProvider;
import com.intellij.openapi.externalSystem.importing.ImportSpecBuilder;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.internal.InternalExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectRefreshCallback;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.externalSystem.service.ui.ExternalProjectDataSelectorDialog;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.project.open.GradleProjectImportUtil;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleJvmResolutionUtil;
import org.jetbrains.plugins.gradle.util.GradleJvmValidationUtil;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0018\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\fH\u0016J&\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002R\u001e\u0010\u0003\u001a\f0\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\u0002\b\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/plugins/gradle/service/project/open/GradleOpenProjectProvider;", "Lcom/intellij/openapi/externalSystem/importing/AbstractOpenProjectProvider;", "()V", "systemId", "Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/NonNls;", "getSystemId", "()Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "createFinalImportCallback", "Lcom/intellij/openapi/externalSystem/service/project/ExternalProjectRefreshCallback;", "project", "Lcom/intellij/openapi/project/Project;", "externalProjectPath", "", "importData", "", "externalProject", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "isProjectFile", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "linkToExistingProject", "projectFile", "selectDataToImport", "intellij.gradle.common"})
public final class GradleOpenProjectProvider
extends AbstractOpenProjectProvider {
    @NotNull
    private final ProjectSystemId systemId = GradleConstants.SYSTEM_ID;

    @NotNull
    public ProjectSystemId getSystemId() {
        return this.systemId;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isProjectFile(@NotNull VirtualFile file) {
        if (file.isDirectory()) return false;
        String[] $this$any$iv = GradleConstants.BUILD_FILE_EXTENSIONS;
        boolean $i$f$any = false;
        int n = 0;
        int n2 = $this$any$iv.length;
        while (n < n2) {
            String element$iv;
            String it = element$iv = $this$any$iv[n];
            boolean bl = false;
            if (StringsKt.endsWith$default((String)file.getName(), (String)it, (boolean)false, (int)2, null)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void linkToExistingProject(@NotNull VirtualFile projectFile, @NotNull Project project) {
        AbstractOpenProjectProvider.getLOG().debug("Link Gradle project '" + projectFile + "' to existing project " + project.getName());
        Path projectPath = this.getProjectDirectory(projectFile).toNioPath();
        GradleProjectSettings settings2 = GradleProjectImportUtil.createLinkSettings(projectPath, project);
        GradleJvmValidationUtil.validateJavaHome(project, projectPath, settings2.resolveGradleVersion());
        String externalProjectPath2 = settings2.getExternalProjectPath();
        ExternalSystemApiUtil.getSettings((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID).linkProject((ExternalProjectSettings)settings2);
        if (!Registry.is((String)"external.system.auto.import.disabled")) {
            ExternalSystemUtil.refreshProject((String)externalProjectPath2, (ImportSpecBuilder)new ImportSpecBuilder(project, GradleConstants.SYSTEM_ID).usePreviewMode().use(ProgressExecutionMode.MODAL_SYNC));
            ExternalProjectsManagerImpl.getInstance((Project)project).runWhenInitialized(() -> GradleOpenProjectProvider.linkToExistingProject$lambda$1(externalProjectPath2, project, this));
        }
    }

    private final ExternalProjectRefreshCallback createFinalImportCallback(Project project, String externalProjectPath2) {
        return new ExternalProjectRefreshCallback(this, project, externalProjectPath2){
            final /* synthetic */ GradleOpenProjectProvider this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ String $externalProjectPath;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                this.$externalProjectPath = $externalProjectPath;
            }

            public void onSuccess(@Nullable DataNode<ProjectData> externalProject) {
                if (externalProject == null) {
                    return;
                }
                GradleOpenProjectProvider.access$selectDataToImport(this.this$0, this.$project, this.$externalProjectPath, externalProject);
                GradleOpenProjectProvider.access$importData(this.this$0, this.$project, externalProject);
                GradleJvmResolutionUtil.updateGradleJvm(this.$project, this.$externalProjectPath);
            }
        };
    }

    private final void selectDataToImport(Project project, String externalProjectPath2, DataNode<ProjectData> externalProject) {
        GradleSettings settings2 = GradleSettings.getInstance(project);
        boolean showSelectiveImportDialog = settings2.showSelectiveImportDialogOnInitialImport();
        Application application = ApplicationManager.getApplication();
        if (showSelectiveImportDialog && !application.isHeadlessEnvironment()) {
            application.invokeAndWait(() -> GradleOpenProjectProvider.selectDataToImport$lambda$2(externalProjectPath2, externalProject, project));
        }
    }

    private final void importData(Project project, DataNode<ProjectData> externalProject) {
        ProjectDataManager.getInstance().importData(externalProject, project);
    }

    private static final void linkToExistingProject$lambda$1(String $externalProjectPath, Project $project, GradleOpenProjectProvider this$0) {
        ExternalSystemUtil.refreshProject((String)$externalProjectPath, (ImportSpecBuilder)new ImportSpecBuilder($project, GradleConstants.SYSTEM_ID).callback(this$0.createFinalImportCallback($project, $externalProjectPath)));
    }

    private static final void selectDataToImport$lambda$2(String $externalProjectPath, DataNode $externalProject, Project $project) {
        InternalExternalProjectInfo projectInfo = new InternalExternalProjectInfo(GradleConstants.SYSTEM_ID, $externalProjectPath, $externalProject);
        ExternalProjectDataSelectorDialog dialog = new ExternalProjectDataSelectorDialog($project, (ExternalProjectInfo)projectInfo);
        if (dialog.hasMultipleDataToSelect()) {
            dialog.showAndGet();
        } else {
            Disposer.dispose((Disposable)dialog.getDisposable());
        }
    }

    public static final /* synthetic */ void access$selectDataToImport(GradleOpenProjectProvider $this, Project project, String externalProjectPath2, DataNode externalProject) {
        $this.selectDataToImport(project, externalProjectPath2, (DataNode<ProjectData>)externalProject);
    }

    public static final /* synthetic */ void access$importData(GradleOpenProjectProvider $this, Project project, DataNode externalProject) {
        $this.importData(project, (DataNode<ProjectData>)externalProject);
    }
}

