/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project.data;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ContentRootData;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractModuleDataService;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Order(value=-2147483617)
public final class GradleExcludeBuildFilesDataService
extends AbstractProjectDataService<ContentRootData, ContentEntry> {
    private static final Logger LOG = Logger.getInstance(GradleExcludeBuildFilesDataService.class);
    public static final String REGISTRY_KEY = "gradle.exclude.build.files.when.in.source.set";

    @NotNull
    public Key<ContentRootData> getTargetDataKey() {
        return ProjectKeys.CONTENT_ROOT;
    }

    public void importData(@NotNull Collection<? extends DataNode<ContentRootData>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (!Registry.get((String)REGISTRY_KEY).asBoolean()) {
            return;
        }
        if (toImport.isEmpty()) {
            return;
        }
        MultiMap byModule = ExternalSystemApiUtil.groupBy(toImport, ModuleData.class);
        for (Map.Entry entry : byModule.entrySet()) {
            Module module = (Module)((DataNode)entry.getKey()).getUserData(AbstractModuleDataService.MODULE_KEY);
            Module module2 = module = module != null ? module : modelsProvider.findIdeModule((ModuleData)((DataNode)entry.getKey()).getData());
            if (module == null) {
                LOG.warn(String.format("Can't exclude build files from content root. Reason: target module (%s) is not found at the ide. Content roots: %s", entry.getKey(), entry.getValue()));
                continue;
            }
            GradleExcludeBuildFilesDataService.importData(modelsProvider, (Collection)entry.getValue(), module);
        }
    }

    private static void importData(@NotNull IdeModifiableModelsProvider modelsProvider, @NotNull Collection<? extends DataNode<ContentRootData>> data, @NotNull Module module) {
        ModifiableRootModel modifiableRootModel = modelsProvider.getModifiableRootModel(module);
        for (DataNode<ContentRootData> dataNode : data) {
            ContentRootData contentRoot = (ContentRootData)dataNode.getData();
            String rootPath = contentRoot.getRootPath();
            ContentEntry contentEntry = GradleExcludeBuildFilesDataService.findContentRoot(modifiableRootModel, rootPath);
            if (contentEntry == null) continue;
            HashSet<String> toExclude = new HashSet<String>(GradleConstants.KNOWN_GRADLE_FILES.size());
            for (SourceFolder sourceFolder : contentEntry.getSourceFolders()) {
                VirtualFile sourceFolderRoot = sourceFolder.getFile();
                if (sourceFolderRoot == null || !sourceFolderRoot.isDirectory()) continue;
                for (String knownGradleFile : GradleConstants.KNOWN_GRADLE_FILES) {
                    VirtualFile buildFile = sourceFolderRoot.findChild(knownGradleFile);
                    if (buildFile == null || !buildFile.exists()) continue;
                    toExclude.add(knownGradleFile);
                }
            }
            List existingPatterns = contentEntry.getExcludePatterns();
            for (String toExcludeFile : toExclude) {
                if (existingPatterns.contains(toExcludeFile)) continue;
                GradleExcludeBuildFilesDataService.logDebug("Excluding build file '%s' for module '%s'", toExcludeFile, module.getName());
                contentEntry.addExcludePattern(toExcludeFile);
            }
        }
    }

    @Nullable
    private static ContentEntry findContentRoot(@NotNull ModifiableRootModel model, @NotNull String path) {
        ContentEntry[] entries;
        for (ContentEntry entry : entries = model.getContentEntries()) {
            VirtualFile file = entry.getFile();
            if (file == null || !ExternalSystemApiUtil.getLocalFileSystemPath((VirtualFile)file).equals(path)) continue;
            return entry;
        }
        return null;
    }

    private static void logDebug(@NotNull String format, Object ... args) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format(format, args));
        }
    }
}

