/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.build.events.MessageEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.DependencyData;
import com.intellij.openapi.externalSystem.model.project.ExternalEntityData;
import com.intellij.openapi.externalSystem.model.project.IExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryDependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryLevel;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ModuleDependencyData;
import com.intellij.openapi.externalSystem.model.project.ProjectCoordinate;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.project.ProjectId;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemDebugEnvironment;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleTypeManager;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectLinkedOpenHashMap;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.ProjectIdentifier;
import org.gradle.tooling.model.idea.IdeaModule;
import org.gradle.tooling.model.idea.IdeaProject;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.DefaultExternalDependencyId;
import org.jetbrains.plugins.gradle.ExternalDependencyId;
import org.jetbrains.plugins.gradle.issue.UnresolvedDependencySyncIssue;
import org.jetbrains.plugins.gradle.model.AbstractExternalDependency;
import org.jetbrains.plugins.gradle.model.Build;
import org.jetbrains.plugins.gradle.model.BuildScriptClasspathModel;
import org.jetbrains.plugins.gradle.model.DefaultExternalMultiLibraryDependency;
import org.jetbrains.plugins.gradle.model.DefaultFileCollectionDependency;
import org.jetbrains.plugins.gradle.model.ExternalDependency;
import org.jetbrains.plugins.gradle.model.ExternalLibraryDependency;
import org.jetbrains.plugins.gradle.model.ExternalMultiLibraryDependency;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.model.ExternalProjectDependency;
import org.jetbrains.plugins.gradle.model.ExternalSourceSet;
import org.jetbrains.plugins.gradle.model.FileCollectionDependency;
import org.jetbrains.plugins.gradle.model.Project;
import org.jetbrains.plugins.gradle.model.UnresolvedExternalDependency;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverExtension;
import org.jetbrains.plugins.gradle.service.project.ProjectResolverContext;
import org.jetbrains.plugins.gradle.settings.GradleExecutionWorkspace;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleModuleDataKt;
import org.jetbrains.plugins.gradle.util.GradleUtil;

public final class GradleProjectResolverUtil {
    private static final Logger LOG = Logger.getInstance(GradleProjectResolverUtil.class);
    @NonNls
    public static final String BUILD_SRC_NAME = "buildSrc";
    @NonNls
    private static final String SOURCE_JAR_SUFFIX = "-sources.jar";
    @NonNls
    private static final String JAVADOC_JAR_SUFFIX = "-javadoc.jar";
    private static final Key<Boolean> IS_INCLUDED_BUILD_TASK_RUN_SUPPORTED = Key.create((String)"is included build task running supported");
    private static final Key<Set<LibraryData>> LIBRARIES_CACHE = Key.create((String)"GradleProjectResolverUtil.LIBRARIES_CACHE");
    private static final Key<Map<String, Map<LibraryPathType, List<String>>>> PATHS_CACHE = Key.create((String)"GradleProjectResolverUtil.PATHS_CACHE");
    private static final Key<Map<String, DataNode<LibraryData>>> LIBRARIES_BY_NAME_CACHE = Key.create((String)"GradleProjectResolverUtil.FOUND_LIBRARIES");

    @NotNull
    public static DataNode<ModuleData> createMainModule(@NotNull ProjectResolverContext resolverCtx, @NotNull IdeaModule gradleModule, @NotNull DataNode<ProjectData> projectDataNode) {
        String mainModuleFileDirectoryPath;
        String moduleName;
        GradleProject gradleProject = gradleModule.getGradleProject();
        String string2 = moduleName = resolverCtx.isUseQualifiedModuleNames() ? gradleProject.getName() : gradleModule.getName();
        if (moduleName == null) {
            throw new IllegalStateException("Module with undefined name detected: " + gradleModule);
        }
        ProjectData projectData = (ProjectData)projectDataNode.getData();
        String mainModuleConfigPath = GradleProjectResolverUtil.getModuleConfigPath(resolverCtx, gradleModule, projectData.getLinkedExternalProjectPath());
        String ideProjectPath = resolverCtx.getIdeProjectPath();
        boolean isUnderProjectRoot = FileUtil.isAncestor((String)projectData.getLinkedExternalProjectPath(), (String)mainModuleConfigPath, (boolean)false);
        String relativePath = isUnderProjectRoot ? FileUtil.getRelativePath((String)projectData.getLinkedExternalProjectPath(), (String)mainModuleConfigPath, (char)'/') : String.valueOf(FileUtil.pathHashCode((String)mainModuleConfigPath));
        String string3 = ideProjectPath == null ? mainModuleConfigPath : (mainModuleFileDirectoryPath = ideProjectPath + "/" + (relativePath == null || relativePath.equals(".") ? "" : relativePath));
        if (ExternalSystemDebugEnvironment.DEBUG_ORPHAN_MODULES_PROCESSING) {
            LOG.info(String.format("Creating module data ('%s') with the external config path: '%s'", gradleProject.getPath(), mainModuleConfigPath));
        }
        String mainModuleId = GradleProjectResolverUtil.getModuleId(resolverCtx, gradleModule);
        ModuleData moduleData = new ModuleData(mainModuleId, GradleConstants.SYSTEM_ID, GradleProjectResolverUtil.getDefaultModuleTypeId(), moduleName, mainModuleFileDirectoryPath, mainModuleConfigPath);
        ExternalProject externalProject = resolverCtx.getExtraProject(gradleModule, ExternalProject.class);
        if (externalProject != null) {
            moduleData.setInternalName(GradleProjectResolverUtil.getInternalModuleName(gradleModule, externalProject, resolverCtx));
            moduleData.setGroup(externalProject.getGroup());
            moduleData.setVersion(externalProject.getVersion());
            moduleData.setDescription(externalProject.getDescription());
            moduleData.setModuleName(moduleName);
            if (!resolverCtx.isResolveModulePerSourceSet()) {
                moduleData.setArtifacts(externalProject.getArtifacts());
                moduleData.setPublication((ProjectCoordinate)new ProjectId(externalProject.getGroup(), externalProject.getName(), externalProject.getVersion()));
            }
        }
        File rootDir = gradleProject.getProjectIdentifier().getBuildIdentifier().getRootDir();
        String rootProjectPath = ExternalSystemApiUtil.toCanonicalPath((String)rootDir.getPath());
        boolean isComposite = !resolverCtx.getModels().getIncludedBuilds().isEmpty();
        boolean isIncludedBuildTaskRunningSupported = isComposite && GradleProjectResolverUtil.isIncludedBuildTaskRunningSupported(projectDataNode, resolverCtx);
        File mainBuildRootDir = resolverCtx.getModels().getMainBuild().getBuildIdentifier().getRootDir();
        String mainBuildRootPath = ExternalSystemApiUtil.toCanonicalPath((String)mainBuildRootDir.getPath());
        boolean isFromIncludedBuild2 = !rootProjectPath.equals(mainBuildRootPath);
        boolean useIncludedBuildPathPrefix = isFromIncludedBuild2 && isIncludedBuildTaskRunningSupported;
        String compositeBuildGradlePath = useIncludedBuildPathPrefix ? ":" + GradleProjectResolverUtil.getRootProject(gradleProject).getName() : "";
        GradleModuleDataKt.setCompositeBuildGradlePath(moduleData, compositeBuildGradlePath);
        String directoryToRunTask = compositeBuildGradlePath.isEmpty() ? (isUnderProjectRoot ? mainModuleConfigPath : rootProjectPath) : mainBuildRootPath;
        GradleModuleDataKt.setDirectoryToRunTask(moduleData, directoryToRunTask);
        return projectDataNode.createChild(ProjectKeys.MODULE, (Object)moduleData);
    }

    @NotNull
    private static GradleProject getRootProject(@NotNull GradleProject project) {
        GradleProject result = project;
        while (result.getParent() != null) {
            result = result.getParent();
        }
        return result;
    }

    private static boolean isIncludedBuildTaskRunningSupported(@NotNull DataNode<ProjectData> project, @NotNull ProjectResolverContext resolverCtx) {
        Boolean isSupported = (Boolean)IS_INCLUDED_BUILD_TASK_RUN_SUPPORTED.get(project);
        if (isSupported == null) {
            String gradleVersion2 = resolverCtx.getProjectGradleVersion();
            isSupported = gradleVersion2 != null && GradleVersion.version((String)gradleVersion2).compareTo(GradleVersion.version((String)"6.8")) >= 0;
            IS_INCLUDED_BUILD_TASK_RUN_SUPPORTED.set(project, (Object)isSupported);
        }
        return isSupported;
    }

    public static String getDefaultModuleTypeId() {
        ModuleType moduleType = ModuleTypeManager.getInstance().getDefaultModuleType();
        return moduleType.getId();
    }

    @NotNull
    static String getInternalModuleName(@NotNull IdeaModule gradleModule, @NotNull ExternalProject externalProject, @NotNull ProjectResolverContext resolverCtx) {
        return GradleProjectResolverUtil.getInternalModuleName(gradleModule, externalProject, null, resolverCtx);
    }

    @NotNull
    static String getInternalModuleName(@NotNull IdeaModule gradleModule, @NotNull ExternalProject externalProject, @Nullable String sourceSetName, @NotNull ProjectResolverContext resolverCtx) {
        String delimiter;
        StringBuilder moduleName = new StringBuilder();
        String buildSrcGroup = resolverCtx.getBuildSrcGroup();
        if (resolverCtx.isUseQualifiedModuleNames()) {
            delimiter = ".";
            if (StringUtil.isNotEmpty((String)buildSrcGroup)) {
                moduleName.append(buildSrcGroup).append(delimiter);
            }
            moduleName.append(GradleProjectResolverUtil.gradlePathToQualifiedName(gradleModule.getProject().getName(), externalProject.getQName()));
        } else {
            delimiter = "_";
            if (StringUtil.isNotEmpty((String)buildSrcGroup)) {
                moduleName.append(buildSrcGroup).append(delimiter);
            }
            moduleName.append(gradleModule.getName());
        }
        if (sourceSetName != null) {
            assert (!sourceSetName.isEmpty());
            moduleName.append(delimiter);
            moduleName.append(sourceSetName);
        }
        return PathUtilRt.suggestFileName((String)moduleName.toString(), (boolean)true, (boolean)false);
    }

    @NotNull
    private static String gradlePathToQualifiedName(@NotNull String rootName, @NotNull String gradlePath2) {
        return (String)(gradlePath2.startsWith(":") ? rootName + "." : "") + Arrays.stream(gradlePath2.split(":")).filter(s -> !s.isEmpty()).collect(Collectors.joining("."));
    }

    @NotNull
    public static String getModuleConfigPath(@NotNull ProjectResolverContext resolverCtx, @NotNull IdeaModule gradleModule, @NotNull String rootProjectPath) {
        ExternalProject externalProject = resolverCtx.getExtraProject(gradleModule, ExternalProject.class);
        if (externalProject != null) {
            File projectDir = externalProject.getProjectDir();
            return ExternalSystemApiUtil.toCanonicalPath((String)projectDir.getPath());
        }
        return GradleUtil.getConfigPath(gradleModule.getGradleProject(), rootProjectPath);
    }

    @NotNull
    public static String getModuleId(@NotNull ProjectResolverContext resolverCtx, @NotNull Build build, @NotNull Project project) {
        boolean isRootPath;
        ProjectIdentifier projectIdentifier = project.getProjectIdentifier();
        String gradlePath2 = projectIdentifier.getProjectPath();
        Object compositePrefix = "";
        boolean bl = isRootPath = StringUtil.isEmpty((String)gradlePath2) || ":".equals(gradlePath2);
        if (!isRootPath && build != resolverCtx.getModels().getMainBuild()) {
            compositePrefix = build.getName();
        } else if (!StringUtil.isEmpty((String)resolverCtx.getBuildSrcGroup())) {
            compositePrefix = resolverCtx.getBuildSrcGroup() + (isRootPath ? ":" : ":buildSrc");
        }
        return (String)compositePrefix + GradleProjectResolverUtil.getModuleId(gradlePath2, project.getName());
    }

    @NotNull
    public static String getModuleId(@NotNull ProjectResolverContext resolverCtx, @NotNull IdeaModule gradleModule) {
        boolean isRootPath;
        GradleProject gradleProject = gradleModule.getGradleProject();
        String gradlePath2 = gradleProject.getPath();
        Object compositePrefix = "";
        IdeaProject ideaProject = gradleModule.getProject();
        boolean bl = isRootPath = StringUtil.isEmpty((String)gradlePath2) || ":".equals(gradlePath2);
        if (!isRootPath && ideaProject != resolverCtx.getModels().getModel(IdeaProject.class)) {
            compositePrefix = ideaProject.getName();
        } else if (!StringUtil.isEmpty((String)resolverCtx.getBuildSrcGroup())) {
            compositePrefix = resolverCtx.getBuildSrcGroup() + (isRootPath ? ":" : ":buildSrc");
        }
        return (String)compositePrefix + GradleProjectResolverUtil.getModuleId(gradlePath2, gradleModule.getName());
    }

    @NotNull
    public static String getModuleId(String gradlePath2, String moduleName) {
        return StringUtil.isEmpty((String)gradlePath2) || ":".equals(gradlePath2) ? moduleName : gradlePath2;
    }

    @NotNull
    public static String getModuleId(@NotNull ExternalProject externalProject) {
        return externalProject.getId();
    }

    @NotNull
    public static String getModuleId(@NotNull ExternalProject externalProject, @NotNull ExternalSourceSet sourceSet) {
        String mainModuleId = GradleProjectResolverUtil.getModuleId(externalProject);
        return mainModuleId + ":" + sourceSet.getName();
    }

    @NotNull
    public static String getModuleId(@NotNull ProjectResolverContext resolverCtx, @NotNull IdeaModule gradleModule, @NotNull ExternalSourceSet sourceSet) {
        String mainModuleId = GradleProjectResolverUtil.getModuleId(resolverCtx, gradleModule);
        return mainModuleId + ":" + sourceSet.getName();
    }

    @NotNull
    public static String getModuleId(@NotNull ExternalProjectDependency projectDependency) {
        Object moduleId;
        DependencyScope dependencyScope = GradleProjectResolverUtil.getDependencyScope(projectDependency.getScope());
        String projectPath = projectDependency.getProjectPath();
        Object object = moduleId = StringUtil.isEmpty((String)projectPath) || ":".equals(projectPath) ? projectDependency.getName() : projectPath;
        moduleId = "default".equals(projectDependency.getConfigurationName()) ? (String)moduleId + (dependencyScope == DependencyScope.TEST ? ":test" : ":main") : (String)moduleId + ":" + projectDependency.getConfigurationName();
        return moduleId;
    }

    @Nullable
    public static String getSourceSetName(Module module) {
        if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module)) {
            return null;
        }
        if (!"sourceSet".equals(ExternalSystemApiUtil.getExternalModuleType((Module)module))) {
            return null;
        }
        String externalProjectId = ExternalSystemApiUtil.getExternalProjectId((Module)module);
        if (externalProjectId == null) {
            return null;
        }
        int i = externalProjectId.lastIndexOf(58);
        if (i == -1 || externalProjectId.length() < i + 1) {
            return null;
        }
        return externalProjectId.substring(i + 1);
    }

    @Nullable
    public static String getGradlePath(Module module) {
        String join;
        if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module)) {
            return null;
        }
        String externalProjectId = ExternalSystemApiUtil.getExternalProjectId((Module)module);
        if (externalProjectId == null) {
            return null;
        }
        String moduleType = ExternalSystemApiUtil.getExternalModuleType((Module)module);
        boolean trimSourceSet = "sourceSet".equals(moduleType);
        List pathParts = StringUtil.split((String)externalProjectId, (String)":");
        if (!externalProjectId.startsWith(":") && !pathParts.isEmpty()) {
            pathParts.remove(0);
        }
        if (trimSourceSet && !pathParts.isEmpty()) {
            pathParts.remove(pathParts.size() - 1);
        }
        return (join = StringUtil.join((Collection)pathParts, (String)":")).isEmpty() ? ":" : ":" + join;
    }

    @NotNull
    public static String getGradlePath(@NotNull ModuleData moduleData) {
        int colonIndex;
        String moduleId = moduleData.getId();
        String gradlePath2 = moduleId.charAt(0) != ':' ? ((colonIndex = moduleId.indexOf(58)) > 0 ? moduleId.substring(colonIndex) : ":") : moduleId;
        return gradlePath2;
    }

    @NotNull
    public static DependencyScope getDependencyScope(@Nullable String scope) {
        return scope != null ? DependencyScope.valueOf((String)scope) : DependencyScope.COMPILE;
    }

    public static void attachGradleSdkSources(@NotNull IdeaModule gradleModule, @Nullable File libFile, @NotNull LibraryData library, @NotNull ProjectResolverContext resolverCtx) {
        if (libFile == null || !libFile.getName().startsWith("gradle-")) {
            return;
        }
        BuildScriptClasspathModel buildScriptClasspathModel = resolverCtx.getExtraProject(gradleModule, BuildScriptClasspathModel.class);
        if (buildScriptClasspathModel == null) {
            return;
        }
        File gradleHomeDir = buildScriptClasspathModel.getGradleHomeDir();
        if (gradleHomeDir == null) {
            return;
        }
        GradleVersion gradleVersion2 = GradleVersion.version((String)buildScriptClasspathModel.getGradleVersion());
        GradleProjectResolverUtil.attachGradleSdkSources(libFile, library, gradleHomeDir, gradleVersion2);
    }

    public static void attachGradleSdkSources(@Nullable File libFile, @NotNull LibraryData library, @NotNull File gradleHomeDir, @NotNull GradleVersion gradleVersion2) {
        if (libFile == null || !libFile.getName().startsWith("gradle-")) {
            return;
        }
        if (!FileUtil.isAncestor((File)gradleHomeDir, (File)libFile, (boolean)true)) {
            File libFileParent = libFile.getParentFile();
            if (libFileParent == null || !StringUtil.equals((CharSequence)"generated-gradle-jars", (CharSequence)libFileParent.getName())) {
                return;
            }
            if (("gradle-api-" + gradleVersion2.getVersion() + ".jar").equals(libFile.getName())) {
                File gradleSrc = new File(gradleHomeDir, "src");
                File[] gradleSrcRoots = gradleSrc.listFiles();
                if (gradleSrcRoots == null) {
                    return;
                }
                for (File srcRoot : gradleSrcRoots) {
                    library.addPath(LibraryPathType.SOURCE, srcRoot.getPath());
                }
            }
            return;
        }
        File libOrPluginsFile = libFile.getParentFile();
        if (libOrPluginsFile != null && "plugins".equals(libOrPluginsFile.getName())) {
            libOrPluginsFile = libOrPluginsFile.getParentFile();
        }
        if (libOrPluginsFile != null && "lib".equals(libOrPluginsFile.getName()) && libOrPluginsFile.getParentFile() != null) {
            int endIndex;
            File srcDir = new File(libOrPluginsFile.getParentFile(), "src");
            if (gradleVersion2.compareTo(GradleVersion.version((String)"1.9")) >= 0 && (endIndex = libFile.getName().indexOf(gradleVersion2.getVersion())) != -1) {
                String srcDirChild = libFile.getName().substring("gradle-".length(), endIndex - 1);
                srcDir = new File(srcDir, srcDirChild);
            }
            if (srcDir.isDirectory()) {
                library.addPath(LibraryPathType.SOURCE, srcDir.getPath());
            }
        }
    }

    public static void attachSourcesAndJavadocFromGradleCacheIfNeeded(File gradleUserHomeDir, LibraryData libraryData) {
        GradleProjectResolverUtil.attachSourcesAndJavadocFromGradleCacheIfNeeded(null, gradleUserHomeDir, libraryData);
    }

    public static void attachSourcesAndJavadocFromGradleCacheIfNeeded(ProjectResolverContext context, File gradleUserHomeDir, LibraryData libraryData) {
        boolean docResolved;
        boolean sourceResolved = !libraryData.getPaths(LibraryPathType.SOURCE).isEmpty();
        boolean bl = docResolved = !libraryData.getPaths(LibraryPathType.DOC).isEmpty();
        if (sourceResolved && docResolved) {
            return;
        }
        Map pathsCache = null;
        if (context != null) {
            Set libsCache = (Set)context.getUserData(LIBRARIES_CACHE);
            if (libsCache == null) {
                libsCache = (Set)context.putUserDataIfAbsent(LIBRARIES_CACHE, Collections.newSetFromMap(new IdentityHashMap()));
            }
            if (!libsCache.add(libraryData)) {
                return;
            }
            pathsCache = (Map)context.getUserData(PATHS_CACHE);
            if (pathsCache == null) {
                pathsCache = (Map)context.putUserDataIfAbsent(PATHS_CACHE, new HashMap());
            }
        }
        for (String path : libraryData.getPaths(LibraryPathType.BINARY)) {
            HashMap<LibraryPathType, List<String>> collectedPaths;
            if (!FileUtil.isAncestor((String)gradleUserHomeDir.getPath(), (String)path, (boolean)true)) continue;
            HashMap<LibraryPathType, List<String>> hashMap = collectedPaths = pathsCache == null ? null : (HashMap<LibraryPathType, List<String>>)pathsCache.get(path);
            if (collectedPaths == null) {
                collectedPaths = new HashMap<LibraryPathType, List<String>>();
                if (pathsCache != null) {
                    pathsCache.put(path, collectedPaths);
                }
                GradleProjectResolverUtil.collectSourcesAndJavadocsFor(path, collectedPaths, sourceResolved, docResolved);
            }
            for (Map.Entry each : collectedPaths.entrySet()) {
                for (String cachedPath : (List)each.getValue()) {
                    libraryData.addPath((LibraryPathType)each.getKey(), cachedPath);
                }
            }
        }
    }

    private static void collectSourcesAndJavadocsFor(@NonNls @NotNull String binaryPath, @NotNull Map<LibraryPathType, List<String>> collect, boolean sourceResolved, boolean docResolved) {
        if (sourceResolved && docResolved) {
            return;
        }
        try {
            if (binaryPath.contains("/.gradle/caches/modules-2/files-2.1/")) {
                GradleProjectResolverUtil.collectSourcesAndJavadocsFromGradleCache(binaryPath, collect, sourceResolved, docResolved);
            } else {
                GradleProjectResolverUtil.collectSourcesAndJavadocsFromTheSameFolder(binaryPath, collect, sourceResolved, docResolved);
            }
        }
        catch (IOException | InvalidPathException e) {
            LOG.debug((Throwable)e);
        }
    }

    private static void collectSourcesAndJavadocsFromGradleCache(@NotNull String binaryPath, final @NotNull Map<LibraryPathType, List<String>> collect, boolean sourceResolved, boolean docResolved) throws IOException {
        Path file = Paths.get(binaryPath, new String[0]);
        final Path binaryFileParent = file.getParent();
        final Path grandParentFile = binaryFileParent.getParent();
        final boolean[] sourceFound = new boolean[]{sourceResolved};
        final boolean[] docFound = new boolean[]{docResolved};
        Files.walkFileTree(grandParentFile, EnumSet.noneOf(FileVisitOption.class), 2, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                if (binaryFileParent.equals(dir)) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return super.preVisitDirectory(dir, attrs);
            }

            @Override
            public FileVisitResult visitFile(Path sourceCandidate, BasicFileAttributes attrs) throws IOException {
                if (!sourceCandidate.getParent().getParent().equals(grandParentFile)) {
                    return FileVisitResult.SKIP_SIBLINGS;
                }
                if (attrs.isRegularFile()) {
                    String candidateFileName = sourceCandidate.getFileName().toString();
                    if (!sourceFound[0] && StringUtil.endsWith((CharSequence)candidateFileName, (CharSequence)GradleProjectResolverUtil.SOURCE_JAR_SUFFIX)) {
                        collect.computeIfAbsent(LibraryPathType.SOURCE, type -> new SmartList()).add(sourceCandidate.toFile().getPath());
                        sourceFound[0] = true;
                    } else if (!docFound[0] && StringUtil.endsWith((CharSequence)candidateFileName, (CharSequence)GradleProjectResolverUtil.JAVADOC_JAR_SUFFIX)) {
                        collect.computeIfAbsent(LibraryPathType.DOC, type -> new SmartList()).add(sourceCandidate.toFile().getPath());
                        docFound[0] = true;
                    }
                }
                if (sourceFound[0] && docFound[0]) {
                    return FileVisitResult.TERMINATE;
                }
                return super.visitFile(sourceCandidate, attrs);
            }
        });
    }

    private static void collectSourcesAndJavadocsFromTheSameFolder(@NotNull String binaryPath, @NotNull Map<LibraryPathType, List<String>> collect, boolean sourceResolved, boolean docResolved) throws IOException {
        Path file = Paths.get(binaryPath, new String[0]);
        Path binaryFileParent = file.getParent();
        if (!Files.isDirectory(binaryFileParent, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> list2 = Files.list(binaryFileParent);){
            Iterator it = list2.iterator();
            while (it.hasNext()) {
                Path p = (Path)it.next();
                if (!Files.isRegularFile(p, new LinkOption[0])) continue;
                String name2 = p.getFileName().toString();
                if (!sourceResolved && name2.endsWith(SOURCE_JAR_SUFFIX)) {
                    collect.computeIfAbsent(LibraryPathType.SOURCE, type -> new SmartList()).add(p.toFile().getPath());
                    sourceResolved = true;
                } else if (!docResolved && name2.endsWith(JAVADOC_JAR_SUFFIX)) {
                    collect.computeIfAbsent(LibraryPathType.DOC, type -> new SmartList()).add(p.toFile().getPath());
                    docResolved = true;
                }
                if (!sourceResolved || !docResolved) continue;
                return;
            }
        }
    }

    public static void buildDependencies(@NotNull ProjectResolverContext resolverCtx, @NotNull Map<String, Pair<DataNode<GradleSourceSetData>, ExternalSourceSet>> sourceSetMap, @NotNull Map<String, String> artifactsMap, @NotNull DataNode<? extends ExternalEntityData> ownerDataNode, @NotNull Collection<ExternalDependency> dependencies, @Nullable DataNode<ProjectData> ideProject) throws IllegalStateException {
        HashMap<ExternalDependencyId, ExternalDependency> dependencyMap = new HashMap<ExternalDependencyId, ExternalDependency>();
        LinkedList<ExternalDependency> queue = new LinkedList<ExternalDependency>(dependencies);
        while (!queue.isEmpty()) {
            ExternalDependency dependency = (ExternalDependency)queue.remove();
            DefaultExternalDependencyId key = new DefaultExternalDependencyId(dependency.getId());
            ExternalDependency seenDependency = (ExternalDependency)dependencyMap.get(key);
            if (seenDependency != null) {
                DependencyScope currentScope;
                if (dependency instanceof ExternalLibraryDependency) {
                    DefaultExternalMultiLibraryDependency mergedDependency;
                    if (seenDependency instanceof ExternalLibraryDependency && !FileUtil.filesEqual((File)((ExternalLibraryDependency)seenDependency).getFile(), (File)((ExternalLibraryDependency)dependency).getFile())) {
                        mergedDependency = new DefaultExternalMultiLibraryDependency();
                        mergedDependency.setName(dependency.getId().getName());
                        mergedDependency.setGroup(dependency.getId().getGroup());
                        mergedDependency.setVersion(dependency.getId().getVersion());
                        mergedDependency.setPackaging(dependency.getId().getPackaging());
                        mergedDependency.setClassifier(dependency.getId().getClassifier());
                        mergedDependency.setScope(dependency.getScope());
                        mergedDependency.setClasspathOrder(dependency.getClasspathOrder());
                        mergedDependency.getDependencies().addAll(dependency.getDependencies());
                        ContainerUtil.addIfNotNull((Collection)mergedDependency.getFiles(), (Object)((ExternalLibraryDependency)seenDependency).getFile());
                        ContainerUtil.addIfNotNull((Collection)mergedDependency.getFiles(), (Object)((ExternalLibraryDependency)dependency).getFile());
                        ContainerUtil.addIfNotNull((Collection)mergedDependency.getSources(), (Object)((ExternalLibraryDependency)seenDependency).getSource());
                        ContainerUtil.addIfNotNull((Collection)mergedDependency.getSources(), (Object)((ExternalLibraryDependency)dependency).getSource());
                        ContainerUtil.addIfNotNull((Collection)mergedDependency.getJavadoc(), (Object)((ExternalLibraryDependency)seenDependency).getJavadoc());
                        ContainerUtil.addIfNotNull((Collection)mergedDependency.getJavadoc(), (Object)((ExternalLibraryDependency)dependency).getJavadoc());
                        dependencyMap.put(dependency.getId(), (ExternalDependency)mergedDependency);
                        continue;
                    }
                    if (seenDependency instanceof DefaultExternalMultiLibraryDependency) {
                        mergedDependency = (DefaultExternalMultiLibraryDependency)seenDependency;
                        ContainerUtil.addIfNotNull((Collection)mergedDependency.getFiles(), (Object)((ExternalLibraryDependency)dependency).getFile());
                        ContainerUtil.addIfNotNull((Collection)mergedDependency.getSources(), (Object)((ExternalLibraryDependency)dependency).getSource());
                        ContainerUtil.addIfNotNull((Collection)mergedDependency.getJavadoc(), (Object)((ExternalLibraryDependency)dependency).getJavadoc());
                        continue;
                    }
                }
                DependencyScope prevScope = seenDependency.getScope() == null ? DependencyScope.COMPILE : DependencyScope.valueOf((String)seenDependency.getScope());
                DependencyScope dependencyScope = currentScope = dependency.getScope() == null ? DependencyScope.COMPILE : DependencyScope.valueOf((String)dependency.getScope());
                if (prevScope.isForProductionCompile() || prevScope.isForProductionRuntime() && currentScope.isForProductionRuntime()) continue;
            }
            dependencyMap.put((ExternalDependencyId)key, dependency);
            queue.addAll(dependency.getDependencies());
        }
        GradleProjectResolverUtil.doBuildDependencies(resolverCtx, sourceSetMap, artifactsMap, dependencyMap, ownerDataNode, dependencies, ideProject);
    }

    private static void doBuildDependencies(@NotNull ProjectResolverContext resolverCtx, @NotNull Map<String, Pair<DataNode<GradleSourceSetData>, ExternalSourceSet>> sourceSetMap, @NotNull Map<String, String> artifactsMap, @NotNull Map<ExternalDependencyId, ExternalDependency> mergedDependencyMap, @NotNull DataNode<? extends ExternalEntityData> ownerDataNode, @NotNull Collection<ExternalDependency> dependencies, @Nullable DataNode<ProjectData> ideProject) throws IllegalStateException {
        int classpathOrderShift = 0;
        LinkedHashMap<ExternalDependencyId, ExternalDependency> dependencyMap = new LinkedHashMap<ExternalDependencyId, ExternalDependency>();
        for (ExternalDependency dependency : dependencies) {
            ExternalDependency dep = (ExternalDependency)dependencyMap.get(dependency.getId());
            if (dep instanceof AbstractExternalDependency) {
                dep.getDependencies().addAll(ContainerUtil.subtract((Collection)dependency.getDependencies(), (Collection)dep.getDependencies()));
                continue;
            }
            dependencyMap.put(dependency.getId(), dependency);
        }
        for (ExternalDependency dependency : dependencyMap.values()) {
            Collection transitiveDependencies = dependency.getDependencies();
            ExternalDependency mergedDependency = (ExternalDependency)ContainerUtil.getOrElse(mergedDependencyMap, (Object)dependency.getId(), (Object)dependency);
            DependencyScope dependencyScope = GradleProjectResolverUtil.getDependencyScope(mergedDependency.getScope());
            ModuleData ownerModule = null;
            if (ownerDataNode.getData() instanceof ModuleData) {
                ownerModule = (ModuleData)ownerDataNode.getData();
            } else if (ownerDataNode.getData() instanceof DependencyData) {
                ownerModule = ((DependencyData)ownerDataNode.getData()).getOwnerModule();
            }
            assert (ownerModule != null);
            DataNode depOwnerDataNode = null;
            if (mergedDependency instanceof ExternalProjectDependency) {
                GradleExecutionWorkspace executionWorkspace;
                ModuleData moduleData;
                ExternalProjectDependency projectDependency = (ExternalProjectDependency)mergedDependency;
                ArrayList<ProjectDependencyInfo> projectDependencyInfos = new ArrayList<ProjectDependencyInfo>();
                if (resolverCtx.getSettings() != null && (moduleData = (executionWorkspace = resolverCtx.getSettings().getExecutionWorkspace()).findModuleDataByArtifacts(projectDependency.getProjectDependencyArtifacts())) != null) {
                    projectDependencyInfos.add(new ProjectDependencyInfo(moduleData, null, projectDependency.getProjectDependencyArtifacts()));
                }
                if (projectDependencyInfos.isEmpty()) {
                    MultiMap projectPairs = new MultiMap((Map)new Reference2ObjectLinkedOpenHashMap());
                    for (File file : projectDependency.getProjectDependencyArtifacts()) {
                        Pair<DataNode<GradleSourceSetData>, ExternalSourceSet> projectPair;
                        String moduleId = artifactsMap.get(ExternalSystemApiUtil.toCanonicalPath((String)file.getPath()));
                        if (moduleId == null || (projectPair = sourceSetMap.get(moduleId)) == null) continue;
                        projectPairs.putValue(projectPair, (Object)file);
                    }
                    for (Map.Entry entry : projectPairs.entrySet()) {
                        projectDependencyInfos.add(new ProjectDependencyInfo((ModuleData)((DataNode)((Pair)entry.getKey()).first).getData(), (ExternalSourceSet)((Pair)entry.getKey()).second, (Collection)entry.getValue()));
                    }
                    String moduleIdFromDependency = GradleProjectResolverUtil.getModuleId(projectDependency);
                    Pair<DataNode<GradleSourceSetData>, ExternalSourceSet> projectPairFromMap = sourceSetMap.get(moduleIdFromDependency);
                    if (projectPairFromMap != null && GradleProjectResolverUtil.doesNotContainDependencyOn(projectDependencyInfos, (GradleSourceSetData)((Object)((DataNode)projectPairFromMap.first).getData()))) {
                        Collection artifacts = projectDependency.getProjectDependencyArtifacts();
                        artifacts.removeAll(GradleProjectResolverUtil.collectProcessedArtifacts(projectDependencyInfos));
                        projectDependencyInfos.add(new ProjectDependencyInfo((ModuleData)((DataNode)projectPairFromMap.first).getData(), (ExternalSourceSet)projectPairFromMap.second, artifacts));
                    }
                }
                if (projectDependencyInfos.isEmpty()) {
                    LibraryLevel level = LibraryLevel.MODULE;
                    LibraryData library = new LibraryData(GradleConstants.SYSTEM_ID, "");
                    LibraryDependencyData libraryDependencyData = new LibraryDependencyData(ownerModule, library, level);
                    libraryDependencyData.setScope(dependencyScope);
                    libraryDependencyData.setOrder(mergedDependency.getClasspathOrder() + classpathOrderShift);
                    libraryDependencyData.setExported(mergedDependency.getExported());
                    if (!projectDependency.getProjectDependencyArtifacts().isEmpty()) {
                        for (File artifact : projectDependency.getProjectDependencyArtifacts()) {
                            library.addPath(LibraryPathType.BINARY, artifact.getPath());
                        }
                        depOwnerDataNode = ownerDataNode.createChild(ProjectKeys.LIBRARY_DEPENDENCY, (Object)libraryDependencyData);
                    } else {
                        depOwnerDataNode = ownerDataNode;
                    }
                } else {
                    int i = 0;
                    for (ProjectDependencyInfo projectDependencyInfo : projectDependencyInfos) {
                        if (i++ > 0 && transitiveDependencies.isEmpty()) {
                            ++classpathOrderShift;
                        }
                        ModuleDependencyData moduleDependencyData = new ModuleDependencyData(ownerModule, projectDependencyInfo.myModuleData);
                        moduleDependencyData.setScope(dependencyScope);
                        if (projectDependencyInfo.mySourceSet != null && GradleProjectResolverUtil.isTestSourceSet(projectDependencyInfo.mySourceSet)) {
                            moduleDependencyData.setProductionOnTestDependency(true);
                        }
                        moduleDependencyData.setOrder(mergedDependency.getClasspathOrder() + classpathOrderShift);
                        moduleDependencyData.setExported(mergedDependency.getExported());
                        moduleDependencyData.setModuleDependencyArtifacts((Collection)ContainerUtil.map(projectDependencyInfo.dependencyArtifacts, File::getPath));
                        depOwnerDataNode = ownerDataNode.createChild(ProjectKeys.MODULE_DEPENDENCY, (Object)moduleDependencyData);
                    }
                    if (projectDependencyInfos.size() > 1) {
                        depOwnerDataNode = ownerDataNode;
                    }
                }
            } else if (mergedDependency instanceof ExternalLibraryDependency) {
                File javaDocPath;
                libraryName = mergedDependency.getId().getPresentableName();
                library = new LibraryData(GradleConstants.SYSTEM_ID, libraryName);
                library.setArtifactId(mergedDependency.getId().getName());
                library.setGroup(mergedDependency.getId().getGroup());
                library.setVersion(mergedDependency.getId().getVersion());
                library.addPath(LibraryPathType.BINARY, ((ExternalLibraryDependency)mergedDependency).getFile().getPath());
                File sourcePath = ((ExternalLibraryDependency)mergedDependency).getSource();
                if (sourcePath != null) {
                    library.addPath(LibraryPathType.SOURCE, sourcePath.getPath());
                }
                if ((javaDocPath = ((ExternalLibraryDependency)mergedDependency).getJavadoc()) != null) {
                    library.addPath(LibraryPathType.DOC, javaDocPath.getPath());
                }
                Object object = level = StringUtil.isNotEmpty((String)libraryName) ? LibraryLevel.PROJECT : LibraryLevel.MODULE;
                if (StringUtil.isEmpty((String)libraryName) || !GradleProjectResolverUtil.linkProjectLibrary(resolverCtx, ideProject, library)) {
                    level = LibraryLevel.MODULE;
                }
                LibraryDependencyData libraryDependencyData = new LibraryDependencyData(ownerModule, library, (LibraryLevel)level);
                libraryDependencyData.setScope(dependencyScope);
                libraryDependencyData.setOrder(mergedDependency.getClasspathOrder() + classpathOrderShift);
                libraryDependencyData.setExported(mergedDependency.getExported());
                depOwnerDataNode = ownerDataNode.createChild(ProjectKeys.LIBRARY_DEPENDENCY, (Object)libraryDependencyData);
            } else if (mergedDependency instanceof ExternalMultiLibraryDependency) {
                level = LibraryLevel.MODULE;
                libraryName = mergedDependency.getId().getPresentableName();
                LibraryData library = new LibraryData(GradleConstants.SYSTEM_ID, libraryName);
                library.setArtifactId(mergedDependency.getId().getName());
                library.setGroup(mergedDependency.getId().getGroup());
                library.setVersion(mergedDependency.getId().getVersion());
                LibraryDependencyData libraryDependencyData = new LibraryDependencyData(ownerModule, library, level);
                libraryDependencyData.setScope(dependencyScope);
                libraryDependencyData.setOrder(mergedDependency.getClasspathOrder() + classpathOrderShift);
                libraryDependencyData.setExported(mergedDependency.getExported());
                for (File file : ((ExternalMultiLibraryDependency)mergedDependency).getFiles()) {
                    library.addPath(LibraryPathType.BINARY, file.getPath());
                }
                for (File file : ((ExternalMultiLibraryDependency)mergedDependency).getSources()) {
                    library.addPath(LibraryPathType.SOURCE, file.getPath());
                }
                level = ((ExternalMultiLibraryDependency)mergedDependency).getJavadoc().iterator();
                while (level.hasNext()) {
                    file = (File)level.next();
                    library.addPath(LibraryPathType.DOC, file.getPath());
                }
                depOwnerDataNode = ownerDataNode.createChild(ProjectKeys.LIBRARY_DEPENDENCY, (Object)libraryDependencyData);
            } else if (mergedDependency instanceof FileCollectionDependency) {
                level = LibraryLevel.MODULE;
                libraryName = "";
                LibraryData library = new LibraryData(GradleConstants.SYSTEM_ID, libraryName);
                LibraryDependencyData libraryDependencyData = new LibraryDependencyData(ownerModule, library, level);
                libraryDependencyData.setScope(dependencyScope);
                libraryDependencyData.setOrder(mergedDependency.getClasspathOrder() + classpathOrderShift);
                libraryDependencyData.setExported(mergedDependency.getExported());
                level = ((FileCollectionDependency)mergedDependency).getFiles().iterator();
                while (level.hasNext()) {
                    file = (File)level.next();
                    library.addPath(LibraryPathType.BINARY, file.getPath());
                    if (!(mergedDependency instanceof DefaultFileCollectionDependency) || !((DefaultFileCollectionDependency)mergedDependency).isExcludedFromIndexing()) continue;
                    library.addPath(LibraryPathType.EXCLUDED, file.getPath());
                }
                ownerDataNode.createChild(ProjectKeys.LIBRARY_DEPENDENCY, (Object)libraryDependencyData);
            } else if (mergedDependency instanceof UnresolvedExternalDependency) {
                libraryName = mergedDependency.getId().getPresentableName();
                library = new LibraryData(GradleConstants.SYSTEM_ID, libraryName, true);
                String failureMessage = ((UnresolvedExternalDependency)mergedDependency).getFailureMessage();
                boolean isOfflineWork = resolverCtx.getSettings() != null && resolverCtx.getSettings().isOfflineWork();
                UnresolvedDependencySyncIssue buildIssue = new UnresolvedDependencySyncIssue(libraryName, failureMessage, resolverCtx.getProjectPath(), isOfflineWork, ownerModule.getId());
                resolverCtx.report(MessageEvent.Kind.ERROR, buildIssue);
                LibraryLevel level = GradleProjectResolverUtil.linkProjectLibrary(resolverCtx, ideProject, library) ? LibraryLevel.PROJECT : LibraryLevel.MODULE;
                LibraryDependencyData libraryDependencyData = new LibraryDependencyData(ownerModule, library, level);
                libraryDependencyData.setScope(dependencyScope);
                libraryDependencyData.setOrder(mergedDependency.getClasspathOrder() + classpathOrderShift);
                ownerDataNode.createChild(ProjectKeys.LIBRARY_DEPENDENCY, (Object)libraryDependencyData);
            }
            if (depOwnerDataNode == null || transitiveDependencies.isEmpty()) continue;
            GradleProjectResolverUtil.doBuildDependencies(resolverCtx, sourceSetMap, artifactsMap, mergedDependencyMap, depOwnerDataNode, transitiveDependencies, ideProject);
        }
    }

    private static boolean isTestSourceSet(@NotNull ExternalSourceSet sourceSet) {
        if (sourceSet.getSources().isEmpty()) {
            return false;
        }
        return sourceSet.getSources().keySet().stream().allMatch(IExternalSystemSourceType::isTest);
    }

    private static Collection<File> collectProcessedArtifacts(Collection<ProjectDependencyInfo> infos) {
        return infos.stream().flatMap(info -> info.dependencyArtifacts.stream()).collect(Collectors.toSet());
    }

    private static boolean doesNotContainDependencyOn(Collection<ProjectDependencyInfo> infos, GradleSourceSetData data) {
        return infos.stream().noneMatch(info -> info.myModuleData.equals((Object)data));
    }

    public static boolean linkProjectLibrary(ProjectResolverContext context, @Nullable DataNode<ProjectData> ideProject, @NotNull LibraryData library) {
        if (ideProject == null) {
            return false;
        }
        HashMap<String, DataNode> cache = (HashMap<String, DataNode>)ideProject.getUserData(LIBRARIES_BY_NAME_CACHE);
        if (cache == null) {
            cache = new HashMap<String, DataNode>();
            ideProject.putUserData(LIBRARIES_BY_NAME_CACHE, cache);
        }
        String libraryName = library.getExternalName();
        DataNode libraryData = cache.computeIfAbsent(libraryName, name2 -> {
            DataNode newValueToCache = ExternalSystemApiUtil.find((DataNode)ideProject, (com.intellij.openapi.externalSystem.model.Key)ProjectKeys.LIBRARY, node -> libraryName.equals(((LibraryData)node.getData()).getExternalName()));
            if (newValueToCache == null) {
                newValueToCache = ideProject.createChild(ProjectKeys.LIBRARY, (Object)library);
            }
            return newValueToCache;
        });
        return ((LibraryData)libraryData.getData()).equals((Object)library);
    }

    public static boolean isIdeaTask(String taskName, @Nullable String group) {
        if ((group == null || "ide".equalsIgnoreCase(group)) && StringUtil.containsIgnoreCase((String)taskName, (String)"idea")) {
            return true;
        }
        return "other".equalsIgnoreCase(group) && StringUtil.containsIgnoreCase((String)taskName, (String)"idea");
    }

    @Nullable
    public static DataNode<ModuleData> findModule(@Nullable DataNode<ProjectData> projectNode, @NotNull String modulePath) {
        if (projectNode == null) {
            return null;
        }
        return ExternalSystemApiUtil.find(projectNode, (com.intellij.openapi.externalSystem.model.Key)ProjectKeys.MODULE, node -> ((ModuleData)node.getData()).getLinkedExternalProjectPath().equals(modulePath));
    }

    @Nullable
    public static DataNode<ModuleData> findModuleById(@Nullable DataNode<ProjectData> projectNode, @NotNull String path) {
        if (projectNode == null) {
            return null;
        }
        return ExternalSystemApiUtil.find(projectNode, (com.intellij.openapi.externalSystem.model.Key)ProjectKeys.MODULE, node -> ((ModuleData)node.getData()).getId().equals(path));
    }

    @ApiStatus.Internal
    public static Stream<GradleProjectResolverExtension> createProjectResolvers(@Nullable ProjectResolverContext projectResolverContext) {
        return GradleProjectResolverExtension.EP_NAME.getExtensionList().stream().map(extension -> {
            try {
                Constructor<?> constructor = extension.getClass().getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                GradleProjectResolverExtension resolverExtension = (GradleProjectResolverExtension)constructor.newInstance(new Object[0]);
                if (projectResolverContext != null) {
                    resolverExtension.setProjectResolverContext(projectResolverContext);
                }
                return resolverExtension;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                return null;
            }
        }).sorted(ExternalSystemApiUtil.ORDER_AWARE_COMPARATOR);
    }

    static class ProjectDependencyInfo {
        @NotNull
        final ModuleData myModuleData;
        @Nullable
        final ExternalSourceSet mySourceSet;
        final Collection<File> dependencyArtifacts;

        ProjectDependencyInfo(@NotNull ModuleData moduleData, @Nullable ExternalSourceSet sourceSet, Collection<File> dependencyArtifacts) {
            this.myModuleData = moduleData;
            this.mySourceSet = sourceSet;
            this.dependencyArtifacts = dependencyArtifacts;
        }
    }
}

