/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.registry.Registry;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildActionExecuter;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.IntermediateResultHandler;
import org.gradle.tooling.LongRunningOperation;
import org.gradle.tooling.ModelBuilder;
import org.gradle.tooling.ResultHandler;
import org.gradle.tooling.UnsupportedVersionException;
import org.gradle.tooling.model.BuildModel;
import org.gradle.tooling.model.ProjectModel;
import org.gradle.tooling.model.idea.BasicIdeaProject;
import org.gradle.tooling.model.idea.IdeaProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.ModelsHolder;
import org.jetbrains.plugins.gradle.model.ProjectImportAction;
import org.jetbrains.plugins.gradle.service.GradleFileModificationTracker;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionHelper;
import org.jetbrains.plugins.gradle.service.project.BuildActionRunnerKt;
import org.jetbrains.plugins.gradle.service.project.GradleOperationHelperExtension;
import org.jetbrains.plugins.gradle.service.project.ProjectResolverContext;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001 B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u0011H\u0002J(\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00112\u0018\u0010\u0014\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u00160\u0015H\u0002J0\u0010\u0019\u001a\u00020\r2\u0018\u0010\u0014\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u00160\u00152\u000e\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u0015J\b\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u0001H\u0002J\u0010\u0010\u001f\u001a\u00020\u001d*\u0006\u0012\u0002\b\u00030\u0011H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/plugins/gradle/service/project/BuildActionRunner;", "", "resolverCtx", "Lorg/jetbrains/plugins/gradle/service/project/ProjectResolverContext;", "buildAction", "Lorg/jetbrains/plugins/gradle/model/ProjectImportAction;", "settings", "Lorg/jetbrains/plugins/gradle/settings/GradleExecutionSettings;", "helper", "Lorg/jetbrains/plugins/gradle/service/execution/GradleExecutionHelper;", "(Lorg/jetbrains/plugins/gradle/service/project/ProjectResolverContext;Lorg/jetbrains/plugins/gradle/model/ProjectImportAction;Lorg/jetbrains/plugins/gradle/settings/GradleExecutionSettings;Lorg/jetbrains/plugins/gradle/service/execution/GradleExecutionHelper;)V", "modelsHandler", "Lorg/gradle/tooling/IntermediateResultHandler;", "Lorg/jetbrains/plugins/gradle/model/ProjectImportAction$AllModels;", "resultQueue", "Ljava/util/concurrent/ArrayBlockingQueue;", "createDefaultExecuter", "Lorg/gradle/tooling/BuildActionExecuter;", "createPhasedExecuter", "Ljava/lang/Void;", "projectsLoadedCallBack", "Ljava/util/function/Consumer;", "Lorg/jetbrains/plugins/gradle/model/ModelsHolder;", "Lorg/gradle/tooling/model/BuildModel;", "Lorg/gradle/tooling/model/ProjectModel;", "fetchModels", "buildFinishedCallBack", "Lorg/gradle/tooling/GradleConnectionException;", "notifyConnectionAboutChangedPaths", "", "takeQueueResultBlocking", "prepare", "BuildActionResultHandler", "intellij.gradle.common"})
public final class BuildActionRunner {
    @NotNull
    private final ProjectResolverContext resolverCtx;
    @NotNull
    private final ProjectImportAction buildAction;
    @NotNull
    private final GradleExecutionSettings settings;
    @NotNull
    private final GradleExecutionHelper helper;
    @NotNull
    private final ArrayBlockingQueue<Object> resultQueue;
    @NotNull
    private final IntermediateResultHandler<ProjectImportAction.AllModels> modelsHandler;

    public BuildActionRunner(@NotNull ProjectResolverContext resolverCtx, @NotNull ProjectImportAction buildAction, @NotNull GradleExecutionSettings settings2, @NotNull GradleExecutionHelper helper) {
        this.resolverCtx = resolverCtx;
        this.buildAction = buildAction;
        this.settings = settings2;
        this.helper = helper;
        this.resultQueue = new ArrayBlockingQueue(1);
        this.modelsHandler = arg_0 -> BuildActionRunner.modelsHandler$lambda$0(this, arg_0);
    }

    @NotNull
    public final ProjectImportAction.AllModels fetchModels(@NotNull Consumer<ModelsHolder<BuildModel, ProjectModel>> projectsLoadedCallBack, @NotNull Consumer<GradleConnectionException> buildFinishedCallBack) {
        if (Registry.is((String)"gradle.report.recently.saved.paths")) {
            this.notifyConnectionAboutChangedPaths();
        }
        this.createPhasedExecuter(projectsLoadedCallBack).run((ResultHandler)new BuildActionResultHandler(buildFinishedCallBack));
        Object phasedResult = this.takeQueueResultBlocking();
        if (phasedResult instanceof Throwable && !(phasedResult instanceof UnsupportedVersionException)) {
            throw (Throwable)phasedResult;
        }
        if (!(phasedResult instanceof Throwable)) {
            Intrinsics.checkNotNull((Object)phasedResult, (String)"null cannot be cast to non-null type org.jetbrains.plugins.gradle.model.ProjectImportAction.AllModels");
            return (ProjectImportAction.AllModels)phasedResult;
        }
        this.resolverCtx.checkCancelled();
        this.createDefaultExecuter().run((ResultHandler)new BuildActionResultHandler(buildFinishedCallBack));
        Object result = this.takeQueueResultBlocking();
        if (result instanceof Throwable && !(result instanceof UnsupportedVersionException)) {
            throw (Throwable)result;
        }
        if (!(result instanceof Throwable)) {
            Intrinsics.checkNotNull((Object)result, (String)"null cannot be cast to non-null type org.jetbrains.plugins.gradle.model.ProjectImportAction.AllModels");
            return (ProjectImportAction.AllModels)result;
        }
        this.resolverCtx.checkCancelled();
        Class aClass = this.resolverCtx.isPreviewMode() ? BasicIdeaProject.class : IdeaProject.class;
        ModelBuilder<BasicIdeaProject> modelBuilder = this.helper.getModelBuilder(aClass, this.resolverCtx.getExternalSystemTaskId(), this.settings, this.resolverCtx.getConnection(), this.resolverCtx.getListener());
        buildFinishedCallBack.accept(null);
        return new ProjectImportAction.AllModels((IdeaProject)modelBuilder.get());
    }

    private final void notifyConnectionAboutChangedPaths() {
        ((GradleFileModificationTracker)ApplicationManager.getApplication().getService(GradleFileModificationTracker.class)).notifyConnectionAboutChangedPaths(this.resolverCtx.getConnection());
    }

    private final Object takeQueueResultBlocking() {
        Object obtainedResult = null;
        while (obtainedResult == null) {
            this.resolverCtx.checkCancelled();
            obtainedResult = this.resultQueue.poll(1L, TimeUnit.SECONDS);
        }
        return obtainedResult;
    }

    private final BuildActionExecuter<Void> createPhasedExecuter(Consumer<ModelsHolder<BuildModel, ProjectModel>> projectsLoadedCallBack) {
        this.buildAction.prepareForPhasedExecuter();
        BuildActionExecuter executer = this.resolverCtx.getConnection().action().projectsLoaded((BuildAction)this.buildAction, arg_0 -> BuildActionRunner.createPhasedExecuter$lambda$1(projectsLoadedCallBack, this, arg_0)).buildFinished((BuildAction)this.buildAction, this.modelsHandler).build();
        this.prepare(executer);
        BuildActionRunnerKt.access$setCancellationToken(executer, this.resolverCtx);
        executer.forTasks((Iterable)CollectionsKt.emptyList());
        return executer;
    }

    private final BuildActionExecuter<ProjectImportAction.AllModels> createDefaultExecuter() {
        this.buildAction.prepareForNonPhasedExecuter();
        BuildActionExecuter executer = this.resolverCtx.getConnection().action((BuildAction)this.buildAction);
        this.prepare(executer);
        BuildActionRunnerKt.access$setCancellationToken(executer, this.resolverCtx);
        return executer;
    }

    private final void prepare(BuildActionExecuter<?> $this$prepare) {
        GradleExecutionHelper.prepare((LongRunningOperation)$this$prepare, this.resolverCtx.getExternalSystemTaskId(), this.settings, this.resolverCtx.getListener(), this.resolverCtx.getConnection());
        GradleOperationHelperExtension.EP_NAME.forEachExtensionSafe(arg_0 -> BuildActionRunner.prepare$lambda$2((Function1)new Function1<GradleOperationHelperExtension, Unit>($this$prepare, this){
            final /* synthetic */ BuildActionExecuter<?> $this_prepare;
            final /* synthetic */ BuildActionRunner this$0;
            {
                this.$this_prepare = $receiver;
                this.this$0 = $receiver2;
                super(1);
            }

            public final void invoke(GradleOperationHelperExtension it) {
                it.prepareForSync((LongRunningOperation)this.$this_prepare, BuildActionRunner.access$getResolverCtx$p(this.this$0));
            }
        }, arg_0));
    }

    private static final void modelsHandler$lambda$0(BuildActionRunner this$0, ProjectImportAction.AllModels allModels) {
        if (allModels == null) {
            this$0.resultQueue.add(new IllegalStateException("Unable to get project model for the project: " + this$0.resolverCtx.getProjectPath()));
        } else {
            this$0.resultQueue.add(allModels);
        }
    }

    private static final void createPhasedExecuter$lambda$1(Consumer $projectsLoadedCallBack, BuildActionRunner this$0, ProjectImportAction.AllModels it) {
        block2: {
            try {
                $projectsLoadedCallBack.accept(it);
            }
            catch (ProcessCanceledException e) {
                CancellationTokenSource cancellationTokenSource = this$0.resolverCtx.getCancellationTokenSource();
                if (cancellationTokenSource == null) break block2;
                cancellationTokenSource.cancel();
            }
        }
    }

    private static final void prepare$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ ProjectResolverContext access$getResolverCtx$p(BuildActionRunner $this) {
        return $this.resolverCtx;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0002H\u0016J\u0012\u0010\f\u001a\u00020\n2\b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u0016R\u0019\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/gradle/service/project/BuildActionRunner$BuildActionResultHandler;", "Lorg/gradle/tooling/ResultHandler;", "", "buildFinishedCallBack", "Ljava/util/function/Consumer;", "Lorg/gradle/tooling/GradleConnectionException;", "(Lorg/jetbrains/plugins/gradle/service/project/BuildActionRunner;Ljava/util/function/Consumer;)V", "getBuildFinishedCallBack", "()Ljava/util/function/Consumer;", "onComplete", "", "allModels", "onFailure", "connectionException", "intellij.gradle.common"})
    private final class BuildActionResultHandler
    implements ResultHandler<Object> {
        @NotNull
        private final Consumer<GradleConnectionException> buildFinishedCallBack;

        public BuildActionResultHandler(Consumer<GradleConnectionException> buildFinishedCallBack) {
            this.buildFinishedCallBack = buildFinishedCallBack;
        }

        @NotNull
        public final Consumer<GradleConnectionException> getBuildFinishedCallBack() {
            return this.buildFinishedCallBack;
        }

        public void onFailure(@Nullable GradleConnectionException connectionException) {
            BuildActionRunner.this.resultQueue.add(connectionException);
            this.buildFinishedCallBack.accept(connectionException);
        }

        public void onComplete(@Nullable Object allModels) {
            if (allModels != null) {
                BuildActionRunner.this.resultQueue.add(allModels);
            }
            this.buildFinishedCallBack.accept(null);
        }
    }
}

