/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.build.FilePosition;
import com.intellij.build.issue.BuildIssue;
import com.intellij.build.issue.BuildIssueChecker;
import com.intellij.build.issue.BuildIssueData;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.issue.BuildIssueException;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.List;
import org.gradle.cli.CommandLineArgumentException;
import org.gradle.tooling.UnsupportedVersionException;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.issue.GradleIssueChecker;
import org.jetbrains.plugins.gradle.issue.GradleIssueData;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionErrorHandler;
import org.jetbrains.plugins.gradle.service.project.AbstractProjectImportErrorHandler;

public class BaseProjectImportErrorHandler
extends AbstractProjectImportErrorHandler {
    private static final Logger LOG = Logger.getInstance(BaseProjectImportErrorHandler.class);

    @Override
    @NotNull
    public ExternalSystemException getUserFriendlyError(@Nullable BuildEnvironment buildEnvironment, @NotNull Throwable error, @NotNull String projectPath, @Nullable String buildFilePath) {
        GradleExecutionErrorHandler executionErrorHandler = new GradleExecutionErrorHandler(error, projectPath, buildFilePath);
        ExternalSystemException exception = this.doGetUserFriendlyError(buildEnvironment, error, projectPath, buildFilePath, executionErrorHandler);
        if (!exception.isCauseInitialized()) {
            exception.initCause((Throwable)ObjectUtils.notNull((Object)executionErrorHandler.getRootCause(), (Object)error));
        }
        return exception;
    }

    @ApiStatus.Experimental
    ExternalSystemException checkErrorsWithoutQuickFixes(@Nullable BuildEnvironment buildEnvironment, @NotNull Throwable error, @NotNull String projectPath, @Nullable String buildFilePath, @NotNull ExternalSystemException e) {
        if (e.getQuickFixes().length > 0 || e instanceof BuildIssueException) {
            return e;
        }
        return this.getUserFriendlyError(buildEnvironment, error, projectPath, buildFilePath);
    }

    /*
     * WARNING - void declaration
     */
    private ExternalSystemException doGetUserFriendlyError(@Nullable BuildEnvironment buildEnvironment, @NotNull Throwable error, @NotNull String projectPath, @Nullable String buildFilePath, @NotNull GradleExecutionErrorHandler executionErrorHandler) {
        void var13_30;
        String string2;
        Throwable throwable;
        String string3;
        ExternalSystemException friendlyError = executionErrorHandler.getUserFriendlyError();
        if (friendlyError != null) {
            return friendlyError;
        }
        LOG.debug(String.format("Failed to run Gradle project at '%1$s'", projectPath), error);
        Throwable rootCause = executionErrorHandler.getRootCause();
        String location = executionErrorHandler.getLocation();
        if (location == null && !StringUtil.isEmpty((String)buildFilePath)) {
            location = String.format("Build file: '%1$s'", buildFilePath);
        }
        FilePosition errorFilePosition = BaseProjectImportErrorHandler.getErrorFilePosition(location);
        GradleIssueData issueData = new GradleIssueData(projectPath, error, buildEnvironment, errorFilePosition);
        List<GradleIssueChecker> knownIssuesCheckList = GradleIssueChecker.getKnownIssuesCheckList();
        for (BuildIssueChecker buildIssueChecker : knownIssuesCheckList) {
            BuildIssue buildIssue = buildIssueChecker.check((BuildIssueData)issueData);
            if (buildIssue == null) continue;
            return new BuildIssueException(buildIssue);
        }
        if (rootCause instanceof UnsupportedVersionException) {
            Object msg2 = "You are using unsupported version of Gradle.";
            msg2 = (String)msg2 + "\nPlease point to a supported Gradle version in the project's Gradle settings or in the project's Gradle wrapper (if applicable.)";
            return this.createUserFriendlyError((String)msg2, null, new String[0]);
        }
        String rootCauseMessage = rootCause.getMessage();
        if (rootCause.getClass().getName().equals(CommandLineArgumentException.class.getName()) && StringUtil.contains((CharSequence)rootCauseMessage, (CharSequence)"Unknown command-line option '--include-build'")) {
            String string4 = String.format("Gradle composite build support available for Gradle 3.1 or better version (<a href=\"%s\">Fix Gradle settings</a>)", "open_gradle_settings");
            return this.createUserFriendlyError(string4, location, "open_gradle_settings");
        }
        if (rootCause instanceof ClassNotFoundException) {
            String string5 = String.format("Unable to load class '%1$s'.", rootCauseMessage) + "\n\nThis is an unexpected error. Please file a bug containing the idea.log file.";
            return this.createUserFriendlyError(string5, null, new String[0]);
        }
        if (rootCause instanceof UnknownHostException) {
            String string6 = String.format("Unknown host '%1$s'.", rootCauseMessage) + "\n\nPlease ensure the host name is correct. If you are behind an HTTP proxy, please configure the proxy settings either in IDE or Gradle.";
            return this.createUserFriendlyError(string6, null, new String[0]);
        }
        if (rootCause instanceof ConnectException && (string3 = rootCauseMessage) != null && string3.contains("timed out")) {
            String string8 = string3 + (string3.endsWith(".") ? " " : ". ");
            string8 = string8 + "If you are behind an HTTP proxy, please configure the proxy settings either in IDE or Gradle.";
            return this.createUserFriendlyError(string8, null, new String[0]);
        }
        if (rootCause instanceof FileNotFoundException && (throwable = error.getCause()) instanceof IllegalArgumentException && GradleExecutionErrorHandler.DOWNLOAD_GRADLE_DISTIBUTION_ERROR_PATTERN.matcher(throwable.getMessage()).matches()) {
            return this.createUserFriendlyError(throwable.getMessage(), null, new String[0]);
        }
        if (rootCause instanceof RuntimeException && (string2 = rootCauseMessage) != null && GradleExecutionErrorHandler.UNSUPPORTED_GRADLE_VERSION_ERROR_PATTERN.matcher(string2).matches()) {
            void var13_25;
            if (!string2.endsWith(".")) {
                String string9 = string2 + ".";
            }
            String string10 = (String)var13_25 + "\n\nPlease fix the project's Gradle settings.";
            return this.createUserFriendlyError(string10, null, new String[0]);
        }
        if (rootCauseMessage == null || ApplicationManager.getApplication().isUnitTestMode()) {
            StringWriter writer = new StringWriter();
            if (rootCauseMessage != null) {
                writer.write(rootCauseMessage + "\n");
            }
            rootCause.printStackTrace(new PrintWriter(writer));
            String string11 = writer.toString();
        } else {
            String string12 = rootCauseMessage;
        }
        return this.createUserFriendlyError((String)var13_30, location, new String[0]);
    }

    @Nullable
    private static FilePosition getErrorFilePosition(@Nullable String location) {
        if (location == null) {
            return null;
        }
        Pair<String, Integer> errorLocation = GradleExecutionErrorHandler.getErrorLocation(location);
        if (errorLocation == null) {
            return null;
        }
        return new FilePosition(new File((String)errorLocation.first), (Integer)errorLocation.second - 1, 0);
    }
}

