/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.execution;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableRunConfigurationOptions;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.target.LanguageRuntimeType;
import com.intellij.execution.target.TargetEnvironmentAwareRunProfile;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.testframework.sm.runner.SMRunnerConsolePropertiesProvider;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import java.util.StringJoiner;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.GradleIdeManager;
import org.jetbrains.plugins.gradle.execution.target.GradleRuntimeType;
import org.jetbrains.plugins.gradle.service.execution.GradleDebugSettingsEditor;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleCommandLine;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleRunConfiguration
extends ExternalSystemRunConfiguration
implements SMRunnerConsolePropertiesProvider,
TargetEnvironmentAwareRunProfile {
    public static final String DEBUG_FLAG_NAME = "GradleScriptDebugEnabled";
    public static final String DEBUG_ALL_NAME = "DebugAllEnabled";
    public static final Key<Boolean> DEBUG_FLAG_KEY = Key.create((String)"DEBUG_GRADLE_SCRIPT");
    public static final Key<Boolean> DEBUG_ALL_KEY = Key.create((String)"DEBUG_ALL_TASKS");
    @ApiStatus.Internal
    public static final Key<String> DEBUGGER_PARAMETERS_KEY = Key.create((String)"DEBUGGER_PARAMETERS");
    private boolean isDebugAllEnabled = false;

    public GradleRunConfiguration(Project project, ConfigurationFactory factory, String name2) {
        super(GradleConstants.SYSTEM_ID, project, factory, name2);
        this.setDebugServerProcess(true);
        this.setReattachDebugProcess(true);
    }

    public boolean isScriptDebugEnabled() {
        return this.isDebugServerProcess();
    }

    public void setScriptDebugEnabled(boolean scriptDebugEnabled) {
        this.setDebugServerProcess(scriptDebugEnabled);
    }

    @NotNull
    public String getRawCommandLine() {
        StringJoiner commandLine = new StringJoiner(" ");
        for (String taskName : this.getSettings().getTaskNames()) {
            commandLine.add(taskName);
        }
        String scriptParameters = this.getSettings().getScriptParameters();
        if (StringUtil.isNotEmpty((String)scriptParameters)) {
            commandLine.add(scriptParameters);
        }
        return commandLine.toString();
    }

    public void setRawCommandLine(@NotNull String commandLine) {
        this.setCommandLine(GradleCommandLine.parse(commandLine));
    }

    public void setCommandLine(@NotNull GradleCommandLine commandLine) {
        this.getSettings().setTaskNames(commandLine.getTasksAndArguments().toList());
        this.getSettings().setScriptParameters(commandLine.getScriptParameters().toString());
    }

    @NotNull
    public GradleCommandLine getCommandLine() {
        return GradleCommandLine.parse(this.getRawCommandLine());
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) {
        this.putUserData(DEBUG_FLAG_KEY, this.isDebugServerProcess());
        this.putUserData(DEBUG_ALL_KEY, this.isDebugAllEnabled);
        return super.getState(executor, env);
    }

    @ApiStatus.Internal
    @NotNull
    public LocatableRunConfigurationOptions getOptions() {
        return super.getOptions();
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        Element debugAll;
        super.readExternal(element);
        Element child = element.getChild(DEBUG_FLAG_NAME);
        if (child != null) {
            this.setDebugServerProcess(Boolean.parseBoolean(child.getText()));
        }
        if ((debugAll = element.getChild(DEBUG_ALL_NAME)) != null) {
            this.isDebugAllEnabled = Boolean.parseBoolean(debugAll.getText());
        }
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        super.writeExternal(element);
        Element debugAll = new Element(DEBUG_ALL_NAME);
        debugAll.setText(String.valueOf(this.isDebugAllEnabled));
        element.addContent(debugAll);
    }

    @NotNull
    public SettingsEditor<ExternalSystemRunConfiguration> getConfigurationEditor() {
        if (Registry.is((String)"ide.new.run.config", (boolean)true)) {
            return super.getConfigurationEditor();
        }
        SettingsEditor editor = super.getConfigurationEditor();
        if (editor instanceof SettingsEditorGroup) {
            SettingsEditorGroup group = (SettingsEditorGroup)editor;
            group.addEditor(GradleBundle.message("gradle.settings.title.debug", new Object[0]), (SettingsEditor)new GradleDebugSettingsEditor());
        }
        return editor;
    }

    @NotNull
    public SMTRunnerConsoleProperties createTestConsoleProperties(@NotNull Executor executor) {
        return GradleIdeManager.getInstance().createTestConsoleProperties(this.getProject(), executor, (RunConfiguration)this);
    }

    public boolean isDebugAllEnabled() {
        return this.isDebugAllEnabled;
    }

    public void setDebugAllEnabled(boolean debugAllEnabled) {
        this.isDebugAllEnabled = debugAllEnabled;
    }

    public boolean canRunOn(@NotNull TargetEnvironmentConfiguration target) {
        return true;
    }

    @Nullable
    public LanguageRuntimeType<?> getDefaultLanguageRuntimeType() {
        return (LanguageRuntimeType)LanguageRuntimeType.EXTENSION_NAME.findExtension(GradleRuntimeType.class);
    }

    @Nullable
    public String getDefaultTargetName() {
        return this.getOptions().getRemoteTarget();
    }

    public void setDefaultTargetName(@Nullable String targetName) {
        this.getOptions().setRemoteTarget(targetName);
    }
}

