/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.properties;

import com.intellij.openapi.project.Project;
import java.nio.file.Path;
import java.util.Properties;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.properties.LocalProperties;
import org.jetbrains.plugins.gradle.properties.LocalPropertiesImpl;
import org.jetbrains.plugins.gradle.properties.base.BasePropertiesFile;
import org.jetbrains.plugins.gradle.properties.models.Property;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\t2\u0006\u0010\u000b\u001a\u00020\tH\u0002J\u0018\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\tH\u0016J\u0010\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\tH\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/gradle/properties/LocalPropertiesFile;", "Lorg/jetbrains/plugins/gradle/properties/base/BasePropertiesFile;", "Lorg/jetbrains/plugins/gradle/properties/LocalProperties;", "()V", "propertiesFileName", "", "getPropertiesFileName", "()Ljava/lang/String;", "getLocalProjectPropertiesPath", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "externalProjectPath", "getProperties", "project", "Lcom/intellij/openapi/project/Project;", "loadLocalProperties", "propertiesPath", "intellij.gradle.common"})
public final class LocalPropertiesFile
extends BasePropertiesFile<LocalProperties> {
    @NotNull
    public static final LocalPropertiesFile INSTANCE = new LocalPropertiesFile();
    @NotNull
    private static final String propertiesFileName = "local.properties";

    private LocalPropertiesFile() {
    }

    @Override
    @NotNull
    public String getPropertiesFileName() {
        return propertiesFileName;
    }

    @Override
    @NotNull
    public LocalProperties getProperties(@NotNull Project project, @NotNull Path externalProjectPath2) {
        Path propertiesPath = this.getLocalProjectPropertiesPath(externalProjectPath2);
        return this.loadLocalProperties(propertiesPath);
    }

    private final LocalProperties loadLocalProperties(Path propertiesPath) {
        Property<String> property2;
        String javaHome;
        Properties properties = this.loadProperties(propertiesPath);
        if (properties == null) {
            return LocalProperties.EMPTY.INSTANCE;
        }
        Properties properties2 = properties;
        String string2 = javaHome = properties2.getProperty("jdk.dir");
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            property2 = new Property<String>(it, ((Object)propertiesPath).toString());
        } else {
            property2 = null;
        }
        Property<String> javaHomeProperty = property2;
        return new LocalPropertiesImpl(javaHomeProperty);
    }

    private final Path getLocalProjectPropertiesPath(Path externalProjectPath2) {
        return externalProjectPath2.resolve(this.getPropertiesFileName()).toAbsolutePath().normalize();
    }
}

