/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model.data;

import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.serialization.PropertyMapping;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public final class GradleSourceSetData
extends ModuleData {
    @NotNull
    public static final Key<GradleSourceSetData> KEY = Key.create(GradleSourceSetData.class, (int)(ProjectKeys.MODULE.getProcessingWeight() + 1));

    @PropertyMapping(value={"id", "externalName", "internalName", "moduleFileDirectoryPath", "externalConfigPath"})
    public GradleSourceSetData(@NotNull String id, @NotNull String externalName, @NotNull String internalName, @NotNull String moduleFileDirectoryPath, @NotNull String externalConfigPath) {
        super(id, GradleConstants.SYSTEM_ID, GradleProjectResolverUtil.getDefaultModuleTypeId(), externalName, internalName, moduleFileDirectoryPath, externalConfigPath);
        this.setModuleName(this.getSourceSetName());
    }

    @NotNull
    public String getIdeGrouping() {
        return super.getIdeGrouping() + ":" + this.getSourceSetName();
    }

    @Nullable
    public String getIdeParentGrouping() {
        return super.getIdeGrouping();
    }

    private String getSourceSetName() {
        return StringUtil.substringAfterLast((String)this.getExternalName(), (String)":");
    }
}

