/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model.data;

import com.intellij.serialization.PropertyMapping;
import java.io.File;
import java.io.Serializable;
import org.jetbrains.annotations.NotNull;

public class EarResource
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NotNull
    private final String earDirectory;
    @NotNull
    private final String relativePath;
    @NotNull
    private final File file;

    @PropertyMapping(value={"earDirectory", "relativePath", "file"})
    public EarResource(@NotNull String earDirectory, @NotNull String relativePath, @NotNull File file) {
        this.earDirectory = earDirectory;
        this.relativePath = EarResource.getAdjustedPath(relativePath);
        this.file = file;
    }

    @NotNull
    public String getEarDirectory() {
        return this.earDirectory;
    }

    @NotNull
    public String getRelativePath() {
        return this.relativePath;
    }

    @NotNull
    public File getFile() {
        return this.file;
    }

    private static String getAdjustedPath(@NotNull String path) {
        return path.isEmpty() || path.charAt(0) != '/' ? "/" + path : path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EarResource)) {
            return false;
        }
        EarResource resource = (EarResource)o;
        if (!this.file.getPath().equals(resource.file.getPath())) {
            return false;
        }
        if (this.earDirectory != resource.earDirectory) {
            return false;
        }
        return this.relativePath.equals(resource.relativePath);
    }

    public int hashCode() {
        int result = this.earDirectory.hashCode();
        result = 31 * result + this.relativePath.hashCode();
        result = 31 * result + this.file.getPath().hashCode();
        return result;
    }

    public String toString() {
        return "Resource{earDirectory=" + this.earDirectory + ", relativePath='" + this.relativePath + "', file=" + this.file + "}";
    }
}

