/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model.data;

import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.AbstractExternalEntityData;
import com.intellij.openapi.externalSystem.model.project.DependencyData;
import com.intellij.serialization.PropertyMapping;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.data.ArtifactConfiguration;
import org.jetbrains.plugins.gradle.model.data.Ear;
import org.jetbrains.plugins.gradle.model.data.WebConfigurationModelData;

public final class EarConfigurationModelData
extends AbstractExternalEntityData
implements ArtifactConfiguration {
    @NotNull
    public static final Key<EarConfigurationModelData> KEY = Key.create(EarConfigurationModelData.class, (int)(WebConfigurationModelData.KEY.getProcessingWeight() + 1));
    @NotNull
    private final List<Ear> ears;
    @NotNull
    private final Collection<DependencyData<?>> deployDependencies;
    @NotNull
    private final Collection<DependencyData<?>> earlibDependencies;

    @PropertyMapping(value={"owner", "ears", "deployDependencies", "earlibDependencies"})
    public EarConfigurationModelData(@NotNull ProjectSystemId owner, @NotNull List<Ear> ears, @NotNull Collection<DependencyData<?>> deployDependencies, @NotNull Collection<DependencyData<?>> earlibDependencies) {
        super(owner);
        this.ears = ears;
        this.deployDependencies = deployDependencies;
        this.earlibDependencies = earlibDependencies;
    }

    private EarConfigurationModelData() {
        super(ProjectSystemId.IDE);
        this.ears = new ArrayList<Ear>();
        this.deployDependencies = new ArrayList();
        this.earlibDependencies = new ArrayList();
    }

    @NotNull
    public List<Ear> getArtifacts() {
        return this.ears;
    }

    @NotNull
    public Collection<DependencyData<?>> getDeployDependencies() {
        return this.deployDependencies;
    }

    @NotNull
    public Collection<DependencyData<?>> getEarlibDependencies() {
        return this.earlibDependencies;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EarConfigurationModelData)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EarConfigurationModelData data = (EarConfigurationModelData)o;
        return this.ears.equals(data.ears);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.ears.hashCode();
        return result;
    }

    public String toString() {
        return "ears='" + this.ears + "'";
    }
}

