/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.issue.quickfix;

import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.issue.quickfix.ReimportQuickFix;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.ex.ConfigurableVisitor;
import com.intellij.openapi.options.newEditor.SettingsDialogFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiPredicate;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.settings.GradleConfigurable;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0014\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\nJ\u001c\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\u000b\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001c\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/gradle/issue/quickfix/GradleSettingsQuickFix;", "Lcom/intellij/build/issue/BuildIssueQuickFix;", "myProjectPath", "", "myRequestImport", "", "myConfigurationChangeDetector", "Ljava/util/function/BiPredicate;", "Lorg/jetbrains/plugins/gradle/settings/GradleProjectSettings;", "myFilter", "(Ljava/lang/String;ZLjava/util/function/BiPredicate;Ljava/lang/String;)V", "id", "getId", "()Ljava/lang/String;", "runQuickFix", "Ljava/util/concurrent/CompletableFuture;", "project", "Lcom/intellij/openapi/project/Project;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.gradle.common"})
@ApiStatus.Experimental
public final class GradleSettingsQuickFix
implements BuildIssueQuickFix {
    @NotNull
    private final String myProjectPath;
    private final boolean myRequestImport;
    @Nullable
    private final BiPredicate<GradleProjectSettings, GradleProjectSettings> myConfigurationChangeDetector;
    @Nullable
    private final String myFilter;
    @NotNull
    private final String id;

    public GradleSettingsQuickFix(@NotNull String myProjectPath, boolean myRequestImport, @Nullable BiPredicate<GradleProjectSettings, GradleProjectSettings> myConfigurationChangeDetector, @Nullable String myFilter) {
        this.myProjectPath = myProjectPath;
        this.myRequestImport = myRequestImport;
        this.myConfigurationChangeDetector = myConfigurationChangeDetector;
        this.myFilter = myFilter;
        this.id = "fix_gradle_settings";
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public CompletableFuture<?> runQuickFix(@NotNull Project project, @NotNull DataContext dataContext) {
        GradleProjectSettings gradleProjectSettings = (GradleProjectSettings)GradleSettings.getInstance(project).getLinkedProjectSettings(this.myProjectPath);
        if (gradleProjectSettings == null) {
            return CompletableFuture.completedFuture(false);
        }
        GradleProjectSettings projectSettings = gradleProjectSettings;
        CompletableFuture future = new CompletableFuture();
        ApplicationManager.getApplication().invokeLater(() -> GradleSettingsQuickFix.runQuickFix$lambda$0(projectSettings, project, this, future));
        return future.thenCompose(arg_0 -> GradleSettingsQuickFix.runQuickFix$lambda$1((Function1)new Function1<Boolean, CompletionStage>(this, project){
            final /* synthetic */ GradleSettingsQuickFix this$0;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                super(1);
            }

            public final CompletionStage invoke(Boolean isSettingsChanged) {
                Boolean bl = isSettingsChanged;
                Intrinsics.checkNotNull((Object)bl);
                return bl != false && GradleSettingsQuickFix.access$getMyRequestImport$p(this.this$0) ? ReimportQuickFix.Companion.requestImport(this.$project, GradleSettingsQuickFix.access$getMyProjectPath$p(this.this$0), GradleConstants.SYSTEM_ID) : CompletableFuture.completedFuture(null);
            }
        }, arg_0));
    }

    private static final void runQuickFix$lambda$0(GradleProjectSettings $projectSettings, Project $project, GradleSettingsQuickFix this$0, CompletableFuture $future) {
        GradleProjectSettings oldSettings = null;
        oldSettings = $projectSettings.clone();
        Object[] groups = ShowSettingsUtilImpl.getConfigurableGroups((Project)$project, (boolean)true);
        Configurable configurable = ConfigurableVisitor.findByType(GradleConfigurable.class, (List)ArraysKt.toList((Object[])groups));
        DialogWrapper dialogWrapper = SettingsDialogFactory.getInstance().create($project, (ConfigurableGroup[])groups, configurable, this$0.myFilter);
        boolean result = dialogWrapper.showAndGet();
        $future.complete(result && this$0.myConfigurationChangeDetector != null && this$0.myConfigurationChangeDetector.test(oldSettings, $projectSettings));
    }

    private static final CompletionStage runQuickFix$lambda$1(Function1 $tmp0, Object p0) {
        return (CompletionStage)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ boolean access$getMyRequestImport$p(GradleSettingsQuickFix $this) {
        return $this.myRequestImport;
    }

    public static final /* synthetic */ String access$getMyProjectPath$p(GradleSettingsQuickFix $this) {
        return $this.myProjectPath;
    }
}

