/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.issue;

import com.intellij.build.BuildConsoleUtils;
import com.intellij.build.FileNavigatable;
import com.intellij.build.FilePosition;
import com.intellij.build.issue.BuildIssue;
import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.build.issue.quickfix.OpenFileQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.util.PlatformUtils;
import com.intellij.util.io.PathKt;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.initialization.BuildLayoutParameters;
import org.gradle.tooling.GradleConnectionException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.issue.GradleIssueChecker;
import org.jetbrains.plugins.gradle.issue.GradleIssueData;
import org.jetbrains.plugins.gradle.issue.quickfix.GradleSettingsQuickFix;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionErrorHandler;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSystemSettings;
import org.jetbrains.plugins.gradle.util.GradleBundle;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/gradle/issue/GradleOutOfMemoryIssueChecker;", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueChecker;", "()V", "check", "Lcom/intellij/build/issue/BuildIssue;", "issueData", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueData;", "intellij.gradle.common"})
@ApiStatus.Experimental
public final class GradleOutOfMemoryIssueChecker
implements GradleIssueChecker {
    @Nullable
    public BuildIssue check(@NotNull GradleIssueData issueData) {
        String gradleVmOptions;
        CharSequence charSequence;
        Object object;
        if (!(issueData.getError() instanceof GradleConnectionException)) {
            return null;
        }
        Throwable rootCause = (Throwable)GradleExecutionErrorHandler.getRootCauseAndLocation((Throwable)issueData.getError()).first;
        if (!(rootCause instanceof OutOfMemoryError)) {
            return null;
        }
        StringBuilder quickFixDescription = new StringBuilder();
        ArrayList<BuildIssueQuickFix> quickFixes = new ArrayList<BuildIssueQuickFix>();
        String[] stringArray = new String[]{"gradle.properties"};
        Path projectGradleProperties = Paths.get(issueData.getProjectPath(), stringArray);
        String subItemPadding = "   ";
        if (PathKt.isFile((Path)projectGradleProperties)) {
            OpenFileQuickFix openFileQuickFix = new OpenFileQuickFix(projectGradleProperties, "org.gradle.jvmargs");
            quickFixDescription.append(subItemPadding + "<a href=\"" + openFileQuickFix.getId() + "\">gradle.properties</a> in project root directory\n");
            quickFixes.add((BuildIssueQuickFix)openFileQuickFix);
        }
        if ((object = issueData.getBuildEnvironment()) == null || (object = object.getGradle()) == null || (object = object.getGradleUserHome()) == null) {
            object = new BuildLayoutParameters().getGradleUserHomeDir();
        }
        Object gradleUserHomeDir = object;
        String[] stringArray2 = new String[]{"gradle.properties"};
        Path commonGradleProperties = Paths.get(((File)gradleUserHomeDir).getPath(), stringArray2);
        if (PathKt.isFile((Path)commonGradleProperties)) {
            OpenFileQuickFix openFileQuickFix = new OpenFileQuickFix(commonGradleProperties, "org.gradle.jvmargs");
            quickFixDescription.append(subItemPadding + "<a href=\"" + openFileQuickFix.getId() + "\">gradle.properties</a> in GRADLE_USER_HOME directory\n");
            quickFixes.add((BuildIssueQuickFix)openFileQuickFix);
        }
        if (!((charSequence = (CharSequence)(gradleVmOptions = GradleSystemSettings.getInstance().getGradleVmOptions())) == null || StringsKt.isBlank((CharSequence)charSequence)) && !Intrinsics.areEqual((Object)"AndroidStudio", (Object)PlatformUtils.getPlatformPrefix())) {
            GradleSettingsQuickFix gradleSettingsFix = new GradleSettingsQuickFix(issueData.getProjectPath(), true, (arg_0, arg_1) -> GradleOutOfMemoryIssueChecker.check$lambda$0(gradleVmOptions, arg_0, arg_1), GradleBundle.message("gradle.settings.text.vm.options", new Object[0]));
            quickFixes.add(gradleSettingsFix);
            quickFixDescription.append(subItemPadding + "<a href=\"" + gradleSettingsFix.getId() + "\">IDE Gradle VM options</a> \n");
        }
        StringBuilder issueDescription = new StringBuilder();
        if (issueData.getFilePosition() != null) {
            String fileName = issueData.getFilePosition().getFile().getName();
            String fileTypePrefix = StringsKt.endsWith((String)fileName, (String)"gradle", (boolean)true) || StringsKt.endsWith((String)fileName, (String)"gradle.kts", (boolean)true) ? "Build file " : "";
            StringBuilder stringBuilder = issueDescription.append(StringsKt.trimIndent((String)("\n      * Where:\n      " + fileTypePrefix + "'" + issueData.getFilePosition().getFile().getPath() + "' line: " + (issueData.getFilePosition().getStartLine() + 1) + "\n\n    ")));
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append('\\n')");
        }
        StringBuilder stringBuilder = issueDescription.append(StringsKt.trimIndent((String)("\n      * What went wrong:\n      Out of memory. " + rootCause.getMessage() + "\n    ")));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append('\\n')");
        if (((CharSequence)quickFixDescription).length() > 0) {
            issueDescription.append("\nPossible solution:\n");
            issueDescription.append(" - Check the JVM memory arguments defined for the gradle process in:\n");
            issueDescription.append((CharSequence)quickFixDescription);
        }
        String description = issueDescription.toString();
        String string2 = rootCause.getMessage();
        if (string2 == null) {
            string2 = description;
        }
        String title = BuildConsoleUtils.getMessageTitle((String)string2);
        return new BuildIssue(title, description, quickFixes, issueData){
            @NotNull
            private final String title;
            @NotNull
            private final String description;
            @NotNull
            private final ArrayList<BuildIssueQuickFix> quickFixes;
            final /* synthetic */ GradleIssueData $issueData;
            {
                this.$issueData = $issueData;
                this.title = $title;
                this.description = $description;
                this.quickFixes = $quickFixes;
            }

            @NotNull
            public String getTitle() {
                return this.title;
            }

            @NotNull
            public String getDescription() {
                return this.description;
            }

            @NotNull
            public ArrayList<BuildIssueQuickFix> getQuickFixes() {
                return this.quickFixes;
            }

            @Nullable
            public Navigatable getNavigatable(@NotNull Project project) {
                FileNavigatable fileNavigatable;
                FilePosition filePosition = this.$issueData.getFilePosition();
                if (filePosition != null) {
                    FilePosition filePosition2 = filePosition;
                    GradleIssueData gradleIssueData = this.$issueData;
                    FilePosition $this$getNavigatable_u24lambda_u240 = filePosition2;
                    boolean bl = false;
                    fileNavigatable = new FileNavigatable(project, gradleIssueData.getFilePosition());
                } else {
                    fileNavigatable = null;
                }
                return (Navigatable)fileNavigatable;
            }
        };
    }

    private static final boolean check$lambda$0(String $gradleVmOptions, GradleProjectSettings gradleProjectSettings, GradleProjectSettings gradleProjectSettings2) {
        return !Intrinsics.areEqual((Object)$gradleVmOptions, (Object)GradleSystemSettings.getInstance().getGradleVmOptions());
    }
}

