/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.issue;

import com.intellij.build.BuildConsoleUtils;
import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.DuplicateMessageAware;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.issue.BuildIssue;
import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.build.issue.quickfix.OpenFileQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.util.PlatformUtils;
import com.intellij.util.io.PathKt;
import com.intellij.util.text.StringKt;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.gradle.initialization.BuildLayoutParameters;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.GradleConsoleFilter;
import org.jetbrains.plugins.gradle.issue.GradleIssueChecker;
import org.jetbrains.plugins.gradle.issue.GradleIssueData;
import org.jetbrains.plugins.gradle.issue.quickfix.GradleSettingsQuickFix;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionErrorHandler;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSystemSettings;
import org.jetbrains.plugins.gradle.util.GradleBundle;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016JD\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\n2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00130\u0012H\u0016\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/gradle/issue/GradleDaemonStartupIssueChecker;", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueChecker;", "()V", "check", "Lcom/intellij/build/issue/BuildIssue;", "issueData", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueData;", "consumeBuildOutputFailureMessage", "", "message", "", "failureCause", "stacktrace", "location", "Lcom/intellij/build/FilePosition;", "parentEventId", "", "messageConsumer", "Ljava/util/function/Consumer;", "Lcom/intellij/build/events/BuildEvent;", "intellij.gradle.common"})
@ApiStatus.Experimental
public final class GradleDaemonStartupIssueChecker
implements GradleIssueChecker {
    @Nullable
    public BuildIssue check(@NotNull GradleIssueData issueData) {
        String gradleVmOptions;
        CharSequence charSequence;
        Object object;
        Throwable rootCause = (Throwable)GradleExecutionErrorHandler.getRootCauseAndLocation((Throwable)issueData.getError()).first;
        String rootCauseText = rootCause.toString();
        if (!StringsKt.startsWith$default((String)rootCauseText, (String)"org.gradle.api.GradleException: Unable to start the daemon process.", (boolean)false, (int)2, null)) {
            return null;
        }
        StringBuilder quickFixDescription = new StringBuilder();
        ArrayList<BuildIssueQuickFix> quickFixes = new ArrayList<BuildIssueQuickFix>();
        String[] stringArray = new String[]{"gradle.properties"};
        Path projectGradleProperties = Paths.get(issueData.getProjectPath(), stringArray);
        if (PathKt.isFile((Path)projectGradleProperties)) {
            OpenFileQuickFix openFileQuickFix = new OpenFileQuickFix(projectGradleProperties, "org.gradle.jvmargs");
            quickFixDescription.append(" - <a href=\"" + openFileQuickFix.getId() + "\">gradle.properties</a> in project root directory\n");
            quickFixes.add((BuildIssueQuickFix)openFileQuickFix);
        }
        if ((object = issueData.getBuildEnvironment()) == null || (object = object.getGradle()) == null || (object = object.getGradleUserHome()) == null) {
            object = new BuildLayoutParameters().getGradleUserHomeDir();
        }
        Object gradleUserHomeDir = object;
        String[] stringArray2 = new String[]{"gradle.properties"};
        Path commonGradleProperties = Paths.get(((File)gradleUserHomeDir).getPath(), stringArray2);
        if (PathKt.isFile((Path)commonGradleProperties)) {
            OpenFileQuickFix openFileQuickFix = new OpenFileQuickFix(commonGradleProperties, "org.gradle.jvmargs");
            quickFixDescription.append(" - <a href=\"" + openFileQuickFix.getId() + "\">gradle.properties</a> in GRADLE_USER_HOME directory\n");
            quickFixes.add((BuildIssueQuickFix)openFileQuickFix);
        }
        if (!((charSequence = (CharSequence)(gradleVmOptions = GradleSystemSettings.getInstance().getGradleVmOptions())) == null || StringsKt.isBlank((CharSequence)charSequence)) && !Intrinsics.areEqual((Object)"AndroidStudio", (Object)PlatformUtils.getPlatformPrefix())) {
            GradleSettingsQuickFix gradleSettingsFix = new GradleSettingsQuickFix(issueData.getProjectPath(), true, (arg_0, arg_1) -> GradleDaemonStartupIssueChecker.check$lambda$0(gradleVmOptions, arg_0, arg_1), GradleBundle.message("gradle.settings.text.vm.options", new Object[0]));
            quickFixes.add(gradleSettingsFix);
            quickFixDescription.append(" - <a href=\"" + gradleSettingsFix.getId() + "\">IDE Gradle VM options</a> \n");
        }
        StringBuilder issueDescription = new StringBuilder(rootCause.getMessage());
        if (((CharSequence)quickFixDescription).length() > 0) {
            issueDescription.append("\n-----------------------\n");
            issueDescription.append("Check the JVM arguments defined for the gradle process in:\n");
            issueDescription.append((CharSequence)quickFixDescription);
        }
        String description = issueDescription.toString();
        String title = BuildConsoleUtils.getMessageTitle((String)description);
        return new BuildIssue(title, description, quickFixes){
            @NotNull
            private final String title;
            @NotNull
            private final String description;
            @NotNull
            private final ArrayList<BuildIssueQuickFix> quickFixes;
            {
                this.title = $title;
                this.description = $description;
                this.quickFixes = $quickFixes;
            }

            @NotNull
            public String getTitle() {
                return this.title;
            }

            @NotNull
            public String getDescription() {
                return this.description;
            }

            @NotNull
            public ArrayList<BuildIssueQuickFix> getQuickFixes() {
                return this.quickFixes;
            }

            @Nullable
            public Navigatable getNavigatable(@NotNull Project project) {
                return null;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean consumeBuildOutputFailureMessage(@NotNull String message, @NotNull String failureCause, @Nullable String stacktrace, @Nullable FilePosition location, @NotNull Object parentEventId, @NotNull Consumer<? super BuildEvent> messageConsumer) {
        if (location == null) {
            return false;
        }
        if (Intrinsics.areEqual((Object)failureCause, (Object)"startup failed:")) {
            Integer[] integerArray;
            List list2;
            String string2 = StringKt.nullize$default((String)StringsKt.substringAfter((String)message, (String)"> startup failed:", (String)""), (boolean)false, (int)1, null);
            if (string2 == null || (string2 = ((Object)StringsKt.trimStart((CharSequence)string2)).toString()) == null || (string2 = StringsKt.substringBefore$default((String)string2, (String)"\n", null, (int)2, null)) == null) {
                return false;
            }
            String locationLine = string2;
            String string3 = StringKt.nullize$default((String)StringsKt.substringAfter((String)locationLine, (String)("'" + location.getFile().getPath() + "': " + (location.getStartLine() + 1) + ": "), (String)""), (boolean)false, (int)1, null);
            if (string3 == null || (string3 = StringsKt.substringBeforeLast$default((String)string3, (String)" @ ", null, (int)2, null)) == null) {
                return false;
            }
            String failedStartupReason = string3;
            String locationPart = StringsKt.substringAfterLast$default((String)locationLine, (String)" @ ", null, (int)2, null);
            MatchResult matchResult = new Regex(GradleConsoleFilter.LINE_AND_COLUMN_PATTERN).matchEntire((CharSequence)locationPart);
            Object object = matchResult;
            if (object != null && (object = object.getGroupValues()) != null && (object = CollectionsKt.drop((Iterable)((Iterable)object), (int)1)) != null) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = (Iterable)object;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string4 = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(Integer.parseInt((String)it));
                }
                list2 = (List)destination$iv$iv;
            } else {
                integerArray = new Integer[]{location.getStartLine() + 1, 0};
                list2 = CollectionsKt.listOf((Object[])integerArray);
            }
            List values = list2;
            int line = ((Number)values.get(0)).intValue() - 1;
            int column = ((Number)values.get(1)).intValue();
            MessageEvent.Kind kind = MessageEvent.Kind.ERROR;
            integerArray = new FilePosition(location.getFile(), line, column);
            messageConsumer.accept((BuildEvent)new DuplicateMessageAware(parentEventId, failedStartupReason, message, kind, (FilePosition)integerArray){});
            return true;
        }
        return false;
    }

    private static final boolean check$lambda$0(String $gradleVmOptions, GradleProjectSettings gradleProjectSettings, GradleProjectSettings gradleProjectSettings2) {
        return !Intrinsics.areEqual((Object)$gradleVmOptions, (Object)GradleSystemSettings.getInstance().getGradleVmOptions());
    }
}

