/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.frameworkSupport.script;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringJoiner;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.frameworkSupport.script.ScriptBuilder;
import org.jetbrains.plugins.gradle.frameworkSupport.script.ScriptElement;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0004J\u001e\u0010\b\u001a\u00020\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0002\u001a\u00020\u0003H\u0004J \u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0016\u0010\u0014\u001a\u00020\f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u000eH\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/plugins/gradle/frameworkSupport/script/AbstractScriptBuilder;", "Lorg/jetbrains/plugins/gradle/frameworkSupport/script/ScriptBuilder;", "indent", "", "(I)V", "lines", "Ljava/util/ArrayList;", "", "add", "", "code", "isNewLine", "", "elements", "", "Lorg/jetbrains/plugins/gradle/frameworkSupport/script/ScriptElement;", "element", "generate", "root", "Lorg/jetbrains/plugins/gradle/frameworkSupport/script/ScriptElement$Statement$Expression$BlockElement;", "hasTrailingBlock", "arguments", "Lorg/jetbrains/plugins/gradle/frameworkSupport/script/ScriptElement$ArgumentElement;", "intellij.gradle.common"})
public abstract class AbstractScriptBuilder
implements ScriptBuilder {
    private final int indent;
    @NotNull
    private final ArrayList<String> lines;

    public AbstractScriptBuilder(int indent) {
        this.indent = indent;
        this.lines = new ArrayList();
    }

    public /* synthetic */ AbstractScriptBuilder(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        this(n);
    }

    @Override
    @NotNull
    public String generate(@NotNull ScriptElement.Statement.Expression.BlockElement root) {
        this.lines.clear();
        Iterable $this$forEach$iv = root.getStatements();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ScriptElement.Statement it = (ScriptElement.Statement)element$iv;
            boolean bl = false;
            this.add(it, this.indent, true);
        }
        StringJoiner joiner = new StringJoiner("\n");
        Iterable $this$forEach$iv2 = this.lines;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            CharSequence p0 = (CharSequence)element$iv;
            boolean bl = false;
            joiner.add(p0);
        }
        return joiner.toString();
    }

    protected void add(@NotNull ScriptElement element, int indent, boolean isNewLine) {
        ScriptElement scriptElement = element;
        if (scriptElement instanceof ScriptElement.ArgumentElement) {
            if (((ScriptElement.ArgumentElement)element).getName() != null) {
                this.add(((ScriptElement.ArgumentElement)element).getName(), indent, isNewLine);
                this.add(" = ", indent, false);
            }
            this.add(((ScriptElement.ArgumentElement)element).getValue(), indent, false);
        } else if (scriptElement instanceof ScriptElement.Statement.AssignElement) {
            this.add(((ScriptElement.Statement.AssignElement)element).getName(), indent, isNewLine);
            this.add(" = ", indent, false);
            this.add(((ScriptElement.Statement.AssignElement)element).getValue(), indent, false);
        } else if (scriptElement instanceof ScriptElement.Statement.PlusAssignElement) {
            this.add(((ScriptElement.Statement.PlusAssignElement)element).getName(), indent, isNewLine);
            this.add(" += ", indent, false);
            this.add(((ScriptElement.Statement.PlusAssignElement)element).getValue(), indent, false);
        } else if (scriptElement instanceof ScriptElement.Statement.Expression.BlockElement) {
            this.add("{", indent, isNewLine);
            for (ScriptElement.Statement statement : ((ScriptElement.Statement.Expression.BlockElement)element).getStatements()) {
                this.add(statement, indent + 1, true);
            }
            this.add("}", indent, true);
        } else if (scriptElement instanceof ScriptElement.Statement.Expression.CallElement) {
            this.add(((ScriptElement.Statement.Expression.CallElement)element).getName(), indent, isNewLine);
            if (this.hasTrailingBlock(((ScriptElement.Statement.Expression.CallElement)element).getArguments())) {
                if (((ScriptElement.Statement.Expression.CallElement)element).getArguments().size() > 1) {
                    this.add("(", indent, false);
                    this.add(CollectionsKt.dropLast(((ScriptElement.Statement.Expression.CallElement)element).getArguments(), (int)1), indent);
                    this.add(")", indent, false);
                }
                this.add(" ", indent, false);
                this.add(((ScriptElement.ArgumentElement)CollectionsKt.last(((ScriptElement.Statement.Expression.CallElement)element).getArguments())).getValue(), indent, false);
            } else {
                this.add("(", indent, false);
                this.add(((ScriptElement.Statement.Expression.CallElement)element).getArguments(), indent);
                this.add(")", indent, false);
            }
        } else if (scriptElement instanceof ScriptElement.Statement.Expression.CodeElement) {
            for (String line : ((ScriptElement.Statement.Expression.CodeElement)element).getText()) {
                this.add(line, indent, isNewLine);
            }
        } else if (scriptElement instanceof ScriptElement.Statement.Expression.InfixCall) {
            this.add(((ScriptElement.Statement.Expression.InfixCall)element).getLeft(), indent, isNewLine);
            this.add(" ", indent, false);
            this.add(((ScriptElement.Statement.Expression.InfixCall)element).getName(), indent, false);
            this.add(" ", indent, false);
            this.add(((ScriptElement.Statement.Expression.InfixCall)element).getRight(), indent, false);
        } else if (scriptElement instanceof ScriptElement.Statement.Expression.IntElement) {
            this.add(String.valueOf(((ScriptElement.Statement.Expression.IntElement)element).getValue()), indent, isNewLine);
        } else if (scriptElement instanceof ScriptElement.Statement.Expression.BooleanElement) {
            this.add(String.valueOf(((ScriptElement.Statement.Expression.BooleanElement)element).getValue()), indent, isNewLine);
        } else if (scriptElement instanceof ScriptElement.Statement.Expression.StringElement) {
            this.add("\"" + ((ScriptElement.Statement.Expression.StringElement)element).getValue() + "\"", indent, isNewLine);
        } else if (Intrinsics.areEqual((Object)scriptElement, (Object)ScriptElement.Statement.NewLineElement.INSTANCE)) {
            this.add("", indent, isNewLine);
        } else {
            throw new IllegalStateException(("Unsupported element: " + element.getClass()).toString());
        }
    }

    protected final void add(@NotNull List<? extends ScriptElement> elements, int indent) {
        Iterator<? extends ScriptElement> iterator = elements.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int i = n++;
            ScriptElement argument2 = iterator.next();
            if (i != 0) {
                this.add(", ", indent, false);
            }
            this.add(argument2, indent, false);
        }
    }

    protected final void add(@NotNull String code2, int indent, boolean isNewLine) {
        if (isNewLine || this.lines.isEmpty()) {
            if (StringsKt.isBlank((CharSequence)code2)) {
                this.lines.add(code2);
            } else {
                this.lines.add(StringsKt.repeat((CharSequence)"    ", (int)indent) + code2);
            }
        } else {
            ArrayList<String> arrayList = this.lines;
            int n = CollectionsKt.getLastIndex((List)this.lines);
            arrayList.set(n, arrayList.get(n) + code2);
        }
    }

    protected final boolean hasTrailingBlock(@NotNull List<ScriptElement.ArgumentElement> arguments) {
        ScriptElement.ArgumentElement argumentElement = (ScriptElement.ArgumentElement)CollectionsKt.lastOrNull(arguments);
        if (argumentElement == null) {
            return false;
        }
        ScriptElement.ArgumentElement last = argumentElement;
        return last.getValue() instanceof ScriptElement.Statement.Expression.BlockElement && last.getName() == null;
    }

    public AbstractScriptBuilder() {
        this(0, 1, null);
    }
}

