/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.target;

import com.intellij.execution.Platform;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.target.HostPort;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentType;
import com.intellij.execution.target.TargetPlatform;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.TargetedCommandLine;
import com.intellij.execution.target.value.TargetEnvironmentFunctions;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.service.execution.TargetEnvironmentConfigurationProvider;
import com.intellij.openapi.externalSystem.service.remote.MultiLoaderObjectInputStream;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.PlatformUtils;
import com.intellij.util.io.BaseOutputReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.initialization.BuildEventConsumer;
import org.gradle.internal.remote.Address;
import org.gradle.internal.remote.internal.ConnectCompletion;
import org.gradle.internal.remote.internal.RemoteConnection;
import org.gradle.internal.remote.internal.inet.SocketInetAddress;
import org.gradle.internal.remote.internal.inet.TcpOutgoingConnector;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.serialize.Serializers;
import org.gradle.launcher.daemon.protocol.BuildEvent;
import org.gradle.launcher.daemon.protocol.DaemonMessageSerializer;
import org.gradle.launcher.daemon.protocol.Failure;
import org.gradle.launcher.daemon.protocol.Message;
import org.gradle.launcher.daemon.protocol.Success;
import org.gradle.tooling.BuildCancelledException;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.ResultHandler;
import org.gradle.tooling.internal.consumer.parameters.ConsumerOperationParameters;
import org.gradle.tooling.internal.protocol.ProgressListenerVersion1;
import org.gradle.tooling.internal.provider.action.BuildActionSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.plugins.gradle.execution.target.GradleServerClasspathInferer;
import org.jetbrains.plugins.gradle.execution.target.GradleServerEnvironmentSetupImpl;
import org.jetbrains.plugins.gradle.execution.target.GradleServerRunnerKt;
import org.jetbrains.plugins.gradle.execution.target.TargetProjectConnection;
import org.jetbrains.plugins.gradle.service.execution.GradleServerConfigurationProvider;
import org.jetbrains.plugins.gradle.tooling.proxy.Output;
import org.jetbrains.plugins.gradle.tooling.proxy.StandardError;
import org.jetbrains.plugins.gradle.tooling.proxy.StandardOutput;
import org.jetbrains.plugins.gradle.tooling.proxy.TargetBuildParameters;
import org.jetbrains.plugins.gradle.util.GradleBundle;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0000\u0018\u0000 #2\u00020\u0001:\u0004#$%&B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J*\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0003J&\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u000e\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0015J8\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u000e\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00152\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001c\u0010\u001d\u001a\u00020\b*\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u0014\u0010\"\u001a\u00020\b*\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/plugins/gradle/execution/target/GradleServerRunner;", "", "connection", "Lorg/jetbrains/plugins/gradle/execution/target/TargetProjectConnection;", "consumerOperationParameters", "Lorg/gradle/tooling/internal/consumer/parameters/ConsumerOperationParameters;", "(Lorg/jetbrains/plugins/gradle/execution/target/TargetProjectConnection;Lorg/gradle/tooling/internal/consumer/parameters/ConsumerOperationParameters;)V", "resolveFistPath", "", "text", "targetProjectBasePath", "localProjectBasePath", "targetPlatform", "Lcom/intellij/execution/target/TargetPlatform;", "run", "", "classpathInferer", "Lorg/jetbrains/plugins/gradle/execution/target/GradleServerClasspathInferer;", "targetBuildParametersBuilder", "Lorg/jetbrains/plugins/gradle/tooling/proxy/TargetBuildParameters$Builder;", "resultHandler", "Lorg/gradle/tooling/ResultHandler;", "runTargetProcess", "targetedCommandLine", "Lcom/intellij/execution/target/TargetedCommandLine;", "serverEnvironmentSetup", "Lorg/jetbrains/plugins/gradle/execution/target/GradleServerEnvironmentSetupImpl;", "targetProgressIndicator", "Lorg/jetbrains/plugins/gradle/execution/target/GradleServerRunner$GradleServerProgressIndicator;", "useLocalFileSeparators", "platform", "Lcom/intellij/execution/Platform;", "uriMode", "", "useLocalLineSeparators", "Companion", "GradleServerEventsListener", "GradleServerProcessListener", "GradleServerProgressIndicator", "intellij.gradle.common"})
public final class GradleServerRunner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TargetProjectConnection connection;
    @NotNull
    private final ConsumerOperationParameters consumerOperationParameters;
    @NotNull
    private static final Logger log;
    @NotNull
    private static final Key<Boolean> targetPreparationKey;

    public GradleServerRunner(@NotNull TargetProjectConnection connection, @NotNull ConsumerOperationParameters consumerOperationParameters) {
        this.connection = connection;
        this.consumerOperationParameters = consumerOperationParameters;
    }

    public final void run(@NotNull GradleServerClasspathInferer classpathInferer2, @NotNull TargetBuildParameters.Builder targetBuildParametersBuilder, @NotNull ResultHandler<Object> resultHandler) {
        ExternalSystemTaskId externalSystemTaskId = this.connection.getTaskId();
        if (externalSystemTaskId == null || (externalSystemTaskId = externalSystemTaskId.findProject()) == null) {
            return;
        }
        ExternalSystemTaskId project = externalSystemTaskId;
        GradleServerProgressIndicator progressIndicator = new GradleServerProgressIndicator(this.connection.getTaskId(), this.connection.getTaskListener());
        this.consumerOperationParameters.getCancellationToken().addCallback(progressIndicator::cancel);
        TargetEnvironmentConfigurationProvider environmentConfigurationProvider = this.connection.getEnvironmentConfigurationProvider();
        GradleServerEnvironmentSetupImpl serverEnvironmentSetup = new GradleServerEnvironmentSetupImpl((Project)project, classpathInferer2, environmentConfigurationProvider);
        TargetedCommandLine commandLine = serverEnvironmentSetup.prepareEnvironment(targetBuildParametersBuilder, this.consumerOperationParameters, progressIndicator);
        this.runTargetProcess(commandLine, serverEnvironmentSetup, progressIndicator, resultHandler, classpathInferer2);
    }

    private final void runTargetProcess(TargetedCommandLine targetedCommandLine, GradleServerEnvironmentSetupImpl serverEnvironmentSetup, GradleServerProgressIndicator targetProgressIndicator, ResultHandler<Object> resultHandler, GradleServerClasspathInferer classpathInferer2) {
        String string2;
        targetProgressIndicator.checkCanceled();
        TargetEnvironment remoteEnvironment = serverEnvironmentSetup.getTargetEnvironment();
        Process process2 = remoteEnvironment.createProcess(targetedCommandLine, (ProgressIndicator)new EmptyProgressIndicator());
        Charset charset = targetedCommandLine.getCharset();
        String string3 = targetedCommandLine.getCommandPresentation(remoteEnvironment);
        CapturingProcessHandler processHandler2 = new CapturingProcessHandler(process2, charset, string3){

            @NotNull
            protected BaseOutputReader.Options readerOptions() {
                return BaseOutputReader.Options.forMostlySilentProcess();
            }
        };
        TargetBuildParameters targetBuildParameters = serverEnvironmentSetup.getTargetBuildParameters();
        TargetEnvironment.UploadRoot projectUploadRoot = serverEnvironmentSetup.getProjectUploadRoot();
        String targetProjectBasePath = (String)TargetEnvironmentFunctions.getTargetUploadPath((TargetEnvironment.UploadRoot)projectUploadRoot).apply(remoteEnvironment);
        String localProjectBasePath = ((Object)projectUploadRoot.getLocalRootPath()).toString();
        TargetPlatform targetPlatform = remoteEnvironment.getTargetPlatform();
        TargetEnvironmentConfigurationProvider targetEnvironmentConfigurationProvider = this.connection.getEnvironmentConfigurationProvider();
        GradleServerConfigurationProvider serverConfigurationProvider = targetEnvironmentConfigurationProvider instanceof GradleServerConfigurationProvider ? (GradleServerConfigurationProvider)targetEnvironmentConfigurationProvider : null;
        Function1 connectionAddressResolver2 = (Function1)new Function1<HostPort, HostPort>(serverEnvironmentSetup, serverConfigurationProvider){
            final /* synthetic */ GradleServerEnvironmentSetupImpl $serverEnvironmentSetup;
            final /* synthetic */ GradleServerConfigurationProvider $serverConfigurationProvider;
            {
                this.$serverEnvironmentSetup = $serverEnvironmentSetup;
                this.$serverConfigurationProvider = $serverConfigurationProvider;
                super(1);
            }

            @NotNull
            public final HostPort invoke(@NotNull HostPort it) {
                Integer targetPort;
                Promise serverBindingPort = this.$serverEnvironmentSetup.getServerBindingPort();
                Promise promise = serverBindingPort;
                Integer localPort = promise != null && (promise = promise.getLocalValue()) != null ? (Integer)promise.blockingGet(0) : null;
                Promise promise2 = serverBindingPort;
                Integer n = targetPort = promise2 != null && (promise2 = promise2.getTargetValue()) != null ? (Integer)promise2.blockingGet(0) : null;
                int n2 = it.getPort();
                HostPort hostPort = n != null && n == n2 && localPort != null ? new HostPort(it.getHost(), localPort.intValue()) : it;
                GradleServerConfigurationProvider gradleServerConfigurationProvider = this.$serverConfigurationProvider;
                if (gradleServerConfigurationProvider == null || (gradleServerConfigurationProvider = gradleServerConfigurationProvider.getClientCommunicationAddress(this.$serverEnvironmentSetup.getEnvironmentConfiguration(), hostPort)) == null) {
                    gradleServerConfigurationProvider = hostPort;
                }
                return gradleServerConfigurationProvider;
            }
        };
        GradleServerEventsListener gradleServerEventsListener = new GradleServerEventsListener(targetBuildParameters, (Function1<? super HostPort, HostPort>)connectionAddressResolver2, classpathInferer2, arg_0 -> GradleServerRunner.runTargetProcess$lambda$1(this, targetProgressIndicator, targetPlatform, targetProjectBasePath, localProjectBasePath, arg_0));
        if (Intrinsics.areEqual((Object)this.connection.getUserData(targetPreparationKey), (Object)true) || PlatformUtils.isFleetBackend()) {
            string2 = null;
        } else {
            String targetDisplayName2;
            this.connection.putUserData(targetPreparationKey, true);
            String targetTypeId = serverEnvironmentSetup.getEnvironmentConfiguration().getTypeId();
            TargetEnvironmentType targetEnvironmentType = (TargetEnvironmentType)TargetEnvironmentType.EXTENSION_NAME.findFirstSafe(arg_0 -> GradleServerRunner.runTargetProcess$lambda$2((Function1)new Function1<TargetEnvironmentType<?>, Boolean>(targetTypeId){
                final /* synthetic */ String $targetTypeId;
                {
                    this.$targetTypeId = $targetTypeId;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(TargetEnvironmentType<?> it) {
                    return Intrinsics.areEqual((Object)it.getId(), (Object)this.$targetTypeId);
                }
            }, arg_0));
            String string4 = targetDisplayName2 = targetEnvironmentType != null ? targetEnvironmentType.getDisplayName() : null;
            if (string4 != null) {
                String $this$runTargetProcess_u24lambda_u243 = string4;
                boolean bl = false;
                Object[] objectArray = new Object[]{$this$runTargetProcess_u24lambda_u243};
                string2 = GradleBundle.message("gradle.target.execution.running", objectArray) + "\n";
            } else {
                string2 = null;
            }
        }
        String appStartedMessage2 = string2;
        processHandler2.addProcessListener((ProcessListener)new GradleServerProcessListener(appStartedMessage2, targetProgressIndicator, resultHandler, gradleServerEventsListener));
        processHandler2.runProcessWithProgressIndicator((ProgressIndicator)targetProgressIndicator.getProgressIndicator(), -1, true);
    }

    private final String useLocalLineSeparators(String $this$useLocalLineSeparators, TargetPlatform targetPlatform) {
        return targetPlatform.getPlatform() == Platform.current() ? $this$useLocalLineSeparators : StringsKt.replace$default((String)$this$useLocalLineSeparators, (String)targetPlatform.getPlatform().lineSeparator, (String)Platform.current().lineSeparator, (boolean)false, (int)4, null);
    }

    private final String useLocalFileSeparators(String $this$useLocalFileSeparators, Platform platform, boolean uriMode) {
        char separator = uriMode ? (char)'/' : (char)Platform.current().fileSeparator;
        return platform.fileSeparator == separator ? $this$useLocalFileSeparators : StringsKt.replace$default((String)$this$useLocalFileSeparators, (char)platform.fileSeparator, (char)separator, (boolean)false, (int)4, null);
    }

    @NlsSafe
    private final String resolveFistPath(@NlsSafe String text, String targetProjectBasePath, String localProjectBasePath, TargetPlatform targetPlatform) {
        char c;
        int pathIndexStart = StringsKt.indexOf$default((CharSequence)text, (String)targetProjectBasePath, (int)0, (boolean)false, (int)6, null);
        if (pathIndexStart == -1) {
            return text;
        }
        int delimiter = pathIndexStart == 0 ? 32 : ((c = text.charAt(pathIndexStart - 1)) != '\'' && c != '\"' ? 32 : (int)c);
        int pathIndexEnd = StringsKt.indexOf$default((CharSequence)text, (char)delimiter, (int)pathIndexStart, (boolean)false, (int)4, null);
        if (pathIndexEnd == -1) {
            pathIndexEnd = StringsKt.indexOf$default((CharSequence)text, (char)'\n', (int)pathIndexStart, (boolean)false, (int)4, null);
        }
        if (pathIndexEnd == -1) {
            pathIndexEnd = text.length();
        }
        String string2 = text.substring(Math.max(0, pathIndexStart - 7), Math.max(0, pathIndexStart - 1));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        boolean isUri = StringsKt.endsWith$default((String)string2, (String)"file:/", (boolean)false, (int)2, null);
        String string3 = text.substring(pathIndexStart + targetProjectBasePath.length(), pathIndexEnd);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        String path = this.useLocalFileSeparators(string3, targetPlatform.getPlatform(), isUri);
        StringBuilder buf = new StringBuilder();
        buf.append(text.subSequence(0, pathIndexStart));
        buf.append(this.useLocalFileSeparators(localProjectBasePath, Platform.current(), isUri));
        buf.append(path);
        String string4 = text.substring(pathIndexEnd);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
        buf.append(string4);
        return buf.toString();
    }

    private static final void runTargetProcess$lambda$1(GradleServerRunner this$0, GradleServerProgressIndicator $targetProgressIndicator, TargetPlatform $targetPlatform, String $targetProjectBasePath, String $localProjectBasePath, Object it) {
        Object object = it;
        if (object instanceof String) {
            ProgressListenerVersion1 $this$runTargetProcess_u24lambda_u241_u24lambda_u240 = this$0.consumerOperationParameters.getProgressListener();
            boolean bl = false;
            $this$runTargetProcess_u24lambda_u241_u24lambda_u240.onOperationStart((String)it);
            $this$runTargetProcess_u24lambda_u241_u24lambda_u240.onOperationEnd();
        } else if (object instanceof StandardError) {
            $targetProgressIndicator.addText(this$0.resolveFistPath(this$0.useLocalLineSeparators(((StandardError)it).getText(), $targetPlatform), $targetProjectBasePath, $localProjectBasePath, $targetPlatform), (Key)ProcessOutputType.STDERR);
        } else if (object instanceof StandardOutput) {
            $targetProgressIndicator.addText(this$0.resolveFistPath(this$0.useLocalLineSeparators(((StandardOutput)it).getText(), $targetPlatform), $targetProjectBasePath, $localProjectBasePath, $targetPlatform), (Key)ProcessOutputType.STDOUT);
        } else {
            this$0.consumerOperationParameters.getBuildProgressListener().onEvent(it);
        }
    }

    private static final boolean runTargetProcess$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GradleServerRunner.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        log = logger;
        targetPreparationKey = Key.create((String)"target preparation key");
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0014\u0010\u000e\u001a\u0004\u0018\u00010\u00012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u0002J0\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00062\u000e\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00142\u0006\u0010\t\u001a\u00020\nH\u0002J&\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u000e\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0014J\u0006\u0010\u0019\u001a\u00020\u0011J\u0014\u0010\u001a\u001a\u00020\u00112\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cJ\u0012\u0010\u001e\u001a\u00020\u0011*\b\u0012\u0004\u0012\u00020 0\u001fH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/plugins/gradle/execution/target/GradleServerRunner$GradleServerEventsListener;", "", "targetBuildParameters", "Lorg/jetbrains/plugins/gradle/tooling/proxy/TargetBuildParameters;", "connectionAddressResolver", "Lkotlin/Function1;", "Lcom/intellij/execution/target/HostPort;", "classpathInferer", "Lorg/jetbrains/plugins/gradle/execution/target/GradleServerClasspathInferer;", "buildEventConsumer", "Lorg/gradle/initialization/BuildEventConsumer;", "(Lorg/jetbrains/plugins/gradle/tooling/proxy/TargetBuildParameters;Lkotlin/jvm/functions/Function1;Lorg/jetbrains/plugins/gradle/execution/target/GradleServerClasspathInferer;Lorg/gradle/initialization/BuildEventConsumer;)V", "listenerTask", "Ljava/util/concurrent/Future;", "deserializeIfNeeded", "value", "doRun", "", "hostName", "resultHandler", "Lorg/gradle/tooling/ResultHandler;", "start", "", "port", "", "stop", "waitForResult", "handler", "Lkotlin/Function0;", "", "sendResultAck", "Lorg/gradle/internal/remote/internal/RemoteConnection;", "Lorg/gradle/launcher/daemon/protocol/Message;", "intellij.gradle.common"})
    private static final class GradleServerEventsListener {
        @NotNull
        private final TargetBuildParameters targetBuildParameters;
        @NotNull
        private final Function1<HostPort, HostPort> connectionAddressResolver;
        @NotNull
        private final GradleServerClasspathInferer classpathInferer;
        @NotNull
        private final BuildEventConsumer buildEventConsumer;
        private Future<?> listenerTask;

        public GradleServerEventsListener(@NotNull TargetBuildParameters targetBuildParameters, @NotNull Function1<? super HostPort, HostPort> connectionAddressResolver2, @NotNull GradleServerClasspathInferer classpathInferer2, @NotNull BuildEventConsumer buildEventConsumer) {
            this.targetBuildParameters = targetBuildParameters;
            this.connectionAddressResolver = connectionAddressResolver2;
            this.classpathInferer = classpathInferer2;
            this.buildEventConsumer = buildEventConsumer;
        }

        public final void start(@NotNull String hostName, int port, @NotNull ResultHandler<Object> resultHandler) {
            if (!(this.listenerTask == null)) {
                boolean bl = false;
                String string2 = "Gradle server events listener has already been started";
                throw new IllegalStateException(string2.toString());
            }
            this.listenerTask = ApplicationManager.getApplication().executeOnPooledThread(() -> GradleServerEventsListener.start$lambda$1(this, hostName, port, resultHandler));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void doRun(TargetBuildParameters targetBuildParameters, HostPort hostName, ResultHandler<Object> resultHandler, BuildEventConsumer buildEventConsumer) {
            InetAddress inetAddress = InetAddress.getByName(hostName.getHost());
            ConnectCompletion connectCompletion = new TcpOutgoingConnector().connect((Address)new SocketInetAddress(inetAddress, hostName.getPort()));
            Serializer serializer = DaemonMessageSerializer.create((Serializer)BuildActionSerializer.create());
            RemoteConnection connection = connectCompletion.create(Serializers.stateful((Serializer)serializer));
            connection.dispatch((Object)new BuildEvent((Object)targetBuildParameters));
            connection.flush();
            try {
                while ((Message)connection.receive() != null) {
                    Message message;
                    Message message2 = message;
                    if (message2 instanceof Success) {
                        Object value = this.deserializeIfNeeded(((Success)message).getValue());
                        resultHandler.onComplete(value);
                        break;
                    }
                    if (message2 instanceof Failure) {
                        Object object = ((Failure)message).getValue();
                        GradleConnectionException gradleConnectionException = object instanceof GradleConnectionException ? (GradleConnectionException)object : null;
                        if (gradleConnectionException == null) {
                            gradleConnectionException = new GradleConnectionException(((Throwable)((Failure)message).getValue()).getMessage());
                        }
                        resultHandler.onFailure(gradleConnectionException);
                        break;
                    }
                    if (message2 instanceof Output) {
                        buildEventConsumer.dispatch((Object)message);
                        continue;
                    }
                    if (!(message2 instanceof BuildEvent)) {
                        break;
                    }
                    buildEventConsumer.dispatch(((BuildEvent)message).getPayload());
                }
            }
            finally {
                this.sendResultAck((RemoteConnection<Message>)connection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final Object deserializeIfNeeded(Object value) {
            Object object;
            byte[] byArray = value instanceof byte[] ? (byte[])value : null;
            if (byArray == null) {
                return value;
            }
            byte[] bytes = byArray;
            Closeable closeable = (Closeable)new MultiLoaderObjectInputStream((InputStream)new ByteArrayInputStream(bytes), this.classpathInferer.getClassloaders());
            Throwable throwable = null;
            try {
                MultiLoaderObjectInputStream it = (MultiLoaderObjectInputStream)closeable;
                boolean bl = false;
                object = it.readObject();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            Object deserialized = object;
            return deserialized;
        }

        private final void sendResultAck(RemoteConnection<Message> $this$sendResultAck) {
            $this$sendResultAck.dispatch((Object)new BuildEvent((Object)"ack"));
            $this$sendResultAck.flush();
            $this$sendResultAck.stop();
        }

        public final void stop() {
            if (this.listenerTask != null) {
                Future<?> future = this.listenerTask;
                if (future == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"listenerTask");
                    future = null;
                }
                if (!future.isDone()) {
                    Future<?> future2 = this.listenerTask;
                    if (future2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"listenerTask");
                        future2 = null;
                    }
                    future2.cancel(true);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void waitForResult(@NotNull Function0<Boolean> handler) {
            long startTime = System.currentTimeMillis();
            while (!((Boolean)handler.invoke()).booleanValue()) {
                Object lock;
                if (this.listenerTask != null) {
                    Future<?> future = this.listenerTask;
                    if (future == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"listenerTask");
                        future = null;
                    }
                    if (future.isDone()) break;
                }
                if (System.currentTimeMillis() - startTime >= 10000L) break;
                Object object = lock = new Object();
                synchronized (object) {
                    boolean bl = false;
                    try {
                        lock.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
        }

        private static final void start$lambda$1(GradleServerEventsListener this$0, String $hostName, int $port, ResultHandler $resultHandler) {
            try {
                HostPort hostPort = (HostPort)this$0.connectionAddressResolver.invoke((Object)new HostPort($hostName, $port));
                this$0.doRun(this$0.targetBuildParameters, hostPort, (ResultHandler<Object>)$resultHandler, this$0.buildEventConsumer);
            }
            catch (Throwable t) {
                $resultHandler.onFailure(new GradleConnectionException(t.getMessage(), t));
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB/\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u001c\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/plugins/gradle/execution/target/GradleServerRunner$GradleServerProcessListener;", "Lcom/intellij/execution/process/ProcessListener;", "appStartedMessage", "", "targetProgressIndicator", "Lcom/intellij/execution/target/TargetProgressIndicator;", "resultHandler", "Lorg/gradle/tooling/ResultHandler;", "", "gradleServerEventsListener", "Lorg/jetbrains/plugins/gradle/execution/target/GradleServerRunner$GradleServerEventsListener;", "(Ljava/lang/String;Lcom/intellij/execution/target/TargetProgressIndicator;Lorg/gradle/tooling/ResultHandler;Lorg/jetbrains/plugins/gradle/execution/target/GradleServerRunner$GradleServerEventsListener;)V", "connectionAddressReceived", "", "resultHandlerWrapper", "getResultHandlerWrapper", "()Lorg/gradle/tooling/ResultHandler;", "resultReceived", "getResultReceived", "()Z", "setResultReceived", "(Z)V", "onTextAvailable", "", "event", "Lcom/intellij/execution/process/ProcessEvent;", "outputType", "Lcom/intellij/openapi/util/Key;", "processTerminated", "startNotified", "Companion", "intellij.gradle.common"})
    private static final class GradleServerProcessListener
    implements ProcessListener {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final String appStartedMessage;
        @NotNull
        private final TargetProgressIndicator targetProgressIndicator;
        @NotNull
        private final ResultHandler<Object> resultHandler;
        @NotNull
        private final GradleServerEventsListener gradleServerEventsListener;
        private volatile boolean connectionAddressReceived;
        private volatile boolean resultReceived;
        @NotNull
        private final ResultHandler<Object> resultHandlerWrapper;
        @NotNull
        private static final String connectionConfLinePrefix = "Gradle target server hostAddress: ";

        public GradleServerProcessListener(@Nullable String appStartedMessage2, @NotNull TargetProgressIndicator targetProgressIndicator, @NotNull ResultHandler<Object> resultHandler, @NotNull GradleServerEventsListener gradleServerEventsListener) {
            this.appStartedMessage = appStartedMessage2;
            this.targetProgressIndicator = targetProgressIndicator;
            this.resultHandler = resultHandler;
            this.gradleServerEventsListener = gradleServerEventsListener;
            this.resultHandlerWrapper = (ResultHandler)new ResultHandler<Object>(this){
                final /* synthetic */ GradleServerProcessListener this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onComplete(@Nullable Object result) {
                    this.this$0.setResultReceived(true);
                    GradleServerProcessListener.access$getResultHandler$p(this.this$0).onComplete(result);
                }

                public void onFailure(@Nullable GradleConnectionException gradleConnectionException) {
                    this.this$0.setResultReceived(true);
                    GradleServerProcessListener.access$getResultHandler$p(this.this$0).onFailure(gradleConnectionException);
                }
            };
        }

        public final boolean getResultReceived() {
            return this.resultReceived;
        }

        public final void setResultReceived(boolean bl) {
            this.resultReceived = bl;
        }

        @NotNull
        public final ResultHandler<Object> getResultHandlerWrapper() {
            return this.resultHandlerWrapper;
        }

        public void startNotified(@NotNull ProcessEvent event) {
            block0: {
                String string2 = this.appStartedMessage;
                if (string2 == null) break block0;
                String it = string2;
                boolean bl = false;
                this.targetProgressIndicator.addText(it, (Key)ProcessOutputType.STDOUT);
            }
        }

        public void processTerminated(@NotNull ProcessEvent event) {
            if (!this.resultReceived) {
                this.gradleServerEventsListener.waitForResult((Function0<Boolean>)((Function0)new Function0<Boolean>(this){
                    final /* synthetic */ GradleServerProcessListener this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @NotNull
                    public final Boolean invoke() {
                        return this.this$0.getResultReceived() || GradleServerProcessListener.access$getTargetProgressIndicator$p(this.this$0).isCanceled();
                    }
                }));
            }
            if (!this.resultReceived) {
                ProcessOutputType outputType = event.getExitCode() == 0 ? ProcessOutputType.STDOUT : ProcessOutputType.STDERR;
                String string2 = event.getText();
                if (string2 != null) {
                    String string3;
                    String it = string3 = string2;
                    boolean bl = false;
                    this.targetProgressIndicator.addText(it, (Key)outputType);
                }
                GradleConnectionException gradleConnectionException = this.targetProgressIndicator.isCanceled() ? (GradleConnectionException)new BuildCancelledException("Build cancelled.") : new GradleConnectionException("Operation result has not been received.");
                this.resultHandler.onFailure(gradleConnectionException);
            }
            this.gradleServerEventsListener.stop();
        }

        public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key<?> outputType) {
            GradleServerRunnerKt.access$traceIfNotEmpty(log, event.getText());
            if (this.connectionAddressReceived) {
                return;
            }
            if (outputType == ProcessOutputTypes.STDERR) {
                this.targetProgressIndicator.addText(event.getText(), outputType);
            }
            if (StringsKt.startsWith$default((String)event.getText(), (String)connectionConfLinePrefix, (boolean)false, (int)2, null)) {
                this.connectionAddressReceived = true;
                String hostName = StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)event.getText(), (String)connectionConfLinePrefix, null, (int)2, null), (String)" port: ", null, (int)2, null);
                int port = Integer.parseInt(((Object)StringsKt.trim((CharSequence)StringsKt.substringAfter$default((String)event.getText(), (String)" port: ", null, (int)2, null))).toString());
                this.gradleServerEventsListener.start(hostName, port, this.resultHandlerWrapper);
            }
        }

        public static final /* synthetic */ TargetProgressIndicator access$getTargetProgressIndicator$p(GradleServerProcessListener $this) {
            return $this.targetProgressIndicator;
        }

        public static final /* synthetic */ ResultHandler access$getResultHandler$p(GradleServerProcessListener $this) {
            return $this.resultHandler;
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/plugins/gradle/execution/target/GradleServerRunner$GradleServerProcessListener$Companion;", "", "()V", "connectionConfLinePrefix", "", "intellij.gradle.common"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0016J\u0006\u0010\u0011\u001a\u00020\fJ\u0006\u0010\u0012\u001a\u00020\fJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\b\u0010\u0016\u001a\u00020\fH\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/plugins/gradle/execution/target/GradleServerRunner$GradleServerProgressIndicator;", "Lcom/intellij/execution/target/TargetProgressIndicator;", "taskId", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "taskListener", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskNotificationListener;", "(Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskNotificationListener;)V", "progressIndicator", "Lcom/intellij/openapi/progress/EmptyProgressIndicator;", "getProgressIndicator", "()Lcom/intellij/openapi/progress/EmptyProgressIndicator;", "addText", "", "text", "", "outputType", "Lcom/intellij/openapi/util/Key;", "cancel", "checkCanceled", "isCanceled", "", "isStopped", "stop", "intellij.gradle.common"})
    public static final class GradleServerProgressIndicator
    implements TargetProgressIndicator {
        @NotNull
        private final ExternalSystemTaskId taskId;
        @Nullable
        private final ExternalSystemTaskNotificationListener taskListener;
        @NotNull
        private final EmptyProgressIndicator progressIndicator;

        /*
         * WARNING - void declaration
         */
        public GradleServerProgressIndicator(@NotNull ExternalSystemTaskId taskId, @Nullable ExternalSystemTaskNotificationListener taskListener) {
            void $this$progressIndicator_u24lambda_u240;
            EmptyProgressIndicator emptyProgressIndicator;
            this.taskId = taskId;
            this.taskListener = taskListener;
            EmptyProgressIndicator emptyProgressIndicator2 = emptyProgressIndicator = new EmptyProgressIndicator();
            GradleServerProgressIndicator gradleServerProgressIndicator = this;
            boolean bl = false;
            $this$progressIndicator_u24lambda_u240.start();
            gradleServerProgressIndicator.progressIndicator = emptyProgressIndicator;
        }

        @NotNull
        public final EmptyProgressIndicator getProgressIndicator() {
            return this.progressIndicator;
        }

        public void addText(@NotNull String text, @NotNull Key<?> outputType) {
            block0: {
                ExternalSystemTaskNotificationListener externalSystemTaskNotificationListener = this.taskListener;
                if (externalSystemTaskNotificationListener == null) break block0;
                externalSystemTaskNotificationListener.onTaskOutput(this.taskId, text, !Intrinsics.areEqual(outputType, (Object)ProcessOutputTypes.STDERR));
            }
        }

        public void stop() {
            this.progressIndicator.stop();
        }

        public boolean isStopped() {
            return !this.progressIndicator.isRunning();
        }

        public final void cancel() {
            this.progressIndicator.cancel();
        }

        public boolean isCanceled() {
            return this.progressIndicator.isCanceled();
        }

        public final void checkCanceled() {
            this.progressIndicator.checkCanceled();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0006\u001a\u0015\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/gradle/execution/target/GradleServerRunner$Companion;", "", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "targetPreparationKey", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "intellij.gradle.common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

