/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.build.output;

import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.impl.MessageEventImpl;
import com.intellij.build.output.BuildOutputInstantReader;
import com.intellij.build.output.BuildOutputParser;
import com.intellij.openapi.util.NlsSafe;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class GradleSyncOutputParser
implements BuildOutputParser {
    private static final String ERROR_PREFIX = "[sync error]";
    private static final String WARNING_PREFIX = "[sync warning]";

    public boolean parse(@NotNull String line, @NotNull BuildOutputInstantReader reader, @NotNull Consumer<? super BuildEvent> messageConsumer) {
        MessageEvent.Kind kind = MessageEvent.Kind.ERROR;
        String prefix = ERROR_PREFIX;
        int prefixIndex = line.indexOf(ERROR_PREFIX);
        if (prefixIndex < 0) {
            kind = MessageEvent.Kind.WARNING;
            prefix = WARNING_PREFIX;
            prefixIndex = line.indexOf(WARNING_PREFIX);
            if (prefixIndex < 0) {
                return false;
            }
        }
        @NlsSafe String text = line.substring(prefixIndex + prefix.length()).trim();
        messageConsumer.accept((BuildEvent)new MessageEventImpl(reader.getParentEventId(), kind, null, text, text));
        return true;
    }
}

