/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.build.output;

import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.DuplicateMessageAware;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.impl.BuildIssueEventImpl;
import com.intellij.build.issue.BuildIssue;
import com.intellij.build.output.BuildOutputInstantReader;
import com.intellij.build.output.BuildOutputParser;
import java.io.File;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.execution.GradleConsoleFilter;
import org.jetbrains.plugins.gradle.issue.GradleIssueChecker;
import org.jetbrains.plugins.gradle.issue.UnresolvedDependencyBuildIssue;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J(\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00040\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/gradle/execution/build/output/GradleBuildScriptErrorParser;", "Lcom/intellij/build/output/BuildOutputParser;", "()V", "checkUnresolvedDependencyError", "Lcom/intellij/build/events/BuildEvent;", "reason", "", "description", "parentId", "", "parse", "", "line", "reader", "Lcom/intellij/build/output/BuildOutputInstantReader;", "messageConsumer", "Ljava/util/function/Consumer;", "intellij.gradle.common"})
public final class GradleBuildScriptErrorParser
implements BuildOutputParser {
    public boolean parse(@NotNull String line, @NotNull BuildOutputInstantReader reader, @NotNull Consumer<? super BuildEvent> messageConsumer) {
        CharSequence charSequence;
        String nextLine;
        Object parentId;
        Ref.ObjectRef reason;
        StringBuilder description;
        GradleConsoleFilter filter;
        block25: {
            String nextLine2;
            if (!StringsKt.startsWith$default((String)line, (String)"FAILURE: Build failed with an exception.", (boolean)false, (int)2, null)) {
                return false;
            }
            CharSequence charSequence2 = reader.readLine();
            if (!(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2))) {
                return false;
            }
            String location = null;
            filter = null;
            String whereOrWhatLine = reader.readLine();
            if (Intrinsics.areEqual((Object)whereOrWhatLine, (Object)"* Where:")) {
                String string2 = reader.readLine();
                if (string2 == null) {
                    return false;
                }
                filter = new GradleConsoleFilter(null);
                location = string2;
                if (filter.applyFilter(location, location.length()) == null) {
                    return false;
                }
                CharSequence charSequence22 = reader.readLine();
                if (!(charSequence22 == null || StringsKt.isBlank((CharSequence)charSequence22))) {
                    return false;
                }
                whereOrWhatLine = reader.readLine();
            } else {
                location = null;
                filter = null;
            }
            if (!Intrinsics.areEqual((Object)whereOrWhatLine, (Object)"* What went wrong:")) {
                return false;
            }
            description = new StringBuilder();
            if (location != null) {
                StringBuilder stringBuilder = description.append(location);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
                StringsKt.appendln((StringBuilder)StringsKt.appendln((StringBuilder)stringBuilder));
            }
            reason = new Ref.ObjectRef();
            String string3 = reader.readLine();
            if (string3 == null) {
                return false;
            }
            reason.element = string3;
            parentId = null;
            parentId = StringsKt.startsWith$default((String)((String)reason.element), (String)"Execution failed for task '", (boolean)false, (int)2, null) ? StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)((String)reason.element), (String)"Execution failed for task '", null, (int)2, null), (String)"'.", null, (int)2, null) : reader.getParentEventId();
            StringBuilder stringBuilder = description.append((String)reason.element);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder);
            do {
                if (reader.readLine() == null) {
                    return false;
                }
                if (StringsKt.isBlank((CharSequence)nextLine2)) break block25;
                StringBuilder stringBuilder2 = description.append(nextLine2);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder2);
                String trimStart = ((Object)StringsKt.trimStart((CharSequence)nextLine2)).toString();
                if (StringsKt.startsWith$default((String)trimStart, (String)"> ", (boolean)false, (int)2, null)) {
                    char[] cArray = new char[]{'.'};
                    reason.element = StringsKt.trimEnd((String)StringsKt.substringAfter$default((String)trimStart, (String)"> ", null, (int)2, null), (char[])cArray);
                }
                if (((CharSequence)nextLine2).length() == 0) break block25;
            } while (!Intrinsics.areEqual((Object)nextLine2, (Object)"* Try:"));
            reader.pushBack();
        }
        StringBuilder trySuggestions = null;
        StringBuilder exception = null;
        while (!(reader.readLine() == null || Intrinsics.areEqual((Object)nextLine, (Object)"BUILD FAILED") || Intrinsics.areEqual((Object)nextLine, (Object)"* Get more help at https://help.gradle.org") || StringsKt.startsWith$default((String)nextLine, (String)"CONFIGURE FAILED", (boolean)false, (int)2, null))) {
            if (Intrinsics.areEqual((Object)nextLine, (Object)"* Exception is:")) {
                exception = new StringBuilder();
                continue;
            }
            if (Intrinsics.areEqual((Object)nextLine, (Object)"* Try:")) {
                trySuggestions = new StringBuilder();
                continue;
            }
            if (exception != null) {
                StringBuilder stringBuilder = exception.append(nextLine);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder);
                continue;
            }
            if (trySuggestions == null || !(!StringsKt.isBlank((CharSequence)nextLine))) continue;
            StringBuilder stringBuilder = trySuggestions.append(nextLine);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder);
        }
        if (StringsKt.startsWith$default((String)((String)reason.element), (String)"Compilation failed", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)reason.element, (Object)"Compilation error. See log for more details") || Intrinsics.areEqual((Object)reason.element, (Object)"Script compilation error:") || StringsKt.contains$default((CharSequence)((CharSequence)reason.element), (CharSequence)"compiler failed", (boolean)false, (int)2, null)) {
            return false;
        }
        FilePosition filePosition = null;
        filePosition = filter != null ? new FilePosition(new File(filter.getFilteredFileName()), filter.getFilteredLineNumber() - 1, 0) : null;
        String errorText = description.toString();
        for (GradleIssueChecker gradleIssueChecker : GradleIssueChecker.Companion.getKnownIssuesCheckList()) {
            if (!gradleIssueChecker.consumeBuildOutputFailureMessage(errorText, (String)reason.element, String.valueOf(exception), filePosition, parentId, messageConsumer)) continue;
            return true;
        }
        StringBuilder detailedMessage = new StringBuilder(errorText);
        CharSequence charSequence3 = trySuggestions;
        if (!(charSequence3 == null || StringsKt.isBlank((CharSequence)charSequence3))) {
            detailedMessage.append("\n* Try:\n" + trySuggestions);
        }
        if (!((charSequence = (CharSequence)exception) == null || StringsKt.isBlank((CharSequence)charSequence))) {
            detailedMessage.append("\n* Exception is:\n" + exception);
        }
        if (filePosition != null) {
            MessageEvent.Kind kind = MessageEvent.Kind.ERROR;
            String string4 = detailedMessage.toString();
            messageConsumer.accept((BuildEvent)new DuplicateMessageAware(parentId, (Ref.ObjectRef<String>)reason, filePosition, kind, string4){});
        } else {
            BuildEvent buildEvent = this.checkUnresolvedDependencyError((String)reason.element, errorText, parentId);
            if (buildEvent != null) {
                messageConsumer.accept((BuildEvent)buildEvent);
            } else {
                MessageEvent.Kind kind = MessageEvent.Kind.ERROR;
                String string5 = detailedMessage.toString();
                messageConsumer.accept((BuildEvent)new DuplicateMessageAware(parentId, (Ref.ObjectRef<String>)reason, kind, string5){});
            }
        }
        return true;
    }

    private final BuildEvent checkUnresolvedDependencyError(String reason, String description, Object parentId) {
        String string2;
        String noCachedVersionPrefix = "No cached version of ";
        String couldNotFindPrefix = "Could not find ";
        String cannotResolvePrefix = "Cannot resolve external dependency ";
        String cannotDownloadPrefix = "Could not download ";
        String string3 = StringsKt.startsWith$default((String)reason, (String)noCachedVersionPrefix, (boolean)false, (int)2, null) ? noCachedVersionPrefix : (StringsKt.startsWith$default((String)reason, (String)couldNotFindPrefix, (boolean)false, (int)2, null) ? couldNotFindPrefix : (StringsKt.startsWith$default((String)reason, (String)cannotResolvePrefix, (boolean)false, (int)2, null) ? cannotResolvePrefix : (StringsKt.startsWith$default((String)reason, (String)cannotDownloadPrefix, (boolean)false, (int)2, null) ? cannotDownloadPrefix : null)));
        if (string3 == null) {
            return null;
        }
        String prefix = string3;
        int indexOfSuffix = StringsKt.indexOf$default((CharSequence)reason, (String)" available for offline mode", (int)0, (boolean)false, (int)6, null);
        if (indexOfSuffix > 0) {
            String string4 = reason.substring(prefix.length(), indexOfSuffix);
            string2 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        } else {
            String string5 = reason.substring(prefix.length());
            string2 = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).substring(startIndex)");
        }
        String dependencyName = string2;
        UnresolvedDependencyBuildIssue unresolvedDependencyIssue = new UnresolvedDependencyBuildIssue(dependencyName, description, indexOfSuffix > 0);
        return (BuildEvent)new BuildIssueEventImpl(parentId, (BuildIssue)unresolvedDependencyIssue, MessageEvent.Kind.ERROR);
    }
}

