/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.build;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsDataStorage;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleModuleData;

public class CachedModuleDataFinder {
    @Nullable
    private final Project myProject;
    private final Map<String, DataNode<? extends ModuleData>> cache = new ConcurrentHashMap<String, DataNode<? extends ModuleData>>();

    @Deprecated(forRemoval=true)
    public CachedModuleDataFinder() {
        this.myProject = null;
    }

    private CachedModuleDataFinder(@NotNull Project project) {
        this.myProject = project;
    }

    public static CachedModuleDataFinder getInstance(@NotNull Project project) {
        return new CachedModuleDataFinder(project);
    }

    @ApiStatus.Experimental
    @Nullable
    public static GradleModuleData getGradleModuleData(@NotNull Module module) {
        DataNode<? extends ModuleData> moduleData = CachedModuleDataFinder.getInstance(module.getProject()).findMainModuleData(module);
        return moduleData != null ? new GradleModuleData(moduleData) : null;
    }

    @Nullable
    public static DataNode<? extends ModuleData> findModuleData(@NotNull Project project, @NotNull String modulePath) {
        DataNode projectNode = ExternalSystemApiUtil.findProjectNode((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID, (String)modulePath);
        if (projectNode == null) {
            return null;
        }
        return CachedModuleDataFinder.getInstance(project).findModuleData((DataNode<ProjectData>)projectNode, modulePath);
    }

    @Nullable
    private DataNode<? extends ModuleData> findModuleData(DataNode<ProjectData> projectNode, String projectPath) {
        DataNode<? extends ModuleData> cachedNode = this.getCache().get(projectPath);
        if (cachedNode != null) {
            return cachedNode;
        }
        return ExternalSystemApiUtil.find(projectNode, (Key)ProjectKeys.MODULE, node -> {
            String externalProjectPath2 = ((ModuleData)node.getData()).getLinkedExternalProjectPath();
            this.getCache().put(externalProjectPath2, (DataNode<? extends ModuleData>)node);
            return StringUtil.equals((CharSequence)projectPath, (CharSequence)((ModuleData)node.getData()).getLinkedExternalProjectPath());
        });
    }

    @Nullable
    public DataNode<? extends ModuleData> findModuleData(@NotNull Module module) {
        DataNode<? extends ModuleData> mainModuleData = this.findMainModuleData(module);
        if (mainModuleData == null) {
            return null;
        }
        boolean isSourceSet = "sourceSet".equals(ExternalSystemApiUtil.getExternalModuleType((Module)module));
        if (!isSourceSet) {
            return mainModuleData;
        }
        String projectId = ExternalSystemApiUtil.getExternalProjectId((Module)module);
        DataNode<? extends ModuleData> cachedNode = this.getCache().get(projectId);
        if (cachedNode != null) {
            return cachedNode;
        }
        return ExternalSystemApiUtil.find(mainModuleData, GradleSourceSetData.KEY, node -> {
            String id = ((GradleSourceSetData)((Object)((Object)node.getData()))).getId();
            this.getCache().put(id, (DataNode<? extends ModuleData>)node);
            return StringUtil.equals((CharSequence)projectId, (CharSequence)id);
        });
    }

    @Nullable
    public DataNode<? extends ModuleData> findMainModuleData(@NotNull Module module) {
        String rootProjectPath = ExternalSystemApiUtil.getExternalRootProjectPath((Module)module);
        if (rootProjectPath == null) {
            return null;
        }
        String projectId = ExternalSystemApiUtil.getExternalProjectId((Module)module);
        if (projectId == null) {
            return null;
        }
        String externalProjectPath2 = ExternalSystemApiUtil.getExternalProjectPath((Module)module);
        if (externalProjectPath2 == null) {
            return null;
        }
        ExternalProjectInfo projectData = ProjectDataManager.getInstance().getExternalProjectData(module.getProject(), GradleConstants.SYSTEM_ID, rootProjectPath);
        if (projectData == null) {
            return null;
        }
        DataNode projectStructure = projectData.getExternalProjectStructure();
        if (projectStructure == null) {
            return null;
        }
        return this.findModuleData((DataNode<ProjectData>)projectStructure, externalProjectPath2);
    }

    private Map<String, DataNode<? extends ModuleData>> getCache() {
        return this.myProject == null ? this.cache : CachedModuleDataFinder.getCache(this.myProject);
    }

    private static Map<String, DataNode<? extends ModuleData>> getCache(@NotNull Project project) {
        return (Map)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> CachedValueProvider.Result.create(new ConcurrentHashMap(), (Object[])new Object[]{ExternalProjectsDataStorage.getInstance((Project)project)}));
    }
}

