/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEnumerationHandler;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.vfs.VfsUtilCore;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.model.ExternalSourceDirectorySet;
import org.jetbrains.plugins.gradle.model.ExternalSourceSet;
import org.jetbrains.plugins.gradle.service.project.data.ExternalProjectDataCache;
import org.jetbrains.plugins.gradle.settings.GradleLocalSettings;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleOrderEnumeratorHandler
extends OrderEnumerationHandler {
    private static final Logger LOG = Logger.getInstance(GradleOrderEnumeratorHandler.class);
    private final boolean myResolveModulePerSourceSet;
    private final boolean myShouldProcessDependenciesRecursively;

    public GradleOrderEnumeratorHandler(@NotNull Module module) {
        String rootProjectPath = ExternalSystemApiUtil.getExternalRootProjectPath((Module)module);
        if (rootProjectPath != null) {
            GradleProjectSettings settings2 = (GradleProjectSettings)GradleSettings.getInstance(module.getProject()).getLinkedProjectSettings(rootProjectPath);
            this.myResolveModulePerSourceSet = settings2 != null && settings2.isResolveModulePerSourceSet();
            String gradleVersion2 = GradleLocalSettings.getInstance(module.getProject()).getGradleVersion(rootProjectPath);
            this.myShouldProcessDependenciesRecursively = gradleVersion2 != null && GradleVersion.version((String)gradleVersion2).compareTo(GradleVersion.version((String)"2.5")) < 0;
        } else {
            this.myShouldProcessDependenciesRecursively = false;
            this.myResolveModulePerSourceSet = false;
        }
    }

    public boolean shouldAddRuntimeDependenciesToTestCompilationClasspath() {
        return !this.myResolveModulePerSourceSet;
    }

    public boolean shouldIncludeTestsFromDependentModulesToTestClasspath() {
        return !this.myResolveModulePerSourceSet;
    }

    public boolean shouldProcessDependenciesRecursively() {
        return this.myShouldProcessDependenciesRecursively;
    }

    public boolean areResourceFilesFromSourceRootsCopiedToOutput() {
        return false;
    }

    public boolean addCustomModuleRoots(@NotNull OrderRootType type, @NotNull ModuleRootModel rootModel, @NotNull Collection<String> result, boolean includeProduction, boolean includeTests) {
        if (!type.equals((Object)OrderRootType.CLASSES)) {
            return false;
        }
        if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)rootModel.getModule())) {
            return false;
        }
        String gradleProjectPath = ExternalSystemModulePropertyManager.getInstance((Module)rootModel.getModule()).getRootProjectPath();
        if (gradleProjectPath == null) {
            LOG.warn("Root project path of the Gradle project not found for " + rootModel.getModule());
            return false;
        }
        Project project = rootModel.getModule().getProject();
        ExternalProjectDataCache externalProjectDataCache = ExternalProjectDataCache.getInstance(project);
        assert (externalProjectDataCache != null);
        ExternalProject externalRootProject = externalProjectDataCache.getRootExternalProject(gradleProjectPath);
        if (externalRootProject == null) {
            LOG.debug("Root external project was not yep imported for the project path: " + gradleProjectPath);
            return false;
        }
        Map<String, ExternalSourceSet> externalSourceSets = externalProjectDataCache.findExternalProject(externalRootProject, rootModel.getModule());
        if (externalSourceSets.isEmpty()) {
            return false;
        }
        boolean isDelegatedBuildEnabled = GradleProjectSettings.isDelegatedBuildEnabled(rootModel.getModule());
        for (ExternalSourceSet sourceSet : externalSourceSets.values()) {
            if (includeTests) {
                if (isDelegatedBuildEnabled) {
                    GradleOrderEnumeratorHandler.addOutputModuleRoots((ExternalSourceDirectorySet)sourceSet.getSources().get(ExternalSystemSourceType.TEST), result, true);
                }
                GradleOrderEnumeratorHandler.addOutputModuleRoots((ExternalSourceDirectorySet)sourceSet.getSources().get(ExternalSystemSourceType.TEST_RESOURCE), result, isDelegatedBuildEnabled);
            }
            if (!includeProduction) continue;
            if (isDelegatedBuildEnabled) {
                GradleOrderEnumeratorHandler.addOutputModuleRoots((ExternalSourceDirectorySet)sourceSet.getSources().get(ExternalSystemSourceType.SOURCE), result, true);
            }
            GradleOrderEnumeratorHandler.addOutputModuleRoots((ExternalSourceDirectorySet)sourceSet.getSources().get(ExternalSystemSourceType.RESOURCE), result, isDelegatedBuildEnabled);
        }
        return true;
    }

    private static void addOutputModuleRoots(@Nullable ExternalSourceDirectorySet directorySet, @NotNull Collection<? super String> result, boolean isGradleAwareMake) {
        if (directorySet == null) {
            return;
        }
        if (isGradleAwareMake) {
            for (File outputDir : directorySet.getGradleOutputDirs()) {
                result.add(VfsUtilCore.pathToUrl((String)outputDir.getPath()));
            }
        } else if (!directorySet.isCompilerOutputPathInherited()) {
            result.add(VfsUtilCore.pathToUrl((String)directorySet.getOutputDir().getPath()));
        }
    }

    public static class FactoryImpl
    extends OrderEnumerationHandler.Factory {
        private static final ExtensionPointName<FactoryImpl> EP_NAME = ExtensionPointName.create((String)"org.jetbrains.plugins.gradle.orderEnumerationHandlerFactory");

        public boolean isApplicable(@NotNull Module module) {
            return ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module);
        }

        @NotNull
        public GradleOrderEnumeratorHandler createHandler(@NotNull Module module) {
            for (FactoryImpl factory : (FactoryImpl[])EP_NAME.getExtensions()) {
                if (!factory.isApplicable(module)) continue;
                return factory.createHandler(module);
            }
            return new GradleOrderEnumeratorHandler(module);
        }
    }
}

