/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution;

import com.intellij.execution.filters.ConsoleFilterProvider;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.RegexpFilter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootModificationTracker;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.util.CachedValueImpl;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.GradleConsoleFilter;
import org.jetbrains.plugins.gradle.settings.GradleSettings;

public class GradleConsoleFilterProvider
implements ConsoleFilterProvider {
    @Language(value="RegExp")
    @NonNls
    private static final String EXPRESSION = String.format("%s:%s(?::%s)?", "$FILE_PATH$", "$LINE$", "$COLUMN$");

    @NotNull
    public @NotNull Filter @NotNull [] getDefaultFilters(final @NotNull Project project) {
        return new Filter[]{new GradleConsoleFilter(project), new RegexpFilter(project, EXPRESSION){
            private final CachedValue<@NotNull Boolean> myIsGradleProject;
            {
                super(arg0, arg1);
                this.myIsGradleProject = new CachedValueImpl(() -> CachedValueProvider.Result.create((Object)this.isGradleProject(), (Object[])new Object[]{ProjectRootModificationTracker.getInstance((Project)project)}));
            }

            @Nullable
            public Filter.Result applyFilter(@NotNull String line, int entireLength) {
                if (!OSAgnosticPathUtil.isAbsolute((String)line)) {
                    return null;
                }
                if (!((Boolean)this.myIsGradleProject.getValue()).booleanValue()) {
                    return null;
                }
                Filter.Result result = super.applyFilter(line, entireLength);
                if (result == null) {
                    return null;
                }
                Pattern pattern = this.getPattern();
                Matcher matcher = pattern.matcher(StringUtil.newBombedCharSequence((CharSequence)line, (long)100L));
                if (!matcher.lookingAt()) {
                    return result;
                }
                int lineStart = entireLength - line.length();
                int start = lineStart + matcher.start();
                int end = lineStart + matcher.end();
                return new Filter.Result(start, end, result.getFirstHyperlinkInfo());
            }

            private boolean isGradleProject() {
                return !GradleSettings.getInstance(project).getLinkedProjectsSettings().isEmpty();
            }
        }};
    }
}

