/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.action;

import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.ide.actions.runAnything.RunAnythingManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.externalSystem.action.ExternalSystemAction;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskExecutionInfo;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemNotificationManager;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.externalSystem.service.notification.NotificationSource;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import org.gradle.cli.CommandLineArgumentException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleCommandLine;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleExecuteTaskAction
extends ExternalSystemAction {
    protected boolean isVisible(@NotNull AnActionEvent e) {
        if (!super.isVisible(e)) {
            return false;
        }
        ExternalProjectsView projectsView = (ExternalProjectsView)e.getData(ExternalSystemDataKeys.VIEW);
        return projectsView == null || GradleConstants.SYSTEM_ID.equals((Object)this.getSystemId(e));
    }

    protected boolean isEnabled(@NotNull AnActionEvent e) {
        return true;
    }

    public void update(@NotNull AnActionEvent e) {
        Presentation p = e.getPresentation();
        p.setVisible(this.isVisible(e));
        p.setEnabled(this.isEnabled(e));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        RunAnythingManager runAnythingManager = RunAnythingManager.getInstance((Project)project);
        runAnythingManager.show("gradle ", false, e);
    }

    public static void runGradle(@NotNull Project project, @Nullable Executor executor, @NotNull String workDirectory, @NotNull @NlsSafe String fullCommandLine) {
        ExternalTaskExecutionInfo taskExecutionInfo;
        try {
            taskExecutionInfo = GradleExecuteTaskAction.buildTaskInfo(workDirectory, fullCommandLine, executor);
        }
        catch (CommandLineArgumentException ex) {
            @NlsSafe String italicFormat = "<i>%s</i> \n";
            NotificationData notificationData = new NotificationData(GradleBundle.message("gradle.command.line.parse.error.invalid.arguments", new Object[0]), String.format(italicFormat, fullCommandLine) + ex.getMessage(), NotificationCategory.WARNING, NotificationSource.TASK_EXECUTION);
            notificationData.setBalloonNotification(true);
            ExternalSystemNotificationManager.getInstance((Project)project).showNotification(GradleConstants.SYSTEM_ID, notificationData);
            return;
        }
        ExternalSystemUtil.runTask((ExternalSystemTaskExecutionSettings)taskExecutionInfo.getSettings(), (String)taskExecutionInfo.getExecutorId(), (Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID);
        RunnerAndConfigurationSettings configuration = ExternalSystemUtil.createExternalSystemRunnerAndConfigurationSettings((ExternalSystemTaskExecutionSettings)taskExecutionInfo.getSettings(), (Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID);
        if (configuration == null) {
            return;
        }
        RunManager runManager = RunManager.getInstance((Project)project);
        RunnerAndConfigurationSettings existingConfiguration = runManager.findConfigurationByTypeAndName(configuration.getType(), configuration.getName());
        if (existingConfiguration == null) {
            runManager.setTemporaryConfiguration(configuration);
        } else {
            runManager.setSelectedConfiguration(existingConfiguration);
        }
    }

    private static ExternalTaskExecutionInfo buildTaskInfo(@NotNull String projectPath, @NotNull String fullCommandLine, @Nullable Executor executor) throws CommandLineArgumentException {
        GradleCommandLine commandLine = GradleCommandLine.parse(fullCommandLine);
        ExternalSystemTaskExecutionSettings settings2 = new ExternalSystemTaskExecutionSettings();
        settings2.setExternalProjectPath(projectPath);
        settings2.setTaskNames(commandLine.getTasksAndArguments().toList());
        settings2.setScriptParameters(commandLine.getScriptParameters().toString());
        settings2.setExternalSystemIdString(GradleConstants.SYSTEM_ID.toString());
        return new ExternalTaskExecutionInfo(settings2, executor == null ? "Run" : executor.getId());
    }
}

