/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.util.resolve;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.LenientConfiguration;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.artifacts.UnresolvedDependency;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentSelector;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.result.ArtifactResult;
import org.gradle.api.artifacts.result.ComponentArtifactsResult;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.UnionFileCollection;
import org.gradle.api.plugins.WarPlugin;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.internal.impldep.com.google.common.collect.ArrayListMultimap;
import org.gradle.internal.impldep.com.google.common.collect.HashMultimap;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.jvm.JvmLibrary;
import org.gradle.language.base.artifact.SourcesArtifact;
import org.gradle.language.java.artifact.JavadocArtifact;
import org.gradle.util.GradleVersion;
import org.gradle.util.Path;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.AbstractExternalDependency;
import org.jetbrains.plugins.gradle.model.DefaultExternalLibraryDependency;
import org.jetbrains.plugins.gradle.model.DefaultExternalProjectDependency;
import org.jetbrains.plugins.gradle.model.DefaultFileCollectionDependency;
import org.jetbrains.plugins.gradle.model.DefaultUnresolvedExternalDependency;
import org.jetbrains.plugins.gradle.model.ExternalDependency;
import org.jetbrains.plugins.gradle.model.ExternalLibraryDependency;
import org.jetbrains.plugins.gradle.model.ExternalMultiLibraryDependency;
import org.jetbrains.plugins.gradle.model.ExternalProjectDependency;
import org.jetbrains.plugins.gradle.model.FileCollectionDependency;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.Supplier;
import org.jetbrains.plugins.gradle.tooling.util.DependencyResolver;
import org.jetbrains.plugins.gradle.tooling.util.ModuleComponentIdentifierImpl;
import org.jetbrains.plugins.gradle.tooling.util.SourceSetCachedFinder;
import org.jetbrains.plugins.gradle.tooling.util.resolve.deprecated.DeprecatedDependencyResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DependencyResolverImpl
implements DependencyResolver {
    private static final Logger LOG = LoggerFactory.getLogger(DependencyResolverImpl.class);
    private static final boolean IS_NEW_DEPENDENCY_RESOLUTION_APPLICABLE = GradleVersion.current().getBaseVersion().compareTo(GradleVersion.version((String)"4.5")) >= 0;
    @NotNull
    private final Project myProject;
    private final boolean myDownloadJavadoc;
    private final boolean myDownloadSources;
    @NotNull
    private final SourceSetCachedFinder mySourceSetFinder;

    public DependencyResolverImpl(@NotNull Project project, boolean downloadJavadoc, boolean downloadSources, @NotNull SourceSetCachedFinder sourceSetFinder) {
        this.myProject = project;
        this.myDownloadJavadoc = downloadJavadoc;
        this.myDownloadSources = downloadSources;
        this.mySourceSetFinder = sourceSetFinder;
    }

    @ApiStatus.Internal
    public static boolean isIsNewDependencyResolutionApplicable() {
        return IS_NEW_DEPENDENCY_RESOLUTION_APPLICABLE;
    }

    @Override
    public Collection<ExternalDependency> resolveDependencies(@Nullable String configurationName) {
        if (!IS_NEW_DEPENDENCY_RESOLUTION_APPLICABLE) {
            return new DeprecatedDependencyResolver(this.myProject, false, this.myDownloadJavadoc, this.myDownloadSources, this.mySourceSetFinder).resolveDependencies(configurationName);
        }
        if (configurationName == null) {
            return Collections.emptyList();
        }
        Collection<ExternalDependency> dependencies = this.resolveDependencies((Configuration)this.myProject.getConfigurations().findByName(configurationName), null);
        int order = 0;
        for (ExternalDependency dependency : dependencies) {
            ((AbstractExternalDependency)dependency).setClasspathOrder(++order);
        }
        return dependencies;
    }

    @Override
    public Collection<ExternalDependency> resolveDependencies(@Nullable Configuration configuration) {
        if (!IS_NEW_DEPENDENCY_RESOLUTION_APPLICABLE) {
            return new DeprecatedDependencyResolver(this.myProject, false, this.myDownloadJavadoc, this.myDownloadSources, this.mySourceSetFinder).resolveDependencies(configuration);
        }
        Collection<ExternalDependency> dependencies = this.resolveDependencies(configuration, null);
        int order = 0;
        for (ExternalDependency dependency : dependencies) {
            ((AbstractExternalDependency)dependency).setClasspathOrder(++order);
        }
        return dependencies;
    }

    @Override
    public Collection<ExternalDependency> resolveDependencies(final @NotNull SourceSet sourceSet) {
        if (!IS_NEW_DEPENDENCY_RESOLUTION_APPLICABLE) {
            return new DeprecatedDependencyResolver(this.myProject, false, this.myDownloadJavadoc, this.myDownloadSources, this.mySourceSetFinder).resolveDependencies(sourceSet);
        }
        ArrayList<ExternalDependency> result = new ArrayList<ExternalDependency>();
        FileCollection compileClasspath = this.getCompileClasspath(sourceSet);
        Collection<? extends ExternalDependency> compileDependencies = this.resolveDependenciesWithDefault(compileClasspath, "COMPILE", new Supplier<Collection<? extends ExternalDependency>>(){

            public Collection<? extends ExternalDependency> get() {
                String configurationName = sourceSet.getCompileClasspathConfigurationName();
                Configuration configuration = DependencyResolverImpl.this.myProject.getConfigurations().getByName(configurationName);
                return DependencyResolverImpl.this.getDependencies((FileCollection)configuration, "COMPILE");
            }
        });
        FileCollection runtimeClasspath = sourceSet.getRuntimeClasspath();
        Collection<? extends ExternalDependency> runtimeDependencies = this.resolveDependenciesWithDefault(runtimeClasspath, "RUNTIME", new Supplier<Collection<? extends ExternalDependency>>(){

            public Collection<? extends ExternalDependency> get() {
                String configurationName = sourceSet.getRuntimeClasspathConfigurationName();
                Configuration configuration = DependencyResolverImpl.this.myProject.getConfigurations().getByName(configurationName);
                return DependencyResolverImpl.this.getDependencies((FileCollection)configuration, "RUNTIME");
            }
        });
        DependencyResolverImpl.filterRuntimeAndMarkCompileOnlyAsProvided(compileDependencies, runtimeDependencies);
        result.addAll(compileDependencies);
        result.addAll(runtimeDependencies);
        this.addAdditionalProvidedDependencies(sourceSet, result);
        int order = 0;
        for (ExternalDependency dependency : result) {
            ((AbstractExternalDependency)dependency).setClasspathOrder(++order);
        }
        return result;
    }

    private FileCollection getCompileClasspath(SourceSet sourceSet) {
        String compileTaskName = sourceSet.getCompileJavaTaskName();
        Task compileTask = (Task)this.myProject.getTasks().findByName(compileTaskName);
        if (compileTask instanceof AbstractCompile) {
            try {
                return ((AbstractCompile)compileTask).getClasspath();
            }
            catch (Exception e) {
                LOG.warn("Error obtaining compile classpath for java compilation task for [" + sourceSet.getName() + "] in project [" + this.myProject.getPath() + "]", (Throwable)e);
            }
        }
        return sourceSet.getCompileClasspath();
    }

    private Collection<ExternalDependency> resolveDependencies(@Nullable Configuration configuration, @Nullable String scope) {
        if (configuration == null) {
            return Collections.emptySet();
        }
        try {
            configuration.getIncoming().artifactView((Action)new Action<ArtifactView.ViewConfiguration>(){

                public void execute(@NotNull ArtifactView.ViewConfiguration configuration) {
                    configuration.setLenient(true);
                }
            }).getArtifacts().getArtifacts();
        }
        catch (Exception exception) {
            // empty catch block
        }
        LenientConfiguration lenientConfiguration = configuration.getResolvedConfiguration().getLenientConfiguration();
        ResolutionResult resolutionResult = configuration.getIncoming().getResolutionResult();
        ArrayList<ComponentIdentifier> components = new ArrayList<ComponentIdentifier>();
        LinkedHashMap resolvedArtifacts = new LinkedHashMap();
        HashMap<ModuleVersionIdentifier, ResolvedDependencyResult> transformedProjectDependenciesResultMap = null;
        for (ResolvedDependency dependency : lenientConfiguration.getAllModuleDependencies()) {
            try {
                Set moduleArtifacts = dependency.getModuleArtifacts();
                for (ResolvedArtifact artifact : moduleArtifacts) {
                    if (artifact.getId().getComponentIdentifier() instanceof ProjectComponentIdentifier) continue;
                    components.add((ComponentIdentifier)DependencyResolverImpl.toComponentIdentifier(artifact.getModuleVersion().getId()));
                }
                resolvedArtifacts.put(dependency, moduleArtifacts);
            }
            catch (GradleException e) {
                if (transformedProjectDependenciesResultMap == null) {
                    transformedProjectDependenciesResultMap = new HashMap<ModuleVersionIdentifier, ResolvedDependencyResult>();
                    for (DependencyResult dependencyResult : resolutionResult.getAllDependencies()) {
                        ComponentSelector resultRequested = dependencyResult.getRequested();
                        if (!(dependencyResult instanceof ResolvedDependencyResult) || !(resultRequested instanceof ProjectComponentSelector)) continue;
                        ResolvedComponentResult resolvedComponentResult = ((ResolvedDependencyResult)dependencyResult).getSelected();
                        ModuleVersionIdentifier selectedResultVersion = resolvedComponentResult.getModuleVersion();
                        transformedProjectDependenciesResultMap.put(selectedResultVersion, (ResolvedDependencyResult)dependencyResult);
                    }
                }
                resolvedArtifacts.put(dependency, Collections.emptySet());
            }
            catch (Exception e) {}
        }
        Map<ComponentIdentifier, ComponentArtifactsResult> auxiliaryArtifactsMap = this.buildAuxiliaryArtifactsMap(configuration, components);
        LinkedHashSet<FileCollectionDependency> sourceSetsOutputDirsRuntimeFileDependencies = new LinkedHashSet<FileCollectionDependency>();
        LinkedHashSet<DefaultExternalLibraryDependency> artifactDependencies = new LinkedHashSet<DefaultExternalLibraryDependency>();
        HashSet<String> resolvedFiles = new HashSet<String>();
        HashMap<String, DefaultExternalProjectDependency> resolvedProjectDependencies = new HashMap<String, DefaultExternalProjectDependency>();
        for (Map.Entry entry : resolvedArtifacts.entrySet()) {
            ExternalProjectDependency projectDependency;
            ResolvedDependency resolvedDependency = (ResolvedDependency)entry.getKey();
            Set artifacts = (Set)entry.getValue();
            for (ResolvedArtifact artifact : artifacts) {
                AbstractExternalDependency dependency;
                File artifactFile = artifact.getFile();
                if (resolvedFiles.contains(artifactFile.getPath())) continue;
                resolvedFiles.add(artifactFile.getPath());
                String artifactPath = this.mySourceSetFinder.findArtifactBySourceSetOutputDir(artifactFile.getPath());
                if (artifactPath != null) {
                    artifactFile = new File(artifactPath);
                    if (resolvedFiles.contains(artifactFile.getPath())) continue;
                    resolvedFiles.add(artifactFile.getPath());
                }
                ModuleVersionIdentifier moduleVersionIdentifier = artifact.getModuleVersion().getId();
                if (artifact.getId().getComponentIdentifier() instanceof ProjectComponentIdentifier) {
                    FileCollectionDependency outputDirsRuntimeFileDependency;
                    SourceSet sourceSet;
                    if (scope == "RUNTIME" && (sourceSet = this.mySourceSetFinder.findByArtifact(artifactFile.getPath())) != null && (outputDirsRuntimeFileDependency = DependencyResolverImpl.resolveSourceSetOutputDirsRuntimeFileDependency(sourceSet.getOutput())) != null) {
                        sourceSetsOutputDirsRuntimeFileDependencies.add(outputDirsRuntimeFileDependency);
                    }
                    ProjectComponentIdentifier projectComponentIdentifier = (ProjectComponentIdentifier)artifact.getId().getComponentIdentifier();
                    String buildName = projectComponentIdentifier.getBuild().getName();
                    String projectPath = projectComponentIdentifier.getProjectPath();
                    String key = buildName + "_" + projectPath + "_" + resolvedDependency.getConfiguration();
                    DefaultExternalProjectDependency projectDependency2 = (DefaultExternalProjectDependency)resolvedProjectDependencies.get(key);
                    if (projectDependency2 != null) {
                        LinkedHashSet<File> projectDependencyArtifacts = new LinkedHashSet<File>(projectDependency2.getProjectDependencyArtifacts());
                        projectDependencyArtifacts.add(artifactFile);
                        projectDependency2.setProjectDependencyArtifacts(projectDependencyArtifacts);
                        LinkedHashSet<File> artifactSources = new LinkedHashSet<File>(projectDependency2.getProjectDependencyArtifactsSources());
                        artifactSources.addAll(DependencyResolverImpl.findArtifactSources(Collections.singleton(artifactFile), this.mySourceSetFinder));
                        projectDependency2.setProjectDependencyArtifactsSources(artifactSources);
                        continue;
                    }
                    projectDependency2 = new DefaultExternalProjectDependency();
                    resolvedProjectDependencies.put(key, projectDependency2);
                    dependency = projectDependency2;
                    String projectName = projectComponentIdentifier.getProjectName();
                    projectDependency2.setName(projectName);
                    projectDependency2.setGroup(resolvedDependency.getModuleGroup());
                    projectDependency2.setVersion(resolvedDependency.getModuleVersion());
                    projectDependency2.setScope(scope);
                    projectDependency2.setProjectPath(projectPath);
                    projectDependency2.setConfigurationName(resolvedDependency.getConfiguration());
                    Set<File> projectArtifacts = Collections.singleton(artifactFile);
                    projectDependency2.setProjectDependencyArtifacts(projectArtifacts);
                    projectDependency2.setProjectDependencyArtifactsSources(DependencyResolverImpl.findArtifactSources(projectArtifacts, this.mySourceSetFinder));
                } else {
                    DefaultExternalLibraryDependency libraryDependency = new DefaultExternalLibraryDependency();
                    libraryDependency.setName(moduleVersionIdentifier.getName());
                    libraryDependency.setGroup(moduleVersionIdentifier.getGroup());
                    libraryDependency.setVersion(moduleVersionIdentifier.getVersion());
                    libraryDependency.setFile(artifactFile);
                    ComponentArtifactsResult artifactsResult = auxiliaryArtifactsMap.get(artifact.getId().getComponentIdentifier());
                    if (artifactsResult != null) {
                        Set sourceArtifactResults = artifactsResult.getArtifacts(SourcesArtifact.class);
                        for (ArtifactResult sourceArtifactResult : sourceArtifactResults) {
                            if (!(sourceArtifactResult instanceof ResolvedArtifactResult)) continue;
                            libraryDependency.setSource(((ResolvedArtifactResult)sourceArtifactResult).getFile());
                            break;
                        }
                        Set javadocArtifactResults = artifactsResult.getArtifacts(JavadocArtifact.class);
                        for (ArtifactResult javadocArtifactResult : javadocArtifactResults) {
                            if (!(javadocArtifactResult instanceof ResolvedArtifactResult)) continue;
                            libraryDependency.setJavadoc(((ResolvedArtifactResult)javadocArtifactResult).getFile());
                            break;
                        }
                    }
                    libraryDependency.setPackaging(artifact.getExtension());
                    libraryDependency.setScope(scope);
                    libraryDependency.setClassifier(artifact.getClassifier());
                    dependency = libraryDependency;
                }
                artifactDependencies.add((DefaultExternalLibraryDependency)dependency);
            }
            if (transformedProjectDependenciesResultMap == null || !artifacts.isEmpty() || (projectDependency = this.getFailedToTransformProjectArtifactDependency(resolvedDependency, transformedProjectDependenciesResultMap, resolvedProjectDependencies, scope)) == null) continue;
            artifactDependencies.add((DefaultExternalLibraryDependency)projectDependency);
        }
        Collection<FileCollectionDependency> otherFileDependencies = DependencyResolverImpl.resolveOtherFileDependencies(resolvedFiles, configuration, scope);
        LinkedHashSet<ExternalDependency> linkedHashSet = new LinkedHashSet<ExternalDependency>();
        linkedHashSet.addAll(sourceSetsOutputDirsRuntimeFileDependencies);
        linkedHashSet.addAll(otherFileDependencies);
        linkedHashSet.addAll(artifactDependencies);
        DependencyResolverImpl.addUnresolvedDependencies(linkedHashSet, lenientConfiguration, scope);
        return linkedHashSet;
    }

    @Nullable
    private ExternalProjectDependency getFailedToTransformProjectArtifactDependency(@NotNull ResolvedDependency resolvedDependency, @NotNull Map<ModuleVersionIdentifier, ResolvedDependencyResult> transformedProjectDependenciesResultMap, @NotNull Map<String, DefaultExternalProjectDependency> resolvedProjectDependencies, @Nullable String scope) {
        ModuleVersionIdentifier moduleVersionIdentifier = resolvedDependency.getModule().getId();
        ResolvedDependencyResult resolvedDependencyResult = transformedProjectDependenciesResultMap.get(moduleVersionIdentifier);
        if (resolvedDependencyResult == null) {
            return null;
        }
        ProjectComponentSelector dependencyResultRequested = (ProjectComponentSelector)resolvedDependencyResult.getRequested();
        String projectPath = dependencyResultRequested.getProjectPath();
        String key = projectPath + "_" + resolvedDependency.getConfiguration();
        DefaultExternalProjectDependency projectDependency = resolvedProjectDependencies.get(key);
        if (projectDependency != null) {
            return null;
        }
        projectDependency = new DefaultExternalProjectDependency();
        resolvedProjectDependencies.put(key, projectDependency);
        String projectName = Path.path((String)projectPath).getName();
        projectDependency.setName(projectName);
        projectDependency.setGroup(resolvedDependency.getModuleGroup());
        projectDependency.setVersion(resolvedDependency.getModuleVersion());
        projectDependency.setScope(scope);
        projectDependency.setProjectPath(projectPath);
        projectDependency.setConfigurationName(resolvedDependency.getConfiguration());
        Project project = this.myProject.findProject(projectPath);
        if (project == null) {
            return null;
        }
        Configuration configuration1 = (Configuration)project.getConfigurations().findByName(resolvedDependency.getConfiguration());
        if (configuration1 == null) {
            return null;
        }
        Set projectArtifacts = configuration1.getArtifacts().getFiles().getFiles();
        projectDependency.setProjectDependencyArtifacts(projectArtifacts);
        projectDependency.setProjectDependencyArtifactsSources(DependencyResolverImpl.findArtifactSources(projectArtifacts, this.mySourceSetFinder));
        return projectDependency;
    }

    @NotNull
    private Map<ComponentIdentifier, ComponentArtifactsResult> buildAuxiliaryArtifactsMap(@NotNull Configuration configuration, List<ComponentIdentifier> components) {
        Map<ComponentIdentifier, ComponentArtifactsResult> artifactsResultMap;
        if (!components.isEmpty()) {
            boolean isBuildScriptConfiguration;
            ArrayList<Class> artifactTypes = new ArrayList<Class>(2);
            if (this.myDownloadSources) {
                artifactTypes.add(SourcesArtifact.class);
            }
            if (this.myDownloadJavadoc) {
                artifactTypes.add(JavadocArtifact.class);
            }
            DependencyHandler dependencyHandler = (isBuildScriptConfiguration = this.myProject.getBuildscript().getConfigurations().contains((Object)configuration)) ? this.myProject.getBuildscript().getDependencies() : this.myProject.getDependencies();
            Set componentResults = dependencyHandler.createArtifactResolutionQuery().forComponents(components).withArtifacts(JvmLibrary.class, artifactTypes).execute().getResolvedComponents();
            artifactsResultMap = new HashMap<ComponentIdentifier, ComponentArtifactsResult>(componentResults.size());
            for (ComponentArtifactsResult artifactsResult : componentResults) {
                artifactsResultMap.put(artifactsResult.getId(), artifactsResult);
            }
        } else {
            artifactsResultMap = Collections.emptyMap();
        }
        return artifactsResultMap;
    }

    private static Collection<FileCollectionDependency> resolveOtherFileDependencies(@NotNull Set<String> resolvedFiles, @NotNull Configuration configuration, @Nullable String scope) {
        ArtifactView artifactView = configuration.getIncoming().artifactView((Action)new Action<ArtifactView.ViewConfiguration>(){

            public void execute(ArtifactView.ViewConfiguration configuration) {
                configuration.setLenient(true);
                configuration.componentFilter((Spec)new Spec<ComponentIdentifier>(){

                    public boolean isSatisfiedBy(ComponentIdentifier identifier) {
                        return !(identifier instanceof ProjectComponentIdentifier) && !(identifier instanceof ModuleComponentIdentifier);
                    }
                });
            }
        });
        Set artifactResults = artifactView.getArtifacts().getArtifacts();
        LinkedHashSet<FileCollectionDependency> result = new LinkedHashSet<FileCollectionDependency>();
        for (ResolvedArtifactResult artifactResult : artifactResults) {
            File file = artifactResult.getFile();
            if (resolvedFiles.contains(file.getPath())) continue;
            DefaultFileCollectionDependency fileCollectionDependency = new DefaultFileCollectionDependency(Collections.singleton(file));
            fileCollectionDependency.setScope(scope);
            result.add(fileCollectionDependency);
        }
        return result;
    }

    private static void addUnresolvedDependencies(@NotNull Collection<ExternalDependency> result, @NotNull LenientConfiguration lenientConfiguration, @Nullable String scope) {
        Set unresolvedModuleDependencies = lenientConfiguration.getUnresolvedModuleDependencies();
        for (UnresolvedDependency unresolvedDependency : unresolvedModuleDependencies) {
            MyModuleVersionSelector myModuleVersionSelector = null;
            Throwable problem = unresolvedDependency.getProblem();
            if (problem.getCause() != null) {
                problem = problem.getCause();
            }
            try {
                ComponentSelector componentSelector;
                if (problem instanceof ModuleVersionResolveException && (componentSelector = ((ModuleVersionResolveException)problem).getSelector()) instanceof ModuleComponentSelector) {
                    ModuleComponentSelector moduleComponentSelector = (ModuleComponentSelector)componentSelector;
                    myModuleVersionSelector = new MyModuleVersionSelector(moduleComponentSelector.getModule(), moduleComponentSelector.getGroup(), moduleComponentSelector.getVersion());
                }
            }
            catch (Throwable componentSelector) {
                // empty catch block
            }
            if (myModuleVersionSelector == null) {
                problem = unresolvedDependency.getProblem();
                ModuleVersionSelector selector = unresolvedDependency.getSelector();
                myModuleVersionSelector = new MyModuleVersionSelector(selector.getName(), selector.getGroup(), selector.getVersion());
            }
            DefaultUnresolvedExternalDependency dependency = new DefaultUnresolvedExternalDependency();
            dependency.setName(myModuleVersionSelector.name);
            dependency.setGroup(myModuleVersionSelector.group);
            dependency.setVersion(myModuleVersionSelector.version);
            dependency.setScope(scope);
            dependency.setFailureMessage(problem.getMessage());
            result.add(dependency);
        }
    }

    private static Collection<ExternalDependency> resolveSourceOutputFileDependencies(@NotNull SourceSetOutput sourceSetOutput, @Nullable String scope) {
        FileCollectionDependency outputDirsRuntimeFileDependency;
        ArrayList<ExternalDependency> result = new ArrayList<ExternalDependency>(2);
        ArrayList<File> files = new ArrayList<File>(sourceSetOutput.getClassesDirs().getFiles());
        files.add(sourceSetOutput.getResourcesDir());
        DefaultFileCollectionDependency fileCollectionDependency = new DefaultFileCollectionDependency(files);
        fileCollectionDependency.setScope(scope);
        result.add(fileCollectionDependency);
        if (scope == "RUNTIME" && (outputDirsRuntimeFileDependency = DependencyResolverImpl.resolveSourceSetOutputDirsRuntimeFileDependency(sourceSetOutput)) != null) {
            result.add((ExternalDependency)outputDirsRuntimeFileDependency);
        }
        return result;
    }

    @Nullable
    private static FileCollectionDependency resolveSourceSetOutputDirsRuntimeFileDependency(@NotNull SourceSetOutput sourceSetOutput) {
        ArrayList<File> runtimeOutputDirs = new ArrayList<File>(sourceSetOutput.getDirs().getFiles());
        if (!runtimeOutputDirs.isEmpty()) {
            DefaultFileCollectionDependency runtimeOutputDirsDependency = new DefaultFileCollectionDependency(runtimeOutputDirs);
            runtimeOutputDirsDependency.setScope("RUNTIME");
            runtimeOutputDirsDependency.setExcludedFromIndexing(true);
            return runtimeOutputDirsDependency;
        }
        return null;
    }

    private static void filterRuntimeAndMarkCompileOnlyAsProvided(@NotNull Collection<? extends ExternalDependency> compileDependencies, @NotNull Collection<? extends ExternalDependency> runtimeDependencies) {
        Collection<File> resolvedFiles;
        HashMultimap filesToRuntimeDependenciesMap = HashMultimap.create();
        for (ExternalDependency externalDependency : runtimeDependencies) {
            resolvedFiles = DependencyResolverImpl.getFiles(externalDependency);
            filesToRuntimeDependenciesMap.put(resolvedFiles, (Object)externalDependency);
        }
        for (ExternalDependency externalDependency : compileDependencies) {
            boolean hasRuntimeDependencies;
            resolvedFiles = DependencyResolverImpl.getFiles(externalDependency);
            Collection dependencies = filesToRuntimeDependenciesMap.get(resolvedFiles);
            boolean bl = hasRuntimeDependencies = dependencies != null && !dependencies.isEmpty();
            if (hasRuntimeDependencies) {
                runtimeDependencies.removeAll(dependencies);
                continue;
            }
            ((AbstractExternalDependency)externalDependency).setScope("PROVIDED");
        }
    }

    private void addAdditionalProvidedDependencies(@NotNull SourceSet sourceSet, @NotNull Collection<ExternalDependency> result) {
        LinkedHashSet<Configuration> providedConfigurations = new LinkedHashSet<Configuration>();
        if (sourceSet.getName().equals("main") && this.myProject.getPlugins().findPlugin(WarPlugin.class) != null) {
            Configuration providedRuntime;
            Configuration providedCompile = (Configuration)this.myProject.getConfigurations().findByName("providedCompile");
            if (providedCompile != null) {
                providedConfigurations.add(providedCompile);
            }
            if ((providedRuntime = (Configuration)this.myProject.getConfigurations().findByName("providedRuntime")) != null) {
                providedConfigurations.add(providedRuntime);
            }
        }
        if (providedConfigurations.isEmpty()) {
            return;
        }
        ArrayListMultimap filesToDependenciesMap = ArrayListMultimap.create();
        for (ExternalDependency dep : result) {
            filesToDependenciesMap.put(DependencyResolverImpl.getFiles(dep), (Object)dep);
        }
        for (Configuration configuration : providedConfigurations) {
            Collection<ExternalDependency> providedDependencies = this.resolveDependencies(configuration, "PROVIDED");
            Iterator<ExternalDependency> iterator = providedDependencies.iterator();
            while (iterator.hasNext()) {
                ExternalDependency providedDependency = iterator.next();
                Collection<File> files = DependencyResolverImpl.getFiles(providedDependency);
                Collection dependencies = filesToDependenciesMap.get(files);
                if (dependencies.isEmpty()) continue;
                for (ExternalDependency depForScope : dependencies) {
                    ((AbstractExternalDependency)depForScope).setScope("PROVIDED");
                }
                iterator.remove();
            }
            result.addAll(providedDependencies);
        }
    }

    @NotNull
    private Collection<? extends ExternalDependency> getDependencies(final @NotNull FileCollection fileCollection, @NotNull String scope) {
        return this.resolveDependenciesWithDefault(fileCollection, scope, new Supplier<Collection<? extends ExternalDependency>>(){

            public Collection<? extends ExternalDependency> get() {
                return Collections.singleton(new DefaultFileCollectionDependency(fileCollection.getFiles()));
            }
        });
    }

    @NotNull
    private Collection<? extends ExternalDependency> resolveDependenciesWithDefault(@NotNull FileCollection fileCollection, @NotNull String scope, @NotNull Supplier<Collection<? extends ExternalDependency>> defaultValueProvider) {
        if (fileCollection instanceof ConfigurableFileCollection) {
            return this.getDependencies(((ConfigurableFileCollection)fileCollection).getFrom(), scope);
        }
        if (fileCollection instanceof UnionFileCollection) {
            return this.getDependencies(((UnionFileCollection)fileCollection).getSources(), scope);
        }
        if (fileCollection instanceof Configuration) {
            return this.resolveDependencies((Configuration)fileCollection, scope);
        }
        if (fileCollection instanceof SourceSetOutput) {
            return DependencyResolverImpl.resolveSourceOutputFileDependencies((SourceSetOutput)fileCollection, scope);
        }
        return (Collection)defaultValueProvider.get();
    }

    private Collection<ExternalDependency> getDependencies(@NotNull Iterable<?> fileCollections, @NotNull String scope) {
        LinkedHashSet<ExternalDependency> result = new LinkedHashSet<ExternalDependency>();
        for (Object fileCollection : fileCollections) {
            if (!(fileCollection instanceof FileCollection)) continue;
            result.addAll(this.getDependencies((FileCollection)fileCollection, scope));
        }
        return result;
    }

    @NotNull
    public static Collection<File> getFiles(ExternalDependency dependency) {
        if (dependency instanceof ExternalLibraryDependency) {
            return Collections.singleton(((ExternalLibraryDependency)dependency).getFile());
        }
        if (dependency instanceof FileCollectionDependency) {
            return ((FileCollectionDependency)dependency).getFiles();
        }
        if (dependency instanceof ExternalMultiLibraryDependency) {
            return ((ExternalMultiLibraryDependency)dependency).getFiles();
        }
        if (dependency instanceof ExternalProjectDependency) {
            return ((ExternalProjectDependency)dependency).getProjectDependencyArtifacts();
        }
        return Collections.emptySet();
    }

    @NotNull
    public static List<File> findArtifactSources(Collection<? extends File> artifactFiles, SourceSetCachedFinder sourceSetFinder) {
        ArrayList<File> artifactSources = new ArrayList<File>();
        for (File file : artifactFiles) {
            Set<File> sources = sourceSetFinder.findSourcesByArtifact(file.getPath());
            if (sources == null) continue;
            artifactSources.addAll(sources);
        }
        return artifactSources;
    }

    public static ModuleComponentIdentifier toComponentIdentifier(ModuleVersionIdentifier id) {
        return new ModuleComponentIdentifierImpl(id.getGroup(), id.getName(), id.getVersion());
    }

    public static ModuleComponentIdentifier toComponentIdentifier(@NotNull String group, @NotNull String module, @NotNull String version) {
        return new ModuleComponentIdentifierImpl(group, module, version);
    }

    private static final class MyModuleVersionSelector {
        private final String name;
        private final String group;
        private final String version;

        private MyModuleVersionSelector(String name, String group, String version) {
            this.name = name;
            this.group = group;
            this.version = version;
        }
    }
}

