/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.internal;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.ClasspathEntryModel;
import org.jetbrains.plugins.gradle.tooling.util.GradleContainerUtil;

public class ClasspathEntryModelImpl
implements ClasspathEntryModel,
Serializable {
    @NotNull
    private final Set<File> classes;
    @NotNull
    private final Set<File> sources;
    @NotNull
    private final Set<File> javadoc;

    public ClasspathEntryModelImpl(@NotNull Collection<File> classes, @NotNull Collection<File> sources, @NotNull Collection<File> javadoc) {
        this.classes = new LinkedHashSet<File>(classes);
        this.sources = new LinkedHashSet<File>(sources);
        this.javadoc = new LinkedHashSet<File>(javadoc);
    }

    @NotNull
    public Set<String> getClasses() {
        return GradleContainerUtil.unmodifiablePathSet(this.classes);
    }

    @NotNull
    public Set<String> getSources() {
        return GradleContainerUtil.unmodifiablePathSet(this.sources);
    }

    @NotNull
    public Set<String> getJavadoc() {
        return GradleContainerUtil.unmodifiablePathSet(this.javadoc);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClasspathEntryModelImpl model = (ClasspathEntryModelImpl)o;
        if (!this.classes.equals(model.classes)) {
            return false;
        }
        if (!this.sources.equals(model.sources)) {
            return false;
        }
        return this.javadoc.equals(model.javadoc);
    }

    public int hashCode() {
        int result = this.classes.hashCode();
        result = 31 * result + this.sources.hashCode();
        result = 31 * result + this.javadoc.hashCode();
        return result;
    }
}

