/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.internal.ImmutableDomainObjectSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.BuildScriptClasspathModel;
import org.jetbrains.plugins.gradle.model.ClasspathEntryModel;

public class BuildScriptClasspathModelImpl
implements BuildScriptClasspathModel {
    private final List<ClasspathEntryModel> myClasspathEntries = new ArrayList<ClasspathEntryModel>(0);
    @Nullable
    private File gradleHomeDir;
    private String myGradleVersion;

    public DomainObjectSet<? extends ClasspathEntryModel> getClasspath() {
        return ImmutableDomainObjectSet.of(this.myClasspathEntries);
    }

    public void setGradleHomeDir(@Nullable File file) {
        this.gradleHomeDir = file;
    }

    @Nullable
    public File getGradleHomeDir() {
        return this.gradleHomeDir;
    }

    public void add(@NotNull ClasspathEntryModel classpathEntryModel) {
        this.myClasspathEntries.add(classpathEntryModel);
    }

    public void setGradleVersion(@NotNull String gradleVersion) {
        this.myGradleVersion = gradleVersion;
    }

    @NotNull
    public String getGradleVersion() {
        return this.myGradleVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildScriptClasspathModelImpl other = (BuildScriptClasspathModelImpl)o;
        if (!this.myClasspathEntries.equals(other.myClasspathEntries)) {
            return false;
        }
        if (this.gradleHomeDir == null && other.gradleHomeDir != null || this.gradleHomeDir != null && (other.gradleHomeDir == null || !this.gradleHomeDir.getPath().equals(other.gradleHomeDir.getPath()))) {
            return false;
        }
        return !(this.myGradleVersion != null ? !this.myGradleVersion.equals(other.myGradleVersion) : other.myGradleVersion != null);
    }

    public int hashCode() {
        int result = this.myClasspathEntries.hashCode();
        result = 31 * result + (this.gradleHomeDir != null ? this.gradleHomeDir.hashCode() : 0);
        result = 31 * result + (this.myGradleVersion != null ? this.myGradleVersion.hashCode() : 0);
        return result;
    }
}

