/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.builder;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.UnknownConfigurationException;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.initialization.dsl.VersionCatalogBuilder;
import org.gradle.api.initialization.resolve.MutableVersionCatalogContainer;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.artifacts.DependencyResolutionServices;
import org.gradle.api.internal.catalog.DefaultVersionCatalogBuilder;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.VersionCatalogsModel;
import org.jetbrains.plugins.gradle.tooling.AbstractModelBuilderService;
import org.jetbrains.plugins.gradle.tooling.ErrorMessageBuilder;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderContext;
import org.jetbrains.plugins.gradle.tooling.internal.VersionCatalogsModelImpl;

public class VersionCatalogsModelBuilder
extends AbstractModelBuilderService {
    public Object buildAll(@NotNull String modelName, @NotNull Project project, @NotNull ModelBuilderContext context) {
        HashMap<String, String> result = new HashMap<String, String>();
        SettingsInternal settings = ((GradleInternal)project.getGradle()).getSettings();
        MutableVersionCatalogContainer catalogs = settings.getDependencyResolutionManagement().getVersionCatalogs();
        for (VersionCatalogBuilder builder : catalogs) {
            if (!(builder instanceof DefaultVersionCatalogBuilder)) continue;
            DefaultVersionCatalogBuilder catalogBuilder = (DefaultVersionCatalogBuilder)builder;
            catalogBuilder.build();
            String name = catalogBuilder.getName();
            DependencyResolutionServices service = VersionCatalogsModelBuilder.extractDependencyResolutionService(catalogBuilder);
            if (service == null) continue;
            try {
                Configuration catalogImportConf = service.getConfigurationContainer().getByName("incomingCatalogFor" + StringGroovyMethods.capitalize((CharSequence)name) + "0");
                for (ResolvedArtifactResult artifact : catalogImportConf.getIncoming().getArtifacts().getArtifacts()) {
                    result.put(name, artifact.getFile().getAbsolutePath().replace('\\', '/'));
                }
            }
            catch (UnknownConfigurationException unknownConfigurationException) {
            }
        }
        return new VersionCatalogsModelImpl(result);
    }

    private static DependencyResolutionServices extractDependencyResolutionService(DefaultVersionCatalogBuilder builder) {
        try {
            Field supplierField = DefaultVersionCatalogBuilder.class.getDeclaredField("dependencyResolutionServicesSupplier");
            supplierField.setAccessible(true);
            Object supplier = supplierField.get(builder);
            Method getMethod = supplier.getClass().getMethod("get", new Class[0]);
            getMethod.setAccessible(true);
            Object result = getMethod.invoke(supplier, new Object[0]);
            if (result instanceof DependencyResolutionServices) {
                return (DependencyResolutionServices)result;
            }
            return null;
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
    }

    public boolean canBuild(String modelName) {
        return VersionCatalogsModel.class.getName().equals(modelName) && GradleVersion.current().compareTo(GradleVersion.version((String)"7.0")) >= 0;
    }

    @NotNull
    public ErrorMessageBuilder getErrorMessageBuilder(@NotNull Project project, @NotNull Exception e) {
        return ErrorMessageBuilder.create((Project)project, (Exception)e, (String)"Project version catalogs inspection errors").withDescription("Unable to obtain version catalogs sources.");
    }
}

