/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.builder;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.tasks.DefaultTaskContainer;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.tooling.MessageBuilder;
import org.jetbrains.plugins.gradle.tooling.MessageReporter;

public class TasksFactory {
    private static final boolean TASKS_REFRESH_REQUIRED = GradleVersion.current().getBaseVersion().compareTo(GradleVersion.version((String)"5.0")) < 0;
    private final Map<Project, Set<Task>> allTasks = new ConcurrentHashMap<Project, Set<Task>>();
    ConcurrentMap<Project, Lock> initializationLocks = new ConcurrentHashMap<Project, Lock>();
    private final Set<Project> processedRootProjects = Collections.newSetFromMap(new ConcurrentHashMap());
    @NotNull
    private final MessageReporter myMessageReporter;

    public TasksFactory(@NotNull MessageReporter messageReporter) {
        this.myMessageReporter = messageReporter;
    }

    private void collectTasks(Project root) {
        this.allTasks.putAll(this.getAllTasks(root));
    }

    @NotNull
    private Map<Project, Set<Task>> getAllTasks(@NotNull Project root) {
        TreeMap<Project, Set<Task>> foundTargets = new TreeMap<Project, Set<Task>>();
        for (Project project : root.getAllprojects()) {
            try {
                TasksFactory.maybeRefreshTasks(project);
                TaskContainer projectTasks = project.getTasks();
                foundTargets.put(project, new TreeSet(projectTasks));
            }
            catch (Exception e) {
                String title = "Can not load tasks for " + project;
                this.myMessageReporter.report(project, MessageBuilder.create((String)title, (String)title).warning().withException(e).build());
            }
        }
        return foundTargets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Task> getTasks(Project project) {
        Project rootProject = project.getRootProject();
        if (!this.processedRootProjects.contains(rootProject)) {
            Lock lock = new ReentrantLock();
            try {
                Lock existingLock = this.initializationLocks.putIfAbsent(rootProject, lock);
                if (existingLock != null) {
                    lock = existingLock;
                }
                lock.lock();
                if (!this.processedRootProjects.contains(rootProject)) {
                    this.collectTasks(rootProject);
                    this.processedRootProjects.add(rootProject);
                }
            }
            finally {
                lock.unlock();
                this.initializationLocks.remove(project);
            }
        }
        LinkedHashSet<Task> tasks = new LinkedHashSet<Task>(this.getTasksNullsafe(project));
        for (Project subProject : project.getSubprojects()) {
            tasks.addAll(this.getTasksNullsafe(subProject));
        }
        return tasks;
    }

    private Set<Task> getTasksNullsafe(Project project) {
        Set<Task> tasks = this.allTasks.get(project);
        if (tasks != null) {
            return tasks;
        }
        return Collections.emptySet();
    }

    private static void maybeRefreshTasks(Project project) {
        TaskContainer tasks;
        if (TASKS_REFRESH_REQUIRED && (tasks = project.getTasks()) instanceof DefaultTaskContainer) {
            ((DefaultTaskContainer)tasks).discoverTasks();
            SortedSet taskNames = tasks.getNames();
            for (String taskName : taskNames) {
                tasks.findByName(taskName);
            }
        }
    }
}

