/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.builder;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.plugins.ide.idea.IdeaPlugin;
import org.gradle.plugins.ide.idea.model.IdeaModule;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.AnnotationProcessingConfig;
import org.jetbrains.plugins.gradle.model.AnnotationProcessingModel;
import org.jetbrains.plugins.gradle.tooling.AbstractModelBuilderService;
import org.jetbrains.plugins.gradle.tooling.ErrorMessageBuilder;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderContext;
import org.jetbrains.plugins.gradle.tooling.internal.AnnotationProcessingConfigImpl;
import org.jetbrains.plugins.gradle.tooling.internal.AnnotationProcessingModelImpl;
import org.jetbrains.plugins.gradle.tooling.util.JavaPluginUtil;

public class AnnotationProcessingModelBuilder
extends AbstractModelBuilderService {
    private static final boolean isAtLeastGradle3_4 = GradleVersion.current().compareTo(GradleVersion.version((String)"3.4")) >= 0;
    private static final boolean isAtLeastGradle4_3 = isAtLeastGradle3_4 && GradleVersion.current().compareTo(GradleVersion.version((String)"4.3")) >= 0;
    private static final boolean isAtLeastGradle4_5 = isAtLeastGradle4_3 && GradleVersion.current().compareTo(GradleVersion.version((String)"4.5")) >= 0;
    private static final boolean isAtLeastGradle6_3 = isAtLeastGradle4_3 && GradleVersion.current().compareTo(GradleVersion.version((String)"6.3")) >= 0;

    public Object buildAll(@NotNull String modelName, @NotNull Project project, @NotNull ModelBuilderContext context) {
        if (!this.canBuild(modelName)) {
            return null;
        }
        if (!isAtLeastGradle3_4) {
            return null;
        }
        SourceSetContainer container = JavaPluginUtil.getSourceSetContainer(project);
        if (container == null) {
            return null;
        }
        HashMap<String, AnnotationProcessingConfig> sourceSetConfigs = new HashMap<String, AnnotationProcessingConfig>();
        IdeaModule ideaModule = null;
        IdeaPlugin plugin = (IdeaPlugin)project.getPlugins().findPlugin(IdeaPlugin.class);
        if (plugin != null) {
            ideaModule = plugin.getModel().getModule();
        }
        for (SourceSet sourceSet : container) {
            Set files;
            CompileOptions options;
            FileCollection path;
            String compileTaskName = sourceSet.getCompileJavaTaskName();
            Task compileTask = (Task)project.getTasks().findByName(compileTaskName);
            if (!(compileTask instanceof JavaCompile) || (path = (options = ((JavaCompile)compileTask).getOptions()).getAnnotationProcessorPath()) == null || (files = path.getFiles()).isEmpty()) continue;
            ArrayList<String> annotationProcessorArgs = new ArrayList<String>();
            List args = isAtLeastGradle4_5 ? options.getAllCompilerArgs() : options.getCompilerArgs();
            for (String arg : args) {
                if (!arg.startsWith("-A")) continue;
                annotationProcessorArgs.add(arg);
            }
            File generatedSourcesDirectory = isAtLeastGradle6_3 ? ((Directory)options.getGeneratedSourceOutputDirectory().get()).getAsFile() : (isAtLeastGradle4_3 ? options.getAnnotationProcessorGeneratedSourcesDirectory() : null);
            String output = generatedSourcesDirectory != null ? generatedSourcesDirectory.getAbsolutePath() : null;
            sourceSetConfigs.put(sourceSet.getName(), new AnnotationProcessingConfigImpl(files, annotationProcessorArgs, output, AnnotationProcessingModelBuilder.isTestSourceSet(sourceSet, ideaModule)));
        }
        if (!sourceSetConfigs.isEmpty()) {
            return new AnnotationProcessingModelImpl(sourceSetConfigs);
        }
        return null;
    }

    private static boolean isTestSourceSet(@NotNull SourceSet sourceSet, @Nullable IdeaModule module) {
        if ("test".equals(sourceSet.getName())) {
            return true;
        }
        if (module != null) {
            return module.getTestSourceDirs().containsAll(sourceSet.getAllJava().getSrcDirs());
        }
        return false;
    }

    public boolean canBuild(String modelName) {
        return AnnotationProcessingModel.class.getName().equals(modelName);
    }

    @NotNull
    public ErrorMessageBuilder getErrorMessageBuilder(@NotNull Project project, @NotNull Exception e) {
        return ErrorMessageBuilder.create((Project)project, (Exception)e, (String)"Project annotation processor import errors").withDescription("Unable to create annotation processors model");
    }
}

