/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.DefaultExternalTask;
import org.jetbrains.plugins.gradle.model.DefaultGradleConfiguration;
import org.jetbrains.plugins.gradle.model.DefaultGradleConvention;
import org.jetbrains.plugins.gradle.model.DefaultGradleExtension;
import org.jetbrains.plugins.gradle.model.DefaultGradleProperty;
import org.jetbrains.plugins.gradle.model.ExternalTask;
import org.jetbrains.plugins.gradle.model.GradleConfiguration;
import org.jetbrains.plugins.gradle.model.GradleConvention;
import org.jetbrains.plugins.gradle.model.GradleExtension;
import org.jetbrains.plugins.gradle.model.GradleExtensions;
import org.jetbrains.plugins.gradle.model.GradleProperty;

public class DefaultGradleExtensions
implements GradleExtensions {
    private static final long serialVersionUID = 1L;
    private final List<DefaultGradleExtension> extensions;
    private final List<DefaultGradleConvention> conventions;
    private final List<DefaultGradleProperty> gradleProperties;
    private final ArrayList<DefaultExternalTask> tasks;
    private final List<DefaultGradleConfiguration> configurations;
    private String parentProjectPath;

    public DefaultGradleExtensions() {
        this.extensions = new ArrayList<DefaultGradleExtension>(0);
        this.conventions = new ArrayList<DefaultGradleConvention>(0);
        this.gradleProperties = new ArrayList<DefaultGradleProperty>(0);
        this.tasks = new ArrayList(0);
        this.configurations = new ArrayList<DefaultGradleConfiguration>(0);
    }

    public DefaultGradleExtensions(@NotNull GradleExtensions extensions) {
        this.parentProjectPath = extensions.getParentProjectPath();
        this.extensions = new ArrayList<DefaultGradleExtension>(extensions.getExtensions().size());
        for (GradleExtension extension : extensions.getExtensions()) {
            this.extensions.add(new DefaultGradleExtension(extension));
        }
        this.conventions = new ArrayList<DefaultGradleConvention>(extensions.getConventions().size());
        for (GradleConvention convention : extensions.getConventions()) {
            this.conventions.add(new DefaultGradleConvention(convention));
        }
        this.gradleProperties = new ArrayList<DefaultGradleProperty>(extensions.getGradleProperties().size());
        for (GradleProperty property : extensions.getGradleProperties()) {
            this.gradleProperties.add(new DefaultGradleProperty(property));
        }
        this.tasks = new ArrayList(extensions.getTasks().size());
        for (ExternalTask entry : extensions.getTasks()) {
            this.tasks.add(new DefaultExternalTask(entry));
        }
        this.configurations = new ArrayList<DefaultGradleConfiguration>(extensions.getConfigurations().size());
        for (ExternalTask entry : extensions.getConfigurations()) {
            this.configurations.add(new DefaultGradleConfiguration((GradleConfiguration)entry));
        }
    }

    @Nullable
    public String getParentProjectPath() {
        return this.parentProjectPath;
    }

    public void setParentProjectPath(String parentProjectPath) {
        this.parentProjectPath = parentProjectPath;
    }

    @NotNull
    public List<DefaultGradleExtension> getExtensions() {
        return this.extensions == null ? Collections.emptyList() : this.extensions;
    }

    @NotNull
    public List<DefaultGradleConvention> getConventions() {
        return this.conventions == null ? Collections.emptyList() : this.conventions;
    }

    @NotNull
    public List<DefaultGradleProperty> getGradleProperties() {
        return this.gradleProperties == null ? Collections.emptyList() : this.gradleProperties;
    }

    @NotNull
    public List<DefaultExternalTask> getTasks() {
        return this.tasks;
    }

    public void addTasks(@NotNull Collection<? extends ExternalTask> values) {
        this.tasks.ensureCapacity(this.tasks.size() + values.size());
        for (ExternalTask externalTask : values) {
            if (externalTask instanceof DefaultExternalTask) {
                this.tasks.add((DefaultExternalTask)externalTask);
                continue;
            }
            this.tasks.add(new DefaultExternalTask(externalTask));
        }
    }

    @NotNull
    public List<DefaultGradleConfiguration> getConfigurations() {
        return this.configurations == null ? Collections.emptyList() : this.configurations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultGradleExtensions that = (DefaultGradleExtensions)o;
        if (this.extensions != null ? !this.extensions.equals(that.extensions) : that.extensions != null) {
            return false;
        }
        if (this.conventions != null ? !this.conventions.equals(that.conventions) : that.conventions != null) {
            return false;
        }
        if (this.gradleProperties != null ? !this.gradleProperties.equals(that.gradleProperties) : that.gradleProperties != null) {
            return false;
        }
        if (this.tasks != null ? !this.tasks.equals(that.tasks) : that.tasks != null) {
            return false;
        }
        if (this.configurations != null ? !this.configurations.equals(that.configurations) : that.configurations != null) {
            return false;
        }
        return !(this.parentProjectPath != null ? !this.parentProjectPath.equals(that.parentProjectPath) : that.parentProjectPath != null);
    }

    public int hashCode() {
        int result = this.extensions != null ? this.extensions.hashCode() : 0;
        result = 31 * result + (this.conventions != null ? this.conventions.hashCode() : 0);
        result = 31 * result + (this.gradleProperties != null ? this.gradleProperties.hashCode() : 0);
        result = 31 * result + (this.tasks != null ? this.tasks.hashCode() : 0);
        result = 31 * result + (this.configurations != null ? this.configurations.hashCode() : 0);
        result = 31 * result + (this.parentProjectPath != null ? this.parentProjectPath.hashCode() : 0);
        return result;
    }
}

