/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model;

import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.tooling.BuildController;
import org.gradle.tooling.model.BuildModel;
import org.gradle.tooling.model.Model;
import org.gradle.tooling.model.gradle.GradleBuild;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.ProjectImportModelProvider;

public final class ClassSetImportModelProvider
implements ProjectImportModelProvider {
    @NotNull
    private final Set<Class<?>> projectModelClasses;
    @NotNull
    private final Set<Class<?>> buildModelClasses;

    public ClassSetImportModelProvider(@NotNull Set<Class<?>> projectModelClasses, @NotNull Set<Class<?>> buildModelClasses) {
        this.projectModelClasses = new LinkedHashSet(projectModelClasses);
        this.buildModelClasses = new LinkedHashSet(buildModelClasses);
    }

    public void populateBuildModels(@NotNull BuildController controller, @NotNull GradleBuild buildModel, @NotNull ProjectImportModelProvider.BuildModelConsumer consumer) {
        for (Class<?> aClass : this.buildModelClasses) {
            Object instance = controller.findModel((Model)buildModel, aClass);
            if (instance == null) continue;
            consumer.consume((BuildModel)buildModel, instance, aClass);
        }
    }

    public void populateProjectModels(@NotNull BuildController controller, @Nullable Model module, @NotNull ProjectImportModelProvider.ProjectModelConsumer modelConsumer) {
        for (Class<?> aClass : this.projectModelClasses) {
            Object instance = controller.findModel(module, aClass);
            if (instance == null) continue;
            modelConsumer.consume(instance, aClass);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassSetImportModelProvider provider = (ClassSetImportModelProvider)o;
        if (!this.projectModelClasses.equals(provider.projectModelClasses)) {
            return false;
        }
        return this.buildModelClasses.equals(provider.buildModelClasses);
    }

    public int hashCode() {
        int result = this.projectModelClasses.hashCode();
        result = 31 * result + this.buildModelClasses.hashCode();
        return result;
    }
}

