/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.DefaultExternalDependencyId;
import org.jetbrains.plugins.gradle.ExternalDependencyId;
import org.jetbrains.plugins.gradle.model.ExternalDependency;
import org.jetbrains.plugins.gradle.model.ModelFactory;
import org.jetbrains.plugins.gradle.tooling.util.BiFunction;
import org.jetbrains.plugins.gradle.tooling.util.BooleanBiFunction;
import org.jetbrains.plugins.gradle.tooling.util.GradleContainerUtil;

public abstract class AbstractExternalDependency
implements ExternalDependency {
    private static final long serialVersionUID = 1L;
    @NotNull
    private final DefaultExternalDependencyId myId;
    private String myScope;
    private final Collection<ExternalDependency> myDependencies;
    private String mySelectionReason;
    private int myClasspathOrder;
    private boolean myExported;

    public AbstractExternalDependency() {
        this((ExternalDependencyId)new DefaultExternalDependencyId(), null, null);
    }

    public AbstractExternalDependency(ExternalDependencyId id, String selectionReason, Collection<? extends ExternalDependency> dependencies) {
        this.myId = new DefaultExternalDependencyId(id);
        this.mySelectionReason = selectionReason;
        this.myDependencies = dependencies == null ? new ArrayList(0) : ModelFactory.createCopy(dependencies);
    }

    public AbstractExternalDependency(ExternalDependency dependency) {
        this(dependency.getId(), dependency.getSelectionReason(), dependency.getDependencies());
        this.myScope = dependency.getScope();
        this.myClasspathOrder = dependency.getClasspathOrder();
        this.myExported = dependency.getExported();
    }

    @NotNull
    public ExternalDependencyId getId() {
        return this.myId;
    }

    public String getName() {
        return this.myId.getName();
    }

    public void setName(String name) {
        this.myId.setName(name);
    }

    public String getGroup() {
        return this.myId.getGroup();
    }

    public void setGroup(String group) {
        this.myId.setGroup(group);
    }

    public String getVersion() {
        return this.myId.getVersion();
    }

    public void setVersion(String version) {
        this.myId.setVersion(version);
    }

    @NotNull
    public String getPackaging() {
        return this.myId.getPackaging();
    }

    public void setPackaging(@NotNull String packaging) {
        this.myId.setPackaging(packaging);
    }

    @Nullable
    public String getClassifier() {
        return this.myId.getClassifier();
    }

    public void setClassifier(@Nullable String classifier) {
        this.myId.setClassifier(classifier);
    }

    @Nullable
    public String getSelectionReason() {
        return this.mySelectionReason;
    }

    public int getClasspathOrder() {
        return this.myClasspathOrder;
    }

    public void setClasspathOrder(int order) {
        this.myClasspathOrder = order;
    }

    public void setSelectionReason(String selectionReason) {
        this.mySelectionReason = selectionReason;
    }

    public String getScope() {
        return this.myScope;
    }

    public void setScope(String scope) {
        this.myScope = scope;
    }

    @NotNull
    public Collection<ExternalDependency> getDependencies() {
        return this.myDependencies;
    }

    public boolean getExported() {
        return this.myExported;
    }

    public void setExported(boolean exported) {
        this.myExported = exported;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractExternalDependency)) {
            return false;
        }
        AbstractExternalDependency that = (AbstractExternalDependency)o;
        return Objects.equal((Object)this.myId, (Object)that.myId) && Objects.equal((Object)this.myScope, (Object)that.myScope) && this.myClasspathOrder == that.myClasspathOrder && AbstractExternalDependency.equal(this.myDependencies, that.myDependencies);
    }

    private static boolean equal(@NotNull Collection<ExternalDependency> dependencies1, @NotNull Collection<ExternalDependency> dependencies2) {
        final DependenciesIterator iterator1 = new DependenciesIterator(dependencies1);
        final DependenciesIterator iterator2 = new DependenciesIterator(dependencies2);
        return GradleContainerUtil.match((Iterator)iterator1, (Iterator)iterator2, (BooleanBiFunction)new BooleanBiFunction<AbstractExternalDependency, AbstractExternalDependency>(){

            public Boolean fun(AbstractExternalDependency o1, AbstractExternalDependency o2) {
                if (!Objects.equal((Object)iterator1.myProcessedStructure, (Object)iterator2.myProcessedStructure)) {
                    return false;
                }
                return Objects.equal((Object)o1.myId, (Object)o2.myId) && Objects.equal((Object)o1.myScope, (Object)o2.myScope);
            }
        });
    }

    public int hashCode() {
        return 31 + Objects.hashCode((Object[])new Object[]{this.myId, this.myScope, this.myClasspathOrder});
    }

    protected static int calcFilesPathsHashCode(@NotNull Iterable<File> iterable) {
        return (Integer)GradleContainerUtil.reduce(iterable, (Object)0, (BiFunction)new BiFunction<Integer, Integer, File>(){

            public Integer fun(Integer currentResult, File item) {
                return 31 * currentResult + (item == null ? 0 : item.getPath().hashCode());
            }
        });
    }

    private static final class DependenciesIterator
    implements Iterator<AbstractExternalDependency> {
        private final Set<AbstractExternalDependency> mySeenDependencies = Collections.newSetFromMap(new IdentityHashMap());
        private final LinkedList<ExternalDependency> myToProcess;
        private final LinkedList<Integer> myProcessedStructure;

        private DependenciesIterator(@NotNull Collection<ExternalDependency> dependencies) {
            this.myToProcess = new LinkedList<ExternalDependency>(dependencies);
            this.myProcessedStructure = new LinkedList();
        }

        @Override
        public boolean hasNext() {
            AbstractExternalDependency dependency = (AbstractExternalDependency)this.myToProcess.peekFirst();
            if (dependency == null) {
                return false;
            }
            if (this.mySeenDependencies.contains(dependency)) {
                this.myToProcess.removeFirst();
                return this.hasNext();
            }
            return !this.myToProcess.isEmpty();
        }

        @Override
        public AbstractExternalDependency next() {
            AbstractExternalDependency dependency = (AbstractExternalDependency)this.myToProcess.removeFirst();
            if (this.mySeenDependencies.add(dependency)) {
                this.myToProcess.addAll(dependency.myDependencies);
                this.myProcessedStructure.add(dependency.myDependencies.size());
                return dependency;
            }
            return this.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }
}

