/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.expressions.impl;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.utils.SmartList;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0010\u0018\u00002\u00020\u0001B?\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\b\u0010\f\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\rB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u000eR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001c\u0010\f\u001a\u0004\u0018\u00010\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0013R\u001a\u0010\u0007\u001a\u00020\bX\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0015\"\u0004\b\u001a\u0010\u0017R\u001a\u0010\u0005\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001e\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/ir/expressions/impl/IrTryImpl;", "Lorg/jetbrains/kotlin/ir/expressions/IrTry;", "startOffset", "", "endOffset", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "tryResult", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "catches", "", "Lorg/jetbrains/kotlin/ir/expressions/IrCatch;", "finallyExpression", "(IILorg/jetbrains/kotlin/ir/types/IrType;Lorg/jetbrains/kotlin/ir/expressions/IrExpression;Ljava/util/List;Lorg/jetbrains/kotlin/ir/expressions/IrExpression;)V", "(IILorg/jetbrains/kotlin/ir/types/IrType;)V", "", "getCatches", "()Ljava/util/List;", "getEndOffset", "()I", "getFinallyExpression", "()Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "setFinallyExpression", "(Lorg/jetbrains/kotlin/ir/expressions/IrExpression;)V", "getStartOffset", "getTryResult", "setTryResult", "getType", "()Lorg/jetbrains/kotlin/ir/types/IrType;", "setType", "(Lorg/jetbrains/kotlin/ir/types/IrType;)V", "ir.tree"})
public final class IrTryImpl
extends IrTry {
    private final int startOffset;
    private final int endOffset;
    @NotNull
    private IrType type;
    public IrExpression tryResult;
    @NotNull
    private final List<IrCatch> catches;
    @Nullable
    private IrExpression finallyExpression;

    public IrTryImpl(int startOffset, int endOffset, @NotNull IrType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.type = type2;
        this.catches = (List)new SmartList();
    }

    @Override
    public int getStartOffset() {
        return this.startOffset;
    }

    @Override
    public int getEndOffset() {
        return this.endOffset;
    }

    @Override
    @NotNull
    public IrType getType() {
        return this.type;
    }

    @Override
    public void setType(@NotNull IrType irType) {
        Intrinsics.checkNotNullParameter((Object)irType, (String)"<set-?>");
        this.type = irType;
    }

    public IrTryImpl(int startOffset, int endOffset, @NotNull IrType type2, @NotNull IrExpression tryResult, @NotNull List<? extends IrCatch> catches, @Nullable IrExpression finallyExpression) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)tryResult, (String)"tryResult");
        Intrinsics.checkNotNullParameter(catches, (String)"catches");
        this(startOffset, endOffset, type2);
        this.setTryResult(tryResult);
        this.getCatches().addAll((Collection<IrCatch>)catches);
        this.setFinallyExpression(finallyExpression);
    }

    @Override
    @NotNull
    public IrExpression getTryResult() {
        IrExpression irExpression = this.tryResult;
        if (irExpression != null) {
            return irExpression;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"tryResult");
        return null;
    }

    @Override
    public void setTryResult(@NotNull IrExpression irExpression) {
        Intrinsics.checkNotNullParameter((Object)irExpression, (String)"<set-?>");
        this.tryResult = irExpression;
    }

    @Override
    @NotNull
    public List<IrCatch> getCatches() {
        return this.catches;
    }

    @Override
    @Nullable
    public IrExpression getFinallyExpression() {
        return this.finallyExpression;
    }

    @Override
    public void setFinallyExpression(@Nullable IrExpression irExpression) {
        this.finallyExpression = irExpression;
    }
}

