/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower.loops;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KDeclarationContainer;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.loops.DefaultHeaderInfoBuilder;
import org.jetbrains.kotlin.backend.common.lower.loops.ForLoopBodyTransformer;
import org.jetbrains.kotlin.backend.common.lower.loops.ForLoopHeader;
import org.jetbrains.kotlin.backend.common.lower.loops.HeaderProcessor;
import org.jetbrains.kotlin.backend.common.lower.loops.LoopReplacement;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.Scope;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCompositeImpl;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u0000 02\u00020\u0001:\u0003012B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002J\u0006\u0010\u001d\u001a\u00020\u001eJ\u0018\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u001a\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020'2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/loops/RangeLoopTransformer;", "Lorg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrSymbolOwner;", "oldLoopToNewLoop", "", "Lorg/jetbrains/kotlin/ir/expressions/IrLoop;", "loopBodyTransformer", "Lorg/jetbrains/kotlin/backend/common/lower/loops/ForLoopBodyTransformer;", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;Lorg/jetbrains/kotlin/ir/declarations/IrSymbolOwner;Ljava/util/Map;Lorg/jetbrains/kotlin/backend/common/lower/loops/ForLoopBodyTransformer;)V", "getContainer", "()Lorg/jetbrains/kotlin/ir/declarations/IrSymbolOwner;", "getContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "headerInfoBuilder", "Lorg/jetbrains/kotlin/backend/common/lower/loops/DefaultHeaderInfoBuilder;", "headerProcessor", "Lorg/jetbrains/kotlin/backend/common/lower/loops/HeaderProcessor;", "getLoopBodyTransformer", "()Lorg/jetbrains/kotlin/backend/common/lower/loops/ForLoopBodyTransformer;", "getOldLoopToNewLoop", "()Ljava/util/Map;", "gatherLoopVariableInfo", "Lorg/jetbrains/kotlin/backend/common/lower/loops/RangeLoopTransformer$LoopVariableInfo;", "statements", "", "Lorg/jetbrains/kotlin/ir/IrStatement;", "getScopeOwnerSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "lowerHeader", "variable", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "loopHeader", "Lorg/jetbrains/kotlin/backend/common/lower/loops/ForLoopHeader;", "lowerWhileLoop", "Lorg/jetbrains/kotlin/backend/common/lower/loops/LoopReplacement;", "loop", "Lorg/jetbrains/kotlin/ir/expressions/IrWhileLoop;", "specializeIteratorIfPossible", "", "irForLoopBlock", "Lorg/jetbrains/kotlin/ir/expressions/IrContainerExpression;", "visitBlock", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrBlock;", "Companion", "FindInitializerCallVisitor", "LoopVariableInfo", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nForLoopsLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ForLoopsLowering.kt\norg/jetbrains/kotlin/backend/common/lower/loops/RangeLoopTransformer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,478:1\n1#2:479\n1747#3,3:480\n381#4,11:483\n*S KotlinDebug\n*F\n+ 1 ForLoopsLowering.kt\norg/jetbrains/kotlin/backend/common/lower/loops/RangeLoopTransformer\n*L\n185#1:480,3\n329#1:483,11\n*E\n"})
final class RangeLoopTransformer
extends IrElementTransformerVoidWithContext {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CommonBackendContext context;
    @NotNull
    private final IrSymbolOwner container;
    @NotNull
    private final Map<IrLoop, IrLoop> oldLoopToNewLoop;
    @Nullable
    private final ForLoopBodyTransformer loopBodyTransformer;
    @NotNull
    private final DefaultHeaderInfoBuilder headerInfoBuilder;
    @NotNull
    private final HeaderProcessor headerProcessor;
    @NotNull
    private static final FqName STDLIB_ITERATOR_FUNCTION_FQ_NAME = new FqName("kotlin.collections.CollectionsKt.iterator");

    public RangeLoopTransformer(@NotNull CommonBackendContext context, @NotNull IrSymbolOwner container, @NotNull Map<IrLoop, IrLoop> oldLoopToNewLoop, @Nullable ForLoopBodyTransformer loopBodyTransformer) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter(oldLoopToNewLoop, (String)"oldLoopToNewLoop");
        this.context = context;
        this.container = container;
        this.oldLoopToNewLoop = oldLoopToNewLoop;
        this.loopBodyTransformer = loopBodyTransformer;
        this.headerInfoBuilder = new DefaultHeaderInfoBuilder(this.context, (Function0<? extends IrSymbol>)((Function0)new Function0<IrSymbol>((Object)this){

            @NotNull
            public final IrSymbol invoke() {
                return ((RangeLoopTransformer)this.receiver).getScopeOwnerSymbol();
            }

            @NotNull
            public final String getSignature() {
                return "getScopeOwnerSymbol()Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;";
            }

            @NotNull
            public final String getName() {
                return "getScopeOwnerSymbol";
            }

            @NotNull
            public final KDeclarationContainer getOwner() {
                return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(RangeLoopTransformer.class);
            }
        }));
        this.headerProcessor = new HeaderProcessor(this.context, this.headerInfoBuilder, (Function0<? extends IrSymbol>)((Function0)new Function0<IrSymbol>((Object)this){

            @NotNull
            public final IrSymbol invoke() {
                return ((RangeLoopTransformer)this.receiver).getScopeOwnerSymbol();
            }

            @NotNull
            public final String getSignature() {
                return "getScopeOwnerSymbol()Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;";
            }

            @NotNull
            public final String getName() {
                return "getScopeOwnerSymbol";
            }

            @NotNull
            public final KDeclarationContainer getOwner() {
                return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(RangeLoopTransformer.class);
            }
        }));
    }

    public /* synthetic */ RangeLoopTransformer(CommonBackendContext commonBackendContext, IrSymbolOwner irSymbolOwner, Map map, ForLoopBodyTransformer forLoopBodyTransformer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            forLoopBodyTransformer = null;
        }
        this(commonBackendContext, irSymbolOwner, map, forLoopBodyTransformer);
    }

    @NotNull
    public final CommonBackendContext getContext() {
        return this.context;
    }

    @NotNull
    public final IrSymbolOwner getContainer() {
        return this.container;
    }

    @NotNull
    public final Map<IrLoop, IrLoop> getOldLoopToNewLoop() {
        return this.oldLoopToNewLoop;
    }

    @Nullable
    public final ForLoopBodyTransformer getLoopBodyTransformer() {
        return this.loopBodyTransformer;
    }

    @NotNull
    public final IrSymbol getScopeOwnerSymbol() {
        Object object = this.getCurrentScope();
        if (object == null || (object = ((ScopeWithIr)object).getScope()) == null || (object = ((Scope)object).getScopeOwnerSymbol()) == null) {
            object = this.container.getSymbol();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IrExpression visitBlock(@NotNull IrBlock expression) {
        boolean bl;
        ForLoopHeader loopHeader;
        IrWhileLoop oldLoop;
        IrVariable iteratorVariable;
        List<IrStatement> statements;
        block10: {
            boolean bl2;
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            if (!Intrinsics.areEqual((Object)expression.getOrigin(), (Object)IrStatementOrigin.FOR_LOOP.INSTANCE)) {
                return super.visitBlock(expression);
            }
            statements = expression.getStatements();
            boolean bl3 = bl2 = statements.size() == 2;
            if (_Assertions.ENABLED && !bl2) {
                boolean $i$a$-assert-RangeLoopTransformer$visitBlock$42 = false;
                String $i$a$-assert-RangeLoopTransformer$visitBlock$42 = "Expected 2 statements in for-loop block, was:\n" + DumpIrTreeKt.dump$default(expression, false, false, 3, null);
                throw new AssertionError((Object)$i$a$-assert-RangeLoopTransformer$visitBlock$42);
            }
            IrStatement irStatement = statements.get(0);
            Intrinsics.checkNotNull((Object)irStatement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrVariable");
            iteratorVariable = (IrVariable)irStatement;
            boolean $i$a$-assert-RangeLoopTransformer$visitBlock$42 = Intrinsics.areEqual((Object)iteratorVariable.getOrigin(), (Object)IrDeclarationOrigin.FOR_LOOP_ITERATOR.INSTANCE);
            if (_Assertions.ENABLED && !$i$a$-assert-RangeLoopTransformer$visitBlock$42) {
                boolean $i$a$-assert-RangeLoopTransformer$visitBlock$52 = false;
                String $i$a$-assert-RangeLoopTransformer$visitBlock$52 = "Expected FOR_LOOP_ITERATOR origin for iterator variable, was:\n" + DumpIrTreeKt.dump$default(iteratorVariable, false, false, 3, null);
                throw new AssertionError((Object)$i$a$-assert-RangeLoopTransformer$visitBlock$52);
            }
            IrStatement irStatement2 = statements.get(1);
            Intrinsics.checkNotNull((Object)irStatement2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrWhileLoop");
            oldLoop = (IrWhileLoop)irStatement2;
            boolean $i$a$-assert-RangeLoopTransformer$visitBlock$52 = Intrinsics.areEqual((Object)oldLoop.getOrigin(), (Object)IrStatementOrigin.FOR_LOOP_INNER_WHILE.INSTANCE);
            if (_Assertions.ENABLED && !$i$a$-assert-RangeLoopTransformer$visitBlock$52) {
                boolean $i$a$-assert-RangeLoopTransformer$visitBlock$62 = false;
                String $i$a$-assert-RangeLoopTransformer$visitBlock$62 = "Expected FOR_LOOP_INNER_WHILE origin for while loop, was:\n" + DumpIrTreeKt.dump$default(oldLoop, false, false, 3, null);
                throw new AssertionError((Object)$i$a$-assert-RangeLoopTransformer$visitBlock$62);
            }
            ForLoopHeader forLoopHeader = this.headerProcessor.extractHeader(iteratorVariable);
            if (forLoopHeader == null) {
                void $this$visitBlock_u24lambda_u243;
                IrBlock irBlock;
                IrBlock irBlock2 = irBlock = expression;
                RangeLoopTransformer rangeLoopTransformer = this;
                boolean bl4 = false;
                this.specializeIteratorIfPossible((IrContainerExpression)$this$visitBlock_u24lambda_u243);
                return super.visitBlock(irBlock);
            }
            loopHeader = forLoopHeader;
            Iterable $this$any$iv = loopHeader.getLoopInitStatements();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IrStatement it = (IrStatement)element$iv;
                    boolean bl5 = false;
                    IrAnnotationContainer irAnnotationContainer = it instanceof IrVariable ? (IrVariable)it : null;
                    boolean bl6 = irAnnotationContainer != null && (irAnnotationContainer = irAnnotationContainer.getType()) != null ? IrTypePredicatesKt.isNothing((IrType)irAnnotationContainer) : false;
                    if (!bl6) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
        }
        if (bl) {
            return super.visitBlock(expression);
        }
        IrStatement loweredHeader = this.lowerHeader(iteratorVariable, loopHeader);
        LoopReplacement loopReplacement = this.lowerWhileLoop(oldLoop, loopHeader);
        if (loopReplacement == null) {
            return super.visitBlock(expression);
        }
        LoopReplacement loopReplacement2 = loopReplacement;
        IrLoop newLoop = loopReplacement2.component1();
        IrExpression loopReplacementExpression = loopReplacement2.component2();
        this.oldLoopToNewLoop.put(oldLoop, newLoop);
        statements.set(0, loweredHeader);
        statements.set(1, loopReplacementExpression);
        return super.visitBlock(expression);
    }

    private final IrStatement lowerHeader(IrVariable variable2, ForLoopHeader loopHeader) {
        return new IrCompositeImpl(variable2.getStartOffset(), variable2.getEndOffset(), this.context.getIrBuiltIns().getUnitType(), null, loopHeader.getLoopInitStatements());
    }

    private final LoopReplacement lowerWhileLoop(IrWhileLoop loop2, ForLoopHeader loopHeader) {
        IrExpression newBody;
        IrExpression irExpression;
        IrExpression irExpression2 = loop2.getBody();
        Object object = irExpression2 instanceof IrContainerExpression ? (IrContainerExpression)irExpression2 : null;
        if (object == null || (object = ((IrContainerExpression)object).getStatements()) == null) {
            return null;
        }
        Object loopBodyStatements = object;
        LoopVariableInfo loopVariableInfo = this.gatherLoopVariableInfo((List<IrStatement>)loopBodyStatements);
        IrVariable mainLoopVariable = loopVariableInfo.component1();
        int mainLoopVariableIndex = loopVariableInfo.component2();
        Map<Integer, IrVariable> loopVariableComponents = loopVariableInfo.component3();
        List<Integer> loopVariableComponentIndices = loopVariableInfo.component4();
        if (loopHeader.getConsumesLoopVariableComponents() && !Intrinsics.areEqual((Object)mainLoopVariable.getOrigin(), (Object)IrDeclarationOrigin.IR_TEMPORARY_VARIABLE.INSTANCE)) {
            return null;
        }
        IrExpression irExpression3 = mainLoopVariable.getInitializer();
        Intrinsics.checkNotNull((Object)irExpression3);
        IrExpression initializer2 = irExpression3;
        DeclarationIrBuilder $this$lowerWhileLoop_u24lambda_u245 = LowerUtilsKt.createIrBuilder(this.context, this.getScopeOwnerSymbol(), initializer2.getStartOffset(), initializer2.getEndOffset());
        boolean bl = false;
        IrCompositeImpl replacement = new IrCompositeImpl(mainLoopVariable.getStartOffset(), mainLoopVariable.getEndOffset(), $this$lowerWhileLoop_u24lambda_u245.getContext().getIrBuiltIns().getUnitType(), IrStatementOrigin.FOR_LOOP_NEXT.INSTANCE, loopHeader.initializeIteration(mainLoopVariable, loopVariableComponents, $this$lowerWhileLoop_u24lambda_u245, this.context));
        if (loopHeader.getConsumesLoopVariableComponents()) {
            Iterator iterator = CollectionsKt.asReversed(loopVariableComponentIndices).iterator();
            while (iterator.hasNext()) {
                boolean bl2;
                int index = ((Number)iterator.next()).intValue();
                boolean bl3 = bl2 = index > mainLoopVariableIndex;
                if (_Assertions.ENABLED && !bl2) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                loopBodyStatements.remove(index);
            }
        }
        loopBodyStatements.set(mainLoopVariableIndex, replacement);
        IrExpression irExpression4 = loop2.getBody();
        if (irExpression4 != null) {
            IrExpression it = irExpression4;
            boolean bl4 = false;
            irExpression = it instanceof IrContainerExpression && !((IrContainerExpression)it).isTransparentScope() ? (IrExpression)new IrCompositeImpl(loop2.getStartOffset(), loop2.getEndOffset(), it.getType(), ((IrContainerExpression)it).getOrigin(), ((IrContainerExpression)it).getStatements()) : it;
        } else {
            irExpression = newBody = null;
        }
        if (newBody != null && this.loopBodyTransformer != null) {
            this.loopBodyTransformer.transform(this.context, newBody, mainLoopVariable, loopHeader, loopVariableComponents);
        }
        return loopHeader.buildLoop(LowerUtilsKt.createIrBuilder(this.context, this.getScopeOwnerSymbol(), loop2.getStartOffset(), loop2.getEndOffset()), loop2, newBody);
    }

    /*
     * WARNING - void declaration
     */
    private final void specializeIteratorIfPossible(IrContainerExpression irForLoopBlock) {
        void $this$specializeIteratorIfPossible_u24lambda_u2410;
        IrCallImpl irCallImpl;
        IrVariable irVariable;
        IrStatement irStatement;
        IrStatement single$iv;
        Object receiverType;
        IrCall initializer2;
        IrVariable iterator;
        List<IrStatement> statements;
        block13: {
            statements = irForLoopBlock.getStatements();
            IrStatement irStatement2 = statements.get(0);
            Intrinsics.checkNotNull((Object)irStatement2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrVariable");
            iterator = (IrVariable)irStatement2;
            IrExpression irExpression = iterator.getInitializer();
            IrCall irCall = irExpression instanceof IrCall ? (IrCall)irExpression : null;
            if (irCall == null) {
                return;
            }
            initializer2 = irCall;
            if (!AdditionalIrUtilsKt.hasEqualFqName(initializer2.getSymbol().getOwner(), STDLIB_ITERATOR_FUNCTION_FQ_NAME)) {
                return;
            }
            Object object = initializer2.getExtensionReceiver();
            if (object == null || (object = ((IrExpression)object).getType()) == null) {
                return;
            }
            receiverType = object;
            if (!IrTypeUtilsKt.isStrictSubtypeOfClass((IrType)receiverType, this.context.getIrBuiltIns().getIteratorClass())) {
                return;
            }
            IrClass irClass = IrTypesKt.getClass((IrType)receiverType);
            if (irClass == null) {
                return;
            }
            IrClass receiverClass = irClass;
            Sequence<IrSimpleFunction> $this$singleOrNull$iv = IrUtilsKt.getFunctions(receiverClass);
            boolean $i$f$singleOrNull = false;
            single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                IrSimpleFunction it = (IrSimpleFunction)element$iv;
                boolean bl = false;
                boolean bl2 = Intrinsics.areEqual((Object)it.getName(), (Object)OperatorNameConventions.NEXT) && it.getDispatchReceiverParameter() != null && it.getExtensionReceiverParameter() == null && it.getValueParameters().isEmpty();
                if (!bl2) continue;
                if (found$iv) {
                    irStatement = null;
                    break block13;
                }
                single$iv = (IrStatement)element$iv;
                found$iv = true;
            }
            irStatement = !found$iv ? null : single$iv;
        }
        IrSimpleFunction irSimpleFunction = (IrSimpleFunction)irStatement;
        if (irSimpleFunction == null) {
            return;
        }
        IrSimpleFunction next = irSimpleFunction;
        IrVariable $this$specializeIteratorIfPossible_u24lambda_u248 = irVariable = iterator;
        boolean bl = false;
        $this$specializeIteratorIfPossible_u24lambda_u248.setType((IrType)receiverType);
        $this$specializeIteratorIfPossible_u24lambda_u248.setInitializer(initializer2.getExtensionReceiver());
        IrStatement irStatement3 = statements.get(1);
        Intrinsics.checkNotNull((Object)irStatement3, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrWhileLoop");
        IrWhileLoop loop2 = (IrWhileLoop)irStatement3;
        Object object = loop2.getBody();
        Object object2 = object instanceof IrBlock ? (IrBlock)object : null;
        single$iv = object2 != null && (object2 = ((IrContainerExpression)object2).getStatements()) != null ? (IrStatement)CollectionsKt.firstOrNull((List)object2) : null;
        IrVariable irVariable2 = single$iv instanceof IrVariable ? (IrVariable)single$iv : null;
        if (irVariable2 == null) {
            return;
        }
        IrVariable loopVariable = irVariable2;
        IrExpression found$iv = loop2.getCondition();
        IrCall irCall = found$iv instanceof IrCall ? (IrCall)found$iv : null;
        if (irCall == null) {
            return;
        }
        IrCall loopCondition = irCall;
        IrExpression irExpression = loopCondition.getDispatchReceiver();
        if (irExpression != null) {
            irExpression.setType((IrType)receiverType);
        }
        object = loopVariable.getInitializer();
        IrCall irCall2 = object instanceof IrCall ? (IrCall)object : null;
        if (irCall2 == null) {
            return;
        }
        IrCall nextCall = irCall2;
        found$iv = nextCall;
        IrVariable irVariable3 = loopVariable;
        boolean bl3 = false;
        IrCallImpl $this$specializeIteratorIfPossible_u24lambda_u2410_u24lambda_u249 = irCallImpl = new IrCallImpl($this$specializeIteratorIfPossible_u24lambda_u2410.getStartOffset(), $this$specializeIteratorIfPossible_u24lambda_u2410.getEndOffset(), $this$specializeIteratorIfPossible_u24lambda_u2410.getType(), next.getSymbol(), $this$specializeIteratorIfPossible_u24lambda_u2410.getTypeArgumentsCount(), $this$specializeIteratorIfPossible_u24lambda_u2410.getValueArgumentsCount(), $this$specializeIteratorIfPossible_u24lambda_u2410.getOrigin(), $this$specializeIteratorIfPossible_u24lambda_u2410.getSuperQualifierSymbol());
        boolean bl4 = false;
        IrUtilsKt.copyTypeAndValueArgumentsFrom$default($this$specializeIteratorIfPossible_u24lambda_u2410_u24lambda_u249, nextCall, false, false, 6, null);
        IrExpression irExpression2 = $this$specializeIteratorIfPossible_u24lambda_u2410_u24lambda_u249.getDispatchReceiver();
        if (irExpression2 != null) {
            irExpression2.setType((IrType)receiverType);
        }
        irVariable3.setInitializer(irCallImpl);
    }

    private final LoopVariableInfo gatherLoopVariableInfo(List<IrStatement> statements) {
        boolean bl;
        IrStatement mainLoopVariable = null;
        int mainLoopVariableIndex = -1;
        Map loopVariableComponents = new LinkedHashMap();
        List loopVariableComponentIndices = new ArrayList();
        Iterator<IrStatement> iterator = statements.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            IrStatementOrigin origin;
            IrMemberAccessExpression initializer2;
            IrMemberAccessExpression irMemberAccessExpression;
            int i = n++;
            IrStatement stmt = iterator.next();
            if (!(stmt instanceof IrVariable)) continue;
            if (((IrVariable)stmt).getInitializer() != null) {
                IrExpression it;
                FindInitializerCallVisitor findInitializerCallVisitor;
                boolean bl2 = false;
                FindInitializerCallVisitor $this$gatherLoopVariableInfo_u24lambda_u2412_u24lambda_u2411 = findInitializerCallVisitor = new FindInitializerCallVisitor((IrVariable)mainLoopVariable);
                boolean bl3 = false;
                IrVisitorsKt.acceptVoid(it, $this$gatherLoopVariableInfo_u24lambda_u2412_u24lambda_u2411);
                irMemberAccessExpression = findInitializerCallVisitor.getInitializerCall();
            } else {
                irMemberAccessExpression = null;
            }
            IrMemberAccessExpression irMemberAccessExpression2 = initializer2 = irMemberAccessExpression;
            IrStatementOrigin irStatementOrigin = origin = irMemberAccessExpression2 != null ? irMemberAccessExpression2.getOrigin() : null;
            if (Intrinsics.areEqual((Object)origin, (Object)IrStatementOrigin.FOR_LOOP_NEXT.INSTANCE)) {
                mainLoopVariable = stmt;
                mainLoopVariableIndex = i;
                continue;
            }
            if (!(origin instanceof IrStatementOrigin.COMPONENT_N)) continue;
            loopVariableComponents.put(((IrStatementOrigin.COMPONENT_N)origin).getIndex(), stmt);
            loopVariableComponentIndices.add(i);
        }
        if (mainLoopVariable == null) {
            boolean bl4 = false;
            String string = "No 'next' statement in for-loop";
            throw new IllegalStateException(string.toString());
        }
        boolean bl5 = bl = mainLoopVariableIndex >= 0;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        return new LoopVariableInfo((IrVariable)mainLoopVariable, mainLoopVariableIndex, loopVariableComponents, loopVariableComponentIndices);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00030\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\u0015\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00030\u0007H\u00c6\u0003J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\tH\u00c6\u0003JC\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00030\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/loops/RangeLoopTransformer$LoopVariableInfo;", "", "mainLoopVariable", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "mainLoopVariableIndex", "", "loopVariableComponents", "", "loopVariableComponentIndices", "", "(Lorg/jetbrains/kotlin/ir/declarations/IrVariable;ILjava/util/Map;Ljava/util/List;)V", "getLoopVariableComponentIndices", "()Ljava/util/List;", "getLoopVariableComponents", "()Ljava/util/Map;", "getMainLoopVariable", "()Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "getMainLoopVariableIndex", "()I", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "ir.backend.common"})
    private static final class LoopVariableInfo {
        @NotNull
        private final IrVariable mainLoopVariable;
        private final int mainLoopVariableIndex;
        @NotNull
        private final Map<Integer, IrVariable> loopVariableComponents;
        @NotNull
        private final List<Integer> loopVariableComponentIndices;

        public LoopVariableInfo(@NotNull IrVariable mainLoopVariable, int mainLoopVariableIndex, @NotNull Map<Integer, ? extends IrVariable> loopVariableComponents, @NotNull List<Integer> loopVariableComponentIndices) {
            Intrinsics.checkNotNullParameter((Object)mainLoopVariable, (String)"mainLoopVariable");
            Intrinsics.checkNotNullParameter(loopVariableComponents, (String)"loopVariableComponents");
            Intrinsics.checkNotNullParameter(loopVariableComponentIndices, (String)"loopVariableComponentIndices");
            this.mainLoopVariable = mainLoopVariable;
            this.mainLoopVariableIndex = mainLoopVariableIndex;
            this.loopVariableComponents = loopVariableComponents;
            this.loopVariableComponentIndices = loopVariableComponentIndices;
        }

        @NotNull
        public final IrVariable getMainLoopVariable() {
            return this.mainLoopVariable;
        }

        public final int getMainLoopVariableIndex() {
            return this.mainLoopVariableIndex;
        }

        @NotNull
        public final Map<Integer, IrVariable> getLoopVariableComponents() {
            return this.loopVariableComponents;
        }

        @NotNull
        public final List<Integer> getLoopVariableComponentIndices() {
            return this.loopVariableComponentIndices;
        }

        @NotNull
        public final IrVariable component1() {
            return this.mainLoopVariable;
        }

        public final int component2() {
            return this.mainLoopVariableIndex;
        }

        @NotNull
        public final Map<Integer, IrVariable> component3() {
            return this.loopVariableComponents;
        }

        @NotNull
        public final List<Integer> component4() {
            return this.loopVariableComponentIndices;
        }

        @NotNull
        public final LoopVariableInfo copy(@NotNull IrVariable mainLoopVariable, int mainLoopVariableIndex, @NotNull Map<Integer, ? extends IrVariable> loopVariableComponents, @NotNull List<Integer> loopVariableComponentIndices) {
            Intrinsics.checkNotNullParameter((Object)mainLoopVariable, (String)"mainLoopVariable");
            Intrinsics.checkNotNullParameter(loopVariableComponents, (String)"loopVariableComponents");
            Intrinsics.checkNotNullParameter(loopVariableComponentIndices, (String)"loopVariableComponentIndices");
            return new LoopVariableInfo(mainLoopVariable, mainLoopVariableIndex, loopVariableComponents, loopVariableComponentIndices);
        }

        public static /* synthetic */ LoopVariableInfo copy$default(LoopVariableInfo loopVariableInfo, IrVariable irVariable, int n, Map map, List list, int n2, Object object) {
            if ((n2 & 1) != 0) {
                irVariable = loopVariableInfo.mainLoopVariable;
            }
            if ((n2 & 2) != 0) {
                n = loopVariableInfo.mainLoopVariableIndex;
            }
            if ((n2 & 4) != 0) {
                map = loopVariableInfo.loopVariableComponents;
            }
            if ((n2 & 8) != 0) {
                list = loopVariableInfo.loopVariableComponentIndices;
            }
            return loopVariableInfo.copy(irVariable, n, map, list);
        }

        @NotNull
        public String toString() {
            return "LoopVariableInfo(mainLoopVariable=" + this.mainLoopVariable + ", mainLoopVariableIndex=" + this.mainLoopVariableIndex + ", loopVariableComponents=" + this.loopVariableComponents + ", loopVariableComponentIndices=" + this.loopVariableComponentIndices + ')';
        }

        public int hashCode() {
            int result2 = this.mainLoopVariable.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.mainLoopVariableIndex);
            result2 = result2 * 31 + ((Object)this.loopVariableComponents).hashCode();
            result2 = result2 * 31 + ((Object)this.loopVariableComponentIndices).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LoopVariableInfo)) {
                return false;
            }
            LoopVariableInfo loopVariableInfo = (LoopVariableInfo)other;
            if (!Intrinsics.areEqual((Object)this.mainLoopVariable, (Object)loopVariableInfo.mainLoopVariable)) {
                return false;
            }
            if (this.mainLoopVariableIndex != loopVariableInfo.mainLoopVariableIndex) {
                return false;
            }
            if (!Intrinsics.areEqual(this.loopVariableComponents, loopVariableInfo.loopVariableComponents)) {
                return false;
            }
            return Intrinsics.areEqual(this.loopVariableComponentIndices, loopVariableInfo.loopVariableComponentIndices);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006H\u0016J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/loops/RangeLoopTransformer$FindInitializerCallVisitor;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementVisitorVoid;", "mainLoopVariable", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "(Lorg/jetbrains/kotlin/ir/declarations/IrVariable;)V", "initializerCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "getInitializerCall", "()Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "setInitializerCall", "(Lorg/jetbrains/kotlin/ir/expressions/IrCall;)V", "visitCall", "", "expression", "visitElement", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "ir.backend.common"})
    private static final class FindInitializerCallVisitor
    implements IrElementVisitorVoid {
        @Nullable
        private final IrVariable mainLoopVariable;
        @Nullable
        private IrCall initializerCall;

        public FindInitializerCallVisitor(@Nullable IrVariable mainLoopVariable) {
            this.mainLoopVariable = mainLoopVariable;
        }

        @Nullable
        public final IrCall getInitializerCall() {
            return this.initializerCall;
        }

        public final void setInitializerCall(@Nullable IrCall irCall) {
            this.initializerCall = irCall;
        }

        @Override
        public void visitElement(@NotNull IrElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            IrVisitorsKt.acceptChildrenVoid(element, this);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void visitCall(@NotNull IrCall expression) {
            block7: {
                block8: {
                    block6: {
                        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                        var3_2 = expression.getOrigin();
                        if (!Intrinsics.areEqual((Object)var3_2, (Object)IrStatementOrigin.FOR_LOOP_NEXT.INSTANCE)) break block6;
                        v0 = expression;
                        break block7;
                    }
                    if (!(var3_2 instanceof IrStatementOrigin.COMPONENT_N)) break block8;
                    if (this.mainLoopVariable == null) ** GOTO lbl-1000
                    var4_3 = expression.getDispatchReceiver();
                    v1 = var4_3 instanceof IrGetValue != false ? (IrGetValue)var4_3 : null;
                    if (Intrinsics.areEqual((Object)(v1 != null ? v1.getSymbol() : null), (Object)this.mainLoopVariable.getSymbol())) {
                        v0 = expression;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v0 = null;
                    }
                    break block7;
                }
                v0 = null;
            }
            candidateCall = v0;
            if (candidateCall == null) {
                IrElementVisitorVoid.DefaultImpls.visitCall(this, expression);
            } else if (this.initializerCall == null) {
                this.initializerCall = candidateCall;
            } else {
                v2 = new StringBuilder().append("Multiple initializer calls found. First: ");
                v3 = this.initializerCall;
                Intrinsics.checkNotNull((Object)v3);
                throw new IllegalStateException(v2.append(RenderIrElementKt.render(v3)).append("\nSecond: ").append(RenderIrElementKt.render(candidateCall)).toString());
            }
        }

        @Override
        public void visitElement(@NotNull IrElement element, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitElement(this, element, data);
        }

        @Override
        public void visitCall(@NotNull IrCall expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitCall(this, expression, data);
        }

        @Override
        public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration) {
            IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration);
        }

        @Override
        public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration, data);
        }

        @Override
        public void visitBlock(@NotNull IrBlock expression) {
            IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression);
        }

        @Override
        public void visitBlock(@NotNull IrBlock expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression, data);
        }

        @Override
        public void visitBlockBody(@NotNull IrBlockBody body2) {
            IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2);
        }

        @Override
        public void visitBlockBody(@NotNull IrBlockBody body2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2, data);
        }

        @Override
        public void visitBody(@NotNull IrBody body2) {
            IrElementVisitorVoid.DefaultImpls.visitBody(this, body2);
        }

        @Override
        public void visitBody(@NotNull IrBody body2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitBody(this, body2, data);
        }

        @Override
        public void visitBranch(@NotNull IrBranch branch) {
            IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch);
        }

        @Override
        public void visitBranch(@NotNull IrBranch branch, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch, data);
        }

        @Override
        public void visitBreak(@NotNull IrBreak jump) {
            IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump);
        }

        @Override
        public void visitBreak(@NotNull IrBreak jump, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump, data);
        }

        @Override
        public void visitBreakContinue(@NotNull IrBreakContinue jump) {
            IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump);
        }

        @Override
        public void visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump, data);
        }

        @Override
        public void visitCallableReference(@NotNull IrCallableReference<?> expression) {
            IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression);
        }

        @Override
        public void visitCallableReference(@NotNull IrCallableReference<?> expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression, data);
        }

        @Override
        public void visitCatch(@NotNull IrCatch aCatch) {
            IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch);
        }

        @Override
        public void visitCatch(@NotNull IrCatch aCatch, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch, data);
        }

        @Override
        public void visitClass(@NotNull IrClass declaration) {
            IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration);
        }

        @Override
        public void visitClass(@NotNull IrClass declaration, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration, data);
        }

        @Override
        public void visitClassReference(@NotNull IrClassReference expression) {
            IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression);
        }

        @Override
        public void visitClassReference(@NotNull IrClassReference expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression, data);
        }

        @Override
        public void visitComposite(@NotNull IrComposite expression) {
            IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression);
        }

        @Override
        public void visitComposite(@NotNull IrComposite expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression, data);
        }

        @Override
        public void visitConst(@NotNull IrConst<?> expression) {
            IrElementVisitorVoid.DefaultImpls.visitConst(this, expression);
        }

        @Override
        public void visitConst(@NotNull IrConst<?> expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitConst(this, expression, data);
        }

        @Override
        public void visitConstantArray(@NotNull IrConstantArray expression) {
            IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression);
        }

        @Override
        public void visitConstantArray(@NotNull IrConstantArray expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression, data);
        }

        @Override
        public void visitConstantObject(@NotNull IrConstantObject expression) {
            IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression);
        }

        @Override
        public void visitConstantObject(@NotNull IrConstantObject expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression, data);
        }

        @Override
        public void visitConstantPrimitive(@NotNull IrConstantPrimitive expression) {
            IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression);
        }

        @Override
        public void visitConstantPrimitive(@NotNull IrConstantPrimitive expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression, data);
        }

        @Override
        public void visitConstantValue(@NotNull IrConstantValue expression) {
            IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression);
        }

        @Override
        public void visitConstantValue(@NotNull IrConstantValue expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression, data);
        }

        @Override
        public void visitConstructor(@NotNull IrConstructor declaration) {
            IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration);
        }

        @Override
        public void visitConstructor(@NotNull IrConstructor declaration, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration, data);
        }

        @Override
        public void visitConstructorCall(@NotNull IrConstructorCall expression) {
            IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression);
        }

        @Override
        public void visitConstructorCall(@NotNull IrConstructorCall expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression, data);
        }

        @Override
        public void visitContainerExpression(@NotNull IrContainerExpression expression) {
            IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression);
        }

        @Override
        public void visitContainerExpression(@NotNull IrContainerExpression expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression, data);
        }

        @Override
        public void visitContinue(@NotNull IrContinue jump) {
            IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump);
        }

        @Override
        public void visitContinue(@NotNull IrContinue jump, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump, data);
        }

        @Override
        public void visitDeclaration(@NotNull IrDeclarationBase declaration) {
            IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration);
        }

        @Override
        public void visitDeclaration(@NotNull IrDeclarationBase declaration, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration, data);
        }

        @Override
        public void visitDeclarationReference(@NotNull IrDeclarationReference expression) {
            IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression);
        }

        @Override
        public void visitDeclarationReference(@NotNull IrDeclarationReference expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression, data);
        }

        @Override
        public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression) {
            IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression);
        }

        @Override
        public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression, data);
        }

        @Override
        public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2) {
            IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2);
        }

        @Override
        public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2, data);
        }

        @Override
        public void visitDynamicExpression(@NotNull IrDynamicExpression expression) {
            IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression);
        }

        @Override
        public void visitDynamicExpression(@NotNull IrDynamicExpression expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression, data);
        }

        @Override
        public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression) {
            IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression);
        }

        @Override
        public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression, data);
        }

        @Override
        public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression) {
            IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression);
        }

        @Override
        public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression, data);
        }

        @Override
        public void visitElseBranch(@NotNull IrElseBranch branch) {
            IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch);
        }

        @Override
        public void visitElseBranch(@NotNull IrElseBranch branch, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch, data);
        }

        @Override
        public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression) {
            IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression);
        }

        @Override
        public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression, data);
        }

        @Override
        public void visitEnumEntry(@NotNull IrEnumEntry declaration) {
            IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration);
        }

        @Override
        public void visitEnumEntry(@NotNull IrEnumEntry declaration, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration, data);
        }

        @Override
        public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression) {
            IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression);
        }

        @Override
        public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression, data);
        }

        @Override
        public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration) {
            IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration);
        }

        @Override
        public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration, data);
        }

        @Override
        public void visitErrorExpression(@NotNull IrErrorExpression expression) {
            IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression);
        }

        @Override
        public void visitErrorExpression(@NotNull IrErrorExpression expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression, data);
        }

        @Override
        public void visitExpression(@NotNull IrExpression expression) {
            IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression);
        }

        @Override
        public void visitExpression(@NotNull IrExpression expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression, data);
        }

        @Override
        public void visitExpressionBody(@NotNull IrExpressionBody body2) {
            IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2);
        }

        @Override
        public void visitExpressionBody(@NotNull IrExpressionBody body2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2, data);
        }

        @Override
        public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration) {
            IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration);
        }

        @Override
        public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration, data);
        }

        @Override
        public void visitField(@NotNull IrField declaration) {
            IrElementVisitorVoid.DefaultImpls.visitField(this, declaration);
        }

        @Override
        public void visitField(@NotNull IrField declaration, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitField(this, declaration, data);
        }

        @Override
        public void visitFieldAccess(@NotNull IrFieldAccessExpression expression) {
            IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression);
        }

        @Override
        public void visitFieldAccess(@NotNull IrFieldAccessExpression expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression, data);
        }

        @Override
        public void visitFile(@NotNull IrFile declaration) {
            IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration);
        }

        @Override
        public void visitFile(@NotNull IrFile declaration, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration, data);
        }

        @Override
        public void visitFunction(@NotNull IrFunction declaration) {
            IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration);
        }

        @Override
        public void visitFunction(@NotNull IrFunction declaration, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration, data);
        }

        @Override
        public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression) {
            IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression);
        }

        @Override
        public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression, data);
        }

        @Override
        public void visitFunctionExpression(@NotNull IrFunctionExpression expression) {
            IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression);
        }

        @Override
        public void visitFunctionExpression(@NotNull IrFunctionExpression expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression, data);
        }

        @Override
        public void visitFunctionReference(@NotNull IrFunctionReference expression) {
            IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression);
        }

        @Override
        public void visitFunctionReference(@NotNull IrFunctionReference expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression, data);
        }

        @Override
        public void visitGetClass(@NotNull IrGetClass expression) {
            IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression);
        }

        @Override
        public void visitGetClass(@NotNull IrGetClass expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression, data);
        }

        @Override
        public void visitGetEnumValue(@NotNull IrGetEnumValue expression) {
            IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression);
        }

        @Override
        public void visitGetEnumValue(@NotNull IrGetEnumValue expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression, data);
        }

        @Override
        public void visitGetField(@NotNull IrGetField expression) {
            IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression);
        }

        @Override
        public void visitGetField(@NotNull IrGetField expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression, data);
        }

        @Override
        public void visitGetObjectValue(@NotNull IrGetObjectValue expression) {
            IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression);
        }

        @Override
        public void visitGetObjectValue(@NotNull IrGetObjectValue expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression, data);
        }

        @Override
        public void visitGetValue(@NotNull IrGetValue expression) {
            IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression);
        }

        @Override
        public void visitGetValue(@NotNull IrGetValue expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression, data);
        }

        @Override
        public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression) {
            IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression);
        }

        @Override
        public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression, data);
        }

        @Override
        public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration) {
            IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration);
        }

        @Override
        public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration, data);
        }

        @Override
        public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression) {
            IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression);
        }

        @Override
        public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression, data);
        }

        @Override
        public void visitLoop(@NotNull IrLoop loop2) {
            IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2);
        }

        @Override
        public void visitLoop(@NotNull IrLoop loop2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2, data);
        }

        @Override
        public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression) {
            IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression);
        }

        @Override
        public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression, data);
        }

        @Override
        public void visitModuleFragment(@NotNull IrModuleFragment declaration) {
            IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration);
        }

        @Override
        public void visitModuleFragment(@NotNull IrModuleFragment declaration, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration, data);
        }

        @Override
        public void visitPackageFragment(@NotNull IrPackageFragment declaration) {
            IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration);
        }

        @Override
        public void visitPackageFragment(@NotNull IrPackageFragment declaration, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration, data);
        }

        @Override
        public void visitProperty(@NotNull IrProperty declaration) {
            IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration);
        }

        @Override
        public void visitProperty(@NotNull IrProperty declaration, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration, data);
        }

        @Override
        public void visitPropertyReference(@NotNull IrPropertyReference expression) {
            IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression);
        }

        @Override
        public void visitPropertyReference(@NotNull IrPropertyReference expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression, data);
        }

        @Override
        public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression) {
            IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression);
        }

        @Override
        public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression, data);
        }

        @Override
        public void visitReturn(@NotNull IrReturn expression) {
            IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression);
        }

        @Override
        public void visitReturn(@NotNull IrReturn expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression, data);
        }

        @Override
        public void visitScript(@NotNull IrScript declaration) {
            IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration);
        }

        @Override
        public void visitScript(@NotNull IrScript declaration, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration, data);
        }

        @Override
        public void visitSetField(@NotNull IrSetField expression) {
            IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression);
        }

        @Override
        public void visitSetField(@NotNull IrSetField expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression, data);
        }

        @Override
        public void visitSetValue(@NotNull IrSetValue expression) {
            IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression);
        }

        @Override
        public void visitSetValue(@NotNull IrSetValue expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression, data);
        }

        @Override
        public void visitSimpleFunction(@NotNull IrSimpleFunction declaration) {
            IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration);
        }

        @Override
        public void visitSimpleFunction(@NotNull IrSimpleFunction declaration, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration, data);
        }

        @Override
        public void visitSingletonReference(@NotNull IrGetSingletonValue expression) {
            IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression);
        }

        @Override
        public void visitSingletonReference(@NotNull IrGetSingletonValue expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression, data);
        }

        @Override
        public void visitSpreadElement(@NotNull IrSpreadElement spread) {
            IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread);
        }

        @Override
        public void visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread, data);
        }

        @Override
        public void visitStringConcatenation(@NotNull IrStringConcatenation expression) {
            IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression);
        }

        @Override
        public void visitStringConcatenation(@NotNull IrStringConcatenation expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression, data);
        }

        @Override
        public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression) {
            IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression);
        }

        @Override
        public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression, data);
        }

        @Override
        public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression) {
            IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression);
        }

        @Override
        public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression, data);
        }

        @Override
        public void visitSyntheticBody(@NotNull IrSyntheticBody body2) {
            IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2);
        }

        @Override
        public void visitSyntheticBody(@NotNull IrSyntheticBody body2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2, data);
        }

        @Override
        public void visitThrow(@NotNull IrThrow expression) {
            IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression);
        }

        @Override
        public void visitThrow(@NotNull IrThrow expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression, data);
        }

        @Override
        public void visitTry(@NotNull IrTry aTry) {
            IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry);
        }

        @Override
        public void visitTry(@NotNull IrTry aTry, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry, data);
        }

        @Override
        public void visitTypeAlias(@NotNull IrTypeAlias declaration) {
            IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration);
        }

        @Override
        public void visitTypeAlias(@NotNull IrTypeAlias declaration, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration, data);
        }

        @Override
        public void visitTypeOperator(@NotNull IrTypeOperatorCall expression) {
            IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression);
        }

        @Override
        public void visitTypeOperator(@NotNull IrTypeOperatorCall expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression, data);
        }

        @Override
        public void visitTypeParameter(@NotNull IrTypeParameter declaration) {
            IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration);
        }

        @Override
        public void visitTypeParameter(@NotNull IrTypeParameter declaration, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration, data);
        }

        @Override
        public void visitValueAccess(@NotNull IrValueAccessExpression expression) {
            IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression);
        }

        @Override
        public void visitValueAccess(@NotNull IrValueAccessExpression expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression, data);
        }

        @Override
        public void visitValueParameter(@NotNull IrValueParameter declaration) {
            IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration);
        }

        @Override
        public void visitValueParameter(@NotNull IrValueParameter declaration, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration, data);
        }

        @Override
        public void visitVararg(@NotNull IrVararg expression) {
            IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression);
        }

        @Override
        public void visitVararg(@NotNull IrVararg expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression, data);
        }

        @Override
        public void visitVariable(@NotNull IrVariable declaration) {
            IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration);
        }

        @Override
        public void visitVariable(@NotNull IrVariable declaration, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration, data);
        }

        @Override
        public void visitWhen(@NotNull IrWhen expression) {
            IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression);
        }

        @Override
        public void visitWhen(@NotNull IrWhen expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression, data);
        }

        @Override
        public void visitWhileLoop(@NotNull IrWhileLoop loop2) {
            IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2);
        }

        @Override
        public void visitWhileLoop(@NotNull IrWhileLoop loop2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2, data);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/loops/RangeLoopTransformer$Companion;", "", "()V", "STDLIB_ITERATOR_FUNCTION_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "getSTDLIB_ITERATOR_FUNCTION_FQ_NAME", "()Lorg/jetbrains/kotlin/name/FqName;", "ir.backend.common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FqName getSTDLIB_ITERATOR_FUNCTION_FQ_NAME() {
            return STDLIB_ITERATOR_FUNCTION_FQ_NAME;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

