/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00132\u00020\u00012\u00020\u0002:\u0001\u0013B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u000fH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/StringTrimLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "maybeComputeTrimIndent", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "maybeComputeTrimMargin", "visitCall", "expression", "Companion", "ir.backend.common"})
public final class StringTrimLowering
extends IrElementTransformerVoid
implements FileLoweringPass {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CommonBackendContext context;
    @NotNull
    private static final FqName TRIM_MARGIN_FQ_NAME = new FqName("kotlin.text.trimMargin");
    @NotNull
    private static final FqName TRIM_INDENT_FQ_NAME = new FqName("kotlin.text.trimIndent");

    public StringTrimLowering(@NotNull CommonBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @NotNull
    public final CommonBackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, this);
    }

    @Override
    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        return StringTrimLowering.Companion.matchTrimIndent(expression) ? this.maybeComputeTrimIndent(expression) : (StringTrimLowering.Companion.matchTrimMargin(expression) ? this.maybeComputeTrimMargin(expression) : super.visitCall(expression));
    }

    private final IrExpression maybeComputeTrimIndent(IrCall call) {
        IrExpression irExpression = call.getExtensionReceiver();
        Intrinsics.checkNotNull((Object)irExpression);
        String string = StringTrimLowering.Companion.getConstantString(irExpression);
        if (string == null) {
            return call;
        }
        String receiverString = string;
        String newString = StringsKt.trimIndent((String)receiverString);
        return IrConstImpl.Companion.string(call.getStartOffset(), call.getEndOffset(), call.getType(), newString);
    }

    private final IrExpression maybeComputeTrimMargin(IrCall call) {
        String string;
        IrExpression irExpression = call.getExtensionReceiver();
        Intrinsics.checkNotNull((Object)irExpression);
        String string2 = StringTrimLowering.Companion.getConstantString(irExpression);
        if (string2 == null) {
            return call;
        }
        String receiverString = string2;
        IrExpression prefixArgument = call.getValueArgument(0);
        if (prefixArgument != null) {
            String string3;
            String string4 = StringTrimLowering.Companion.getConstantString(prefixArgument);
            if (string4 == null) {
                return call;
            }
            String prefixString = string4;
            try {
                string3 = StringsKt.trimMargin((String)receiverString, (String)prefixString);
            }
            catch (IllegalArgumentException e) {
                return call;
            }
            string = string3;
        } else {
            string = StringsKt.trimMargin$default((String)receiverString, null, (int)1, null);
        }
        String newString = string;
        return IrConstImpl.Companion.string(call.getStartOffset(), call.getEndOffset(), call.getType(), newString);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u000e\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/StringTrimLowering$Companion;", "", "()V", "TRIM_INDENT_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "TRIM_MARGIN_FQ_NAME", "matchTrimIndent", "", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "matchTrimMargin", "getConstantString", "", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "ir.backend.common"})
    public static final class Companion {
        private Companion() {
        }

        private final String getConstantString(IrExpression $this$getConstantString) {
            if ($this$getConstantString instanceof IrConst && Intrinsics.areEqual(((IrConst)$this$getConstantString).getKind(), (Object)IrConstKind.String.INSTANCE)) {
                return (String)IrConstKind.String.INSTANCE.valueOf((IrConst)$this$getConstantString);
            }
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean matchTrimIndent(IrCall expression) {
            IrSimpleFunction callee = (IrSimpleFunction)expression.getSymbol().getOwner();
            if (!callee.getValueParameters().isEmpty()) return false;
            IrValueParameter irValueParameter = callee.getExtensionReceiverParameter();
            IrAnnotationContainer irAnnotationContainer = irValueParameter;
            if (irValueParameter == null) return false;
            IrType irType = irAnnotationContainer.getType();
            irAnnotationContainer = irType;
            if (irType == null) return false;
            if (!IrTypePredicatesKt.isString((IrType)irAnnotationContainer)) return false;
            boolean bl = true;
            if (!bl) return false;
            if (!Intrinsics.areEqual((Object)AdditionalIrUtilsKt.getKotlinFqName(callee), (Object)TRIM_INDENT_FQ_NAME)) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean matchTrimMargin(IrCall expression) {
            IrSimpleFunction callee = (IrSimpleFunction)expression.getSymbol().getOwner();
            IrValueParameter irValueParameter = (IrValueParameter)CollectionsKt.singleOrNull(callee.getValueParameters());
            IrAnnotationContainer irAnnotationContainer = irValueParameter;
            if (irValueParameter == null) return false;
            IrType irType = irAnnotationContainer.getType();
            irAnnotationContainer = irType;
            if (irType == null) return false;
            if (!IrTypePredicatesKt.isString((IrType)irAnnotationContainer)) return false;
            boolean bl = true;
            if (!bl) return false;
            IrValueParameter irValueParameter2 = callee.getExtensionReceiverParameter();
            IrAnnotationContainer irAnnotationContainer2 = irValueParameter2;
            if (irValueParameter2 == null) return false;
            IrType irType2 = irAnnotationContainer2.getType();
            irAnnotationContainer2 = irType2;
            if (irType2 == null) return false;
            if (!IrTypePredicatesKt.isString((IrType)irAnnotationContainer2)) return false;
            boolean bl2 = true;
            if (!bl2) return false;
            if (!Intrinsics.areEqual((Object)AdditionalIrUtilsKt.getKotlinFqName(callee), (Object)TRIM_MARGIN_FQ_NAME)) return false;
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

