/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.BackendContext;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.LowerKt;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.lower.LocalDeclarationsLoweringKt;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrStatementContainer;
import org.jetbrains.kotlin.ir.expressions.impl.IrCompositeImpl;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001\u001aB.\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u001f\b\u0002\u0010\u0004\u001a\u0019\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\b\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001a\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00062\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR(\u0010\u0004\u001a\u0019\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\b\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/LocalClassPopupLowering;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/common/BackendContext;", "recordExtractedLocalClasses", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "", "Lkotlin/ExtensionFunctionType;", "(Lorg/jetbrains/kotlin/backend/common/BackendContext;Lkotlin/jvm/functions/Function2;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/BackendContext;", "getRecordExtractedLocalClasses", "()Lkotlin/jvm/functions/Function2;", "lower", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "shouldPopUp", "", "klass", "currentScope", "Lorg/jetbrains/kotlin/backend/common/ScopeWithIr;", "ExtractedLocalClass", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nLocalClassPopupLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalClassPopupLowering.kt\norg/jetbrains/kotlin/backend/common/lower/LocalClassPopupLowering\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,87:1\n1#2:88\n*E\n"})
public class LocalClassPopupLowering
implements BodyLoweringPass {
    @NotNull
    private final BackendContext context;
    @NotNull
    private final Function2<BackendContext, IrClass, Unit> recordExtractedLocalClasses;

    public LocalClassPopupLowering(@NotNull BackendContext context, @NotNull Function2<? super BackendContext, ? super IrClass, Unit> recordExtractedLocalClasses) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(recordExtractedLocalClasses, (String)"recordExtractedLocalClasses");
        this.context = context;
        this.recordExtractedLocalClasses = recordExtractedLocalClasses;
    }

    public /* synthetic */ LocalClassPopupLowering(BackendContext backendContext, Function2 function2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function2 = 1.INSTANCE;
        }
        this(backendContext, (Function2<? super BackendContext, ? super IrClass, Unit>)function2);
    }

    @NotNull
    public final BackendContext getContext() {
        return this.context;
    }

    @NotNull
    public final Function2<BackendContext, IrClass, Unit> getRecordExtractedLocalClasses() {
        return this.recordExtractedLocalClasses;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        LowerKt.runOnFilePostfix(this, irFile, true);
    }

    @Override
    public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container) {
        Intrinsics.checkNotNullParameter((Object)irBody, (String)"irBody");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        ArrayList<ExtractedLocalClass> extractedLocalClasses = new ArrayList<ExtractedLocalClass>();
        irBody.transform((IrElementTransformer)new IrElementTransformerVoidWithContext(container, this, extractedLocalClasses){
            final /* synthetic */ IrDeclaration $container;
            final /* synthetic */ LocalClassPopupLowering this$0;
            final /* synthetic */ ArrayList<ExtractedLocalClass> $extractedLocalClasses;
            {
                this.$container = $container;
                this.this$0 = $receiver;
                this.$extractedLocalClasses = $extractedLocalClasses;
            }

            @NotNull
            public IrStatement visitClassNew(@NotNull IrClass declaration) {
                ScopeWithIr currentScope;
                ScopeWithIr scopeWithIr;
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                if (this.getAllScopes().size() > 1) {
                    scopeWithIr = this.getAllScopes().get(CollectionsKt.getLastIndex(this.getAllScopes()) - 1);
                } else {
                    IrDeclaration irDeclaration = this.$container;
                    Intrinsics.checkNotNull((Object)irDeclaration, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrSymbolOwner");
                    scopeWithIr = currentScope = this.createScope(irDeclaration);
                }
                if (!this.this$0.shouldPopUp(declaration, currentScope)) {
                    return declaration;
                }
                IrStatement extractedUnder = declaration;
                IrDeclarationParent newContainer = null;
                newContainer = declaration.getParent();
                while (newContainer instanceof IrDeclaration && !(newContainer instanceof IrClass) && !(newContainer instanceof IrScript)) {
                    extractedUnder = (IrStatement)((Object)newContainer);
                    newContainer = ((IrDeclaration)((Object)newContainer)).getParent();
                }
                IrDeclarationParent irDeclarationParent = newContainer;
                if (irDeclarationParent instanceof IrStatementContainer) {
                    if (Intrinsics.areEqual((Object)extractedUnder, (Object)declaration)) {
                        IrStatement irStatement;
                        Integer n;
                        Integer n2 = ((IrStatementContainer)((Object)newContainer)).getStatements().indexOf(extractedUnder) + 1;
                        int it = ((Number)n2).intValue();
                        boolean bl = false;
                        Integer n3 = n = it > 0 && it < ((IrStatementContainer)((Object)newContainer)).getStatements().size() ? n2 : null;
                        if (n != null) {
                            it = ((Number)n).intValue();
                            boolean bl2 = false;
                            irStatement = ((IrStatementContainer)((Object)newContainer)).getStatements().get(it);
                        } else {
                            irStatement = null;
                        }
                        extractedUnder = irStatement;
                    }
                    this.$extractedLocalClasses.add(new ExtractedLocalClass(declaration, newContainer, extractedUnder));
                } else if (irDeclarationParent instanceof IrDeclarationContainer) {
                    this.$extractedLocalClasses.add(new ExtractedLocalClass(declaration, newContainer, extractedUnder));
                } else {
                    throw new IllegalStateException(("Inexpected container type " + newContainer).toString());
                }
                return new IrCompositeImpl(declaration.getStartOffset(), declaration.getEndOffset(), this.this$0.getContext().getIrBuiltIns().getUnitType(), null, 8, null);
            }
        }, (Object)null);
        for (ExtractedLocalClass extractedLocalClass : extractedLocalClasses) {
            IrClass local = extractedLocalClass.component1();
            IrDeclarationParent newContainer = extractedLocalClass.component2();
            IrStatement extractedUnder = extractedLocalClass.component3();
            IrDeclarationParent irDeclarationParent = newContainer;
            if (irDeclarationParent instanceof IrStatementContainer) {
                int insertIndex;
                int n;
                if (extractedUnder != null) {
                    IrStatement it;
                    boolean bl = false;
                    n = ((IrStatementContainer)((Object)newContainer)).getStatements().indexOf(it);
                } else {
                    n = insertIndex = -1;
                }
                if (insertIndex >= 0) {
                    ((IrStatementContainer)((Object)newContainer)).getStatements().add(insertIndex, local);
                } else {
                    ((IrStatementContainer)((Object)newContainer)).getStatements().add(local);
                }
                IrUtilsKt.setDeclarationsParent((IrElement)local, newContainer);
            } else if (irDeclarationParent instanceof IrDeclarationContainer) {
                IrUtilsKt.addChild((IrDeclarationContainer)newContainer, local);
            } else {
                throw new IllegalStateException(("Inexpected container type " + newContainer).toString());
            }
            this.recordExtractedLocalClasses.invoke((Object)this.context, (Object)local);
        }
    }

    protected boolean shouldPopUp(@NotNull IrClass klass, @Nullable ScopeWithIr currentScope) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        return LocalDeclarationsLoweringKt.isLocalNotInner(klass);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J)\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/LocalClassPopupLowering$ExtractedLocalClass;", "", "local", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "newContainer", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "extractedUnder", "Lorg/jetbrains/kotlin/ir/IrStatement;", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;Lorg/jetbrains/kotlin/ir/IrStatement;)V", "getExtractedUnder", "()Lorg/jetbrains/kotlin/ir/IrStatement;", "getLocal", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getNewContainer", "()Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "ir.backend.common"})
    private static final class ExtractedLocalClass {
        @NotNull
        private final IrClass local;
        @NotNull
        private final IrDeclarationParent newContainer;
        @Nullable
        private final IrStatement extractedUnder;

        public ExtractedLocalClass(@NotNull IrClass local, @NotNull IrDeclarationParent newContainer, @Nullable IrStatement extractedUnder) {
            Intrinsics.checkNotNullParameter((Object)local, (String)"local");
            Intrinsics.checkNotNullParameter((Object)newContainer, (String)"newContainer");
            this.local = local;
            this.newContainer = newContainer;
            this.extractedUnder = extractedUnder;
        }

        @NotNull
        public final IrClass getLocal() {
            return this.local;
        }

        @NotNull
        public final IrDeclarationParent getNewContainer() {
            return this.newContainer;
        }

        @Nullable
        public final IrStatement getExtractedUnder() {
            return this.extractedUnder;
        }

        @NotNull
        public final IrClass component1() {
            return this.local;
        }

        @NotNull
        public final IrDeclarationParent component2() {
            return this.newContainer;
        }

        @Nullable
        public final IrStatement component3() {
            return this.extractedUnder;
        }

        @NotNull
        public final ExtractedLocalClass copy(@NotNull IrClass local, @NotNull IrDeclarationParent newContainer, @Nullable IrStatement extractedUnder) {
            Intrinsics.checkNotNullParameter((Object)local, (String)"local");
            Intrinsics.checkNotNullParameter((Object)newContainer, (String)"newContainer");
            return new ExtractedLocalClass(local, newContainer, extractedUnder);
        }

        public static /* synthetic */ ExtractedLocalClass copy$default(ExtractedLocalClass extractedLocalClass, IrClass irClass, IrDeclarationParent irDeclarationParent, IrStatement irStatement, int n, Object object) {
            if ((n & 1) != 0) {
                irClass = extractedLocalClass.local;
            }
            if ((n & 2) != 0) {
                irDeclarationParent = extractedLocalClass.newContainer;
            }
            if ((n & 4) != 0) {
                irStatement = extractedLocalClass.extractedUnder;
            }
            return extractedLocalClass.copy(irClass, irDeclarationParent, irStatement);
        }

        @NotNull
        public String toString() {
            return "ExtractedLocalClass(local=" + this.local + ", newContainer=" + this.newContainer + ", extractedUnder=" + this.extractedUnder + ')';
        }

        public int hashCode() {
            int result2 = this.local.hashCode();
            result2 = result2 * 31 + this.newContainer.hashCode();
            result2 = result2 * 31 + (this.extractedUnder == null ? 0 : this.extractedUnder.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ExtractedLocalClass)) {
                return false;
            }
            ExtractedLocalClass extractedLocalClass = (ExtractedLocalClass)other;
            if (!Intrinsics.areEqual((Object)this.local, (Object)extractedLocalClass.local)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.newContainer, (Object)extractedLocalClass.newContainer)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.extractedUnder, (Object)extractedLocalClass.extractedUnder);
        }
    }
}

