/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.shellcheck;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessAdapter;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sh.parser.ShShebangParserUtil;
import com.intellij.sh.psi.ShFile;
import com.intellij.sh.settings.ShSettings;
import com.intellij.sh.shellcheck.ShQuickFixIntention;
import com.intellij.sh.shellcheck.ShShellcheckInspection;
import com.intellij.sh.shellcheck.ShShellcheckUtil;
import com.intellij.sh.shellcheck.intention.ShDisableInspectionIntention;
import com.intellij.sh.shellcheck.intention.ShSuppressInspectionIntention;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShShellcheckExternalAnnotator
extends ExternalAnnotator<CollectedInfo, ShellcheckResponse> {
    private static final Logger LOG = Logger.getInstance(ShShellcheckExternalAnnotator.class);
    private static final List<@NlsSafe String> KNOWN_SHELLS = Arrays.asList("bash", "dash", "ksh", "sh");
    @NlsSafe
    private static final String DEFAULT_SHELL = "bash";
    private static final int TIMEOUT_IN_MILLISECONDS = 10000;

    public String getPairedBatchInspectionShortName() {
        return "ShellCheck";
    }

    @Nullable
    public CollectedInfo collectInformation(@NotNull PsiFile file) {
        if (!(file instanceof ShFile)) {
            return null;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile parent = virtualFile.getParent();
        if (parent == null) {
            return null;
        }
        return new CollectedInfo(file.getProject(), parent.getPath(), file.getText(), file.getModificationStamp(), ShShellcheckExternalAnnotator.getShellcheckExecutionParams(file));
    }

    @Nullable
    public ShellcheckResponse doAnnotate(@NotNull CollectedInfo fileInfo) {
        Application application = ApplicationManager.getApplication();
        if (application != null && application.isReadAccessAllowed() && !application.isUnitTestMode()) {
            return null;
        }
        String shellcheckExecutable = ShSettings.getShellcheckPath();
        if (!ShShellcheckUtil.isExecutionValidPath(shellcheckExecutable)) {
            return null;
        }
        ShShellcheckUtil.checkShellCheckForUpdate(fileInfo.project);
        try {
            GeneralCommandLine commandLine = new GeneralCommandLine().withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE).withExePath(shellcheckExecutable).withParameters(fileInfo.executionParams);
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                commandLine.withWorkDirectory(fileInfo.workDirectory);
            }
            final long timestamp = fileInfo.modificationStamp;
            OSProcessHandler handler = new OSProcessHandler(commandLine);
            final Ref response = Ref.create();
            handler.addProcessListener((ProcessListener)new CapturingProcessAdapter(){

                public void processTerminated(@NotNull ProcessEvent event) {
                    Type type = TypeToken.getParameterized(List.class, (Type[])new Type[]{Result.class}).getType();
                    Collection results = (Collection)new Gson().fromJson(this.getOutput().getStdout(), type);
                    if (results != null) {
                        response.set((Object)new ShellcheckResponse(results, timestamp));
                    }
                }
            });
            handler.startNotify();
            ShShellcheckExternalAnnotator.writeFileContentToStdin(handler.getProcess(), fileInfo.fileContent, commandLine.getCharset());
            if (!handler.waitFor(10000L)) {
                LOG.debug("Execution timeout, process will be forcibly terminated");
                handler.destroyProcess();
            }
            return (ShellcheckResponse)response.get();
        }
        catch (ExecutionException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    public void apply(@NotNull PsiFile file, ShellcheckResponse shellcheckResponse, @NotNull AnnotationHolder holder) {
        super.apply(file, (Object)shellcheckResponse, holder);
        Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
        if (document == null) {
            return;
        }
        Collection outerElements = PsiTreeUtil.findChildrenOfType((PsiElement)file, OuterLanguageElement.class);
        List rangesOfOuterElements = ContainerUtil.map((Collection)outerElements, el -> el.getTextRange());
        for (Result result : shellcheckResponse.results) {
            CharSequence sequence = document.getCharsSequence();
            int startOffset = ShShellcheckUtil.calcOffset(sequence, document.getLineStartOffset(result.line - 1), result.column);
            int endOffset = ShShellcheckUtil.calcOffset(sequence, document.getLineStartOffset(result.endLine - 1), result.endColumn);
            TextRange range = TextRange.create((int)startOffset, (int)(endOffset == startOffset ? endOffset + 1 : endOffset));
            if (!file.getTextRange().contains(range) || ContainerUtil.exists((Iterable)rangesOfOuterElements, it -> it.contains(range))) continue;
            long code = result.code;
            String message = result.message;
            @NonNls String scCode = "SC" + code;
            @NonNls String html = "<html><p>" + StringUtil.escapeXmlEntities((String)message) + "</p><p>See <a href='https://github.com/koalaman/shellcheck/wiki/SC" + code + "'>" + scCode + "</a>.</p></html>";
            AnnotationBuilder builder = holder.newAnnotation(ShShellcheckExternalAnnotator.severity(result.level), message).range(range).tooltip(html);
            String formattedMessage = ShShellcheckExternalAnnotator.format(message);
            Fix fix = result.fix;
            if (fix != null && !ArrayUtil.isEmpty((Object[])fix.replacements)) {
                builder = builder.withFix((IntentionAction)new ShQuickFixIntention(formattedMessage, fix, shellcheckResponse.timestamp));
            }
            String quotedMessage = ShShellcheckExternalAnnotator.quote(formattedMessage);
            builder.withFix((IntentionAction)new ShSuppressInspectionIntention(quotedMessage, scCode, startOffset)).withFix((IntentionAction)new ShDisableInspectionIntention(quotedMessage, scCode)).create();
        }
    }

    @NotNull
    private static HighlightSeverity severity(@Nullable String level) {
        if ("error".equals(level)) {
            return HighlightSeverity.ERROR;
        }
        if ("warning".equals(level)) {
            return HighlightSeverity.WARNING;
        }
        return HighlightSeverity.WEAK_WARNING;
    }

    private static @NotNull List<@NlsSafe String> getShellcheckExecutionParams(@NotNull PsiFile file) {
        String interpreter = ShShellcheckExternalAnnotator.getInterpreter(file);
        SmartList params = new SmartList();
        ShShellcheckInspection inspection = ShShellcheckInspection.findShShellcheckInspection((PsiElement)file);
        Collections.addAll(params, new String[]{"--color=never", "--format=json", "--severity=style", "--shell=" + interpreter, "--wiki-link-count=10", "--exclude=SC1091", "-"});
        inspection.getDisabledInspections().forEach(arg_0 -> ShShellcheckExternalAnnotator.lambda$getShellcheckExecutionParams$2((List)params, arg_0));
        return params;
    }

    private static void writeFileContentToStdin(@NotNull Process process, @NotNull String content, @NotNull Charset charset) {
        try (OutputStream stdin = Objects.requireNonNull(process.getOutputStream());){
            stdin.write(content.getBytes(charset));
            stdin.flush();
        }
        catch (IOException e) {
            LOG.debug("Failed to write file content to stdin\n\n" + content, (Throwable)e);
        }
    }

    @Contract(pure=true)
    @NotNull
    private static String format(@NotNull String originalMessage) {
        return originalMessage.endsWith(".") ? originalMessage.substring(0, originalMessage.length() - 1) : originalMessage;
    }

    @NotNull
    private static String quote(@NotNull String originalMessage) {
        return "'" + StringUtil.first((String)originalMessage, (int)60, (boolean)true) + "'";
    }

    @NotNull
    private static String getInterpreter(@NotNull PsiFile file) {
        if (!(file instanceof ShFile)) {
            return DEFAULT_SHELL;
        }
        return ShShebangParserUtil.getInterpreter((ShFile)file, KNOWN_SHELLS, DEFAULT_SHELL);
    }

    private static /* synthetic */ void lambda$getShellcheckExecutionParams$2(List params, String setting) {
        params.add("--exclude=" + setting);
    }

    static class CollectedInfo {
        private final Project project;
        private final String workDirectory;
        private final String fileContent;
        private final long modificationStamp;
        private final List<String> executionParams;

        CollectedInfo(Project project, String workDirectory, String fileContent, long modificationStamp, List<String> executionParams) {
            this.project = project;
            this.workDirectory = workDirectory;
            this.fileContent = fileContent;
            this.modificationStamp = modificationStamp;
            this.executionParams = executionParams;
        }
    }

    class ShellcheckResponse {
        final Collection<Result> results;
        final long timestamp;

        ShellcheckResponse(Collection<Result> results, long timestamp) {
            this.results = results;
            this.timestamp = timestamp;
        }
    }

    class Result {
        int line;
        int endLine;
        int column;
        int endColumn;
        String level;
        @InspectionMessage String message;
        long code;
        @Nullable
        Fix fix;

        Result() {
        }
    }

    class Fix {
        Replacement[] replacements;

        Fix() {
        }
    }

    class Replacement {
        int line;
        int column;
        int endLine;
        int endColumn;
        String replacement;

        Replacement() {
        }
    }
}

