/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.shellcheck;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.sh.ShBundle;
import com.intellij.sh.shellcheck.ShShellcheckExternalAnnotator;
import com.intellij.sh.shellcheck.ShShellcheckUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Comparator;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class ShQuickFixIntention
implements IntentionAction {
    @FileModifier.SafeFieldForPreview
    private final ShShellcheckExternalAnnotator.Fix fix;
    private final long timestamp;
    @IntentionName
    private final String message;

    public ShQuickFixIntention(@IntentionName String message, ShShellcheckExternalAnnotator.Fix fix, long timestamp) {
        this.timestamp = timestamp;
        this.message = message;
        this.fix = fix;
    }

    @NotNull
    public String getFamilyName() {
        return ShBundle.message("sh.shell.script", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        return this.timestamp == file.getModificationStamp();
    }

    public boolean startInWriteAction() {
        return true;
    }

    @NotNull
    public String getText() {
        return this.message;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        class Replacement {
            final String replacement;
            final int startOffset;
            final int endOffset;

            Replacement(int startOffset, int endOffset, String replacement) {
                this.replacement = replacement;
                this.startOffset = startOffset;
                this.endOffset = endOffset;
            }
        }
        if (editor == null) {
            return;
        }
        Document document = editor.getDocument();
        Stream.of(this.fix.replacements).map(it -> {
            int startOffset = ShQuickFixIntention.calcOffset(document, it.line, it.column);
            int endOffset = ShQuickFixIntention.calcOffset(document, it.endLine, it.endColumn);
            return new Replacement(startOffset, endOffset, it.replacement);
        }).sorted(Comparator.comparingInt(it -> -it.endOffset)).forEach(it -> document.replaceString(it.startOffset, it.endOffset, (CharSequence)it.replacement));
    }

    private static int calcOffset(Document document, int line, int column) {
        return ShShellcheckUtil.calcOffset(document.getCharsSequence(), document.getLineStartOffset(line - 1), column);
    }
}

