/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.run;

import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sh.parser.ShShebangParserUtil;
import com.intellij.sh.psi.ShFile;
import com.intellij.sh.run.ShConfigurationType;
import com.intellij.sh.run.ShRunConfiguration;
import com.intellij.sh.run.ShRunConfigurationProducer;
import com.intellij.sh.run.ShRunnerAdditionalCondition;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;

final class ShRunFileAction
extends DumbAwareAction {
    static final String ID = "runShellFileAction";

    ShRunFileAction() {
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        ShRunConfiguration runConfiguration;
        PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        if (file == null) {
            return;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        Project project = file.getProject();
        ConfigurationContext context = ConfigurationContext.getFromContext((DataContext)e.getDataContext(), (String)e.getPlace());
        ShRunConfigurationProducer configProducer = (ShRunConfigurationProducer)RunConfigurationProducer.getInstance(ShRunConfigurationProducer.class);
        RunnerAndConfigurationSettings configurationSettings = configProducer.findExistingConfiguration(context);
        if (configurationSettings == null) {
            configurationSettings = RunManager.getInstance((Project)project).createConfiguration(file.getName(), ShConfigurationType.class);
            runConfiguration = (ShRunConfiguration)configurationSettings.getConfiguration();
            runConfiguration.setScriptPath(virtualFile.getPath());
            runConfiguration.setExecuteScriptFile(true);
            runConfiguration.setScriptWorkingDirectory(virtualFile.getParent().getPath());
            if (file instanceof ShFile) {
                @NlsSafe String defaultShell = (String)ObjectUtils.notNull((Object)ShConfigurationType.getDefaultShell(), (Object)"/bin/sh");
                String shebang = ShShebangParserUtil.getShebangExecutable((ShFile)file);
                if (shebang != null) {
                    Pair<String, String> result = ShRunFileAction.parseInterpreterAndOptions(shebang);
                    runConfiguration.setInterpreterPath((String)result.first);
                    runConfiguration.setInterpreterOptions((String)result.second);
                } else {
                    runConfiguration.setInterpreterPath(defaultShell);
                }
            } else {
                runConfiguration.setInterpreterPath("");
            }
        } else {
            runConfiguration = (ShRunConfiguration)configurationSettings.getConfiguration();
        }
        ExecutionEnvironmentBuilder builder = ExecutionEnvironmentBuilder.createOrNull((Executor)DefaultRunExecutor.getRunExecutorInstance(), (RunConfiguration)runConfiguration);
        if (builder != null) {
            ExecutionManager.getInstance((Project)project).restartRunProfile(builder.build());
        }
    }

    public void update(@NotNull AnActionEvent e) {
        e.getPresentation().setEnabledAndVisible(ShRunFileAction.isEnabled(e));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    @NotNull
    static Pair<String, String> parseInterpreterAndOptions(@NotNull String shebang) {
        String shebangParam;
        String[] splitShebang = shebang.split(" ");
        if (splitShebang.length > 1 && !(shebangParam = splitShebang[splitShebang.length - 1]).contains("/") && !shebangParam.contains("\\")) {
            return Pair.create((Object)shebang.substring(0, shebang.length() - shebangParam.length() - 1), (Object)shebangParam);
        }
        return Pair.create((Object)shebang, (Object)"");
    }

    private static boolean isEnabled(@NotNull AnActionEvent e) {
        PsiFile file;
        if (e.getProject() != null && (file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE)) != null) {
            boolean runningProhibited = ContainerUtil.exists((Iterable)ShRunnerAdditionalCondition.EP.getExtensionsIfPointIsRegistered(), runningCondition -> runningCondition.isRunningProhibitedForFile(file));
            if (runningProhibited) {
                return false;
            }
            if (file instanceof ShFile) {
                return true;
            }
            PsiElement firstChild = file.findElementAt(0);
            return firstChild instanceof PsiComment && firstChild.getText().startsWith("#!");
        }
        return false;
    }
}

