/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.run;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunConfigurationBeforeRunProviderDelegate;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.util.Key;
import com.intellij.sh.run.ShRunConfiguration;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

final class ShBeforeRunProviderDelegate
implements RunConfigurationBeforeRunProviderDelegate {
    private static final String SH_BEFORE_KEY_PREFIX = "Sh.BeforeRunTask";
    private static final Map<String, Key<Boolean>> KEY_MAP = new HashMap<String, Key<Boolean>>();

    ShBeforeRunProviderDelegate() {
    }

    public void beforeRun(@NotNull ExecutionEnvironment environment) {
        RunnerAndConfigurationSettings settings = environment.getRunnerAndConfigurationSettings();
        if (settings == null) {
            return;
        }
        RunConfiguration configuration = settings.getConfiguration();
        if (configuration instanceof ShRunConfiguration) {
            Key<Boolean> userDataKey = ShBeforeRunProviderDelegate.getRunBeforeUserDataKey(configuration);
            configuration.getProject().putUserData(userDataKey, (Object)true);
        }
    }

    static Key<Boolean> getRunBeforeUserDataKey(@NotNull RunConfiguration runConfiguration) {
        return KEY_MAP.computeIfAbsent(runConfiguration.getName(), key -> Key.create((String)("Sh.BeforeRunTask_" + key)));
    }
}

